# Copyright 1999-2018 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI="5"

inherit base autotools pax-utils

MY_P="${PN}.${PV}"

DESCRIPTION="Poly/ML is a full implementation of Standard ML"
HOMEPAGE="https://www.polyml.org"
SRC_URI="mirror://sourceforge/${PN}/${MY_P}.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~x86"
IUSE="X elibc_glibc +gmp portable test +threads"

RDEPEND="X? ( x11-libs/motif:0 )
		gmp? ( >=dev-libs/gmp-5 )
		elibc_glibc? ( threads? ( >=sys-libs/glibc-2.13 ) )
		virtual/libffi"
DEPEND="${RDEPEND}"

S=${WORKDIR}/${MY_P}

PATCHES=(
	# Bug 256679 - patch the assembler code.  The remaining executable stacks in ./.libs/poly
	# comes from the polyml generated ./polyexport.o file.
	"${FILESDIR}/${PN}-5.5.0-asm.patch"
	# https://sourceforge.net/p/polyml/code/1875/ for isabelle-2013.2
	"${FILESDIR}/${PN}-5.5.1-inputN-return-for-zero-chars.patch"
	# https://sourceforge.net/p/polyml/code/1869/
	# Adds Test146.ML that fails, applying it anyway as it is required by
	# sci-mathematics/isabelle-2013.2
	"${FILESDIR}/${PN}-5.5.1-optimize-closure.patch"
)

src_prepare() {
	base_src_prepare
	eautoreconf
	if [ -f "${S}/Tests/Succeed/Test146.ML" ]; then
		mv "${S}/Tests/Succeed/Test146.ML" "${S}/Tests/Succeed/Test146.ML.disable-test-as-it-fails"
	fi
}

src_configure() {
	econf \
		--enable-shared \
		--disable-static \
		--with-system-libffi \
		$(use_with X x) \
		$(use_with gmp) \
		$(use_with portable) \
		$(use_with threads)
}

src_compile() {
	# Bug 453146 - dev-lang/polyml-5.5.0: fails to build (pax kernel?)
	pushd libpolyml || die "Could not cd to libpolyml"
	emake
	popd
	emake polyimport
	pax-mark m "${S}/.libs/polyimport"
	emake
	pax-mark m "${S}/.libs/poly"
}

src_test() {
	emake tests || die "tests failed"
}
