# Copyright 1999-2018 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=6

inherit cmake-utils readme.gentoo-r1

DESCRIPTION="Midi processing library and a midi player using the gus patch set"
HOMEPAGE="http://www.mindwerks.net/projects/wildmidi/"
SRC_URI="https://github.com/Mindwerks/${PN}/archive/${P}.tar.gz"

LICENSE="GPL-3 LGPL-3"
SLOT="0"
KEYWORDS="amd64 arm ~hppa ppc ppc64 x86"
IUSE="+alsa openal oss +player"

DEPEND="
	player? (
		alsa? ( media-libs/alsa-lib )
		openal? ( media-libs/openal )
	)
"
RDEPEND="${DEPEND}
	media-sound/timidity-freepats
"

REQUIRED_USE="player? ( ^^ ( alsa oss openal ) )"

DOC_CONTENTS="${PN} is using timidity-freepats for midi playback.
	A default configuration file was placed on /etc/${PN}/${PN}.cfg.
	For more information please read the ${PN}.cfg manpage."

S="${WORKDIR}"/${PN}-${P}

src_prepare() {
	# alsa openal oss only make sense if player is enabled. See CMakeLists.txt
	if ! use player && (use alsa || use openal || use oss); then
		ewarn "The 'alsa', 'openal' and 'oss' use flags only make sense if"
		ewarn "the 'player' use flags is selected and as a result they will be"
		ewarn "ignored in this build"
	fi
	cmake-utils_src_prepare
}

src_configure() {
	local mycmakeargs=(
		-DWANT_ALSA=$(usex alsa)
		-DWANT_OPENAL=$(usex openal)
		-DWANT_OSS=$(usex oss)
		-DWANT_PLAYER=$(usex player)
	)
	cmake-utils_src_configure
}

src_install() {
	cmake-utils_src_install

	find "${D}" -name '*.la' -delete || die

	insinto /etc/${PN}/
	doins cfg/${PN}.cfg

	readme.gentoo_create_doc
}

pkg_postinst() {
	if [[ -e "${ROOT}"/etc/${PN}.cfg ]]; then
		elog
		elog "Old /etc/${PN}.cfg detected!"
		elog "Please migrate your configuration file to"
		elog "/etc/${PN}/ directory which is now the default"
		elog "location for the ${PN} configuration file."
		elog
	fi
}
