# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=6

PYTHON_COMPAT=( python2_7 python3_{5,6,7} pypy )
PYTHON_REQ_USE="threads(+)"

inherit distutils-r1 eutils

DESCRIPTION="Python code static checker"
HOMEPAGE="https://www.logilab.org/project/pylint
	https://pypi.org/project/pylint/
	https://github.com/pycqa/pylint"
SRC_URI="mirror://pypi/${PN:0:1}/${PN}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~arm ~arm64 ~ia64 ~ppc ~sparc ~x86 ~amd64-linux ~x86-linux ~x64-macos ~x86-macos"
IUSE="doc examples test"

RDEPEND="
	>=dev-python/astroid-1.6.0[${PYTHON_USEDEP}]
	dev-python/six[${PYTHON_USEDEP}]
	>=dev-python/isort-4.2.5[${PYTHON_USEDEP}]
	dev-python/mccabe[${PYTHON_USEDEP}]
	virtual/python-singledispatch[${PYTHON_USEDEP}]
	$(python_gen_cond_dep '
		dev-python/backports-functools-lru-cache[${PYTHON_USEDEP}]
		dev-python/configparser[${PYTHON_USEDEP}]' -2)"
DEPEND="dev-python/setuptools[${PYTHON_USEDEP}]
	doc? ( dev-python/sphinx[${PYTHON_USEDEP}] )
	test? ( ${RDEPEND}
		<dev-python/pytest-4[${PYTHON_USEDEP}] )"

python_prepare_all() {
	# remove unused dep
	sed -i -e '/pytest-runner/d' setup.py || die

	# Disable failing tests
	# TODO: investigate if it's our fault and how can we fix it
	sed -i -e 's/io.StringIO()/\0 if sys.version_info.major > 2 else open(os.devnull, "w")/' \
		-e 's/test_libmodule/_&/' \
		pylint/test/acceptance/test_stdlib.py || die
	sed -i -e 's/^# pylint:.*/\0, import-error/' \
		pylint/test/functional/deprecated_module_py36.py || die
	sed -i -e 's/^# pylint:.*/\0, wrong-import-order/' \
		pylint/test/functional/generated_members.py || die
	sed -i -e 's/test_good_comprehension_checks/_&/' \
		pylint/test/functional/using_constant_test.py || die

	distutils-r1_python_prepare_all
}

python_compile_all() {
	# selection of straight html triggers a trivial annoying bug, we skirt it
	use doc && PYTHONPATH="${S}" emake -e -C doc singlehtml
}

python_test() {
	py.test -v || die "Tests fail with ${EPYTHON}"
}

python_install_all() {
	doman man/{pylint,pyreverse}.1
	if use examples ; then
		docinto examples
		dodoc -r examples/.
	fi
	use doc && local HTML_DOCS=( doc/_build/singlehtml/. )
	distutils-r1_python_install_all
}

pkg_postinst() {
	# Optional dependency on "tk" USE flag would break support for Jython.
	optfeature "pylint-gui script requires dev-lang/python with \"tk\" USE flag enabled." 'dev-lang/python[tk]'
}
