# Copyright 1999-2015 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=5

# ebuild generated by hackport 0.3.4.9999

CABAL_FEATURES="bin lib profile haddock hoogle hscolour"
inherit haskell-cabal

DESCRIPTION="Library and executables for working with SFF files"
HOMEPAGE="http://biohaskell.org/"
SRC_URI="mirror://hackage/packages/archive/${PN}/${PV}/${P}.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~x86"
IUSE="+fclip +flower +frecover"

RDEPEND="dev-haskell/binary:=[profile?]
	>=dev-haskell/biocore-0.3:=[profile?]
	dev-haskell/cmdargs:=[profile?]
	>=dev-haskell/mtl-2:=[profile?]
	>=dev-lang/ghc-7.4.1:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-1.6
"

src_prepare() {
	epatch "${FILESDIR}"/${P}-ghc-7.10.patch
}

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag fclip fclip) \
		$(cabal_flag flower flower) \
		$(cabal_flag frecover frecover)
}
