# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=5
USE_RUBY="ruby23 ruby24 ruby25 ruby26"

RUBY_FAKEGEM_EXTRADOC="README.md HISTORY.md"

inherit ruby-fakegem

DESCRIPTION="Helper class for launching cross-platform applications"
HOMEPAGE="https://github.com/copiousfreetime/launchy"

LICENSE="ISC"

SLOT="0"
KEYWORDS="amd64 ~arm ~arm64 ~x86"
IUSE=""

# File collision conflict with x11-misc/launchy, bug 545170
ruby_add_rdepend ">=dev-ruby/addressable-2.3 !!x11-misc/launchy"

ruby_add_bdepend "test? ( >=dev-ruby/minitest-5.0:5 )"

# This test is expected to fail on linux, drop it
RUBY_PATCHES=( "${FILESDIR}"/${PN}-2.4.2-drop-failing-test.patch )

all_ruby_prepare() {
	sed -i -e "/[Ss]implecov/d" spec/spec_helper.rb || die

	# Avoid tests depending on the current user's desktop environment.
	sed -e '/returns NotFound if it cannot determine/askip "gentoo"' \
		-i spec/detect/nix_desktop_environment_spec.rb || die
	sed -e '/asssumes we open a local file if we have an exception/askip "gentoo"' \
		-i spec/launchy_spec.rb || die
}
