# Copyright 1999-2016 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=5

# ebuild generated by hackport 0.3.2.9999

CABAL_FEATURES="bin lib profile haddock hoogle hscolour"
inherit eutils haskell-cabal

DESCRIPTION="A bioinformatics library"
HOMEPAGE="http://biohaskell.org/Libraries/Bio"
SRC_URI="mirror://hackage/packages/archive/${PN}/${PV}/${P}.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~x86"
IUSE="+examples test"

RDEPEND=">=dev-haskell/binary-0.4:=[profile?]
		dev-haskell/mtl:=[profile?]
		dev-haskell/old-time:=[profile?]
		dev-haskell/parallel:=[profile?]
		dev-haskell/parsec:=[profile?]
		>=dev-haskell/quickcheck-2:2=[profile?]
		dev-haskell/random:=[profile?]
		>=dev-haskell/tagsoup-0.8:=[profile?]
		>=dev-lang/ghc-6.10.4:="
DEPEND="${RDEPEND}
		>=dev-haskell/cabal-1.6"

src_prepare() {
	epatch "${FILESDIR}"/${P}-ghc-7.10.patch

	cabal_chdeps \
		'binary >=0.4 && <0.5' 'binary >=0.4'
}

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag examples examples) \
		$(cabal_flag test test)
}

src_test() {
	dist/build/qc/qc || die
}

src_install() {
	haskell-cabal_src_install

	use test && rm "${ED}"/usr/bin/qc
	# many examples collide with dev-haskell/flower
	if use examples ; then
		pushd "${ED}"/usr/bin
		local example
		for example in *
		do
			mv "${example}" "${PN}-example-${example}"
		done
		popd
	fi
}
