# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

PYTHON_COMPAT=( python2_7 python3_{5,6})
inherit distutils-r1

DESCRIPTION="Utility for accessing HTTP server and storing files locally for reuse"
HOMEPAGE="https://github.com/biolab/serverfiles"
SRC_URI="https://github.com/biolab/${PN}/archive/${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="GPL-3+"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="test"

RDEPEND=">=dev-python/requests-2.11.1[${PYTHON_USEDEP}]"
DEPEND="${DEPEND}
	dev-python/setuptools[${PYTHON_USEDEP}]
	dev-python/setuptools_scm[${PYTHON_USEDEP}]
	test? ( dev-python/pytest[${PYTHON_USEDEP}] )"

python_test(){
	py.test -v || die "Tests fail with ${EPYTHON}"
}
