# Copyright 1999-2008 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/media-libs/sdl-gfx/sdl-gfx-2.0.16.ebuild,v 1.5 2008/03/06 03:59:50 wolf31o2 Exp $

inherit autotools eutils flag-o-matic libtool

MY_P="${P/sdl-/SDL_}"
DESCRIPTION="Graphics drawing primitives library for SDL"
HOMEPAGE="http://www.ferzkopp.net/joomla/content/view/19/14/"
SRC_URI="http://www.ferzkopp.net/Software/SDL_gfx-2.0/${MY_P}.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~hppa ~ia64 ~ppc ~sparc ~x86 ~x86-fbsd"
IUSE="mmx"

DEPEND="media-libs/libsdl"

S=${WORKDIR}/${MY_P}

src_unpack() {
	unpack ${A}
	cd "${S}"
	rm -f acinclude.m4 # bug #210137
	eautoreconf
	elibtoolize
}

src_compile() {
	filter-flags -finline-functions -funroll-loops #26892 #89749
	replace-flags -O? -O2

	econf \
		--disable-dependency-tracking \
		$(use_enable mmx) || die
	emake || die "emake failed"
}

src_install() {
	emake DESTDIR="${D}" install || die "emake install failed"
	dodoc AUTHORS ChangeLog README
	dohtml -r Docs/*
}

pkg_postinst() {
	ewarn "If you upgraded from sdl-gfx-2.0.13-r1 or earlier, please run"
	ewarn "\"revdep-rebuild\" from app-portage/gentoolkit"
}
