# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/media-libs/pdflib/pdflib-7.0.1.ebuild,v 1.15 2007/12/11 23:53:39 vapier Exp $

# eutils must be inherited since get_libdir() is only
# globally available on baselayout-1.11 (still on ~arch)
inherit base eutils java-pkg-opt-2 flag-o-matic libtool

MY_PN="${PN/pdf/PDF}-Lite"
MY_P="${MY_PN}-${PV}"
S="${WORKDIR}/${MY_P}"

DESCRIPTION="A library for generating PDF on the fly."
HOMEPAGE="http://www.pdflib.com/"
SRC_URI="http://www.pdflib.com/binaries/${PN/pdf/PDF}/${PV//./}/${MY_P}.tar.gz"
LICENSE="PDFLite"
SLOT="5"
KEYWORDS="~alpha ~amd64 arm ~hppa ~ia64 ~ppc ppc64 s390 sh sparc x86 ~x86-fbsd"
IUSE="doc tcl perl python java"

COMMON_DEP="
	>=sys-apps/sed-4
	tcl? ( >=dev-lang/tcl-8.2 )
	perl? ( >=dev-lang/perl-5.1 )
	python? ( >=dev-lang/python-2.2 )"

DEPEND="
	${COMMON_DEP}
	java? ( >=virtual/jdk-1.4 )"

RDEPEND="
	${COMMON_DEP}
	java? ( >=virtual/jre-1.4 )"

src_unpack() {
	unpack ${A}
	cd "${S}"

	elibtoolize
}

src_compile() {
	local myconf

	# Bug #87004
	filter-flags -mcpu=*
	filter-flags -mtune=*

	PYVER="$(/usr/bin/python -V 2>&1 | cut -d ' ' -f 2 | cut -d '.' -f 1,2)"
	# Necessary for multilib on amd64. Please keep this in future releases.
	# BUG #81197
	# Danny van Dyk <kugelfang@gentoo.org> 2005/02/14
	TCLVER="$(echo 'puts [info tclversion]' | $(type -P tclsh))"
	use tcl \
		&& myconf="--with-tclpkg=/usr/$(get_libdir)/tcl${TCLVER}/" \
		|| myconf="--with-tcl=no"
	use perl || myconf="${myconf} --with-perl=no"
	use python \
		&& myconf="${myconf} --with-py=/usr --with-pyincl=/usr/include/python${PYVER}" \
		|| myconf="${myconf} --with-py=no"
	use java \
		&& myconf="${myconf} --with-java=${JAVA_HOME}" \
		|| myconf="${myconf} --with-java=no"

	econf \
		--enable-cxx \
		${myconf} || die

	if use java; then
		JAVACFLAGS="$(java-pkg_javac-args)" emake || die "emake failed"
		if use doc; then
			cd ./bind/pdflib/java || die
			emake javadoc || die "Failed to generate javadoc"
		fi
	else
		emake || die "emake failed"
	fi
}

src_install() {
	sed -i \
		-e "s:^\(LANG_LIBDIR\).*= \(.*\):\1\t = ${D}/\2:" \
		"${S}/bind/pdflib/perl/Makefile" \
			|| die "sed bind/pdflib/perl/Makefile failed"

	sed -i \
		-e "s:^\(LANG_LIBDIR\).*= \(.*\):\1\t = ${D}/\2:" \
		"${S}/bind/pdflib/python/Makefile" \
			|| die "sed bind/pdflib/python/Makefile failed"

	sed -i \
		-e "s:^\(LANG_LIBDIR\).*= \(.*\):\1\t = ${D}/\2:" \
		"${S}/bind/pdflib/tcl/Makefile" \
			|| die "sed bind/pdflib/tcl/Makefile failed"

	# ok, this should create the correct lib dirs for perl and python.
	# yes, i know it is messy, but as i see it, a ebuild should be generic
	# ... ie. you should be able to just use cp to update it
	if use perl && [ -x /usr/bin/perl ] ; then
		local perlmajver="`/usr/bin/perl -v |grep 'This is perl' \
			|cut -d ' ' -f 4 |cut -d '.' -f 1`"
		local perlver="`/usr/bin/perl -v |grep 'This is perl' \
			|cut -d ' ' -f 4`"
		local perlarch="`/usr/bin/perl -v |grep 'This is perl' \
			|cut -d ' ' -f 7`"
		dodir /usr/$(get_libdir)/perl${perlmajver/v/}/site_perl/${perlver/v/}/${perlarch}
	fi
	if use python && [ -x /usr/bin/python ] ; then
		dodir /usr/$(get_libdir)/python${PYVER}/lib-dynload
	fi
	#next line required for proper install
	dodir /usr/bin
	einstall || die

	dodoc readme.txt doc/*
	docinto pdflib
	dodoc doc/pdflib/*

	# seemant: seems like the makefiles for pdflib generate the .jar file
	# anyway
	use java && java-pkg_dojar bind/pdflib/java/pdflib.jar
	if use java && use doc; then
		java-pkg_dojavadoc ./bind/pdflib/java/javadoc
	fi
}

pkg_postinst() {
	ewarn "                                                             "
	ewarn "Please run revdep-rebuild now! All packages that linked with "
	ewarn "previous versions of PDFLib will no longer work unless you   "
	ewarn "run it.                                                      "
	ewarn "                                                             "
}
