# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/media-gfx/gphoto2/gphoto2-2.4.0.ebuild,v 1.2 2007/10/07 13:13:57 eva Exp $

DESCRIPTION="free, redistributable digital camera software application"
HOMEPAGE="http://www.gphoto.org/"
SRC_URI="mirror://sourceforge/gphoto/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~ia64 ~ppc ~ppc64 ~sparc ~x86"
IUSE="nls exif readline ncurses aalib"

# jpeg useflag -> exif support
# aalib -> needs libjpeg
RDEPEND=">=dev-libs/libusb-0.1.8
	dev-libs/popt
	>=media-libs/libgphoto2-2.4.0
	ncurses? ( dev-libs/cdk )
	aalib? ( media-libs/aalib
		media-libs/jpeg )
	exif? (	media-libs/libexif )
	readline? ( sys-libs/readline )"
DEPEND="${RDEPEND}
	dev-util/pkgconfig"

src_compile() {
	econf \
		$(use_enable nls) \
		$(use_with ncurses cdk) \
		$(use_with aalib) \
		$(use_with aalib jpeg) \
		$(use_with exif) \
		$(use_with readline) || die "econf failed"
	emake || die "compilation failed"
}

src_install() {
	einstall \
		gphotodocdir="${D}"/usr/share/doc/${PF} \
		HTML_DIR="${D}"/usr/share/doc/${PF}/sgml \
		|| die "installation failed"

	dodoc ChangeLog NEWS* README AUTHORS COPYING
	rm -rf "${D}"/usr/share/doc/${PF}/sgml/gphoto2
}
