# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/games-action/d2x/d2x-0.2.5-r2.ebuild,v 1.6 2007/03/07 15:55:40 wolf31o2 Exp $

inherit flag-o-matic eutils games

DATAFILE="d2shar10"
DESCRIPTION="Descent 2"
HOMEPAGE="http://icculus.org/d2x/"
SRC_URI="http://icculus.org/d2x/src/${P}.tar.gz
	!cdinstall? ( http://icculus.org/d2x/data/${DATAFILE}.tar.gz )"

LICENSE="D1X"
SLOT="0"
KEYWORDS="ppc x86"
IUSE="cdinstall debug opengl ggi svga"

RDEPEND="media-libs/libsdl
	media-libs/sdl-image
	cdinstall? ( app-arch/unarj )
	opengl? ( virtual/opengl )
	ggi? ( media-libs/libggi )
	svga? ( media-libs/svgalib )"
DEPEND="${RDEPEND}
	x86? ( dev-lang/nasm )"

src_unpack() {
	unpack ${A}
	if use cdinstall ; then
		if [[ ! -e "${DISTDIR}"/descent2.sow ]] ; then
			cdrom_get_cds d2data
			if [[ -e ${CDROM_ROOT}/d2data/descent2.sow ]] ; then
				export CDROM_ROOT=${CDROM_ROOT}/d2data
				einfo "Found the original Descent2 CD"
				einfo "Copying descent2.sow to ${DISTDIR}"
				cp ${CDROM_ROOT}/descent2.sow "${DISTDIR}"/descent2.sow
			else
				die "You need the original Descent2 CD"
			fi
		fi
		cd "${WORKDIR}"
		mkdir SOW
		cd SOW
		unarj e "${DISTDIR}"/descent2.sow
	fi
	rm *.{exe,bat}
	cd "${S}"
	epatch "${FILESDIR}"/${PV}-shellscripts.patch
	epatch "${FILESDIR}"/${P}-dofpcalcs-macro.patch
}

src_compile() {
	# --disable-network --enable-console
	local myconf="$(use_enable x86 assembler)"
	use debug \
		&& myconf="${myconf} --enable-debug --disable-release" \
		|| myconf="${myconf} --disable-debug --enable-release"
	# we do this because each of the optional guys define the same functions
	# in gr, thus when they go to link they cause redefine errors ...
	# we build each by it self, save the binary file, clean up, and start over
	mkdir my-bins
	for ren in sdl $(useq opengl && echo opengl) \
			$(useq svga && echo svga) $(useq ggi && echo ggi)
	do
		[[ "${ren}" == "sdl" ]] \
			&& renconf="" \
			|| renconf="--with-${ren}"
		[[ "${ren}" == "svga" ]] \
			&& defflags="-DSVGALIB_INPUT" \
			|| defflags=""
		make distclean
		egamesconf \
			${myconf} \
			${renconf} \
			--datadir="${GAMES_DATADIR_BASE}" \
			|| die "conf ${ren}"
		emake CXXFLAGS="${CXXFLAGS} ${defflags}" || die "build ${ren}"
		mv d2x* my-bins/
	done
}

src_install() {
	make install DESTDIR="${D}" || die
	dogamesbin my-bins/*
	dodir "${GAMES_DATADIR}"/${PN}
	if use cdinstall ; then
		cp -r "${WORKDIR}"/SOW/* "${D}/${GAMES_DATADIR}"/${PN}/
	else
		cp -r "${WORKDIR}"/${DATAFILE}/* "${D}/${GAMES_DATADIR}"/${PN}/
	fi
	dodoc AUTHORS ChangeLog NEWS README* TODO readme.txt
	prepgamesdirs
}
