######################################################################
# setup script for the Python wrapper of ODE
######################################################################

from distutils.core import setup, Extension
import distutils.sysconfig
import shutil, os, os.path, sys, glob
from stat import *

# Windows?
if sys.platform=="win32":

    try:
        base = [ODE_BASE]
    except NameError:
		base = []
		base.append("../ode_single_trimesh")
		base.append("../ode_double_notrimesh")

    LIBS     = ["ode", "user32"]  # user32 because of the MessageBox() call
    CC_ARGS  = ["/ML"]

# Linux (and other)
else:

    LIBS     = ["ode", "stdc++"]
    CC_ARGS  = []
    INC_DIRS = ['/usr/include/ode']
    LIB_DIRS = ['/usr/lib']

# Generate the C source file (if necessary)
def generate(name, trimesh_support):
    # Generate the trimesh_switch file

    f = file("_trimesh_switch.pyx", "wt")
    print >>f, '# This file was generated by the setup script and is included in ode.pyx.\n'
    if (trimesh_support):
        print >>f, 'include "trimeshdata.pyx"'
        print >>f, 'include "trimesh.pyx"'
    else:
        print >>f, 'include "trimesh_dummy.pyx"'
    f.close()

    cmd = "pyrexc -o %s -I. -Isrc src/ode.pyx" % name
    pyrex_out = name

    # Check if the pyrex output is still up to date or if it has to be generated
    # (ode.c will be updated if any of the *.pyx files in the directory "src"
    # is newer than ode.c)
    if os.access(pyrex_out, os.F_OK):
        ctime = os.stat(pyrex_out)[ST_MTIME]
        for pyx in glob.glob("src/*.pyx"):
            pytime = os.stat(pyx)[ST_MTIME]
            if pytime>ctime:
                print "Updating",pyrex_out
                print cmd
                err = os.system(cmd)
                break
        else:
            print pyrex_out,"is up to date"
            err = 0
    else:
        print "Creating",pyrex_out
        print cmd
        err = os.system(cmd)

    # Check if calling pyrex produced an error
    if err!=0:
        print "An error occured while generating the C source file."
        sys.exit(err)

wrap_trimesh = not os.system('objdump --syms /usr/lib/libode.a | grep -q libOPCODE')

if (wrap_trimesh):
    print "Installing with trimesh support."
    generate('ode_trimesh.c', True)
    install = 'ode_trimesh.c'
else:
    print "Installing without trimesh support."
    generate('ode_notrimesh.c', False)
    install = 'ode_notrimesh.c'

# Compile the module
setup(name = "PyODE",
      version = "1.1.0",
      description = "Python wrapper for the Open Dynamics Engine",
      author = "see file AUTHORS",
      author_email = "timothy@stranex.com",
      license = "BSD or LGPL",
      url = "http://pyode.sourceforge.net/",
      packages = ["xode"],
      ext_modules = [Extension("ode", [install]
                     ,libraries=LIBS
                     ,include_dirs=INC_DIRS
                     ,library_dirs=LIB_DIRS
                     ,extra_compile_args=CC_ARGS)
                    ])
