# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-python/cgkit/cgkit-1.2.0.ebuild,v 1.4 2007/03/28 20:18:37 opfer Exp $

inherit distutils

DESCRIPTION="Python library for creating 3D images"
SRC_URI="mirror://sourceforge/${PN}/${P}.zip
	mirror://sourceforge/${PN}/${P}-doc.zip"
HOMEPAGE="http://cgkit.sourceforge.net"
RDEPEND="dev-lang/python
	dev-python/pyrex"
DEPEND="${RDEPEND}
	app-arch/unzip"
SLOT="0"
LICENSE="GPL-2"
KEYWORDS="x86 ~ppc"
IUSE="doc"

src_unpack() {
	unpack ${A}
	# this forces the file to be regenerated by the build system using
	# pyrex.  Compilation with GCC 4 would fail otherwise, see
	# bug #152210
	rm "${S}/cgtypes.c"
}
src_install () {
	distutils_src_install
	if use doc; then
		cd ${WORKDIR}
		dohtml *.html
		cp -ar pics ${D}/usr/share/doc/${PF}/html/
		cd ${S}/examples
		for example in *; do
			dodir /usr/share/${P}/examples/${example}
			exeinto /usr/share/${P}/examples/${example}
			doexe ${example}/*.py
		done
	fi
}
