# Copyright 1999-2008 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-php5/pecl-mcve/pecl-mcve-5.2.2-r1.ebuild,v 1.9 2008/01/10 10:02:04 vapier Exp $

PHP_EXT_NAME="mcve"
PHP_EXT_INI="yes"
PHP_EXT_ZENDEXT="no"

inherit php-ext-pecl-r1

KEYWORDS="alpha amd64 arm hppa ia64 ppc ppc64 s390 sh sparc x86"

DESCRIPTION="Interface to the MCVE/Monetra API, allowing you to work directly with MCVE/Monetra from PHP."
LICENSE="PHP-3"
SLOT="0"
IUSE=""

DEPEND="dev-libs/openssl
		net-libs/libmonetra"
RDEPEND="${DEPEND}"

need_php_by_category

pkg_setup() {
	has_php
	require_php_with_use ssl
}

src_unpack() {
	unpack ${A}
	cd "${S}"

	# Fix incorrect LDFLAGS usage in config.m4
	# (breaks concurrentmodphp)
	epatch "${FILESDIR}/${P}-ldflagsfix.patch"
}

src_compile() {
	my_conf="--with-mcve --with-openssl-dir=/usr"
	php-ext-pecl-r1_src_compile
}
