# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-java/blowfishj/blowfishj-2.14-r1.ebuild,v 1.7 2007/06/10 10:32:12 philantrop Exp $

JAVA_PKG_IUSE="doc source test"

inherit java-pkg-2 java-ant-2

DESCRIPTION="Blowfish implementation in Java"
SRC_URI="mirror://sourceforge/${PN}/${P}-src.tar.gz"
HOMEPAGE="http://blowfishj.sourceforge.net/index.html"

LICENSE="Apache-2.0"
SLOT="0"
KEYWORDS="amd64 ppc x86"
IUSE="doc test source"

DEPEND=">=virtual/jdk-1.4
	test? ( =dev-java/junit-3* dev-java/ant-junit ) "
RDEPEND=">=virtual/jre-1.4"

src_unpack() {
	unpack "${A}"
	cd "${S}"
	java-ant_ignore-system-classes
	mkdir -p target/lib
	cd target/lib
	use test && java-pkg_jar-from --build-only junit
}

src_test() {
	ANT_TASKS="ant-junit" eant test -DJunit.present=true
}

src_install() {
	java-pkg_newjar target/${P}.jar

	use doc && java-pkg_dojavadoc dist/docs/api
	use source && java-pkg_dosrc src/java/net
}
