# Copyright 1999-2006 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/net-www/mod_auth_ldap/mod_auth_ldap-3.3.ebuild,v 1.8 2006/11/09 22:53:24 kloeri Exp $

inherit eutils apache-module

DESCRIPTION="Apache module for LDAP authorization"
HOMEPAGE="http://www.muquit.com/muquit/software/mod_auth_ldap/mod_auth_ldap.html"
SRC_URI="http://www.muquit.com/muquit/software/${PN}/${PN}${PV}.tar.gz"

KEYWORDS="ppc ppc64 ~sparc x86"
LICENSE="as-is"
SLOT="0"
IUSE="apache2 berkdb diskcache gdbm memcache"

DEPEND=">=net-nds/openldap-2.0.25"
RDEPEND=""

APACHE1_MOD_CONF="55_${PN}"
APACHE1_MOD_DEFINE="AUTH_LDAP"

APACHE2_MOD_CONF="55_${PN}"
APACHE2_MOD_DEFINE="AUTH_LDAP"

DOCFILES="README *.pdf"

S=${WORKDIR}/${PN}${PV}

need_apache

src_compile() {
	local myconf="--with-apache-dir=/usr --with-ldap-dir=/usr"

	if ! use diskcache; then
		if use berkdb || use gdbm; then
			ewarn "Enabling diskcache for berkdb/gdbm support"
		else
			myconf="${myconf} --without-diskcache"
		fi
	fi

	if use apache2; then
		myconf="${myconf} --with-apache-ver=2 --with-apxs=${APXS2}"
	else
		myconf="${myconf} --with-apache-ver=1 --with-apxs=${APXS1}"
	fi

	myconf="${myconf} `use_with gdbm` `use_with berkdb db` `use_with memcache`"

	econf ${myconf} || die "econf failed"

	use memcache && emake libghthash.a
	emake || die "emake failed"
}
