# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/net-dialup/minicom/minicom-2.2.ebuild,v 1.4 2007/02/21 05:20:52 vapier Exp $

inherit eutils flag-o-matic

STUPID_NUM="1806"

DESCRIPTION="Serial Communication Program"
HOMEPAGE="http://alioth.debian.org/projects/minicom"
SRC_URI="http://alioth.debian.org/download.php/${STUPID_NUM}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha amd64 arm ~hppa ia64 ~mips ~ppc ~ppc64 sh sparc ~x86"
IUSE=""

DEPEND=">=sys-libs/ncurses-5.2-r3"
RDEPEND="${DEPEND}
	net-dialup/lrzsz"

src_unpack() {
	unpack ${A}
	cd "${S}"
	epatch "${FILESDIR}"/${P}-gentoo-runscript.patch
	epatch "${FILESDIR}"/${P}-one-off.patch
}

src_compile() {
	# avoid lazy binding (minicom is sgided)
	append-ldflags $(bindnow-flags)
	econf --sysconfdir=/etc/${PN} || die "econf failed"
	emake || die "emake failed"
}

src_install() {
	emake install DESTDIR="${D}" || die "einstall failed"

	# minicom must be uucp sgided is needed for being able to
	# lock serial ports when run as simple user
	fowners root:uucp /usr/bin/minicom
	fperms g+s /usr/bin/minicom

	dodoc AUTHORS ChangeLog NEWS README doc/minicom.FAQ
	insinto /etc/minicom
	doins "${FILESDIR}"/minirc.dfl
}

pkg_preinst() {
	[[ -s /etc/minicom/minirc.dfl ]] \
		&& rm -f "${D}"/etc/minicom/minirc.dfl
}
