# Copyright 1999-2006 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/media-sound/orpheus/orpheus-1.6.ebuild,v 1.2 2006/11/29 19:39:59 aballier Exp $

WANT_AUTOCONF=2.5
WANT_AUTOMAKE=1.8

inherit eutils autotools

DESCRIPTION="Command line MP3 player."
HOMEPAGE="http://konst.org.ua/en/orpheus"
SRC_URI="http://konst.org.ua/download/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~ppc ~sparc ~x86"
IUSE="cddb"

DEPEND=">=sys-libs/ncurses-5.2
	>=media-libs/libvorbis-1.0_beta1
	virtual/mpg123
	cddb? ( gnome-base/libghttp )
	media-sound/vorbis-tools"

src_unpack() {
	unpack ${A}
	cd "${S}"

	epatch "${FILESDIR}/1.5-amd64.patch"

	# configures generated by different autoconf versions
	# cause problems when calling econf
	cd "${S}/kkstrtext-0.1"
	eautoreconf
	cd "${S}/kkconsui-0.1"
	eautoreconf

	# force not using deprecated libghttp
	cd "${S}"
	use cddb || epatch "${FILESDIR}/${P}-nolibghttp.patch"
}

src_compile() {
	econf || die "configure failed"
	emake || die "emake failed"
}

src_install() {
	emake DESTDIR="${D}" install || die "make install failed"
	dodoc AUTHORS ChangeLog NEWS README TODO
}
