# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-java/toolbar/toolbar-0.4.ebuild,v 1.9 2007/01/28 19:19:02 wltjr Exp $

inherit java-pkg

DESCRIPTION="An improved version of JToolBar"
HOMEPAGE="http://toolbar.tigris.org"
SRC_URI="http://toolbar.tigris.org/files/documents/869/10303/ToolBar-${PV}-src.zip"

LICENSE="Apache-2.0"
SLOT="0"
KEYWORDS="x86 amd64"
IUSE="jikes source"

DEPEND=">=virtual/jdk-1.4
	dev-java/ant-core
	jikes? ( dev-java/jikes )
	app-arch/unzip
	source? ( app-arch/zip )"
RDEPEND=">=virtual/jre-1.4"

src_unpack() {
	unpack ${A}

	# Remove the CVS directories
	find . -name 'CVS' | xargs rmdir

	# Remove the src and test directores
	mv src/org ${S}
	rm -rf src test

	# Copy over the build.xml
	cp ${FILESDIR}/build.xml ${S} || die "Unable to copy the build file!"
}

src_compile() {
	local antflags="-Dversion=${PV}"
	use jikes && antflags="${antflags} -Dbuild.compiler=jikes"
	ant ${antflags} || die "Compile failed!"
}

src_install() {
	java-pkg_newjar dest/toolbar-${PV}.jar ${PN}.jar

	use source && java-pkg_dosrc tigris
}
