# Copyright 1999-2005 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-java/axion/axion-1.0_rc2-r2.ebuild,v 1.2 2005/07/12 12:28:37 axxo Exp $

inherit java-pkg eutils

DESCRIPTION="Java RDMS with SQL and JDBC"
HOMEPAGE="http://axion.tigris.org/"
SRC_URI="http://axion.tigris.org/releases/1.0M2/axion-1.0-M2-src.tar.gz"
LICENSE="BSD"
SLOT="0"
KEYWORDS="x86 amd64"
IUSE="doc jikes source"
RDEPEND=">=virtual/jre-1.4
	>=dev-java/commons-collections-2.1
	>=dev-java/commons-primitives-1.0
	>=dev-java/commons-codec-1.2
	>=dev-java/log4j-1.2
	=dev-java/jakarta-regexp-1.3*"
DEPEND=">=virtual/jdk-1.4
	${RDEPEND}
	dev-java/javacc
	jikes? ( >=dev-java/jikes-1.19 )
	source? ( app-arch/zip )
	>=dev-java/ant-1.5.4"

S=${WORKDIR}/${PN}-1.0-M2

src_unpack() {
	unpack ${A}
	cd ${S}

	epatch ${FILESDIR}/commons-codec.patch

	echo javacc.home=/usr/share/javacc/lib/ > build.properties

	mkdir lib test
	cd lib
	java-pkg_jar-from commons-collections
	java-pkg_jar-from commons-primitives
	java-pkg_jar-from commons-logging
	java-pkg_jar-from commons-codec
	java-pkg_jar-from log4j
	java-pkg_jar-from jakarta-regexp-1.3
}

src_compile() {
	local antflags="compile jar"
	use jikes && antflags="-Dbuild.compiler=jikes ${antflags}"
	use doc && antflags="${antflags} javadoc"
	ant ${antflags} || die "Compilation failed"
}

src_install() {
	java-pkg_newjar bin/axion-1.0-M2.jar ${PN}.jar
	use doc && java-pkg_dohtml -r bin/docs/api
	use source && java-pkg_dosrc src/*
}
