/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1997, 98, 99, 2000, 2003 Ralf Baechle
 * Copyright (C) 1999 Silicon Graphics, Inc.
 */
#ifndef _ASM_CACHE_H
#define _ASM_CACHE_H

#include <linux/config.h>
#include <asm/mach-generic/kmalloc.h>

#ifndef CONFIG_MIPS_L1_CACHE_SHIFT
#define L1_CACHE_SHIFT 5  /* 5 is given with MIPS_GENERIC kernel config */
#else
#define L1_CACHE_SHIFT		CONFIG_MIPS_L1_CACHE_SHIFT
#endif
#define L1_CACHE_BYTES		(1 << L1_CACHE_SHIFT)

#define L1_CACHE_SHIFT_MAX	6
#define SMP_CACHE_SHIFT		L1_CACHE_SHIFT
#define SMP_CACHE_BYTES		L1_CACHE_BYTES

#endif /* _ASM_CACHE_H */
