require '_h2ph_pre.ph';

no warnings 'redefine';

require 'asm/types.ph';
require 'linux/major.ph';
unless(defined(&FUSE_KERNEL_VERSION)) {
    sub FUSE_KERNEL_VERSION () {	7;}
}
unless(defined(&FUSE_KERNEL_MINOR_VERSION)) {
    sub FUSE_KERNEL_MINOR_VERSION () {	8;}
}
unless(defined(&FUSE_ROOT_ID)) {
    sub FUSE_ROOT_ID () {	1;}
}
unless(defined(&FUSE_MAJOR)) {
    sub FUSE_MAJOR () {	 &MISC_MAJOR;}
}
unless(defined(&FUSE_MINOR)) {
    sub FUSE_MINOR () {	229;}
}
unless(defined(&FATTR_MODE)) {
    sub FATTR_MODE () {	(1<< 0);}
}
unless(defined(&FATTR_UID)) {
    sub FATTR_UID () {	(1<< 1);}
}
unless(defined(&FATTR_GID)) {
    sub FATTR_GID () {	(1<< 2);}
}
unless(defined(&FATTR_SIZE)) {
    sub FATTR_SIZE () {	(1<< 3);}
}
unless(defined(&FATTR_ATIME)) {
    sub FATTR_ATIME () {	(1<< 4);}
}
unless(defined(&FATTR_MTIME)) {
    sub FATTR_MTIME () {	(1<< 5);}
}
unless(defined(&FATTR_FH)) {
    sub FATTR_FH () {	(1<< 6);}
}
unless(defined(&FOPEN_DIRECT_IO)) {
    sub FOPEN_DIRECT_IO () {	(1<< 0);}
}
unless(defined(&FOPEN_KEEP_CACHE)) {
    sub FOPEN_KEEP_CACHE () {	(1<< 1);}
}
unless(defined(&FUSE_ASYNC_READ)) {
    sub FUSE_ASYNC_READ () {	(1<< 0);}
}
unless(defined(&FUSE_POSIX_LOCKS)) {
    sub FUSE_POSIX_LOCKS () {	(1<< 1);}
}
unless(defined(&FUSE_RELEASE_FLUSH)) {
    sub FUSE_RELEASE_FLUSH () {	(1<< 0);}
}
eval("sub FUSE_LOOKUP () { 1; }") unless defined(&FUSE_LOOKUP);
eval("sub FUSE_FORGET () { 2; }") unless defined(&FUSE_FORGET);
eval("sub FUSE_GETATTR () { 3; }") unless defined(&FUSE_GETATTR);
eval("sub FUSE_SETATTR () { 4; }") unless defined(&FUSE_SETATTR);
eval("sub FUSE_READLINK () { 5; }") unless defined(&FUSE_READLINK);
eval("sub FUSE_SYMLINK () { 6; }") unless defined(&FUSE_SYMLINK);
eval("sub FUSE_MKNOD () { 8; }") unless defined(&FUSE_MKNOD);
eval("sub FUSE_MKDIR () { 9; }") unless defined(&FUSE_MKDIR);
eval("sub FUSE_UNLINK () { 10; }") unless defined(&FUSE_UNLINK);
eval("sub FUSE_RMDIR () { 11; }") unless defined(&FUSE_RMDIR);
eval("sub FUSE_RENAME () { 12; }") unless defined(&FUSE_RENAME);
eval("sub FUSE_LINK () { 13; }") unless defined(&FUSE_LINK);
eval("sub FUSE_OPEN () { 14; }") unless defined(&FUSE_OPEN);
eval("sub FUSE_READ () { 15; }") unless defined(&FUSE_READ);
eval("sub FUSE_WRITE () { 16; }") unless defined(&FUSE_WRITE);
eval("sub FUSE_STATFS () { 17; }") unless defined(&FUSE_STATFS);
eval("sub FUSE_RELEASE () { 18; }") unless defined(&FUSE_RELEASE);
eval("sub FUSE_FSYNC () { 20; }") unless defined(&FUSE_FSYNC);
eval("sub FUSE_SETXATTR () { 21; }") unless defined(&FUSE_SETXATTR);
eval("sub FUSE_GETXATTR () { 22; }") unless defined(&FUSE_GETXATTR);
eval("sub FUSE_LISTXATTR () { 23; }") unless defined(&FUSE_LISTXATTR);
eval("sub FUSE_REMOVEXATTR () { 24; }") unless defined(&FUSE_REMOVEXATTR);
eval("sub FUSE_FLUSH () { 25; }") unless defined(&FUSE_FLUSH);
eval("sub FUSE_INIT () { 26; }") unless defined(&FUSE_INIT);
eval("sub FUSE_OPENDIR () { 27; }") unless defined(&FUSE_OPENDIR);
eval("sub FUSE_READDIR () { 28; }") unless defined(&FUSE_READDIR);
eval("sub FUSE_RELEASEDIR () { 29; }") unless defined(&FUSE_RELEASEDIR);
eval("sub FUSE_FSYNCDIR () { 30; }") unless defined(&FUSE_FSYNCDIR);
eval("sub FUSE_GETLK () { 31; }") unless defined(&FUSE_GETLK);
eval("sub FUSE_SETLK () { 32; }") unless defined(&FUSE_SETLK);
eval("sub FUSE_SETLKW () { 33; }") unless defined(&FUSE_SETLKW);
eval("sub FUSE_ACCESS () { 34; }") unless defined(&FUSE_ACCESS);
eval("sub FUSE_CREATE () { 35; }") unless defined(&FUSE_CREATE);
eval("sub FUSE_INTERRUPT () { 36; }") unless defined(&FUSE_INTERRUPT);
eval("sub FUSE_BMAP () { 37; }") unless defined(&FUSE_BMAP);
eval("sub FUSE_DESTROY () { 38; }") unless defined(&FUSE_DESTROY);
unless(defined(&FUSE_MIN_READ_BUFFER)) {
    sub FUSE_MIN_READ_BUFFER () {	8192;}
}
unless(defined(&FUSE_COMPAT_STATFS_SIZE)) {
    sub FUSE_COMPAT_STATFS_SIZE () {	48;}
}
unless(defined(&FUSE_NAME_OFFSET)) {
    sub FUSE_NAME_OFFSET () {	 &offsetof('struct fuse_dirent',  &name);}
}
unless(defined(&FUSE_DIRENT_ALIGN)) {
    sub FUSE_DIRENT_ALIGN {
	my($x) = @_;
	eval q(((($x) + $sizeof{ &__u64} - 1) & ~($sizeof{ &__u64} - 1)));
    }
}
unless(defined(&FUSE_DIRENT_SIZE)) {
    sub FUSE_DIRENT_SIZE {
	my($d) = @_;
	eval q( &FUSE_DIRENT_ALIGN( &FUSE_NAME_OFFSET + ($d)-> &namelen));
    }
}
1;
