require '_h2ph_pre.ph';

no warnings 'redefine';

require 'stdint.ph';
unless(defined(&LOCK_PREFIX)) {
    if(defined(&UP)) {
	eval 'sub LOCK_PREFIX () {1;}' unless defined(&LOCK_PREFIX);
    } else {
	eval 'sub LOCK_PREFIX () {"lock;";}' unless defined(&LOCK_PREFIX);
    }
}
unless(defined(&__arch_compare_and_exchange_val_8_acq)) {
    sub __arch_compare_and_exchange_val_8_acq {
	my($mem, $newval, $oldval) = @_;
	eval q(({  &__typeof (*$mem)  &ret;  &__asm  &__volatile ( &LOCK_PREFIX \"cmpxchgb %b2, %1\" : \"=a\" ( &ret), \"=m\" (*$mem) : \"q\" ($newval), \"m\" (*$mem), \"0\" ($oldval));  &ret; }));
    }
}
unless(defined(&__arch_compare_and_exchange_val_16_acq)) {
    sub __arch_compare_and_exchange_val_16_acq {
	my($mem, $newval, $oldval) = @_;
	eval q(({  &__typeof (*$mem)  &ret;  &__asm  &__volatile ( &LOCK_PREFIX \"cmpxchgw %w2, %1\" : \"=a\" ( &ret), \"=m\" (*$mem) : \"r\" ($newval), \"m\" (*$mem), \"0\" ($oldval));  &ret; }));
    }
}
unless(defined(&__arch_compare_and_exchange_val_32_acq)) {
    sub __arch_compare_and_exchange_val_32_acq {
	my($mem, $newval, $oldval) = @_;
	eval q(({  &__typeof (*$mem)  &ret;  &__asm  &__volatile ( &LOCK_PREFIX \"cmpxchgl %2, %1\" : \"=a\" ( &ret), \"=m\" (*$mem) : \"r\" ($newval), \"m\" (*$mem), \"0\" ($oldval));  &ret; }));
    }
}
if(1) {
    eval 'sub __arch_compare_and_exchange_val_64_acq {
        my($mem, $newval, $oldval) = @_;
	    eval q(({  &__typeof (*$mem)  &ret = *($mem);  &abort ();  &ret = ($newval);  &ret = ($oldval); }));
    }' unless defined(&__arch_compare_and_exchange_val_64_acq);
} else {
    if(defined(&__PIC__)) {
	eval 'sub __arch_compare_and_exchange_val_64_acq {
	    my($mem, $newval, $oldval) = @_;
    	    eval q(({  &__typeof (*$mem)  &ret;  &__asm  &__volatile (\\"xchgl %2, %%ebx\\\\n\\\\t\\"  &LOCK_PREFIX \\"cmpxchg8b %1\\\\n\\\\t\\" \\"xchgl %2, %%ebx\\" : \\"=A\\" ( &ret), \\"=m\\" (*$mem) : \\"DS\\" (( ($newval)) & 0xffffffff), \\"c\\" (( ($newval)) >> 32), \\"m\\" (*$mem), \\"a\\" (( ($oldval)) & 0xffffffff), \\"d\\" (( ($oldval)) >> 32));  &ret; }));
	}' unless defined(&__arch_compare_and_exchange_val_64_acq);
    } else {
	eval 'sub __arch_compare_and_exchange_val_64_acq {
	    my($mem, $newval, $oldval) = @_;
    	    eval q(({  &__typeof (*$mem)  &ret;  &__asm  &__volatile ( &LOCK_PREFIX \\"cmpxchg8b %1\\" : \\"=A\\" ( &ret), \\"=m\\" (*$mem) : \\"b\\" (( ($newval)) & 0xffffffff), \\"c\\" (( ($newval)) >> 32), \\"m\\" (*$mem), \\"a\\" (( ($oldval)) & 0xffffffff), \\"d\\" (( ($oldval)) >> 32));  &ret; }));
	}' unless defined(&__arch_compare_and_exchange_val_64_acq);
    }
}
unless(defined(&atomic_exchange_acq)) {
    sub atomic_exchange_acq {
	my($mem, $newvalue) = @_;
	eval q(({  &__typeof (*$mem)  &result;  &if ($sizeof{$mem} == 1)  &__asm  &__volatile (\"xchgb %b0, %1\" : \"=r\" ( &result), \"=m\" (*$mem) : \"0\" ($newvalue), \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile (\"xchgw %w0, %1\" : \"=r\" ( &result), \"=m\" (*$mem) : \"0\" ($newvalue), \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile (\"xchgl %0, %1\" : \"=r\" ( &result), \"=m\" (*$mem) : \"0\" ($newvalue), \"m\" (*$mem));  &else {  &result = 0;  &abort (); }  &result; }));
    }
}
unless(defined(&atomic_exchange_and_add)) {
    sub atomic_exchange_and_add {
	my($mem, $value) = @_;
	eval q(({  &__typeof (*$mem)  &__result;  &__typeof ($value)  &__addval = ($value);  &if ($sizeof{$mem} == 1)  &__asm  &__volatile ( &LOCK_PREFIX \"xaddb %b0, %1\" : \"=r\" ( &__result), \"=m\" (*$mem) : \"0\" ( &__addval), \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile ( &LOCK_PREFIX \"xaddw %w0, %1\" : \"=r\" ( &__result), \"=m\" (*$mem) : \"0\" ( &__addval), \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile ( &LOCK_PREFIX \"xaddl %0, %1\" : \"=r\" ( &__result), \"=m\" (*$mem) : \"0\" ( &__addval), \"m\" (*$mem));  &else {  &__typeof ($mem)  &__memp = ($mem);  &__typeof (*$mem)  &__tmpval;  &__result = * &__memp;  &do  &__tmpval =  &__result;  &while (( &__result =  &__arch_compare_and_exchange_val_64_acq ( &__memp,  &__result +  &__addval,  &__result)) ==  &__tmpval); }  &__result; }));
    }
}
unless(defined(&atomic_add)) {
    sub atomic_add {
	my($mem, $value) = @_;
	eval q(( &void) ({  &if ( &__builtin_constant_p ($value)  && ($value) == 1)  &atomic_increment ($mem);  &else  &if ( &__builtin_constant_p ($value)  && ($value) == -1)  &atomic_decrement ($mem);  &else  &if ($sizeof{$mem} == 1)  &__asm  &__volatile ( &LOCK_PREFIX \"addb %b1, %0\" : \"=m\" (*$mem) : \"ir\" ($value), \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile ( &LOCK_PREFIX \"addw %w1, %0\" : \"=m\" (*$mem) : \"ir\" ($value), \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile ( &LOCK_PREFIX \"addl %1, %0\" : \"=m\" (*$mem) : \"ir\" ($value), \"m\" (*$mem));  &else {  &__typeof ($value)  &__addval = ($value);  &__typeof ($mem)  &__memp = ($mem);  &__typeof (*$mem)  &__oldval = * &__memp;  &__typeof (*$mem)  &__tmpval;  &do  &__tmpval =  &__oldval;  &while (( &__oldval =  &__arch_compare_and_exchange_val_64_acq ( &__memp,  &__oldval +  &__addval,  &__oldval)) ==  &__tmpval); } }));
    }
}
unless(defined(&atomic_add_negative)) {
    sub atomic_add_negative {
	my($mem, $value) = @_;
	eval q(({ 'unsigned char __result';  &if ($sizeof{$mem} == 1)  &__asm  &__volatile ( &LOCK_PREFIX \"addb %b2, %0; sets %1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"iq\" ($value), \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile ( &LOCK_PREFIX \"addw %w2, %0; sets %1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"ir\" ($value), \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile ( &LOCK_PREFIX \"addl %2, %0; sets %1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"ir\" ($value), \"m\" (*$mem));  &else  &abort ();  &__result; }));
    }
}
unless(defined(&atomic_add_zero)) {
    sub atomic_add_zero {
	my($mem, $value) = @_;
	eval q(({ 'unsigned char __result';  &if ($sizeof{$mem} == 1)  &__asm  &__volatile ( &LOCK_PREFIX \"addb %b2, %0; setz %1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"ir\" ($value), \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile ( &LOCK_PREFIX \"addw %w2, %0; setz %1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"ir\" ($value), \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile ( &LOCK_PREFIX \"addl %2, %0; setz %1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"ir\" ($value), \"m\" (*$mem));  &else  &abort ();  &__result; }));
    }
}
unless(defined(&atomic_increment)) {
    sub atomic_increment {
	my($mem) = @_;
	eval q(( &void) ({  &if ($sizeof{$mem} == 1)  &__asm  &__volatile ( &LOCK_PREFIX \"incb %b0\" : \"=m\" (*$mem) : \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile ( &LOCK_PREFIX \"incw %w0\" : \"=m\" (*$mem) : \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile ( &LOCK_PREFIX \"incl %0\" : \"=m\" (*$mem) : \"m\" (*$mem));  &else {  &__typeof ($mem)  &__memp = ($mem);  &__typeof (*$mem)  &__oldval = * &__memp;  &__typeof (*$mem)  &__tmpval;  &do  &__tmpval =  &__oldval;  &while (( &__oldval =  &__arch_compare_and_exchange_val_64_acq ( &__memp,  &__oldval + 1,  &__oldval)) ==  &__tmpval); } }));
    }
}
unless(defined(&atomic_increment_and_test)) {
    sub atomic_increment_and_test {
	my($mem) = @_;
	eval q(({ 'unsigned char __result';  &if ($sizeof{$mem} == 1)  &__asm  &__volatile ( &LOCK_PREFIX \"incb %0; sete %b1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile ( &LOCK_PREFIX \"incw %0; sete %w1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile ( &LOCK_PREFIX \"incl %0; sete %1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"m\" (*$mem));  &else  &abort ();  &__result; }));
    }
}
unless(defined(&atomic_decrement)) {
    sub atomic_decrement {
	my($mem) = @_;
	eval q(( &void) ({  &if ($sizeof{$mem} == 1)  &__asm  &__volatile ( &LOCK_PREFIX \"decb %b0\" : \"=m\" (*$mem) : \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile ( &LOCK_PREFIX \"decw %w0\" : \"=m\" (*$mem) : \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile ( &LOCK_PREFIX \"decl %0\" : \"=m\" (*$mem) : \"m\" (*$mem));  &else {  &__typeof ($mem)  &__memp = ($mem);  &__typeof (*$mem)  &__oldval = * &__memp;  &__typeof (*$mem)  &__tmpval;  &do  &__tmpval =  &__oldval;  &while (( &__oldval =  &__arch_compare_and_exchange_val_64_acq ( &__memp,  &__oldval - 1,  &__oldval)) ==  &__tmpval); } }));
    }
}
unless(defined(&atomic_decrement_and_test)) {
    sub atomic_decrement_and_test {
	my($mem) = @_;
	eval q(({ 'unsigned char __result';  &if ($sizeof{$mem} == 1)  &__asm  &__volatile ( &LOCK_PREFIX \"decb %b0; sete %1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile ( &LOCK_PREFIX \"decw %w0; sete %1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"m\" (*$mem));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile ( &LOCK_PREFIX \"decl %0; sete %1\" : \"=m\" (*$mem), \"=qm\" ( &__result) : \"m\" (*$mem));  &else  &abort ();  &__result; }));
    }
}
unless(defined(&atomic_bit_set)) {
    sub atomic_bit_set {
	my($mem, $bit) = @_;
	eval q(( &void) ({  &if ($sizeof{$mem} == 1)  &__asm  &__volatile ( &LOCK_PREFIX \"orb %b2, %0\" : \"=m\" (*$mem) : \"m\" (*$mem), \"ir\" (1<< ($bit)));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile ( &LOCK_PREFIX \"orw %w2, %0\" : \"=m\" (*$mem) : \"m\" (*$mem), \"ir\" (1<< ($bit)));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile ( &LOCK_PREFIX \"orl %2, %0\" : \"=m\" (*$mem) : \"m\" (*$mem), \"ir\" (1<< ($bit)));  &else  &abort (); }));
    }
}
unless(defined(&atomic_bit_test_set)) {
    sub atomic_bit_test_set {
	my($mem, $bit) = @_;
	eval q(({ 'unsigned char __result';  &if ($sizeof{$mem} == 1)  &__asm  &__volatile ( &LOCK_PREFIX \"btsb %3, %1; setc %0\" : \"=q\" ( &__result), \"=m\" (*$mem) : \"m\" (*$mem), \"ir\" ($bit));  &else  &if ($sizeof{$mem} == 2)  &__asm  &__volatile ( &LOCK_PREFIX \"btsw %3, %1; setc %0\" : \"=q\" ( &__result), \"=m\" (*$mem) : \"m\" (*$mem), \"ir\" ($bit));  &else  &if ($sizeof{$mem} == 4)  &__asm  &__volatile ( &LOCK_PREFIX \"btsl %3, %1; setc %0\" : \"=q\" ( &__result), \"=m\" (*$mem) : \"m\" (*$mem), \"ir\" ($bit));  &else  &abort ();  &__result; }));
    }
}
unless(defined(&atomic_delay)) {
    sub atomic_delay () {
	eval q( &asm (\"rep; nop\"));
    }
}
1;
