require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_FS_H)) {
    eval 'sub _LINUX_FS_H () {1;}' unless defined(&_LINUX_FS_H);
    require 'linux/limits.ph';
    require 'linux/ioctl.ph';
    undef(&NR_OPEN) if defined(&NR_OPEN);
    eval 'sub NR_OPEN () {(1024*1024);}' unless defined(&NR_OPEN);
    eval 'sub INR_OPEN () {1024;}' unless defined(&INR_OPEN);
    eval 'sub BLOCK_SIZE_BITS () {10;}' unless defined(&BLOCK_SIZE_BITS);
    eval 'sub BLOCK_SIZE () {(1<< &BLOCK_SIZE_BITS);}' unless defined(&BLOCK_SIZE);
    eval 'sub SEEK_SET () {0;}' unless defined(&SEEK_SET);
    eval 'sub SEEK_CUR () {1;}' unless defined(&SEEK_CUR);
    eval 'sub SEEK_END () {2;}' unless defined(&SEEK_END);
    eval 'sub SEEK_MAX () { &SEEK_END;}' unless defined(&SEEK_MAX);
    if(defined(&CONFIG_DNOTIFY)) {
    }
    eval 'sub NR_FILE () {8192;}' unless defined(&NR_FILE);
    eval 'sub MAY_EXEC () {1;}' unless defined(&MAY_EXEC);
    eval 'sub MAY_WRITE () {2;}' unless defined(&MAY_WRITE);
    eval 'sub MAY_READ () {4;}' unless defined(&MAY_READ);
    eval 'sub MAY_APPEND () {8;}' unless defined(&MAY_APPEND);
    eval 'sub FMODE_READ () {1;}' unless defined(&FMODE_READ);
    eval 'sub FMODE_WRITE () {2;}' unless defined(&FMODE_WRITE);
    eval 'sub FMODE_LSEEK () {4;}' unless defined(&FMODE_LSEEK);
    eval 'sub FMODE_PREAD () {8;}' unless defined(&FMODE_PREAD);
    eval 'sub FMODE_PWRITE () { &FMODE_PREAD;}' unless defined(&FMODE_PWRITE);
    eval 'sub FMODE_EXEC () {16;}' unless defined(&FMODE_EXEC);
    eval 'sub RW_MASK () {1;}' unless defined(&RW_MASK);
    eval 'sub RWA_MASK () {2;}' unless defined(&RWA_MASK);
    eval 'sub READ () {0;}' unless defined(&READ);
    eval 'sub WRITE () {1;}' unless defined(&WRITE);
    eval 'sub READA () {2;}' unless defined(&READA);
    eval 'sub SWRITE () {3;}' unless defined(&SWRITE);
    eval 'sub READ_SYNC () {( &READ | (1<<  &BIO_RW_SYNC));}' unless defined(&READ_SYNC);
    eval 'sub READ_META () {( &READ | (1<<  &BIO_RW_META));}' unless defined(&READ_META);
    eval 'sub WRITE_SYNC () {( &WRITE | (1<<  &BIO_RW_SYNC));}' unless defined(&WRITE_SYNC);
    eval 'sub WRITE_BARRIER () {((1<<  &BIO_RW) | (1<<  &BIO_RW_BARRIER));}' unless defined(&WRITE_BARRIER);
    eval 'sub SEL_IN () {1;}' unless defined(&SEL_IN);
    eval 'sub SEL_OUT () {2;}' unless defined(&SEL_OUT);
    eval 'sub SEL_EX () {4;}' unless defined(&SEL_EX);
    eval 'sub FS_REQUIRES_DEV () {1;}' unless defined(&FS_REQUIRES_DEV);
    eval 'sub FS_BINARY_MOUNTDATA () {2;}' unless defined(&FS_BINARY_MOUNTDATA);
    eval 'sub FS_HAS_SUBTYPE () {4;}' unless defined(&FS_HAS_SUBTYPE);
    eval 'sub FS_REVAL_DOT () {16384;}' unless defined(&FS_REVAL_DOT);
    eval 'sub FS_RENAME_DOES_D_MOVE () {32768;}' unless defined(&FS_RENAME_DOES_D_MOVE);
    eval 'sub MS_RDONLY () {1;}' unless defined(&MS_RDONLY);
    eval 'sub MS_NOSUID () {2;}' unless defined(&MS_NOSUID);
    eval 'sub MS_NODEV () {4;}' unless defined(&MS_NODEV);
    eval 'sub MS_NOEXEC () {8;}' unless defined(&MS_NOEXEC);
    eval 'sub MS_SYNCHRONOUS () {16;}' unless defined(&MS_SYNCHRONOUS);
    eval 'sub MS_REMOUNT () {32;}' unless defined(&MS_REMOUNT);
    eval 'sub MS_MANDLOCK () {64;}' unless defined(&MS_MANDLOCK);
    eval 'sub MS_DIRSYNC () {128;}' unless defined(&MS_DIRSYNC);
    eval 'sub MS_NOATIME () {1024;}' unless defined(&MS_NOATIME);
    eval 'sub MS_NODIRATIME () {2048;}' unless defined(&MS_NODIRATIME);
    eval 'sub MS_BIND () {4096;}' unless defined(&MS_BIND);
    eval 'sub MS_MOVE () {8192;}' unless defined(&MS_MOVE);
    eval 'sub MS_REC () {16384;}' unless defined(&MS_REC);
    eval 'sub MS_VERBOSE () {32768;}' unless defined(&MS_VERBOSE);
    eval 'sub MS_SILENT () {32768;}' unless defined(&MS_SILENT);
    eval 'sub MS_POSIXACL () {(1<<16);}' unless defined(&MS_POSIXACL);
    eval 'sub MS_UNBINDABLE () {(1<<17);}' unless defined(&MS_UNBINDABLE);
    eval 'sub MS_PRIVATE () {(1<<18);}' unless defined(&MS_PRIVATE);
    eval 'sub MS_SLAVE () {(1<<19);}' unless defined(&MS_SLAVE);
    eval 'sub MS_SHARED () {(1<<20);}' unless defined(&MS_SHARED);
    eval 'sub MS_RELATIME () {(1<<21);}' unless defined(&MS_RELATIME);
    eval 'sub MS_ACTIVE () {(1<<30);}' unless defined(&MS_ACTIVE);
    eval 'sub MS_NOUSER () {(1<<31);}' unless defined(&MS_NOUSER);
    eval 'sub MS_RMT_MASK () {( &MS_RDONLY| &MS_SYNCHRONOUS| &MS_MANDLOCK);}' unless defined(&MS_RMT_MASK);
    eval 'sub MS_MGC_VAL () {0xc0ed0000;}' unless defined(&MS_MGC_VAL);
    eval 'sub MS_MGC_MSK () {0xffff0000;}' unless defined(&MS_MGC_MSK);
    eval 'sub S_SYNC () {1;}' unless defined(&S_SYNC);
    eval 'sub S_NOATIME () {2;}' unless defined(&S_NOATIME);
    eval 'sub S_APPEND () {4;}' unless defined(&S_APPEND);
    eval 'sub S_IMMUTABLE () {8;}' unless defined(&S_IMMUTABLE);
    eval 'sub S_DEAD () {16;}' unless defined(&S_DEAD);
    eval 'sub S_NOQUOTA () {32;}' unless defined(&S_NOQUOTA);
    eval 'sub S_DIRSYNC () {64;}' unless defined(&S_DIRSYNC);
    eval 'sub S_NOCMTIME () {128;}' unless defined(&S_NOCMTIME);
    eval 'sub S_SWAPFILE () {256;}' unless defined(&S_SWAPFILE);
    eval 'sub S_PRIVATE () {512;}' unless defined(&S_PRIVATE);
    eval 'sub __IS_FLG {
        my($inode,$flg) = @_;
	    eval q((($inode)-> ($i_sb->{s_flags}) & ($flg)));
    }' unless defined(&__IS_FLG);
    eval 'sub IS_RDONLY {
        my($inode) = @_;
	    eval q((($inode)-> ($i_sb->{s_flags}) &  &MS_RDONLY));
    }' unless defined(&IS_RDONLY);
    eval 'sub IS_SYNC {
        my($inode) = @_;
	    eval q(( &__IS_FLG($inode,  &MS_SYNCHRONOUS) || (($inode)-> &i_flags &  &S_SYNC)));
    }' unless defined(&IS_SYNC);
    eval 'sub IS_DIRSYNC {
        my($inode) = @_;
	    eval q(( &__IS_FLG($inode,  &MS_SYNCHRONOUS| &MS_DIRSYNC) || (($inode)-> &i_flags & ( &S_SYNC| &S_DIRSYNC))));
    }' unless defined(&IS_DIRSYNC);
    eval 'sub IS_MANDLOCK {
        my($inode) = @_;
	    eval q( &__IS_FLG($inode,  &MS_MANDLOCK));
    }' unless defined(&IS_MANDLOCK);
    eval 'sub IS_NOATIME {
        my($inode) = @_;
	    eval q( &__IS_FLG($inode,  &MS_RDONLY| &MS_NOATIME));
    }' unless defined(&IS_NOATIME);
    eval 'sub IS_NOQUOTA {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_NOQUOTA));
    }' unless defined(&IS_NOQUOTA);
    eval 'sub IS_APPEND {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_APPEND));
    }' unless defined(&IS_APPEND);
    eval 'sub IS_IMMUTABLE {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_IMMUTABLE));
    }' unless defined(&IS_IMMUTABLE);
    eval 'sub IS_POSIXACL {
        my($inode) = @_;
	    eval q( &__IS_FLG($inode,  &MS_POSIXACL));
    }' unless defined(&IS_POSIXACL);
    eval 'sub IS_DEADDIR {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_DEAD));
    }' unless defined(&IS_DEADDIR);
    eval 'sub IS_NOCMTIME {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_NOCMTIME));
    }' unless defined(&IS_NOCMTIME);
    eval 'sub IS_SWAPFILE {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_SWAPFILE));
    }' unless defined(&IS_SWAPFILE);
    eval 'sub IS_PRIVATE {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_PRIVATE));
    }' unless defined(&IS_PRIVATE);
    eval 'sub BLKROSET () { &_IO(0x12,93);}' unless defined(&BLKROSET);
    eval 'sub BLKROGET () { &_IO(0x12,94);}' unless defined(&BLKROGET);
    eval 'sub BLKRRPART () { &_IO(0x12,95);}' unless defined(&BLKRRPART);
    eval 'sub BLKGETSIZE () { &_IO(0x12,96);}' unless defined(&BLKGETSIZE);
    eval 'sub BLKFLSBUF () { &_IO(0x12,97);}' unless defined(&BLKFLSBUF);
    eval 'sub BLKRASET () { &_IO(0x12,98);}' unless defined(&BLKRASET);
    eval 'sub BLKRAGET () { &_IO(0x12,99);}' unless defined(&BLKRAGET);
    eval 'sub BLKFRASET () { &_IO(0x12,100);}' unless defined(&BLKFRASET);
    eval 'sub BLKFRAGET () { &_IO(0x12,101);}' unless defined(&BLKFRAGET);
    eval 'sub BLKSECTSET () { &_IO(0x12,102);}' unless defined(&BLKSECTSET);
    eval 'sub BLKSECTGET () { &_IO(0x12,103);}' unless defined(&BLKSECTGET);
    eval 'sub BLKSSZGET () { &_IO(0x12,104);}' unless defined(&BLKSSZGET);
    if(0) {
	eval 'sub BLKPG () { &_IO(0x12,105);}' unless defined(&BLKPG);
	eval 'sub BLKELVGET () { &_IOR(0x12,106,\'size_t\');}' unless defined(&BLKELVGET);
	eval 'sub BLKELVSET () { &_IOW(0x12,107,\'size_t\');}' unless defined(&BLKELVSET);
    }
    eval 'sub BLKBSZGET () { &_IOR(0x12,112,\'size_t\');}' unless defined(&BLKBSZGET);
    eval 'sub BLKBSZSET () { &_IOW(0x12,113,\'size_t\');}' unless defined(&BLKBSZSET);
    eval 'sub BLKGETSIZE64 () { &_IOR(0x12,114,\'size_t\');}' unless defined(&BLKGETSIZE64);
    eval 'sub BLKTRACESETUP () { &_IOWR(0x12,115,\'struct blk_user_trace_setup\');}' unless defined(&BLKTRACESETUP);
    eval 'sub BLKTRACESTART () { &_IO(0x12,116);}' unless defined(&BLKTRACESTART);
    eval 'sub BLKTRACESTOP () { &_IO(0x12,117);}' unless defined(&BLKTRACESTOP);
    eval 'sub BLKTRACETEARDOWN () { &_IO(0x12,118);}' unless defined(&BLKTRACETEARDOWN);
    eval 'sub BMAP_IOCTL () {1;}' unless defined(&BMAP_IOCTL);
    eval 'sub FIBMAP () { &_IO(0x,1);}' unless defined(&FIBMAP);
    eval 'sub FIGETBSZ () { &_IO(0x,2);}' unless defined(&FIGETBSZ);
    eval 'sub FS_IOC_GETFLAGS () { &_IOR(ord(\'f\'), 1, \'long\');}' unless defined(&FS_IOC_GETFLAGS);
    eval 'sub FS_IOC_SETFLAGS () { &_IOW(ord(\'f\'), 2, \'long\');}' unless defined(&FS_IOC_SETFLAGS);
    eval 'sub FS_IOC_GETVERSION () { &_IOR(ord(\'v\'), 1, \'long\');}' unless defined(&FS_IOC_GETVERSION);
    eval 'sub FS_IOC_SETVERSION () { &_IOW(ord(\'v\'), 2, \'long\');}' unless defined(&FS_IOC_SETVERSION);
    eval 'sub FS_IOC32_GETFLAGS () { &_IOR(ord(\'f\'), 1, \'int\');}' unless defined(&FS_IOC32_GETFLAGS);
    eval 'sub FS_IOC32_SETFLAGS () { &_IOW(ord(\'f\'), 2, \'int\');}' unless defined(&FS_IOC32_SETFLAGS);
    eval 'sub FS_IOC32_GETVERSION () { &_IOR(ord(\'v\'), 1, \'int\');}' unless defined(&FS_IOC32_GETVERSION);
    eval 'sub FS_IOC32_SETVERSION () { &_IOW(ord(\'v\'), 2, \'int\');}' unless defined(&FS_IOC32_SETVERSION);
    eval 'sub FS_SECRM_FL () {0x1;}' unless defined(&FS_SECRM_FL);
    eval 'sub FS_UNRM_FL () {0x2;}' unless defined(&FS_UNRM_FL);
    eval 'sub FS_COMPR_FL () {0x4;}' unless defined(&FS_COMPR_FL);
    eval 'sub FS_SYNC_FL () {0x8;}' unless defined(&FS_SYNC_FL);
    eval 'sub FS_IMMUTABLE_FL () {0x10;}' unless defined(&FS_IMMUTABLE_FL);
    eval 'sub FS_APPEND_FL () {0x20;}' unless defined(&FS_APPEND_FL);
    eval 'sub FS_NODUMP_FL () {0x40;}' unless defined(&FS_NODUMP_FL);
    eval 'sub FS_NOATIME_FL () {0x80;}' unless defined(&FS_NOATIME_FL);
    eval 'sub FS_DIRTY_FL () {0x100;}' unless defined(&FS_DIRTY_FL);
    eval 'sub FS_COMPRBLK_FL () {0x200;}' unless defined(&FS_COMPRBLK_FL);
    eval 'sub FS_NOCOMP_FL () {0x400;}' unless defined(&FS_NOCOMP_FL);
    eval 'sub FS_ECOMPR_FL () {0x800;}' unless defined(&FS_ECOMPR_FL);
    eval 'sub FS_BTREE_FL () {0x1000;}' unless defined(&FS_BTREE_FL);
    eval 'sub FS_INDEX_FL () {0x1000;}' unless defined(&FS_INDEX_FL);
    eval 'sub FS_IMAGIC_FL () {0x2000;}' unless defined(&FS_IMAGIC_FL);
    eval 'sub FS_JOURNAL_DATA_FL () {0x4000;}' unless defined(&FS_JOURNAL_DATA_FL);
    eval 'sub FS_NOTAIL_FL () {0x8000;}' unless defined(&FS_NOTAIL_FL);
    eval 'sub FS_DIRSYNC_FL () {0x10000;}' unless defined(&FS_DIRSYNC_FL);
    eval 'sub FS_TOPDIR_FL () {0x20000;}' unless defined(&FS_TOPDIR_FL);
    eval 'sub FS_EXTENT_FL () {0x80000;}' unless defined(&FS_EXTENT_FL);
    eval 'sub FS_DIRECTIO_FL () {0x100000;}' unless defined(&FS_DIRECTIO_FL);
    eval 'sub FS_RESERVED_FL () {0x80000000;}' unless defined(&FS_RESERVED_FL);
    eval 'sub FS_FL_USER_VISIBLE () {0x3dfff;}' unless defined(&FS_FL_USER_VISIBLE);
    eval 'sub FS_FL_USER_MODIFIABLE () {0x380ff;}' unless defined(&FS_FL_USER_MODIFIABLE);
    eval 'sub SYNC_FILE_RANGE_WAIT_BEFORE () {1;}' unless defined(&SYNC_FILE_RANGE_WAIT_BEFORE);
    eval 'sub SYNC_FILE_RANGE_WRITE () {2;}' unless defined(&SYNC_FILE_RANGE_WRITE);
    eval 'sub SYNC_FILE_RANGE_WAIT_AFTER () {4;}' unless defined(&SYNC_FILE_RANGE_WAIT_AFTER);
}
1;
