#ifndef S390_CMB_H
#define S390_CMB_H
/**
 * struct cmbdata -- channel measurement block data for user space
 *
 * @size:	size of the stored data
 * @ssch_rsch_count: XXX
 * @sample_count:
 * @device_connect_time:
 * @function_pending_time:
 * @device_disconnect_time:
 * @control_unit_queuing_time:
 * @device_active_only_time:
 * @device_busy_time:
 * @initial_command_response_time:
 *
 * all values are stored as 64 bit for simplicity, especially
 * in 32 bit emulation mode. All time values are normalized to
 * nanoseconds.
 * Currently, two formats are known, which differ by the size of
 * this structure, i.e. the last two members are only set when
 * the extended channel measurement facility (first shipped in
 * z990 machines) is activated.
 * Potentially, more fields could be added, which results in a
 * new ioctl number.
 **/
struct cmbdata {
	__u64 size;
	__u64 elapsed_time;
 /* basic and exended format: */
	__u64 ssch_rsch_count;
	__u64 sample_count;
	__u64 device_connect_time;
	__u64 function_pending_time;
	__u64 device_disconnect_time;
	__u64 control_unit_queuing_time;
	__u64 device_active_only_time;
 /* extended format only: */
	__u64 device_busy_time;
	__u64 initial_command_response_time;
};

/* enable channel measurement */
#define BIODASDCMFENABLE	_IO(DASD_IOCTL_LETTER,32)
/* enable channel measurement */
#define BIODASDCMFDISABLE	_IO(DASD_IOCTL_LETTER,33)
/* read channel measurement data */
#define BIODASDREADALLCMB	_IOWR(DASD_IOCTL_LETTER,33,struct cmbdata)

#endif /* S390_CMB_H */
