require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_WANPIPE_H)) {
    eval 'sub _WANPIPE_H () {1;}' unless defined(&_WANPIPE_H);
    require 'linux/version.ph';
    unless(defined(&KERNEL_VERSION)) {
	eval 'sub KERNEL_VERSION {
	    local($a,$b,$c) = @_;
    	    eval q(((($a) << 16) + (($b) << 8) + ($c)));
	}' unless defined(&KERNEL_VERSION);
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) >=  &KERNEL_VERSION(2,3,0)) {
	eval 'sub LINUX_2_4 () {1;}' unless defined(&LINUX_2_4);
	eval 'sub netdevice_t () {\'struct net_device\';}' unless defined(&netdevice_t);
	eval 'sub FREE_READ () {1;}' unless defined(&FREE_READ);
	eval 'sub FREE_WRITE () {0;}' unless defined(&FREE_WRITE);
	eval 'sub stop_net_queue {
	    local($a) = @_;
    	    eval q( &netif_stop_queue($a));
	}' unless defined(&stop_net_queue);
	eval 'sub start_net_queue {
	    local($a) = @_;
    	    eval q( &netif_start_queue($a));
	}' unless defined(&start_net_queue);
	eval 'sub is_queue_stopped {
	    local($a) = @_;
    	    eval q( &netif_queue_stopped($a));
	}' unless defined(&is_queue_stopped);
	eval 'sub wake_net_dev {
	    local($a) = @_;
    	    eval q( &netif_wake_queue($a));
	}' unless defined(&wake_net_dev);
	eval 'sub is_dev_running {
	    local($a) = @_;
    	    eval q( &netif_running($a));
	}' unless defined(&is_dev_running);
	eval 'sub wan_dev_kfree_skb {
	    local($a,$b) = @_;
    	    eval q( &dev_kfree_skb_any($a));
	}' unless defined(&wan_dev_kfree_skb);
    }
 elsif((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) >=  &KERNEL_VERSION(2,1,0)) {
	eval 'sub LINUX_2_1 () {1;}' unless defined(&LINUX_2_1);
	eval 'sub netdevice_t () {\'struct device\';}' unless defined(&netdevice_t);
	eval 'sub FREE_READ () {1;}' unless defined(&FREE_READ);
	eval 'sub FREE_WRITE () {0;}' unless defined(&FREE_WRITE);
	eval 'sub stop_net_queue {
	    local($a) = @_;
    	    eval q(( &set_bit(0, & ($a->{tbusy}))));
	}' unless defined(&stop_net_queue);
	eval 'sub start_net_queue {
	    local($a) = @_;
    	    eval q(( &clear_bit(0,& ($a->{tbusy}))));
	}' unless defined(&start_net_queue);
	eval 'sub is_queue_stopped {
	    local($a) = @_;
    	    eval q(( ($a->{tbusy})));
	}' unless defined(&is_queue_stopped);
	eval 'sub wake_net_dev {
	    local($a) = @_;
    	    eval q({ &clear_bit(0,& ($a->{tbusy})); &mark_bh( &NET_BH);});
	}' unless defined(&wake_net_dev);
	eval 'sub is_dev_running {
	    local($a) = @_;
    	    eval q(( &test_bit(0,& ($a->{start}))));
	}' unless defined(&is_dev_running);
	eval 'sub wan_dev_kfree_skb {
	    local($a,$b) = @_;
    	    eval q( &dev_kfree_skb($a));
	}' unless defined(&wan_dev_kfree_skb);
    } else {
	eval 'sub LINUX_2_0 () {1;}' unless defined(&LINUX_2_0);
	eval 'sub netdevice_t () {\'struct device\';}' unless defined(&netdevice_t);
	eval 'sub test_and_set_bit () { &set_bit;}' unless defined(&test_and_set_bit);
	eval 'sub net_ratelimit () {
	    eval q(1);
	}' unless defined(&net_ratelimit);
	eval 'sub stop_net_queue {
	    local($a) = @_;
    	    eval q(( &set_bit(0, & ($a->{tbusy}))));
	}' unless defined(&stop_net_queue);
	eval 'sub start_net_queue {
	    local($a) = @_;
    	    eval q(( &clear_bit(0,& ($a->{tbusy}))));
	}' unless defined(&start_net_queue);
	eval 'sub is_queue_stopped {
	    local($a) = @_;
    	    eval q(( ($a->{tbusy})));
	}' unless defined(&is_queue_stopped);
	eval 'sub wake_net_dev {
	    local($a) = @_;
    	    eval q({ &clear_bit(0,& ($a->{tbusy})); &mark_bh( &NET_BH);});
	}' unless defined(&wake_net_dev);
	eval 'sub is_dev_running {
	    local($a) = @_;
    	    eval q(( &test_bit(0,( &void*)& ($a->{start}))));
	}' unless defined(&is_dev_running);
	eval 'sub wan_dev_kfree_skb {
	    local($a,$b) = @_;
    	    eval q( &dev_kfree_skb($a,$b));
	}' unless defined(&wan_dev_kfree_skb);
	eval 'sub spin_lock_init {
	    local($a) = @_;
    	    eval q();
	}' unless defined(&spin_lock_init);
	eval 'sub spin_lock {
	    local($a) = @_;
    	    eval q();
	}' unless defined(&spin_lock);
	eval 'sub spin_unlock {
	    local($a) = @_;
    	    eval q();
	}' unless defined(&spin_unlock);
    }
    require 'linux/wanrouter.ph';
    unless(defined(&PACKED)) {
	eval 'sub PACKED () { &__attribute__(( &packed));}' unless defined(&PACKED);
    }
    eval 'sub WANPIPE_MAGIC () {0x414c4453;}' unless defined(&WANPIPE_MAGIC);
    eval 'sub WANPIPE_DUMP () {( &ROUTER_USER+0);}' unless defined(&WANPIPE_DUMP);
    eval 'sub WANPIPE_EXEC () {( &ROUTER_USER+1);}' unless defined(&WANPIPE_EXEC);
    eval 'sub TRACE_ALL () {0x;}' unless defined(&TRACE_ALL);
    eval 'sub TRACE_PROT () {0x1;}' unless defined(&TRACE_PROT);
    eval 'sub TRACE_DATA () {0x2;}' unless defined(&TRACE_DATA);
    eval 'sub UDPMGMT_REQUEST () {0x1;}' unless defined(&UDPMGMT_REQUEST);
    eval 'sub UDPMGMT_REPLY () {0x2;}' unless defined(&UDPMGMT_REPLY);
    eval 'sub UDP_OFFSET () {12;}' unless defined(&UDP_OFFSET);
    eval 'sub MAX_CMD_BUFF () {10;}' unless defined(&MAX_CMD_BUFF);
    eval 'sub MAX_X25_LCN () {255;}' unless defined(&MAX_X25_LCN);
    eval 'sub MAX_LCN_NUM () {4095;}' unless defined(&MAX_LCN_NUM);
    eval 'sub MAX_FT1_RETRY () {100;}' unless defined(&MAX_FT1_RETRY);
    if(defined(&LINUX_2_4)) {
	unless(defined(&AF_WANPIPE)) {
	    eval 'sub AF_WANPIPE () {25;}' unless defined(&AF_WANPIPE);
	    unless(defined(&PF_WANPIPE)) {
		eval 'sub PF_WANPIPE () { &AF_WANPIPE;}' unless defined(&PF_WANPIPE);
	    }
	}
    } else {
	unless(defined(&AF_WANPIPE)) {
	    eval 'sub AF_WANPIPE () {24;}' unless defined(&AF_WANPIPE);
	    unless(defined(&PF_WANPIPE)) {
		eval 'sub PF_WANPIPE () { &AF_WANPIPE;}' unless defined(&PF_WANPIPE);
	    }
	}
    }
    eval 'sub TX_TIMEOUT () {5* &HZ;}' unless defined(&TX_TIMEOUT);
    eval 'sub SEND_CRIT () {0x;}' unless defined(&SEND_CRIT);
    eval 'sub PERI_CRIT () {0x1;}' unless defined(&PERI_CRIT);
    eval 'sub POLL_CRIT () {0x3;}' unless defined(&POLL_CRIT);
    eval 'sub SEND_TXIRQ_CRIT () {0x2;}' unless defined(&SEND_TXIRQ_CRIT);
    eval 'sub ARP_CRIT () {0x3;}' unless defined(&ARP_CRIT);
    eval 'sub DYN_OPT_ON () {0x;}' unless defined(&DYN_OPT_ON);
    eval 'sub DEV_DOWN () {0x1;}' unless defined(&DEV_DOWN);
    eval 'sub MAX_LGTH_UDP_MGNT_PKT () {2000;}' unless defined(&MAX_LGTH_UDP_MGNT_PKT);
    eval 'sub INTR_TEST_MODE () {0x2;}' unless defined(&INTR_TEST_MODE);
    eval 'sub WUM_SIGNATURE_L () {0x50495046;}' unless defined(&WUM_SIGNATURE_L);
    eval 'sub WUM_SIGNATURE_H () {0x444e3845;}' unless defined(&WUM_SIGNATURE_H);
    eval 'sub WUM_KILL () {0x50;}' unless defined(&WUM_KILL);
    eval 'sub WUM_EXEC () {0x51;}' unless defined(&WUM_EXEC);
    eval 'sub WANPIPE () {0x;}' unless defined(&WANPIPE);
    eval 'sub API () {0x1;}' unless defined(&API);
    eval 'sub BRIDGE () {0x2;}' unless defined(&BRIDGE);
    eval 'sub BRIDGE_NODE () {0x3;}' unless defined(&BRIDGE_NODE);
    if(defined(&__KERNEL__)) {
	require 'linux/sdladrv.ph';
	require 'linux/sdlasfm.ph';
	require 'linux/tqueue.ph';
	if(defined(&LINUX_2_4)) {
	    require 'linux/serial.ph';
	    require 'linux/serialP.ph';
	    require 'linux/serial_reg.ph';
	    require 'asm/serial.ph';
	}
	require 'linux/tty.ph';
	require 'linux/tty_driver.ph';
	require 'linux/tty_flip.ph';
	eval 'sub is_digit {
	    local($ch) = @_;
    	    eval q(((($ch)>=ord(\'0\'&&(ch)<=(unsigned)\'9\'))?1:0));
	}' unless defined(&is_digit);
	eval 'sub is_alpha {
	    local($ch) = @_;
    	    eval q((((($ch)>=ord(\'a\'&&(ch)<=(unsigned)\'z\')||	 	  ((ch)>=(unsigned)\'A\'&&(ch)<=(unsigned)\'Z\')))?1:0));
	}' unless defined(&is_alpha);
	eval 'sub is_hex_digit {
	    local($ch) = @_;
    	    eval q((((($ch)>=ord(\'0\'&&(ch)<=(unsigned)\'9\')||	 	  ((ch)>=(unsigned)\'a\'&&(ch)<=(unsigned)\'f\')||	 	  ((ch)>=(unsigned)\'A\'&&(ch)<=(unsigned)\'F\')))?1:0));
	}' unless defined(&is_hex_digit);
    }
}
1;
