require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SWAP_H)) {
    eval 'sub _LINUX_SWAP_H () {1;}' unless defined(&_LINUX_SWAP_H);
    require 'linux/spinlock.ph';
    require 'asm/page.ph';
    eval 'sub SWAP_FLAG_PREFER () {0x8000;}' unless defined(&SWAP_FLAG_PREFER);
    eval 'sub SWAP_FLAG_PRIO_MASK () {0x7fff;}' unless defined(&SWAP_FLAG_PRIO_MASK);
    eval 'sub SWAP_FLAG_PRIO_SHIFT () {0;}' unless defined(&SWAP_FLAG_PRIO_SHIFT);
    eval 'sub MAX_SWAPFILES () {32;}' unless defined(&MAX_SWAPFILES);
    if(defined(&__KERNEL__)) {
	eval 'sub __swapoffset {
	    local($x) = @_;
    	    eval q(((0)->$x));
	}' unless defined(&__swapoffset);
	eval 'sub MAX_SWAP_BADPAGES () {(( &__swapoffset( ($magic->{magic})) -  &__swapoffset( ($info->{badpages}))) / $sizeof{\'int\'});}' unless defined(&MAX_SWAP_BADPAGES);
	require 'asm/atomic.ph';
	eval 'sub SWP_USED () {1;}' unless defined(&SWP_USED);
	eval 'sub SWP_WRITEOK () {3;}' unless defined(&SWP_WRITEOK);
	eval 'sub SWAP_CLUSTER_MAX () {32;}' unless defined(&SWAP_CLUSTER_MAX);
	eval 'sub SWAP_MAP_MAX () {0x7fff;}' unless defined(&SWAP_MAP_MAX);
	eval 'sub SWAP_MAP_BAD () {0x8000;}' unless defined(&SWAP_MAP_BAD);
	eval 'sub vm_swap_full () {
	    eval q(( &nr_swap_pages*2<  &total_swap_pages));
	}' unless defined(&vm_swap_full);
	eval 'sub pagecache_lock () {( ($pagecache_lock_cacheline->{lock}));}' unless defined(&pagecache_lock);
	eval 'sub SWAP_CACHE_INFO () {1;}' unless defined(&SWAP_CACHE_INFO);
	if(defined(&SWAP_CACHE_INFO)) {
	}
	eval 'sub pagemap_lru_lock () { ($pagemap_lru_lock_cacheline->{lock});}' unless defined(&pagemap_lru_lock);
	eval 'sub DEBUG_LRU_PAGE {
	    local($page) = @_;
    	    eval q( &do {  &if (! &PageLRU($page))  &BUG();  &if ( &PageActive($page))  &BUG(); }  &while (0));
	}' unless defined(&DEBUG_LRU_PAGE);
	eval 'sub inc_nr_active_pages {
	    local($page) = @_;
    	    eval q( &delta_nr_active_pages($page, 1));
	}' unless defined(&inc_nr_active_pages);
	eval 'sub dec_nr_active_pages {
	    local($page) = @_;
    	    eval q( &delta_nr_active_pages($page, -1));
	}' unless defined(&dec_nr_active_pages);
	eval 'sub inc_nr_inactive_pages {
	    local($page) = @_;
    	    eval q( &delta_nr_inactive_pages($page, 1));
	}' unless defined(&inc_nr_inactive_pages);
	eval 'sub dec_nr_inactive_pages {
	    local($page) = @_;
    	    eval q( &delta_nr_inactive_pages($page, -1));
	}' unless defined(&dec_nr_inactive_pages);
	eval 'sub add_page_to_active_list {
	    local($page) = @_;
    	    eval q( &do {  &DEBUG_LRU_PAGE($page);  &SetPageActive($page);  &list_add(($page)-> &lru,  &active_list);  &inc_nr_active_pages($page); }  &while (0));
	}' unless defined(&add_page_to_active_list);
	eval 'sub add_page_to_inactive_list {
	    local($page) = @_;
    	    eval q( &do {  &DEBUG_LRU_PAGE($page);  &list_add(($page)-> &lru,  &inactive_list);  &inc_nr_inactive_pages($page); }  &while (0));
	}' unless defined(&add_page_to_inactive_list);
	eval 'sub del_page_from_active_list {
	    local($page) = @_;
    	    eval q( &do {  &list_del(($page)-> &lru);  &ClearPageActive($page);  &dec_nr_active_pages($page); }  &while (0));
	}' unless defined(&del_page_from_active_list);
	eval 'sub del_page_from_inactive_list {
	    local($page) = @_;
    	    eval q( &do {  &list_del(($page)-> &lru);  &dec_nr_inactive_pages($page); }  &while (0));
	}' unless defined(&del_page_from_inactive_list);
	eval 'sub inc_nr_cache_pages {
	    local($page) = @_;
    	    eval q( &delta_nr_cache_pages($page, 1));
	}' unless defined(&inc_nr_cache_pages);
	eval 'sub dec_nr_cache_pages {
	    local($page) = @_;
    	    eval q( &delta_nr_cache_pages($page, -1));
	}' unless defined(&dec_nr_cache_pages);
	eval 'sub swap_list_lock () {
	    eval q( &spin_lock( &swaplock));
	}' unless defined(&swap_list_lock);
	eval 'sub swap_list_unlock () {
	    eval q( &spin_unlock( &swaplock));
	}' unless defined(&swap_list_unlock);
	eval 'sub swap_device_lock {
	    local($p) = @_;
    	    eval q( &spin_lock( ($p->{sdev_lock})));
	}' unless defined(&swap_device_lock);
	eval 'sub swap_device_unlock {
	    local($p) = @_;
    	    eval q( &spin_unlock( ($p->{sdev_lock})));
	}' unless defined(&swap_device_unlock);
    }
}
1;
