require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SKBUFF_H)) {
    eval 'sub _LINUX_SKBUFF_H () {1;}' unless defined(&_LINUX_SKBUFF_H);
    require 'linux/config.ph';
    require 'linux/kernel.ph';
    require 'linux/sched.ph';
    require 'linux/time.ph';
    require 'linux/cache.ph';
    require 'asm/atomic.ph';
    require 'asm/types.ph';
    require 'linux/spinlock.ph';
    require 'linux/mm.ph';
    require 'linux/highmem.ph';
    eval 'sub HAVE_ALLOC_SKB () {1;}' unless defined(&HAVE_ALLOC_SKB);
    eval 'sub HAVE_ALIGNABLE_SKB () {1;}' unless defined(&HAVE_ALIGNABLE_SKB);
    eval 'sub SLAB_SKB () {1;}' unless defined(&SLAB_SKB);
    eval 'sub CHECKSUM_NONE () {0;}' unless defined(&CHECKSUM_NONE);
    eval 'sub CHECKSUM_HW () {1;}' unless defined(&CHECKSUM_HW);
    eval 'sub CHECKSUM_UNNECESSARY () {2;}' unless defined(&CHECKSUM_UNNECESSARY);
    eval 'sub SKB_DATA_ALIGN {
        local($X) = @_;
	    eval q(((($X) + ( &SMP_CACHE_BYTES-1)) & ~( &SMP_CACHE_BYTES-1)));
    }' unless defined(&SKB_DATA_ALIGN);
    eval 'sub SKB_MAX_ORDER {
        local($X,$ORDER) = @_;
	    eval q(((( &PAGE_SIZE<<($ORDER)) - ($X) - $sizeof{\'struct skb_shared_info\'})&~( &SMP_CACHE_BYTES-1)));
    }' unless defined(&SKB_MAX_ORDER);
    eval 'sub SKB_MAX_HEAD {
        local($X) = @_;
	    eval q(( &SKB_MAX_ORDER(($X),0)));
    }' unless defined(&SKB_MAX_HEAD);
    eval 'sub SKB_MAX_ALLOC () {( &SKB_MAX_ORDER(0,2));}' unless defined(&SKB_MAX_ALLOC);
    if(defined(&__i386__)) {
	eval 'sub NET_CALLER {
	    local($arg) = @_;
    	    eval q((*((( &void**)$arg)-1)));
	}' unless defined(&NET_CALLER);
    } else {
	eval 'sub NET_CALLER {
	    local($arg) = @_;
    	    eval q( &__builtin_return_address(0));
	}' unless defined(&NET_CALLER);
    }
    if(defined(&CONFIG_NETFILTER)) {
    }
    eval 'sub MAX_SKB_FRAGS () {6;}' unless defined(&MAX_SKB_FRAGS);
    if(defined(&CONFIG_NETFILTER)) {
	if(defined(&CONFIG_NETFILTER_DEBUG)) {
	}
    }
    if(defined( &CONFIG_HIPPI)) {
    }
    if(defined(&CONFIG_NET_SCHED)) {
    }
    if(defined(&__KERNEL__)) {
	require 'linux/slab.ph';
	require 'asm/system.ph';
	eval 'sub dev_kfree_skb {
	    local($a) = @_;
    	    eval q( &kfree_skb($a));
	}' unless defined(&dev_kfree_skb);
	eval 'sub skb_shinfo {
	    local($SKB) = @_;
    	    eval q(((($SKB)-> &end)));
	}' unless defined(&skb_shinfo);
	eval 'sub skb_queue_head_init {
	    local($list) = @_;
    	    eval q({  &spin_lock_init( ($list->{lock}));  ($list->{prev}) = $list;  ($list->{next}) = $list;  ($list->{qlen}) = 0; });
	}' unless defined(&skb_queue_head_init);
	eval 'sub skb_is_nonlinear {
	    local($skb) = @_;
    	    eval q({  ($skb->{data_len}); });
	}' unless defined(&skb_is_nonlinear);
	eval 'sub skb_headlen {
	    local($skb) = @_;
    	    eval q({  ($skb->{len}) -  ($skb->{data_len}); });
	}' unless defined(&skb_headlen);
	eval 'sub SKB_PAGE_ASSERT {
	    local($skb) = @_;
    	    eval q( &do {  &if ( &skb_shinfo($skb)-> &nr_frags)  &out_of_line_bug(); }  &while (0));
	}' unless defined(&SKB_PAGE_ASSERT);
	eval 'sub SKB_FRAG_ASSERT {
	    local($skb) = @_;
    	    eval q( &do {  &if ( &skb_shinfo($skb)-> &frag_list)  &out_of_line_bug(); }  &while (0));
	}' unless defined(&SKB_FRAG_ASSERT);
	eval 'sub SKB_LINEAR_ASSERT {
	    local($skb) = @_;
    	    eval q( &do {  &if ( &skb_is_nonlinear($skb))  &out_of_line_bug(); }  &while (0));
	}' unless defined(&SKB_LINEAR_ASSERT);
	eval 'sub char {
	    eval q(* &__skb_push(\'struct sk_buff\' * &skb, my $len) {  ($skb->{data})-= $len;  ($skb->{len})+= $len;  ($skb->{data}); });
	}' unless defined(&char);
	eval 'sub char {
	    eval q(* &__skb_pull(\'struct sk_buff\' * &skb, my $len) {  ($skb->{len})-= $len;  &if ( ($skb->{len}) <  ($skb->{data_len}))  &out_of_line_bug();  ($skb->{data})+= $len; });
	}' unless defined(&char);
	eval 'sub char {
	    eval q(* &__pskb_pull(\'struct sk_buff\' * &skb, my $len) {  &if ( $len >  &skb_headlen( &skb)  &&  &__pskb_pull_tail( &skb,  $len- &skb_headlen( &skb)) ==  &NULL)  &NULL;  ($skb->{len}) -=  $len;  ($skb->{data}) +=  $len; });
	}' unless defined(&char);
	eval 'sub pskb_pull {
	    local($skb,$len) = @_;
    	    eval q({  &if ($len >  ($skb->{len}))  &NULL;  &__pskb_pull($skb,$len); });
	}' unless defined(&pskb_pull);
	eval 'sub pskb_may_pull {
	    local($skb,$len) = @_;
    	    eval q({  &if ($len <=  &skb_headlen($skb)) 1;  &if ($len >  ($skb->{len})) 0; ( &__pskb_pull_tail($skb, $len- &skb_headlen($skb)) !=  &NULL); });
	}' unless defined(&pskb_may_pull);
	eval 'sub __skb_trim {
	    local($skb,$len) = @_;
    	    eval q({  &if (! ($skb->{data_len})) {  ($skb->{len}) = $len;  ($skb->{tail}) =  ($skb->{data})+$len; }  &else {  &___pskb_trim($skb, $len, 0); } });
	}' unless defined(&__skb_trim);
	eval 'sub __pskb_trim {
	    local($skb,$len) = @_;
    	    eval q({  &if (! ($skb->{data_len})) {  ($skb->{len}) = $len;  ($skb->{tail}) =  ($skb->{data})+$len; 0; }  &else {  &___pskb_trim($skb, $len, 1); } });
	}' unless defined(&__pskb_trim);
	eval 'sub pskb_trim {
	    local($skb,$len) = @_;
    	    eval q({  &if ($len <  ($skb->{len}))  &__pskb_trim($skb, $len); 0; });
	}' unless defined(&pskb_trim);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub void {
	    eval q(* &kmap_skb_frag( &const  &skb_frag_t * &frag) {  &kmap_atomic( ($frag->{page}),  &KM_SKB_DATA_SOFTIRQ); });
	}' unless defined(&void);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub kunmap_skb_frag {
	    local($vaddr) = @_;
    	    eval q({  &kunmap_atomic($vaddr,  &KM_SKB_DATA_SOFTIRQ); });
	}' unless defined(&kunmap_skb_frag);
	eval 'sub skb_queue_walk {
	    local($queue, $skb) = @_;
    	    eval q( &for ($skb = ($queue)-> &next; ($skb != ($queue)); $skb= ($skb->{next})));
	}' unless defined(&skb_queue_walk);
	if(defined(&CONFIG_NETFILTER)) {
	    eval 'sub nf_conntrack_put {
	        local($nfct) = @_;
    		eval q({  &if ($nfct  &&  &atomic_dec_and_test( ($nfct->{master}->{use})))  ($nfct->{master}->{destroy})( ($nfct->{master})); });
	    }' unless defined(&nf_conntrack_put);
	    eval 'sub nf_conntrack_get {
	        local($nfct) = @_;
    		eval q({  &if ($nfct)  &atomic_inc( ($nfct->{master}->{use})); });
	    }' unless defined(&nf_conntrack_get);
	}
    }
}
1;
