require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SCHED_H)) {
    eval 'sub _LINUX_SCHED_H () {1;}' unless defined(&_LINUX_SCHED_H);
    require 'asm/param.ph';
    require 'linux/config.ph';
    require 'linux/binfmts.ph';
    require 'linux/threads.ph';
    require 'linux/kernel.ph';
    require 'linux/types.ph';
    require 'linux/times.ph';
    require 'linux/timex.ph';
    require 'linux/rbtree.ph';
    require 'asm/system.ph';
    require 'asm/semaphore.ph';
    require 'asm/page.ph';
    require 'asm/ptrace.ph';
    require 'asm/mmu.ph';
    require 'linux/smp.ph';
    require 'linux/tty.ph';
    require 'linux/sem.ph';
    require 'linux/signal.ph';
    require 'linux/securebits.ph';
    require 'linux/fs_struct.ph';
    eval 'sub CSIGNAL () {0xff;}' unless defined(&CSIGNAL);
    eval 'sub CLONE_VM () {0x100;}' unless defined(&CLONE_VM);
    eval 'sub CLONE_FS () {0x200;}' unless defined(&CLONE_FS);
    eval 'sub CLONE_FILES () {0x400;}' unless defined(&CLONE_FILES);
    eval 'sub CLONE_SIGHAND () {0x800;}' unless defined(&CLONE_SIGHAND);
    eval 'sub CLONE_PID () {0x1000;}' unless defined(&CLONE_PID);
    eval 'sub CLONE_PTRACE () {0x2000;}' unless defined(&CLONE_PTRACE);
    eval 'sub CLONE_VFORK () {0x4000;}' unless defined(&CLONE_VFORK);
    eval 'sub CLONE_PARENT () {0x8000;}' unless defined(&CLONE_PARENT);
    eval 'sub CLONE_THREAD () {0x10000;}' unless defined(&CLONE_THREAD);
    eval 'sub CLONE_NEWNS () {0x20000;}' unless defined(&CLONE_NEWNS);
    eval 'sub CLONE_SIGNAL () {( &CLONE_SIGHAND |  &CLONE_THREAD);}' unless defined(&CLONE_SIGNAL);
    eval 'sub FSHIFT () {11;}' unless defined(&FSHIFT);
    eval 'sub FIXED_1 () {(1<< &FSHIFT);}' unless defined(&FIXED_1);
    eval 'sub LOAD_FREQ () {(5* &HZ);}' unless defined(&LOAD_FREQ);
    eval 'sub EXP_1 () {1884;}' unless defined(&EXP_1);
    eval 'sub EXP_5 () {2014;}' unless defined(&EXP_5);
    eval 'sub EXP_15 () {2037;}' unless defined(&EXP_15);
    eval 'sub CALC_LOAD {
        local($load,$exp,$n) = @_;
	    eval q($load *= $exp; $load += $n*( &FIXED_1-$exp); $load >>=  &FSHIFT;);
    }' unless defined(&CALC_LOAD);
    eval 'sub CT_TO_SECS {
        local($x) = @_;
	    eval q((($x) /  &HZ));
    }' unless defined(&CT_TO_SECS);
    eval 'sub CT_TO_USECS {
        local($x) = @_;
	    eval q(((($x) %  &HZ) * 1000000/ &HZ));
    }' unless defined(&CT_TO_USECS);
    require 'linux/fs.ph';
    require 'linux/time.ph';
    require 'linux/param.ph';
    require 'linux/resource.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/timer.ph';
    }
    require 'asm/processor.ph';
    eval 'sub TASK_RUNNING () {0;}' unless defined(&TASK_RUNNING);
    eval 'sub TASK_INTERRUPTIBLE () {1;}' unless defined(&TASK_INTERRUPTIBLE);
    eval 'sub TASK_UNINTERRUPTIBLE () {2;}' unless defined(&TASK_UNINTERRUPTIBLE);
    eval 'sub TASK_ZOMBIE () {4;}' unless defined(&TASK_ZOMBIE);
    eval 'sub TASK_STOPPED () {8;}' unless defined(&TASK_STOPPED);
    eval 'sub __set_task_state {
        local($tsk, $state_value) = @_;
	    eval q( &do { ($tsk)-> &state = ($state_value); }  &while (0));
    }' unless defined(&__set_task_state);
    eval 'sub set_task_state {
        local($tsk, $state_value) = @_;
	    eval q( &set_mb(($tsk)-> &state, ($state_value)));
    }' unless defined(&set_task_state);
    eval 'sub __set_current_state {
        local($state_value) = @_;
	    eval q( &do {  ($current->{state}) = ($state_value); }  &while (0));
    }' unless defined(&__set_current_state);
    eval 'sub set_current_state {
        local($state_value) = @_;
	    eval q( &set_mb( ($current->{state}), ($state_value)));
    }' unless defined(&set_current_state);
    eval 'sub SCHED_OTHER () {0;}' unless defined(&SCHED_OTHER);
    eval 'sub SCHED_FIFO () {1;}' unless defined(&SCHED_FIFO);
    eval 'sub SCHED_RR () {2;}' unless defined(&SCHED_RR);
    eval 'sub SCHED_YIELD () {0x10;}' unless defined(&SCHED_YIELD);
    if(defined(&__KERNEL__)) {
	require 'linux/spinlock.ph';
	eval 'sub MAX_SCHEDULE_TIMEOUT () { &LONG_MAX;}' unless defined(&MAX_SCHEDULE_TIMEOUT);
	if((defined(&CONFIG_SMP) ? &CONFIG_SMP : 0)) {
	} else {
	    eval 'sub set_cpus_allowed {
	        local($p, $new_mask) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&set_cpus_allowed);
	}
	eval 'sub NR_OPEN_DEFAULT () { &BITS_PER_LONG;}' unless defined(&NR_OPEN_DEFAULT);
	eval 'sub INIT_FILES () {{  &count:  &ATOMIC_INIT(1),  &file_lock:  &RW_LOCK_UNLOCKED,  &max_fds:  &NR_OPEN_DEFAULT,  &max_fdset:  &__FD_SETSIZE,  &next_fd: 0,  &fd:  ($init_files->{fd_array[0]}),  &close_on_exec:  ($init_files->{close_on_exec_init}),  &open_fds:  ($init_files->{open_fds_init}),  &close_on_exec_init: { { 0, } },  &open_fds_init: { { 0, } },  &fd_array: {  &NULL, } };}' unless defined(&INIT_FILES);
	eval 'sub DEFAULT_MAX_MAP_COUNT () {(65536);}' unless defined(&DEFAULT_MAX_MAP_COUNT);
	eval 'sub INIT_MM {
	    local($name) = @_;
    	    eval q({  &mm_rb:  &RB_ROOT,  &pgd:  &swapper_pg_dir,  &mm_users:  &ATOMIC_INIT(2),  &mm_count:  &ATOMIC_INIT(1),  &mmap_sem:  &__RWSEM_INITIALIZER( ($name->{mmap_sem})),  &page_table_lock:  &SPIN_LOCK_UNLOCKED,  &mmlist:  &LIST_HEAD_INIT( ($name->{mmlist})), });
	}' unless defined(&INIT_MM);
	eval 'sub INIT_SIGNALS () {{  &count:  &ATOMIC_INIT(1),  &action: { {{0,}}, },  &siglock:  &SPIN_LOCK_UNLOCKED };}' unless defined(&INIT_SIGNALS);
	eval 'sub get_current_user () {
	    eval q(({ \'struct user_struct\' * &__user =  ($current->{user});  &atomic_inc(& ($__user->{__count}));  &__user; }));
	}' unless defined(&get_current_user);
	eval 'sub INIT_USER () {( &root_user);}' unless defined(&INIT_USER);
	eval 'sub PF_ALIGNWARN () {0x1;}' unless defined(&PF_ALIGNWARN);
	eval 'sub PF_STARTING () {0x2;}' unless defined(&PF_STARTING);
	eval 'sub PF_EXITING () {0x4;}' unless defined(&PF_EXITING);
	eval 'sub PF_FORKNOEXEC () {0x40;}' unless defined(&PF_FORKNOEXEC);
	eval 'sub PF_SUPERPRIV () {0x100;}' unless defined(&PF_SUPERPRIV);
	eval 'sub PF_DUMPCORE () {0x200;}' unless defined(&PF_DUMPCORE);
	eval 'sub PF_SIGNALED () {0x400;}' unless defined(&PF_SIGNALED);
	eval 'sub PF_MEMALLOC () {0x800;}' unless defined(&PF_MEMALLOC);
	eval 'sub PF_MEMDIE () {0x1000;}' unless defined(&PF_MEMDIE);
	eval 'sub PF_FREE_PAGES () {0x2000;}' unless defined(&PF_FREE_PAGES);
	eval 'sub PF_NOIO () {0x4000;}' unless defined(&PF_NOIO);
	eval 'sub PF_FSTRANS () {0x8000;}' unless defined(&PF_FSTRANS);
	eval 'sub PF_USEDFPU () {0x100000;}' unless defined(&PF_USEDFPU);
	eval 'sub PT_PTRACED () {0x1;}' unless defined(&PT_PTRACED);
	eval 'sub PT_TRACESYS () {0x2;}' unless defined(&PT_TRACESYS);
	eval 'sub PT_DTRACE () {0x4;}' unless defined(&PT_DTRACE);
	eval 'sub PT_TRACESYSGOOD () {0x8;}' unless defined(&PT_TRACESYSGOOD);
	eval 'sub PT_PTRACE_CAP () {0x10;}' unless defined(&PT_PTRACE_CAP);
	eval 'sub is_dumpable {
	    local($tsk) = @_;
    	    eval q((($tsk)-> &task_dumpable  && ($tsk)-> &mm  && ($tsk)-> ($mm->{dumpable})));
	}' unless defined(&is_dumpable);
	eval 'sub _STK_LIM () {(8*1024*1024);}' unless defined(&_STK_LIM);
	eval 'sub DEF_COUNTER () {(10* &HZ/100);}' unless defined(&DEF_COUNTER);
	eval 'sub MAX_COUNTER () {(20* &HZ/100);}' unless defined(&MAX_COUNTER);
	eval 'sub DEF_NICE () {(0);}' unless defined(&DEF_NICE);
	eval 'sub INIT_TASK {
	    local($tsk) = @_;
    	    eval q({  &state: 0,  &flags: 0,  &sigpending: 0,  &addr_limit:  &KERNEL_DS,  &exec_domain:  &default_exec_domain,  &lock_depth: -1,  &counter:  &DEF_COUNTER,  &nice:  &DEF_NICE,  &policy:  &SCHED_OTHER,  &mm:  &NULL,  &active_mm:  &init_mm,  &cpus_runnable: ~0,  &cpus_allowed: ~0,  &run_list:  &LIST_HEAD_INIT( ($tsk->{run_list})),  &next_task: $tsk,  &prev_task: $tsk,  &p_opptr: $tsk,  &p_pptr: $tsk,  &thread_group:  &LIST_HEAD_INIT( ($tsk->{thread_group})),  &wait_chldexit:  &__WAIT_QUEUE_HEAD_INITIALIZER( ($tsk->{wait_chldexit})),  &real_timer: {  &function:  &it_real_fn },  &cap_effective:  &CAP_INIT_EFF_SET,  &cap_inheritable:  &CAP_INIT_INH_SET,  &cap_permitted:  &CAP_FULL_SET,  &keep_capabilities: 0,  &rlim:  &INIT_RLIMITS,  &user:  &INIT_USER,  &comm: \\"swapper\\",  &thread:  &INIT_THREAD,  &fs:  &init_fs,  &files:  &init_files,  &sigmask_lock:  &SPIN_LOCK_UNLOCKED,  &sig:  &init_signals,  &pending: {  &NULL,  ($tsk->{pending}->{head}), {{0}}},  &blocked: {{0}},  &alloc_lock:  &SPIN_LOCK_UNLOCKED,  &journal_info:  &NULL, });
	}' unless defined(&INIT_TASK);
	unless(defined(&INIT_TASK_SIZE)) {
	    eval 'sub INIT_TASK_SIZE () {2048*$sizeof{\'long\'};}' unless defined(&INIT_TASK_SIZE);
	}
	eval 'sub PIDHASH_SZ () {(4096>> 2);}' unless defined(&PIDHASH_SZ);
	eval 'sub pid_hashfn {
	    local($x) = @_;
    	    eval q((((($x) >> 8) ^ ($x)) & ( &PIDHASH_SZ - 1)));
	}' unless defined(&pid_hashfn);
	eval 'sub hash_pid {
	    local($p) = @_;
    	    eval q({ \'struct task_struct\' ** &htable =  $pidhash[ &pid_hashfn( ($p->{pid}))];  &if(( ($p->{pidhash_next}) = * &htable) !=  &NULL) (* &htable)-> &pidhash_pprev =  ($p->{pidhash_next}); * &htable = $p;  ($p->{pidhash_pprev}) =  &htable; });
	}' unless defined(&hash_pid);
	eval 'sub unhash_pid {
	    local($p) = @_;
    	    eval q({  &if( ($p->{pidhash_next}))  ($p->{pidhash_next}->{pidhash_pprev}) =  ($p->{pidhash_pprev}); * ($p->{pidhash_pprev}) =  ($p->{pidhash_next}); });
	}' unless defined(&unhash_pid);
	eval 'sub task_struct {
	    eval q(* &find_task_by_pid(\'int\'  &pid) { \'struct task_struct\' * &p, ** &htable =  $pidhash[ &pid_hashfn( &pid)];  &for( &p = * &htable;  &p  &&  ($p->{pid}) !=  &pid;  &p =  ($p->{pidhash_next})) ;  &p; });
	}' unless defined(&task_struct);
	eval 'sub task_has_cpu {
	    local($tsk) = @_;
    	    eval q((($tsk)-> &cpus_runnable != ~0));
	}' unless defined(&task_has_cpu);
	eval 'sub task_set_cpu {
	    local($tsk,$cpu) = @_;
    	    eval q({  ($tsk->{processor}) = $cpu;  ($tsk->{cpus_runnable}) = 1 << $cpu; });
	}' unless defined(&task_set_cpu);
	eval 'sub task_release_cpu {
	    local($tsk) = @_;
    	    eval q({  ($tsk->{cpus_runnable}) = ~0; });
	}' unless defined(&task_release_cpu);
	require 'asm/current.ph';
	eval 'sub CURRENT_TIME () {( ($xtime->{tv_sec}));}' unless defined(&CURRENT_TIME);
	eval 'sub wake_up {
	    local($x) = @_;
    	    eval q( &__wake_up(($x), &TASK_UNINTERRUPTIBLE |  &TASK_INTERRUPTIBLE, 1));
	}' unless defined(&wake_up);
	eval 'sub wake_up_nr {
	    local($x, $nr) = @_;
    	    eval q( &__wake_up(($x), &TASK_UNINTERRUPTIBLE |  &TASK_INTERRUPTIBLE, $nr));
	}' unless defined(&wake_up_nr);
	eval 'sub wake_up_all {
	    local($x) = @_;
    	    eval q( &__wake_up(($x), &TASK_UNINTERRUPTIBLE |  &TASK_INTERRUPTIBLE, 0));
	}' unless defined(&wake_up_all);
	eval 'sub wake_up_sync {
	    local($x) = @_;
    	    eval q( &__wake_up_sync(($x), &TASK_UNINTERRUPTIBLE |  &TASK_INTERRUPTIBLE, 1));
	}' unless defined(&wake_up_sync);
	eval 'sub wake_up_sync_nr {
	    local($x, $nr) = @_;
    	    eval q( &__wake_up_sync(($x), &TASK_UNINTERRUPTIBLE |  &TASK_INTERRUPTIBLE, $nr));
	}' unless defined(&wake_up_sync_nr);
	eval 'sub wake_up_interruptible {
	    local($x) = @_;
    	    eval q( &__wake_up(($x), &TASK_INTERRUPTIBLE, 1));
	}' unless defined(&wake_up_interruptible);
	eval 'sub wake_up_interruptible_nr {
	    local($x, $nr) = @_;
    	    eval q( &__wake_up(($x), &TASK_INTERRUPTIBLE, $nr));
	}' unless defined(&wake_up_interruptible_nr);
	eval 'sub wake_up_interruptible_all {
	    local($x) = @_;
    	    eval q( &__wake_up(($x), &TASK_INTERRUPTIBLE, 0));
	}' unless defined(&wake_up_interruptible_all);
	eval 'sub wake_up_interruptible_sync {
	    local($x) = @_;
    	    eval q( &__wake_up_sync(($x), &TASK_INTERRUPTIBLE, 1));
	}' unless defined(&wake_up_interruptible_sync);
	eval 'sub wake_up_interruptible_sync_nr {
	    local($x, $nr) = @_;
    	    eval q( &__wake_up_sync(($x), &TASK_INTERRUPTIBLE, $nr));
	}' unless defined(&wake_up_interruptible_sync_nr);
	eval 'sub signal_pending {
	    local($p) = @_;
    	    eval q({ ( ($p->{sigpending}) != 0); });
	}' unless defined(&signal_pending);
	eval 'sub sas_ss_flags {
	    local($sp) = @_;
    	    eval q({ ( ($current->{sas_ss_size}) == 0?  &SS_DISABLE :  &on_sig_stack($sp) ?  &SS_ONSTACK : 0); });
	}' unless defined(&sas_ss_flags);
	eval 'sub fsuser {
	    local($void) = @_;
    	    eval q({  &if (! &issecure( &SECURE_NOROOT)  &&  ($current->{fsuid}) == 0) {  ($current->{flags}) |=  &PF_SUPERPRIV; 1; } 0; });
	}' unless defined(&fsuser);
	if(1) {
	} else {
	}
	eval 'sub mmdrop {
	    local($mm) = @_;
    	    eval q({  &if ( &atomic_dec_and_test( ($mm->{mm_count})))  &__mmdrop($mm); });
	}' unless defined(&mmdrop);
	eval 'sub __wait_event {
	    local($wq, $condition) = @_;
    	    eval q( &do {  &wait_queue_t  &__wait;  &init_waitqueue_entry(& &__wait,  &current);  &add_wait_queue($wq, & &__wait);  &for (;;) {  &set_current_state( &TASK_UNINTERRUPTIBLE);  &if ($condition)  &break;  &schedule(); }  ($current->{state}) =  &TASK_RUNNING;  &remove_wait_queue($wq, & &__wait); }  &while (0));
	}' unless defined(&__wait_event);
	eval 'sub wait_event {
	    local($wq, $condition) = @_;
    	    eval q( &do {  &if ($condition)  &break;  &__wait_event($wq, $condition); }  &while (0));
	}' unless defined(&wait_event);
	eval 'sub __wait_event_interruptible {
	    local($wq, $condition, $ret) = @_;
    	    eval q( &do {  &wait_queue_t  &__wait;  &init_waitqueue_entry(& &__wait,  &current);  &add_wait_queue($wq, & &__wait);  &for (;;) {  &set_current_state( &TASK_INTERRUPTIBLE);  &if ($condition)  &break;  &if (! &signal_pending( &current)) {  &schedule();  &continue; } $ret = - &ERESTARTSYS;  &break; }  ($current->{state}) =  &TASK_RUNNING;  &remove_wait_queue($wq, & &__wait); }  &while (0));
	}' unless defined(&__wait_event_interruptible);
	eval 'sub wait_event_interruptible {
	    local($wq, $condition) = @_;
    	    eval q(({ \'int\'  &__ret = 0;  &if (!($condition))  &__wait_event_interruptible($wq, $condition,  &__ret);  &__ret; }));
	}' unless defined(&wait_event_interruptible);
	eval 'sub REMOVE_LINKS {
	    local($p) = @_;
    	    eval q( &do { ($p)-> ($next_task->{prev_task}) = ($p)-> &prev_task; ($p)-> ($prev_task->{next_task}) = ($p)-> &next_task;  &if (($p)-> &p_osptr) ($p)-> ($p_osptr->{p_ysptr}) = ($p)-> &p_ysptr;  &if (($p)-> &p_ysptr) ($p)-> ($p_ysptr->{p_osptr}) = ($p)-> &p_osptr;  &else ($p)-> ($p_pptr->{p_cptr}) = ($p)-> &p_osptr; }  &while (0));
	}' unless defined(&REMOVE_LINKS);
	eval 'sub SET_LINKS {
	    local($p) = @_;
    	    eval q( &do { ($p)-> &next_task =  &init_task; ($p)-> &prev_task =  ($init_task->{prev_task});  ($init_task->{prev_task}->{next_task}) = ($p);  ($init_task->{prev_task}) = ($p); ($p)-> &p_ysptr =  &NULL;  &if ((($p)-> &p_osptr = ($p)-> ($p_pptr->{p_cptr})) !=  &NULL) ($p)-> ($p_osptr->{p_ysptr}) = $p; ($p)-> ($p_pptr->{p_cptr}) = $p; }  &while (0));
	}' unless defined(&SET_LINKS);
	eval 'sub for_each_task {
	    local($p) = @_;
    	    eval q( &for ($p =  &init_task ; ($p =  ($p->{next_task})) !=  &init_task ; ));
	}' unless defined(&for_each_task);
	eval 'sub for_each_thread {
	    local($task) = @_;
    	    eval q( &for ($task =  &next_thread( &current) ; $task !=  &current ; $task =  &next_thread($task)));
	}' unless defined(&for_each_thread);
	eval 'sub next_thread {
	    local($p) = @_;
    	    eval q( &list_entry(($p)-> ($thread_group->{next}), \'struct task_struct\',  &thread_group));
	}' unless defined(&next_thread);
	eval 'sub thread_group_leader {
	    local($p) = @_;
    	    eval q(( ($p->{pid}) ==  ($p->{tgid})));
	}' unless defined(&thread_group_leader);
	eval 'sub del_from_runqueue {
	    local($p) = @_;
    	    eval q({  &nr_running--;  ($p->{sleep_time}) =  &jiffies;  &list_del( ($p->{run_list}));  ($p->{run_list}->{next}) =  &NULL; });
	}' unless defined(&del_from_runqueue);
	eval 'sub task_on_runqueue {
	    local($p) = @_;
    	    eval q({ ( ($p->{run_list}->{next}) !=  &NULL); });
	}' unless defined(&task_on_runqueue);
	eval 'sub unhash_process {
	    local($p) = @_;
    	    eval q({  &if ( &task_on_runqueue($p))  &out_of_line_bug();  &write_lock_irq( &tasklist_lock);  &nr_threads--;  &unhash_pid($p);  &REMOVE_LINKS($p);  &list_del( ($p->{thread_group}));  &write_unlock_irq( &tasklist_lock); });
	}' unless defined(&unhash_process);
	eval 'sub task_unlock {
	    local($p) = @_;
    	    eval q({  &spin_unlock( ($p->{alloc_lock})); });
	}' unless defined(&task_unlock);
	eval 'sub need_resched {
	    local($void) = @_;
    	    eval q({ ( &unlikely( ($current->{need_resched}))); });
	}' unless defined(&need_resched);
	eval 'sub cond_resched {
	    local($void) = @_;
    	    eval q({  &if ( &need_resched())  &__cond_resched(); });
	}' unless defined(&cond_resched);
    }
}
1;
