require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_REISER_FS_SB)) {
    eval 'sub _LINUX_REISER_FS_SB () {1;}' unless defined(&_LINUX_REISER_FS_SB);
    if(defined(&__KERNEL__)) {
	require 'linux/tqueue.ph';
    }
    eval 'sub REISERFS_VERSION_2 () {2;}' unless defined(&REISERFS_VERSION_2);
    eval 'sub UNSET_HASH () {0;}' unless defined(&UNSET_HASH);
    eval 'sub TEA_HASH () {1;}' unless defined(&TEA_HASH);
    eval 'sub YURA_HASH () {2;}' unless defined(&YURA_HASH);
    eval 'sub R5_HASH () {3;}' unless defined(&R5_HASH);
    eval 'sub DEFAULT_HASH () { &R5_HASH;}' unless defined(&DEFAULT_HASH);
    eval("sub reiserfs_attrs_cleared () { 0x00000001; }") unless defined(&reiserfs_attrs_cleared);
    eval 'sub sb_block_count {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_block_count}))));
    }' unless defined(&sb_block_count);
    eval 'sub set_sb_block_count {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_block_count}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_block_count);
    eval 'sub sb_free_blocks {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_free_blocks}))));
    }' unless defined(&sb_free_blocks);
    eval 'sub set_sb_free_blocks {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_free_blocks}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_free_blocks);
    eval 'sub sb_root_block {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_root_block}))));
    }' unless defined(&sb_root_block);
    eval 'sub set_sb_root_block {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_root_block}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_root_block);
    eval 'sub sb_jp_journal_1st_block {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_1st_block}))));
    }' unless defined(&sb_jp_journal_1st_block);
    eval 'sub set_sb_jp_journal_1st_block {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_1st_block}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_1st_block);
    eval 'sub sb_jp_journal_dev {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_dev}))));
    }' unless defined(&sb_jp_journal_dev);
    eval 'sub set_sb_jp_journal_dev {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_dev}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_dev);
    eval 'sub sb_jp_journal_size {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_size}))));
    }' unless defined(&sb_jp_journal_size);
    eval 'sub set_sb_jp_journal_size {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_size}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_size);
    eval 'sub sb_jp_journal_trans_max {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_trans_max}))));
    }' unless defined(&sb_jp_journal_trans_max);
    eval 'sub set_sb_jp_journal_trans_max {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_trans_max}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_trans_max);
    eval 'sub sb_jp_journal_magic {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_magic}))));
    }' unless defined(&sb_jp_journal_magic);
    eval 'sub set_sb_jp_journal_magic {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_magic}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_magic);
    eval 'sub sb_jp_journal_max_batch {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_max_batch}))));
    }' unless defined(&sb_jp_journal_max_batch);
    eval 'sub set_sb_jp_journal_max_batch {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_max_batch}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_max_batch);
    eval 'sub sb_jp_jourmal_max_commit_age {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_max_commit_age}))));
    }' unless defined(&sb_jp_jourmal_max_commit_age);
    eval 'sub set_sb_jp_journal_max_commit_age {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_max_commit_age}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_max_commit_age);
    eval 'sub sb_blocksize {
        local($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_blocksize}))));
    }' unless defined(&sb_blocksize);
    eval 'sub set_sb_blocksize {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_blocksize}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_blocksize);
    eval 'sub sb_oid_maxsize {
        local($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_oid_maxsize}))));
    }' unless defined(&sb_oid_maxsize);
    eval 'sub set_sb_oid_maxsize {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_oid_maxsize}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_oid_maxsize);
    eval 'sub sb_oid_cursize {
        local($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_oid_cursize}))));
    }' unless defined(&sb_oid_cursize);
    eval 'sub set_sb_oid_cursize {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_oid_cursize}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_oid_cursize);
    eval 'sub sb_umount_state {
        local($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_umount_state}))));
    }' unless defined(&sb_umount_state);
    eval 'sub set_sb_umount_state {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_umount_state}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_umount_state);
    eval 'sub sb_fs_state {
        local($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_fs_state}))));
    }' unless defined(&sb_fs_state);
    eval 'sub set_sb_fs_state {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_fs_state}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_fs_state);
    eval 'sub sb_hash_function_code {
        local($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_hash_function_code}))));
    }' unless defined(&sb_hash_function_code);
    eval 'sub set_sb_hash_function_code {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_hash_function_code}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_hash_function_code);
    eval 'sub sb_tree_height {
        local($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_tree_height}))));
    }' unless defined(&sb_tree_height);
    eval 'sub set_sb_tree_height {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_tree_height}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_tree_height);
    eval 'sub sb_bmap_nr {
        local($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_bmap_nr}))));
    }' unless defined(&sb_bmap_nr);
    eval 'sub set_sb_bmap_nr {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_bmap_nr}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_bmap_nr);
    eval 'sub sb_version {
        local($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_version}))));
    }' unless defined(&sb_version);
    eval 'sub set_sb_version {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_version}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_version);
    eval 'sub sb_reserved_for_journal {
        local($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_reserved_for_journal}))));
    }' unless defined(&sb_reserved_for_journal);
    eval 'sub set_sb_reserved_for_journal {
        local($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_reserved_for_journal}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_reserved_for_journal);
    eval 'sub JOURNAL_BLOCK_SIZE () {4096;}' unless defined(&JOURNAL_BLOCK_SIZE);
    eval 'sub JOURNAL_MAX_CNODE () {1500;}' unless defined(&JOURNAL_MAX_CNODE);
    eval 'sub JOURNAL_HASH_SIZE () {8192;}' unless defined(&JOURNAL_HASH_SIZE);
    eval 'sub JOURNAL_NUM_BITMAPS () {5;}' unless defined(&JOURNAL_NUM_BITMAPS);
    eval 'sub JOURNAL_LIST_COUNT () {64;}' unless defined(&JOURNAL_LIST_COUNT);
    eval 'sub BH_JDirty () {16;}' unless defined(&BH_JDirty);
    eval 'sub BH_JDirty_wait () {18;}' unless defined(&BH_JDirty_wait);
    eval 'sub BH_JNew () {19;}' unless defined(&BH_JNew);
    eval 'sub BH_JPrepared () {20;}' unless defined(&BH_JPrepared);
    eval 'sub BH_JRestore_dirty () {22;}' unless defined(&BH_JRestore_dirty);
    eval 'sub JOURNAL_DESC_MAGIC () {"ReIsErLB";}' unless defined(&JOURNAL_DESC_MAGIC);
    if(defined( (defined(&CONFIG_PROC_FS) ? &CONFIG_PROC_FS : 0) )  && defined( (defined(&CONFIG_REISERFS_PROC_INFO) ? &CONFIG_REISERFS_PROC_INFO : 0) )) {
    } else {
    }
    eval 'sub REISERFS_3_5 () {0;}' unless defined(&REISERFS_3_5);
    eval 'sub REISERFS_3_6 () {1;}' unless defined(&REISERFS_3_6);
    eval 'sub REISERFS_LARGETAIL () {0;}' unless defined(&REISERFS_LARGETAIL);
    eval 'sub REISERFS_SMALLTAIL () {17;}' unless defined(&REISERFS_SMALLTAIL);
    eval 'sub REPLAYONLY () {3;}' unless defined(&REPLAYONLY);
    eval 'sub REISERFS_NOLOG () {4;}' unless defined(&REISERFS_NOLOG);
    eval 'sub REISERFS_CONVERT () {5;}' unless defined(&REISERFS_CONVERT);
    eval 'sub FORCE_TEA_HASH () {6;}' unless defined(&FORCE_TEA_HASH);
    eval 'sub FORCE_RUPASOV_HASH () {7;}' unless defined(&FORCE_RUPASOV_HASH);
    eval 'sub FORCE_R5_HASH () {8;}' unless defined(&FORCE_R5_HASH);
    eval 'sub FORCE_HASH_DETECT () {9;}' unless defined(&FORCE_HASH_DETECT);
    eval 'sub REISERFS_NO_BORDER () {11;}' unless defined(&REISERFS_NO_BORDER);
    eval 'sub REISERFS_NO_UNHASHED_RELOCATION () {12;}' unless defined(&REISERFS_NO_UNHASHED_RELOCATION);
    eval 'sub REISERFS_HASHED_RELOCATION () {13;}' unless defined(&REISERFS_HASHED_RELOCATION);
    eval 'sub REISERFS_TEST4 () {14;}' unless defined(&REISERFS_TEST4);
    eval 'sub REISERFS_TEST1 () {11;}' unless defined(&REISERFS_TEST1);
    eval 'sub REISERFS_TEST2 () {12;}' unless defined(&REISERFS_TEST2);
    eval 'sub REISERFS_TEST3 () {13;}' unless defined(&REISERFS_TEST3);
    eval 'sub REISERFS_TEST4 () {14;}' unless defined(&REISERFS_TEST4);
    eval 'sub REISERFS_ATTRS () {(15);}' unless defined(&REISERFS_ATTRS);
    eval 'sub reiserfs_r5_hash {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &FORCE_R5_HASH)));
    }' unless defined(&reiserfs_r5_hash);
    eval 'sub reiserfs_rupasov_hash {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &FORCE_RUPASOV_HASH)));
    }' unless defined(&reiserfs_rupasov_hash);
    eval 'sub reiserfs_tea_hash {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &FORCE_TEA_HASH)));
    }' unless defined(&reiserfs_tea_hash);
    eval 'sub reiserfs_hash_detect {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &FORCE_HASH_DETECT)));
    }' unless defined(&reiserfs_hash_detect);
    eval 'sub reiserfs_no_border {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_NO_BORDER)));
    }' unless defined(&reiserfs_no_border);
    eval 'sub reiserfs_no_unhashed_relocation {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_NO_UNHASHED_RELOCATION)));
    }' unless defined(&reiserfs_no_unhashed_relocation);
    eval 'sub reiserfs_hashed_relocation {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_HASHED_RELOCATION)));
    }' unless defined(&reiserfs_hashed_relocation);
    eval 'sub reiserfs_test4 {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_TEST4)));
    }' unless defined(&reiserfs_test4);
    eval 'sub have_large_tails {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_LARGETAIL)));
    }' unless defined(&have_large_tails);
    eval 'sub have_small_tails {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_SMALLTAIL)));
    }' unless defined(&have_small_tails);
    eval 'sub replay_only {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REPLAYONLY)));
    }' unless defined(&replay_only);
    eval 'sub reiserfs_dont_log {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_NOLOG)));
    }' unless defined(&reiserfs_dont_log);
    eval 'sub reiserfs_attrs {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_ATTRS)));
    }' unless defined(&reiserfs_attrs);
    eval 'sub old_format_only {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_properties}) & (1<<  &REISERFS_3_5)));
    }' unless defined(&old_format_only);
    eval 'sub convert_reiserfs {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_CONVERT)));
    }' unless defined(&convert_reiserfs);
    eval 'sub CARRY_ON () {0;}' unless defined(&CARRY_ON);
    eval 'sub SCHEDULE_OCCURRED () {1;}' unless defined(&SCHEDULE_OCCURRED);
    eval 'sub SB_BUFFER_WITH_SB {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_sbh})));
    }' unless defined(&SB_BUFFER_WITH_SB);
    eval 'sub SB_JOURNAL {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_journal})));
    }' unless defined(&SB_JOURNAL);
    eval 'sub SB_JOURNAL_1st_RESERVED_BLOCK {
        local($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_1st_reserved_block));
    }' unless defined(&SB_JOURNAL_1st_RESERVED_BLOCK);
    eval 'sub SB_JOURNAL_LIST {
        local($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_journal_list));
    }' unless defined(&SB_JOURNAL_LIST);
    eval 'sub SB_JOURNAL_LIST_INDEX {
        local($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_journal_list_index));
    }' unless defined(&SB_JOURNAL_LIST_INDEX);
    eval 'sub SB_JOURNAL_LEN_FREE {
        local($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_journal_len_free));
    }' unless defined(&SB_JOURNAL_LEN_FREE);
    eval 'sub SB_AP_BITMAP {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_ap_bitmap})));
    }' unless defined(&SB_AP_BITMAP);
    eval 'sub SB_DISK_JOURNAL_HEAD {
        local($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_header_bh->));
    }' unless defined(&SB_DISK_JOURNAL_HEAD);
    eval 'sub SB_JOURNAL_TRANS_MAX {
        local($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &s_journal_trans_max));
    }' unless defined(&SB_JOURNAL_TRANS_MAX);
    eval 'sub SB_JOURNAL_MAX_BATCH {
        local($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &s_journal_max_batch));
    }' unless defined(&SB_JOURNAL_MAX_BATCH);
    eval 'sub SB_JOURNAL_MAX_COMMIT_AGE {
        local($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &s_journal_max_commit_age));
    }' unless defined(&SB_JOURNAL_MAX_COMMIT_AGE);
    eval 'sub SB_JOURNAL_MAX_TRANS_AGE {
        local($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &s_journal_max_trans_age));
    }' unless defined(&SB_JOURNAL_MAX_TRANS_AGE);
    eval 'sub SB_JOURNAL_DEV {
        local($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_dev));
    }' unless defined(&SB_JOURNAL_DEV);
}
1;
