require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_REISER_FS_H)) {
    eval 'sub _LINUX_REISER_FS_H () {1;}' unless defined(&_LINUX_REISER_FS_H);
    require 'linux/types.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/slab.ph';
	require 'linux/tqueue.ph';
	require 'asm/unaligned.ph';
	require 'linux/bitops.ph';
	require 'asm/hardirq.ph';
	require 'linux/proc_fs.ph';
    }
    eval 'sub USE_INODE_GENERATION_COUNTER () {1;}' unless defined(&USE_INODE_GENERATION_COUNTER);
    eval 'sub REISERFS_PREALLOCATE () {1;}' unless defined(&REISERFS_PREALLOCATE);
    eval 'sub DISPLACE_NEW_PACKING_LOCALITIES () {1;}' unless defined(&DISPLACE_NEW_PACKING_LOCALITIES);
    eval 'sub PREALLOCATION_SIZE () {9;}' unless defined(&PREALLOCATION_SIZE);
    eval 'sub _ROUND_UP {
        local($x,$n) = @_;
	    eval q(((($x)+($n)-1) & ~(($n)-1)));
    }' unless defined(&_ROUND_UP);
    eval 'sub ROUND_UP {
        local($x) = @_;
	    eval q( &_ROUND_UP($x,8));
    }' unless defined(&ROUND_UP);
    eval 'sub REISERFS_DEBUG_CODE () {5;}' unless defined(&REISERFS_DEBUG_CODE);
    eval 'sub RASSERT () {(  &cond,  &format,  &args... )  &if( !(  &cond ) )  &reiserfs_panic( 0, "reiserfs[%i]: assertion "  &cond " failed at "  &__FILE__ ":%i:%s: "  &format "\\n",  &in_interrupt() ? -1:  &current ->  &pid,  &__LINE__ ,  &__FUNCTION__ ,  &args );}' unless defined(&RASSERT);
    if(defined( (defined(&CONFIG_REISERFS_CHECK) ? &CONFIG_REISERFS_CHECK : 0) )) {
	eval 'sub RFALSE () {(  &cond,  &format,  &args... )  &RASSERT( !(  &cond ),  &format,  &args );}' unless defined(&RFALSE);
    } else {
	eval 'sub RFALSE () {(  &cond,  &format,  &args... )  &do {;}  &while( 0);}' unless defined(&RFALSE);
    }
    eval 'sub CONSTF () { &__attribute__( (  &const ) );}' unless defined(&CONSTF);
    eval 'sub UNSET_HASH () {0;}' unless defined(&UNSET_HASH);
    eval 'sub TEA_HASH () {1;}' unless defined(&TEA_HASH);
    eval 'sub YURA_HASH () {2;}' unless defined(&YURA_HASH);
    eval 'sub R5_HASH () {3;}' unless defined(&R5_HASH);
    eval 'sub DEFAULT_HASH () { &R5_HASH;}' unless defined(&DEFAULT_HASH);
    eval 'sub SB_SIZE_V1 () {($sizeof{\'struct reiserfs_super_block_v1\'});}' unless defined(&SB_SIZE_V1);
    eval 'sub SB_SIZE () {($sizeof{\'struct reiserfs_super_block\'});}' unless defined(&SB_SIZE);
    eval 'sub REISERFS_VERSION_1 () {0;}' unless defined(&REISERFS_VERSION_1);
    eval 'sub REISERFS_VERSION_2 () {2;}' unless defined(&REISERFS_VERSION_2);
    eval 'sub SB_DISK_SUPER_BLOCK {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_rs})));
    }' unless defined(&SB_DISK_SUPER_BLOCK);
    eval 'sub SB_V1_DISK_SUPER_BLOCK {
        local($s) = @_;
	    eval q((( &SB_DISK_SUPER_BLOCK($s)-> &s_v1)));
    }' unless defined(&SB_V1_DISK_SUPER_BLOCK);
    eval 'sub SB_BLOCKSIZE {
        local($s) = @_;
	    eval q( &le32_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_blocksize)));
    }' unless defined(&SB_BLOCKSIZE);
    eval 'sub SB_BLOCK_COUNT {
        local($s) = @_;
	    eval q( &le32_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_block_count)));
    }' unless defined(&SB_BLOCK_COUNT);
    eval 'sub SB_FREE_BLOCKS {
        local($s) = @_;
	    eval q( &le32_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_free_blocks)));
    }' unless defined(&SB_FREE_BLOCKS);
    eval 'sub SB_REISERFS_MAGIC {
        local($s) = @_;
	    eval q(( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_magic));
    }' unless defined(&SB_REISERFS_MAGIC);
    eval 'sub SB_ROOT_BLOCK {
        local($s) = @_;
	    eval q( &le32_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_root_block)));
    }' unless defined(&SB_ROOT_BLOCK);
    eval 'sub SB_TREE_HEIGHT {
        local($s) = @_;
	    eval q( &le16_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_tree_height)));
    }' unless defined(&SB_TREE_HEIGHT);
    eval 'sub SB_REISERFS_STATE {
        local($s) = @_;
	    eval q( &le16_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_umount_state)));
    }' unless defined(&SB_REISERFS_STATE);
    eval 'sub SB_VERSION {
        local($s) = @_;
	    eval q( &le16_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_version)));
    }' unless defined(&SB_VERSION);
    eval 'sub SB_BMAP_NR {
        local($s) = @_;
	    eval q( &le16_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_bmap_nr)));
    }' unless defined(&SB_BMAP_NR);
    eval 'sub PUT_SB_BLOCK_COUNT {
        local($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_block_count =  &cpu_to_le32($val); }  &while (0));
    }' unless defined(&PUT_SB_BLOCK_COUNT);
    eval 'sub PUT_SB_FREE_BLOCKS {
        local($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_free_blocks =  &cpu_to_le32($val); }  &while (0));
    }' unless defined(&PUT_SB_FREE_BLOCKS);
    eval 'sub PUT_SB_ROOT_BLOCK {
        local($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_root_block =  &cpu_to_le32($val); }  &while (0));
    }' unless defined(&PUT_SB_ROOT_BLOCK);
    eval 'sub PUT_SB_TREE_HEIGHT {
        local($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_tree_height =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&PUT_SB_TREE_HEIGHT);
    eval 'sub PUT_SB_REISERFS_STATE {
        local($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_umount_state =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&PUT_SB_REISERFS_STATE);
    eval 'sub PUT_SB_VERSION {
        local($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_version =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&PUT_SB_VERSION);
    eval 'sub PUT_SB_BMAP_NR {
        local($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_bmap_nr =  &cpu_to_le16 ($val); }  &while (0));
    }' unless defined(&PUT_SB_BMAP_NR);
    eval 'sub SB_ONDISK_JP {
        local($s) = @_;
	    eval q(( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_journal));
    }' unless defined(&SB_ONDISK_JP);
    eval 'sub SB_ONDISK_JOURNAL_SIZE {
        local($s) = @_;
	    eval q( &le32_to_cpu (( &SB_ONDISK_JP($s)-> &jp_journal_size)));
    }' unless defined(&SB_ONDISK_JOURNAL_SIZE);
    eval 'sub SB_ONDISK_JOURNAL_1st_BLOCK {
        local($s) = @_;
	    eval q( &le32_to_cpu (( &SB_ONDISK_JP($s)-> &jp_journal_1st_block)));
    }' unless defined(&SB_ONDISK_JOURNAL_1st_BLOCK);
    eval 'sub SB_ONDISK_JOURNAL_DEVICE {
        local($s) = @_;
	    eval q( &le32_to_cpu (( &SB_ONDISK_JP($s)-> &jp_journal_dev)));
    }' unless defined(&SB_ONDISK_JOURNAL_DEVICE);
    eval 'sub SB_ONDISK_RESERVED_FOR_JOURNAL {
        local($s) = @_;
	    eval q( &le32_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_reserved_for_journal)));
    }' unless defined(&SB_ONDISK_RESERVED_FOR_JOURNAL);
    eval 'sub is_block_in_log_or_reserved_area {
        local($s, $block) = @_;
	    eval q($block >=  &SB_JOURNAL_1st_RESERVED_BLOCK($s)  && $block <  &SB_JOURNAL_1st_RESERVED_BLOCK($s) + ((! &is_reiserfs_jr( &SB_DISK_SUPER_BLOCK($s)) ?  &SB_ONDISK_JOURNAL_SIZE($s) + 1:  &SB_ONDISK_RESERVED_FOR_JOURNAL($s))));
    }' unless defined(&is_block_in_log_or_reserved_area);
    eval 'sub REISERFS_SUPER_MAGIC () {0x52654973;}' unless defined(&REISERFS_SUPER_MAGIC);
    eval 'sub REISERFS_SUPER_MAGIC_STRING () {"ReIsErFs";}' unless defined(&REISERFS_SUPER_MAGIC_STRING);
    eval 'sub REISER2FS_SUPER_MAGIC_STRING () {"ReIsEr2Fs";}' unless defined(&REISER2FS_SUPER_MAGIC_STRING);
    eval 'sub REISER2FS_JR_SUPER_MAGIC_STRING () {"ReIsEr3Fs";}' unless defined(&REISER2FS_JR_SUPER_MAGIC_STRING);
    eval 'sub REISERFS_DISK_OFFSET_IN_BYTES () {(64* 1024);}' unless defined(&REISERFS_DISK_OFFSET_IN_BYTES);
    eval 'sub REISERFS_FIRST_BLOCK () { &unused_define;}' unless defined(&REISERFS_FIRST_BLOCK);
    eval 'sub REISERFS_JOURNAL_OFFSET_IN_BYTES () { &REISERFS_DISK_OFFSET_IN_BYTES;}' unless defined(&REISERFS_JOURNAL_OFFSET_IN_BYTES);
    eval 'sub REISERFS_OLD_DISK_OFFSET_IN_BYTES () {(8* 1024);}' unless defined(&REISERFS_OLD_DISK_OFFSET_IN_BYTES);
    eval 'sub CARRY_ON () {0;}' unless defined(&CARRY_ON);
    eval 'sub REPEAT_SEARCH () {-1;}' unless defined(&REPEAT_SEARCH);
    eval 'sub IO_ERROR () {-2;}' unless defined(&IO_ERROR);
    eval 'sub NO_DISK_SPACE () {-3;}' unless defined(&NO_DISK_SPACE);
    eval 'sub NO_BALANCING_NEEDED () {(-4);}' unless defined(&NO_BALANCING_NEEDED);
    eval 'sub NO_MORE_UNUSED_CONTIGUOUS_BLOCKS () {(-5);}' unless defined(&NO_MORE_UNUSED_CONTIGUOUS_BLOCKS);
    eval 'sub KEY_FORMAT_3_5 () {0;}' unless defined(&KEY_FORMAT_3_5);
    eval 'sub KEY_FORMAT_3_6 () {1;}' unless defined(&KEY_FORMAT_3_6);
    eval 'sub STAT_DATA_V1 () {0;}' unless defined(&STAT_DATA_V1);
    eval 'sub STAT_DATA_V2 () {1;}' unless defined(&STAT_DATA_V2);
    eval 'sub get_inode_item_key_version {
        local( $inode ) = @_;
	    eval q(((($inode)-> ($u->{reiserfs_i}->{i_flags}) &  &i_item_key_version_mask) ?  &KEY_FORMAT_3_6 :  &KEY_FORMAT_3_5));
    }' unless defined(&get_inode_item_key_version);
    eval 'sub set_inode_item_key_version {
        local( $inode, $version ) = @_;
	    eval q(({  &if(($version)== &KEY_FORMAT_3_6) ($inode)-> ($u->{reiserfs_i}->{i_flags}) |=  &i_item_key_version_mask;  &else ($inode)-> ($u->{reiserfs_i}->{i_flags}) &= ~ &i_item_key_version_mask; }));
    }' unless defined(&set_inode_item_key_version);
    eval 'sub get_inode_sd_version {
        local($inode) = @_;
	    eval q(((($inode)-> ($u->{reiserfs_i}->{i_flags}) &  &i_stat_data_version_mask) ?  &STAT_DATA_V2 :  &STAT_DATA_V1));
    }' unless defined(&get_inode_sd_version);
    eval 'sub set_inode_sd_version {
        local($inode, $version) = @_;
	    eval q(({  &if(($version)== &STAT_DATA_V2) ($inode)-> ($u->{reiserfs_i}->{i_flags}) |=  &i_stat_data_version_mask;  &else ($inode)-> ($u->{reiserfs_i}->{i_flags}) &= ~ &i_stat_data_version_mask; }));
    }' unless defined(&set_inode_sd_version);
    eval 'sub STORE_TAIL_IN_UNFM_S1 {
        local($n_file_size,$n_tail_size,$n_block_size) = @_;
	    eval q(( (!($n_tail_size)) || ((($n_tail_size) >  &MAX_DIRECT_ITEM_LEN($n_block_size)) || ( ($n_file_size) >= ($n_block_size) * 4) || ( ( ($n_file_size) >= ($n_block_size) * 3)  && ( ($n_tail_size) >= ( &MAX_DIRECT_ITEM_LEN($n_block_size))/4) ) || ( ( ($n_file_size) >= ($n_block_size) * 2)  && ( ($n_tail_size) >= ( &MAX_DIRECT_ITEM_LEN($n_block_size))/2) ) || ( ( ($n_file_size) >= ($n_block_size) )  && ( ($n_tail_size) >= ( &MAX_DIRECT_ITEM_LEN($n_block_size) * 3)/4) ) ) ));
    }' unless defined(&STORE_TAIL_IN_UNFM_S1);
    eval 'sub STORE_TAIL_IN_UNFM_S2 {
        local($n_file_size,$n_tail_size,$n_block_size) = @_;
	    eval q(( (!($n_tail_size)) || ((($n_file_size) >  &MAX_DIRECT_ITEM_LEN($n_block_size)) ) ));
    }' unless defined(&STORE_TAIL_IN_UNFM_S2);
    eval 'sub REISERFS_VALID_FS () {1;}' unless defined(&REISERFS_VALID_FS);
    eval 'sub REISERFS_ERROR_FS () {2;}' unless defined(&REISERFS_ERROR_FS);
    eval 'sub TYPE_STAT_DATA () {0;}' unless defined(&TYPE_STAT_DATA);
    eval 'sub TYPE_INDIRECT () {1;}' unless defined(&TYPE_INDIRECT);
    eval 'sub TYPE_DIRECT () {2;}' unless defined(&TYPE_DIRECT);
    eval 'sub TYPE_DIRENTRY () {3;}' unless defined(&TYPE_DIRENTRY);
    eval 'sub TYPE_MAXTYPE () {3;}' unless defined(&TYPE_MAXTYPE);
    eval 'sub TYPE_ANY () {15;}' unless defined(&TYPE_ANY);
    if(defined(&__LITTLE_ENDIAN)) {
    } else {
    }
    unless(defined(&__LITTLE_ENDIAN)) {
	eval 'sub offset_v2_k_type {
	    local($v2) = @_;
    	    eval q({  &offset_v2_esafe_overlay  &tmp = *( &const  &offset_v2_esafe_overlay *)$v2;  ($tmp->{linear}) =  &le64_to_cpu(  ($tmp->{linear}) ); ( ($tmp->{offset_v2}->{k_type}) <=  &TYPE_MAXTYPE)? ($tmp->{offset_v2}->{k_type}): &TYPE_ANY; });
	}' unless defined(&offset_v2_k_type);
	eval 'sub set_offset_v2_k_offset {
	    local($v2,$offset) = @_;
    	    eval q({  &offset_v2_esafe_overlay * &tmp = ( &offset_v2_esafe_overlay *)$v2;  ($tmp->{linear}) =  &le64_to_cpu( ($tmp->{linear}));  ($tmp->{offset_v2}->{k_offset}) = $offset;  ($tmp->{linear}) =  &cpu_to_le64( ($tmp->{linear})); });
	}' unless defined(&set_offset_v2_k_offset);
    } else {
	eval 'sub offset_v2_k_type {
	    local($v2) = @_;
    	    eval q((($v2)-> &k_type));
	}' unless defined(&offset_v2_k_type);
	eval 'sub set_offset_v2_k_type {
	    local($v2,$val) = @_;
    	    eval q(( &offset_v2_k_type($v2) = ($val)));
	}' unless defined(&set_offset_v2_k_type);
	eval 'sub offset_v2_k_offset {
	    local($v2) = @_;
    	    eval q((($v2)-> &k_offset));
	}' unless defined(&offset_v2_k_offset);
	eval 'sub set_offset_v2_k_offset {
	    local($v2,$val) = @_;
    	    eval q(( &offset_v2_k_offset($v2) = ($val)));
	}' unless defined(&set_offset_v2_k_offset);
    }
    eval 'sub REISERFS_FULL_KEY_LEN () {4;}' unless defined(&REISERFS_FULL_KEY_LEN);
    eval 'sub REISERFS_SHORT_KEY_LEN () {2;}' unless defined(&REISERFS_SHORT_KEY_LEN);
    eval 'sub FIRST_GREATER () {1;}' unless defined(&FIRST_GREATER);
    eval 'sub SECOND_GREATER () {-1;}' unless defined(&SECOND_GREATER);
    eval 'sub KEYS_IDENTICAL () {0;}' unless defined(&KEYS_IDENTICAL);
    eval 'sub KEY_FOUND () {1;}' unless defined(&KEY_FOUND);
    eval 'sub KEY_NOT_FOUND () {0;}' unless defined(&KEY_NOT_FOUND);
    eval 'sub KEY_SIZE () {($sizeof{\'struct key\'});}' unless defined(&KEY_SIZE);
    eval 'sub SHORT_KEY_SIZE () {($sizeof{ &__u32} + $sizeof{ &__u32});}' unless defined(&SHORT_KEY_SIZE);
    eval 'sub ITEM_FOUND () {1;}' unless defined(&ITEM_FOUND);
    eval 'sub ITEM_NOT_FOUND () {0;}' unless defined(&ITEM_NOT_FOUND);
    eval 'sub ENTRY_FOUND () {1;}' unless defined(&ENTRY_FOUND);
    eval 'sub ENTRY_NOT_FOUND () {0;}' unless defined(&ENTRY_NOT_FOUND);
    eval 'sub DIRECTORY_NOT_FOUND () {-1;}' unless defined(&DIRECTORY_NOT_FOUND);
    eval 'sub REGULAR_FILE_FOUND () {-2;}' unless defined(&REGULAR_FILE_FOUND);
    eval 'sub DIRECTORY_FOUND () {-3;}' unless defined(&DIRECTORY_FOUND);
    eval 'sub BYTE_FOUND () {1;}' unless defined(&BYTE_FOUND);
    eval 'sub BYTE_NOT_FOUND () {0;}' unless defined(&BYTE_NOT_FOUND);
    eval 'sub FILE_NOT_FOUND () {-1;}' unless defined(&FILE_NOT_FOUND);
    eval 'sub POSITION_FOUND () {1;}' unless defined(&POSITION_FOUND);
    eval 'sub POSITION_NOT_FOUND () {0;}' unless defined(&POSITION_NOT_FOUND);
    eval 'sub NAME_FOUND () {1;}' unless defined(&NAME_FOUND);
    eval 'sub NAME_NOT_FOUND () {0;}' unless defined(&NAME_NOT_FOUND);
    eval 'sub GOTO_PREVIOUS_ITEM () {2;}' unless defined(&GOTO_PREVIOUS_ITEM);
    eval 'sub NAME_FOUND_INVISIBLE () {3;}' unless defined(&NAME_FOUND_INVISIBLE);
    eval 'sub IH_SIZE () {($sizeof{\'struct item_head\'});}' unless defined(&IH_SIZE);
    eval 'sub ih_free_space {
        local($ih) = @_;
	    eval q( &le16_to_cpu(($ih)-> ($u->{ih_free_space_reserved})));
    }' unless defined(&ih_free_space);
    eval 'sub ih_version {
        local($ih) = @_;
	    eval q( &le16_to_cpu(($ih)-> &ih_version));
    }' unless defined(&ih_version);
    eval 'sub ih_entry_count {
        local($ih) = @_;
	    eval q( &le16_to_cpu(($ih)-> ($u->{ih_entry_count})));
    }' unless defined(&ih_entry_count);
    eval 'sub ih_location {
        local($ih) = @_;
	    eval q( &le16_to_cpu(($ih)-> &ih_item_location));
    }' unless defined(&ih_location);
    eval 'sub ih_item_len {
        local($ih) = @_;
	    eval q( &le16_to_cpu(($ih)-> &ih_item_len));
    }' unless defined(&ih_item_len);
    eval 'sub put_ih_free_space {
        local($ih, $val) = @_;
	    eval q( &do { ($ih)-> ($u->{ih_free_space_reserved}) =  &cpu_to_le16($val); }  &while(0));
    }' unless defined(&put_ih_free_space);
    eval 'sub put_ih_version {
        local($ih, $val) = @_;
	    eval q( &do { ($ih)-> &ih_version =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&put_ih_version);
    eval 'sub put_ih_entry_count {
        local($ih, $val) = @_;
	    eval q( &do { ($ih)-> ($u->{ih_entry_count}) =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&put_ih_entry_count);
    eval 'sub put_ih_location {
        local($ih, $val) = @_;
	    eval q( &do { ($ih)-> &ih_item_location =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&put_ih_location);
    eval 'sub put_ih_item_len {
        local($ih, $val) = @_;
	    eval q( &do { ($ih)-> &ih_item_len =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&put_ih_item_len);
    eval 'sub unreachable_item {
        local($ih) = @_;
	    eval q(( &ih_version($ih) & (1<< 15)));
    }' unless defined(&unreachable_item);
    eval 'sub get_ih_free_space {
        local($ih) = @_;
	    eval q(( &ih_version ($ih) ==  &KEY_FORMAT_3_6 ? 0:  &ih_free_space ($ih)));
    }' unless defined(&get_ih_free_space);
    eval 'sub set_ih_free_space {
        local($ih,$val) = @_;
	    eval q( &put_ih_free_space(($ih), (( &ih_version($ih) ==  &KEY_FORMAT_3_6) ? 0: ($val))));
    }' unless defined(&set_ih_free_space);
    eval 'sub get_block_num {
        local($p, $i) = @_;
	    eval q( &le32_to_cpu( &get_unaligned(($p) + ($i))));
    }' unless defined(&get_block_num);
    eval 'sub put_block_num {
        local($p, $i, $v) = @_;
	    eval q( &put_unaligned( &cpu_to_le32($v), ($p) + ($i)));
    }' unless defined(&put_block_num);
    eval 'sub V1_SD_UNIQUENESS () {0;}' unless defined(&V1_SD_UNIQUENESS);
    eval 'sub V1_INDIRECT_UNIQUENESS () {0xfffffffe;}' unless defined(&V1_INDIRECT_UNIQUENESS);
    eval 'sub V1_DIRECT_UNIQUENESS () {0xffffffff;}' unless defined(&V1_DIRECT_UNIQUENESS);
    eval 'sub V1_DIRENTRY_UNIQUENESS () {500;}' unless defined(&V1_DIRENTRY_UNIQUENESS);
    eval 'sub V1_ANY_UNIQUENESS () {555;}' unless defined(&V1_ANY_UNIQUENESS);
    eval 'sub uniqueness2type {
        local($uniqueness) = @_;
	    eval q({  &switch ($uniqueness) {  &case  &V1_SD_UNIQUENESS:  &TYPE_STAT_DATA;  &case  &V1_INDIRECT_UNIQUENESS:  &TYPE_INDIRECT;  &case  &V1_DIRECT_UNIQUENESS:  &TYPE_DIRECT;  &case  &V1_DIRENTRY_UNIQUENESS:  &TYPE_DIRENTRY;  &default:  &reiserfs_warning( &NULL, \\"vs-500: unknown uniqueness %d\\\\n\\", $uniqueness);  &case  &V1_ANY_UNIQUENESS:  &TYPE_ANY; } });
    }' unless defined(&uniqueness2type);
    eval 'sub type2uniqueness {
        local($type) = @_;
	    eval q({  &switch ($type) {  &case  &TYPE_STAT_DATA:  &V1_SD_UNIQUENESS;  &case  &TYPE_INDIRECT:  &V1_INDIRECT_UNIQUENESS;  &case  &TYPE_DIRECT:  &V1_DIRECT_UNIQUENESS;  &case  &TYPE_DIRENTRY:  &V1_DIRENTRY_UNIQUENESS;  &default:  &reiserfs_warning( &NULL, \\"vs-501: unknown type %d\\\\n\\", $type);  &case  &TYPE_ANY:  &V1_ANY_UNIQUENESS; } });
    }' unless defined(&type2uniqueness);
    eval 'sub le_key_k_offset {
        local($version,$key) = @_;
	    eval q({ ($version ==  &KEY_FORMAT_3_5) ?  &le32_to_cpu(  ($key->{u}->{k_offset_v1}->{k_offset}) ) :  &offset_v2_k_offset( ( ($key->{u}->{k_offset_v2})) ); });
    }' unless defined(&le_key_k_offset);
    eval 'sub le_ih_k_offset {
        local($ih) = @_;
	    eval q({  &le_key_k_offset ( &ih_version ($ih), ( ($ih->{ih_key}))); });
    }' unless defined(&le_ih_k_offset);
    eval 'sub le_key_k_type {
        local($version,$key) = @_;
	    eval q({ ($version ==  &KEY_FORMAT_3_5) ?  &uniqueness2type(  &le32_to_cpu(  ($key->{u}->{k_offset_v1}->{k_uniqueness}))) :  &offset_v2_k_type( ( ($key->{u}->{k_offset_v2})) ); });
    }' unless defined(&le_key_k_type);
    eval 'sub le_ih_k_type {
        local($ih) = @_;
	    eval q({  &le_key_k_type ( &ih_version ($ih), ( ($ih->{ih_key}))); });
    }' unless defined(&le_ih_k_type);
    eval 'sub set_le_key_k_offset {
        local($version,$key,$offset) = @_;
	    eval q({ ($version ==  &KEY_FORMAT_3_5) ? ( ($key->{u}->{k_offset_v1}->{k_offset}) =  &cpu_to_le32 ($offset)) : ( &set_offset_v2_k_offset( ( ($key->{u}->{k_offset_v2})), $offset )); });
    }' unless defined(&set_le_key_k_offset);
    eval 'sub set_le_ih_k_offset {
        local($ih,$offset) = @_;
	    eval q({  &set_le_key_k_offset ( &ih_version ($ih), ( ($ih->{ih_key})), $offset); });
    }' unless defined(&set_le_ih_k_offset);
    eval 'sub set_le_key_k_type {
        local($version,$key,$type) = @_;
	    eval q({ ($version ==  &KEY_FORMAT_3_5) ? ( ($key->{u}->{k_offset_v1}->{k_uniqueness}) =  &cpu_to_le32( &type2uniqueness($type))): ( &set_offset_v2_k_type( ( ($key->{u}->{k_offset_v2})), $type )); });
    }' unless defined(&set_le_key_k_type);
    eval 'sub set_le_ih_k_type {
        local($ih,$type) = @_;
	    eval q({  &set_le_key_k_type ( &ih_version ($ih), ( ($ih->{ih_key})), $type); });
    }' unless defined(&set_le_ih_k_type);
    eval 'sub is_direntry_le_key {
        local($version,$key) = @_;
	    eval q(( &le_key_k_type ($version, $key) ==  &TYPE_DIRENTRY));
    }' unless defined(&is_direntry_le_key);
    eval 'sub is_direct_le_key {
        local($version,$key) = @_;
	    eval q(( &le_key_k_type ($version, $key) ==  &TYPE_DIRECT));
    }' unless defined(&is_direct_le_key);
    eval 'sub is_indirect_le_key {
        local($version,$key) = @_;
	    eval q(( &le_key_k_type ($version, $key) ==  &TYPE_INDIRECT));
    }' unless defined(&is_indirect_le_key);
    eval 'sub is_statdata_le_key {
        local($version,$key) = @_;
	    eval q(( &le_key_k_type ($version, $key) ==  &TYPE_STAT_DATA));
    }' unless defined(&is_statdata_le_key);
    eval 'sub is_direntry_le_ih {
        local($ih) = @_;
	    eval q( &is_direntry_le_key ( &ih_version ($ih), (($ih)-> &ih_key)));
    }' unless defined(&is_direntry_le_ih);
    eval 'sub is_direct_le_ih {
        local($ih) = @_;
	    eval q( &is_direct_le_key ( &ih_version ($ih), (($ih)-> &ih_key)));
    }' unless defined(&is_direct_le_ih);
    eval 'sub is_indirect_le_ih {
        local($ih) = @_;
	    eval q( &is_indirect_le_key ( &ih_version($ih), (($ih)-> &ih_key)));
    }' unless defined(&is_indirect_le_ih);
    eval 'sub is_statdata_le_ih {
        local($ih) = @_;
	    eval q( &is_statdata_le_key ( &ih_version ($ih), (($ih)-> &ih_key)));
    }' unless defined(&is_statdata_le_ih);
    eval 'sub cpu_key_k_offset {
        local($key) = @_;
	    eval q({ ( ($key->{version}) ==  &KEY_FORMAT_3_5) ?  ($key->{on_disk_key}->{u}->{k_offset_v1}->{k_offset}) :  ($key->{on_disk_key}->{u}->{k_offset_v2}->{k_offset}); });
    }' unless defined(&cpu_key_k_offset);
    eval 'sub cpu_key_k_type {
        local($key) = @_;
	    eval q({ ( ($key->{version}) ==  &KEY_FORMAT_3_5) ?  &uniqueness2type ( ($key->{on_disk_key}->{u}->{k_offset_v1}->{k_uniqueness})) :  ($key->{on_disk_key}->{u}->{k_offset_v2}->{k_type}); });
    }' unless defined(&cpu_key_k_type);
    eval 'sub set_cpu_key_k_offset {
        local($key,$offset) = @_;
	    eval q({ ( ($key->{version}) ==  &KEY_FORMAT_3_5) ? ( ($key->{on_disk_key}->{u}->{k_offset_v1}->{k_offset}) = $offset) : ( ($key->{on_disk_key}->{u}->{k_offset_v2}->{k_offset}) = $offset); });
    }' unless defined(&set_cpu_key_k_offset);
    eval 'sub set_cpu_key_k_type {
        local($key,$type) = @_;
	    eval q({ ( ($key->{version}) ==  &KEY_FORMAT_3_5) ? ( ($key->{on_disk_key}->{u}->{k_offset_v1}->{k_uniqueness}) =  &type2uniqueness ($type)): ( ($key->{on_disk_key}->{u}->{k_offset_v2}->{k_type}) = $type); });
    }' unless defined(&set_cpu_key_k_type);
    eval 'sub cpu_key_k_offset_dec {
        local($key) = @_;
	    eval q({  &if ( ($key->{version}) ==  &KEY_FORMAT_3_5)  ($key->{on_disk_key}->{u}->{k_offset_v1}->{k_offset}) --;  &else  ($key->{on_disk_key}->{u}->{k_offset_v2}->{k_offset}) --; });
    }' unless defined(&cpu_key_k_offset_dec);
    eval 'sub is_direntry_cpu_key {
        local($key) = @_;
	    eval q(( &cpu_key_k_type ($key) ==  &TYPE_DIRENTRY));
    }' unless defined(&is_direntry_cpu_key);
    eval 'sub is_direct_cpu_key {
        local($key) = @_;
	    eval q(( &cpu_key_k_type ($key) ==  &TYPE_DIRECT));
    }' unless defined(&is_direct_cpu_key);
    eval 'sub is_indirect_cpu_key {
        local($key) = @_;
	    eval q(( &cpu_key_k_type ($key) ==  &TYPE_INDIRECT));
    }' unless defined(&is_indirect_cpu_key);
    eval 'sub is_statdata_cpu_key {
        local($key) = @_;
	    eval q(( &cpu_key_k_type ($key) ==  &TYPE_STAT_DATA));
    }' unless defined(&is_statdata_cpu_key);
    eval 'sub is_direntry_cpu_ih {
        local($ih) = @_;
	    eval q(( &is_direntry_cpu_key ((($ih)-> &ih_key))));
    }' unless defined(&is_direntry_cpu_ih);
    eval 'sub is_direct_cpu_ih {
        local($ih) = @_;
	    eval q(( &is_direct_cpu_key ((($ih)-> &ih_key))));
    }' unless defined(&is_direct_cpu_ih);
    eval 'sub is_indirect_cpu_ih {
        local($ih) = @_;
	    eval q(( &is_indirect_cpu_key ((($ih)-> &ih_key))));
    }' unless defined(&is_indirect_cpu_ih);
    eval 'sub is_statdata_cpu_ih {
        local($ih) = @_;
	    eval q(( &is_statdata_cpu_key ((($ih)-> &ih_key))));
    }' unless defined(&is_statdata_cpu_ih);
    eval 'sub I_K_KEY_IN_ITEM {
        local($p_s_ih, $p_s_key, $n_blocksize) = @_;
	    eval q(( !  &COMP_SHORT_KEYS($p_s_ih, $p_s_key)  &&  &I_OFF_BYTE_IN_ITEM($p_s_ih,  &k_offset ($p_s_key), $n_blocksize) ));
    }' unless defined(&I_K_KEY_IN_ITEM);
    eval 'sub MAX_ITEM_LEN {
        local($block_size) = @_;
	    eval q(($block_size -  &BLKH_SIZE -  &IH_SIZE));
    }' unless defined(&MAX_ITEM_LEN);
    eval 'sub MIN_ITEM_LEN () {1;}' unless defined(&MIN_ITEM_LEN);
    eval 'sub REISERFS_ROOT_OBJECTID () {2;}' unless defined(&REISERFS_ROOT_OBJECTID);
    eval 'sub REISERFS_ROOT_PARENT_OBJECTID () {1;}' unless defined(&REISERFS_ROOT_PARENT_OBJECTID);
    eval 'sub BLKH_SIZE () {($sizeof{\'struct block_head\'});}' unless defined(&BLKH_SIZE);
    eval 'sub blkh_level {
        local($p_blkh) = @_;
	    eval q(( &le16_to_cpu(($p_blkh)-> &blk_level)));
    }' unless defined(&blkh_level);
    eval 'sub blkh_nr_item {
        local($p_blkh) = @_;
	    eval q(( &le16_to_cpu(($p_blkh)-> &blk_nr_item)));
    }' unless defined(&blkh_nr_item);
    eval 'sub blkh_free_space {
        local($p_blkh) = @_;
	    eval q(( &le16_to_cpu(($p_blkh)-> &blk_free_space)));
    }' unless defined(&blkh_free_space);
    eval 'sub blkh_reserved {
        local($p_blkh) = @_;
	    eval q(( &le16_to_cpu(($p_blkh)-> &blk_reserved)));
    }' unless defined(&blkh_reserved);
    eval 'sub set_blkh_level {
        local($p_blkh,$val) = @_;
	    eval q((($p_blkh)-> &blk_level =  &cpu_to_le16($val)));
    }' unless defined(&set_blkh_level);
    eval 'sub set_blkh_nr_item {
        local($p_blkh,$val) = @_;
	    eval q((($p_blkh)-> &blk_nr_item =  &cpu_to_le16($val)));
    }' unless defined(&set_blkh_nr_item);
    eval 'sub set_blkh_free_space {
        local($p_blkh,$val) = @_;
	    eval q((($p_blkh)-> &blk_free_space =  &cpu_to_le16($val)));
    }' unless defined(&set_blkh_free_space);
    eval 'sub set_blkh_reserved {
        local($p_blkh,$val) = @_;
	    eval q((($p_blkh)-> &blk_reserved =  &cpu_to_le16($val)));
    }' unless defined(&set_blkh_reserved);
    eval 'sub blkh_right_delim_key {
        local($p_blkh) = @_;
	    eval q((($p_blkh)-> &blk_right_delim_key));
    }' unless defined(&blkh_right_delim_key);
    eval 'sub set_blkh_right_delim_key {
        local($p_blkh,$val) = @_;
	    eval q((($p_blkh)-> &blk_right_delim_key = $val));
    }' unless defined(&set_blkh_right_delim_key);
    eval 'sub FREE_LEVEL () {0;}' unless defined(&FREE_LEVEL);
    eval 'sub DISK_LEAF_NODE_LEVEL () {1;}' unless defined(&DISK_LEAF_NODE_LEVEL);
    eval 'sub B_BLK_HEAD {
        local($p_s_bh) = @_;
	    eval q(((($p_s_bh)-> &b_data)));
    }' unless defined(&B_BLK_HEAD);
    eval 'sub B_NR_ITEMS {
        local($p_s_bh) = @_;
	    eval q(( &blkh_nr_item( &B_BLK_HEAD($p_s_bh))));
    }' unless defined(&B_NR_ITEMS);
    eval 'sub B_LEVEL {
        local($p_s_bh) = @_;
	    eval q(( &blkh_level( &B_BLK_HEAD($p_s_bh))));
    }' unless defined(&B_LEVEL);
    eval 'sub B_FREE_SPACE {
        local($p_s_bh) = @_;
	    eval q(( &blkh_free_space( &B_BLK_HEAD($p_s_bh))));
    }' unless defined(&B_FREE_SPACE);
    eval 'sub PUT_B_NR_ITEMS {
        local($p_s_bh,$val) = @_;
	    eval q( &do {  &set_blkh_nr_item( &B_BLK_HEAD($p_s_bh),$val); }  &while (0));
    }' unless defined(&PUT_B_NR_ITEMS);
    eval 'sub PUT_B_LEVEL {
        local($p_s_bh,$val) = @_;
	    eval q( &do {  &set_blkh_level( &B_BLK_HEAD($p_s_bh),$val); }  &while (0));
    }' unless defined(&PUT_B_LEVEL);
    eval 'sub PUT_B_FREE_SPACE {
        local($p_s_bh,$val) = @_;
	    eval q( &do {  &set_blkh_free_space( &B_BLK_HEAD($p_s_bh),$val); }  &while (0));
    }' unless defined(&PUT_B_FREE_SPACE);
    eval 'sub B_PRIGHT_DELIM_KEY {
        local($p_s_bh) = @_;
	    eval q((( &blk_right_delim_key( &B_BLK_HEAD($p_s_bh)));
    }' unless defined(&B_PRIGHT_DELIM_KEY);
    eval 'sub B_IS_ITEMS_LEVEL {
        local($p_s_bh) = @_;
	    eval q(( &B_LEVEL($p_s_bh) ==  &DISK_LEAF_NODE_LEVEL));
    }' unless defined(&B_IS_ITEMS_LEVEL);
    eval 'sub B_IS_KEYS_LEVEL {
        local($p_s_bh) = @_;
	    eval q(( &B_LEVEL($p_s_bh) >  &DISK_LEAF_NODE_LEVEL  &&  &B_LEVEL($p_s_bh) <=  &MAX_HEIGHT));
    }' unless defined(&B_IS_KEYS_LEVEL);
    eval 'sub SD_V1_SIZE () {($sizeof{\'struct stat_data_v1\'});}' unless defined(&SD_V1_SIZE);
    eval 'sub stat_data_v1 {
        local($ih) = @_;
	    eval q(( &ih_version ($ih) ==  &KEY_FORMAT_3_5));
    }' unless defined(&stat_data_v1);
    eval 'sub sd_v1_mode {
        local($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_mode)));
    }' unless defined(&sd_v1_mode);
    eval 'sub set_sd_v1_mode {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_mode =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v1_mode);
    eval 'sub sd_v1_nlink {
        local($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_nlink)));
    }' unless defined(&sd_v1_nlink);
    eval 'sub set_sd_v1_nlink {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_nlink =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v1_nlink);
    eval 'sub sd_v1_uid {
        local($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_uid)));
    }' unless defined(&sd_v1_uid);
    eval 'sub set_sd_v1_uid {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_uid =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v1_uid);
    eval 'sub sd_v1_gid {
        local($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_gid)));
    }' unless defined(&sd_v1_gid);
    eval 'sub set_sd_v1_gid {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_gid =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v1_gid);
    eval 'sub sd_v1_size {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_size)));
    }' unless defined(&sd_v1_size);
    eval 'sub set_sd_v1_size {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_size =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_size);
    eval 'sub sd_v1_atime {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_atime)));
    }' unless defined(&sd_v1_atime);
    eval 'sub set_sd_v1_atime {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_atime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_atime);
    eval 'sub sd_v1_mtime {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_mtime)));
    }' unless defined(&sd_v1_mtime);
    eval 'sub set_sd_v1_mtime {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_mtime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_mtime);
    eval 'sub sd_v1_ctime {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_ctime)));
    }' unless defined(&sd_v1_ctime);
    eval 'sub set_sd_v1_ctime {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_ctime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_ctime);
    eval 'sub sd_v1_rdev {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> ($u->{sd_rdev}))));
    }' unless defined(&sd_v1_rdev);
    eval 'sub set_sd_v1_rdev {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> ($u->{sd_rdev}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_rdev);
    eval 'sub sd_v1_blocks {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> ($u->{sd_blocks}))));
    }' unless defined(&sd_v1_blocks);
    eval 'sub set_sd_v1_blocks {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> ($u->{sd_blocks}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_blocks);
    eval 'sub sd_v1_first_direct_byte {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_first_direct_byte)));
    }' unless defined(&sd_v1_first_direct_byte);
    eval 'sub set_sd_v1_first_direct_byte {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_first_direct_byte =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_first_direct_byte);
    require 'linux/ext2_fs.ph';
    eval 'sub REISERFS_IMMUTABLE_FL () { &EXT2_IMMUTABLE_FL;}' unless defined(&REISERFS_IMMUTABLE_FL);
    eval 'sub REISERFS_APPEND_FL () { &EXT2_APPEND_FL;}' unless defined(&REISERFS_APPEND_FL);
    eval 'sub REISERFS_SYNC_FL () { &EXT2_SYNC_FL;}' unless defined(&REISERFS_SYNC_FL);
    eval 'sub REISERFS_NOATIME_FL () { &EXT2_NOATIME_FL;}' unless defined(&REISERFS_NOATIME_FL);
    eval 'sub REISERFS_NODUMP_FL () { &EXT2_NODUMP_FL;}' unless defined(&REISERFS_NODUMP_FL);
    eval 'sub REISERFS_SECRM_FL () { &EXT2_SECRM_FL;}' unless defined(&REISERFS_SECRM_FL);
    eval 'sub REISERFS_UNRM_FL () { &EXT2_UNRM_FL;}' unless defined(&REISERFS_UNRM_FL);
    eval 'sub REISERFS_COMPR_FL () { &EXT2_COMPR_FL;}' unless defined(&REISERFS_COMPR_FL);
    eval 'sub REISERFS_NOTAIL_FL () {(0x8000);}' unless defined(&REISERFS_NOTAIL_FL);
    eval 'sub REISERFS_INHERIT_MASK () {(  &REISERFS_IMMUTABLE_FL |  &REISERFS_SYNC_FL |  &REISERFS_NOATIME_FL |  &REISERFS_NODUMP_FL |  &REISERFS_SECRM_FL |  &REISERFS_COMPR_FL |  &REISERFS_NOTAIL_FL );}' unless defined(&REISERFS_INHERIT_MASK);
    eval 'sub SD_SIZE () {($sizeof{\'struct stat_data\'});}' unless defined(&SD_SIZE);
    eval 'sub SD_V2_SIZE () { &SD_SIZE;}' unless defined(&SD_V2_SIZE);
    eval 'sub stat_data_v2 {
        local($ih) = @_;
	    eval q(( &ih_version ($ih) ==  &KEY_FORMAT_3_6));
    }' unless defined(&stat_data_v2);
    eval 'sub sd_v2_mode {
        local($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_mode)));
    }' unless defined(&sd_v2_mode);
    eval 'sub set_sd_v2_mode {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_mode =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v2_mode);
    eval 'sub sd_v2_nlink {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_nlink)));
    }' unless defined(&sd_v2_nlink);
    eval 'sub set_sd_v2_nlink {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_nlink =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_nlink);
    eval 'sub sd_v2_size {
        local($sdp) = @_;
	    eval q(( &le64_to_cpu(($sdp)-> &sd_size)));
    }' unless defined(&sd_v2_size);
    eval 'sub set_sd_v2_size {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_size =  &cpu_to_le64($v)));
    }' unless defined(&set_sd_v2_size);
    eval 'sub sd_v2_uid {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_uid)));
    }' unless defined(&sd_v2_uid);
    eval 'sub set_sd_v2_uid {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_uid =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_uid);
    eval 'sub sd_v2_gid {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_gid)));
    }' unless defined(&sd_v2_gid);
    eval 'sub set_sd_v2_gid {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_gid =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_gid);
    eval 'sub sd_v2_atime {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_atime)));
    }' unless defined(&sd_v2_atime);
    eval 'sub set_sd_v2_atime {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_atime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_atime);
    eval 'sub sd_v2_mtime {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_mtime)));
    }' unless defined(&sd_v2_mtime);
    eval 'sub set_sd_v2_mtime {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_mtime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_mtime);
    eval 'sub sd_v2_ctime {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_ctime)));
    }' unless defined(&sd_v2_ctime);
    eval 'sub set_sd_v2_ctime {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_ctime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_ctime);
    eval 'sub sd_v2_blocks {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_blocks)));
    }' unless defined(&sd_v2_blocks);
    eval 'sub set_sd_v2_blocks {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_blocks =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_blocks);
    eval 'sub sd_v2_rdev {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> ($u->{sd_rdev}))));
    }' unless defined(&sd_v2_rdev);
    eval 'sub set_sd_v2_rdev {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> ($u->{sd_rdev}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_rdev);
    eval 'sub sd_v2_generation {
        local($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> ($u->{sd_generation}))));
    }' unless defined(&sd_v2_generation);
    eval 'sub set_sd_v2_generation {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> ($u->{sd_generation}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_generation);
    eval 'sub sd_v2_attrs {
        local($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_attrs)));
    }' unless defined(&sd_v2_attrs);
    eval 'sub set_sd_v2_attrs {
        local($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_attrs =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v2_attrs);
    eval 'sub SD_OFFSET () {0;}' unless defined(&SD_OFFSET);
    eval 'sub SD_UNIQUENESS () {0;}' unless defined(&SD_UNIQUENESS);
    eval 'sub DOT_OFFSET () {1;}' unless defined(&DOT_OFFSET);
    eval 'sub DOT_DOT_OFFSET () {2;}' unless defined(&DOT_DOT_OFFSET);
    eval 'sub DIRENTRY_UNIQUENESS () {500;}' unless defined(&DIRENTRY_UNIQUENESS);
    eval 'sub FIRST_ITEM_OFFSET () {1;}' unless defined(&FIRST_ITEM_OFFSET);
    eval 'sub DEH_SIZE () {$sizeof{\'struct reiserfs_de_head\'};}' unless defined(&DEH_SIZE);
    eval 'sub deh_offset {
        local($p_deh) = @_;
	    eval q(( &le32_to_cpu(($p_deh)-> &deh_offset)));
    }' unless defined(&deh_offset);
    eval 'sub deh_dir_id {
        local($p_deh) = @_;
	    eval q(( &le32_to_cpu(($p_deh)-> &deh_dir_id)));
    }' unless defined(&deh_dir_id);
    eval 'sub deh_objectid {
        local($p_deh) = @_;
	    eval q(( &le32_to_cpu(($p_deh)-> &deh_objectid)));
    }' unless defined(&deh_objectid);
    eval 'sub deh_location {
        local($p_deh) = @_;
	    eval q(( &le16_to_cpu(($p_deh)-> &deh_location)));
    }' unless defined(&deh_location);
    eval 'sub deh_state {
        local($p_deh) = @_;
	    eval q(( &le16_to_cpu(($p_deh)-> &deh_state)));
    }' unless defined(&deh_state);
    eval 'sub put_deh_offset {
        local($p_deh,$v) = @_;
	    eval q((($p_deh)-> &deh_offset =  &cpu_to_le32(($v))));
    }' unless defined(&put_deh_offset);
    eval 'sub put_deh_dir_id {
        local($p_deh,$v) = @_;
	    eval q((($p_deh)-> &deh_dir_id =  &cpu_to_le32(($v))));
    }' unless defined(&put_deh_dir_id);
    eval 'sub put_deh_objectid {
        local($p_deh,$v) = @_;
	    eval q((($p_deh)-> &deh_objectid =  &cpu_to_le32(($v))));
    }' unless defined(&put_deh_objectid);
    eval 'sub put_deh_location {
        local($p_deh,$v) = @_;
	    eval q((($p_deh)-> &deh_location =  &cpu_to_le16(($v))));
    }' unless defined(&put_deh_location);
    eval 'sub put_deh_state {
        local($p_deh,$v) = @_;
	    eval q((($p_deh)-> &deh_state =  &cpu_to_le16(($v))));
    }' unless defined(&put_deh_state);
    eval 'sub EMPTY_DIR_SIZE () {( &DEH_SIZE * 2+  &ROUND_UP ( &strlen (".")) +  &ROUND_UP ( &strlen ("..")));}' unless defined(&EMPTY_DIR_SIZE);
    eval 'sub EMPTY_DIR_SIZE_V1 () {( &DEH_SIZE * 2+ 3);}' unless defined(&EMPTY_DIR_SIZE_V1);
    eval 'sub DEH_Statdata () {0;}' unless defined(&DEH_Statdata);
    eval 'sub DEH_Visible () {2;}' unless defined(&DEH_Visible);
    if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 64|| defined( &__s390__) || defined( &__hppa__)) {
	eval 'sub ADDR_UNALIGNED_BITS () {(3);}' unless defined(&ADDR_UNALIGNED_BITS);
    }
    if(defined(&ADDR_UNALIGNED_BITS)) {
	eval 'sub aligned_address {
	    local($addr) = @_;
    	    eval q((( &void *)(($addr) & ~((1 <<  &ADDR_UNALIGNED_BITS) - 1))));
	}' unless defined(&aligned_address);
	eval 'sub unaligned_offset {
	    local($addr) = @_;
    	    eval q((((($addr) & ((1<<  &ADDR_UNALIGNED_BITS) - 1))) << 3));
	}' unless defined(&unaligned_offset);
	eval 'sub set_bit_unaligned {
	    local($nr, $addr) = @_;
    	    eval q( &ext2_set_bit(($nr) +  &unaligned_offset($addr),  &aligned_address($addr)));
	}' unless defined(&set_bit_unaligned);
	eval 'sub clear_bit_unaligned {
	    local($nr, $addr) = @_;
    	    eval q( &ext2_clear_bit(($nr) +  &unaligned_offset($addr),  &aligned_address($addr)));
	}' unless defined(&clear_bit_unaligned);
	eval 'sub test_bit_unaligned {
	    local($nr, $addr) = @_;
    	    eval q( &ext2_test_bit(($nr) +  &unaligned_offset($addr),  &aligned_address($addr)));
	}' unless defined(&test_bit_unaligned);
    } else {
	eval 'sub set_bit_unaligned {
	    local($nr, $addr) = @_;
    	    eval q( &ext2_set_bit($nr, $addr));
	}' unless defined(&set_bit_unaligned);
	eval 'sub clear_bit_unaligned {
	    local($nr, $addr) = @_;
    	    eval q( &ext2_clear_bit($nr, $addr));
	}' unless defined(&clear_bit_unaligned);
	eval 'sub test_bit_unaligned {
	    local($nr, $addr) = @_;
    	    eval q( &ext2_test_bit($nr, $addr));
	}' unless defined(&test_bit_unaligned);
    }
    eval 'sub mark_de_with_sd {
        local($deh) = @_;
	    eval q( &set_bit_unaligned ( &DEH_Statdata, (($deh)-> &deh_state)));
    }' unless defined(&mark_de_with_sd);
    eval 'sub mark_de_without_sd {
        local($deh) = @_;
	    eval q( &clear_bit_unaligned ( &DEH_Statdata, (($deh)-> &deh_state)));
    }' unless defined(&mark_de_without_sd);
    eval 'sub mark_de_visible {
        local($deh) = @_;
	    eval q( &set_bit_unaligned ( &DEH_Visible, (($deh)-> &deh_state)));
    }' unless defined(&mark_de_visible);
    eval 'sub mark_de_hidden {
        local($deh) = @_;
	    eval q( &clear_bit_unaligned ( &DEH_Visible, (($deh)-> &deh_state)));
    }' unless defined(&mark_de_hidden);
    eval 'sub de_with_sd {
        local($deh) = @_;
	    eval q( &test_bit_unaligned ( &DEH_Statdata, (($deh)-> &deh_state)));
    }' unless defined(&de_with_sd);
    eval 'sub de_visible {
        local($deh) = @_;
	    eval q( &test_bit_unaligned ( &DEH_Visible, (($deh)-> &deh_state)));
    }' unless defined(&de_visible);
    eval 'sub de_hidden {
        local($deh) = @_;
	    eval q(! &test_bit_unaligned ( &DEH_Visible, (($deh)-> &deh_state)));
    }' unless defined(&de_hidden);
    eval 'sub B_I_PITEM {
        local($bh,$ih) = @_;
	    eval q(( ($bh)-> &b_data +  &ih_location($ih) ));
    }' unless defined(&B_I_PITEM);
    eval 'sub B_I_DEH {
        local($bh,$ih) = @_;
	    eval q((( &B_I_PITEM($bh,$ih))));
    }' unless defined(&B_I_DEH);
    eval 'sub I_ENTRY_COUNT {
        local($ih) = @_;
	    eval q(( &ih_entry_count(($ih))));
    }' unless defined(&I_ENTRY_COUNT);
    eval 'sub B_I_E_NAME {
        local($bh,$ih,$entry_num) = @_;
	    eval q((( ($bh->{b_data}) +  &ih_location($ih) +  &deh_location( &B_I_DEH($bh,$ih)+($entry_num)))));
    }' unless defined(&B_I_E_NAME);
    eval 'sub REISERFS_MAX_NAME {
        local($block_size) = @_;
	    eval q(255);
    }' unless defined(&REISERFS_MAX_NAME);
    eval 'sub B_I_DEH_ENTRY_FILE_NAME {
        local($bh,$ih,$deh) = @_;
	    eval q(( &B_I_PITEM ($bh, $ih) +  &deh_location($deh)));
    }' unless defined(&B_I_DEH_ENTRY_FILE_NAME);
    eval 'sub I_DEH_N_ENTRY_FILE_NAME_LENGTH {
        local($ih,$deh,$entry_num) = @_;
	    eval q(( &I_DEH_N_ENTRY_LENGTH ($ih, $deh, $entry_num) - ( &de_with_sd ($deh) ?  &SD_SIZE : 0)));
    }' unless defined(&I_DEH_N_ENTRY_FILE_NAME_LENGTH);
    eval 'sub GET_HASH_VALUE {
        local($offset) = @_;
	    eval q((($offset) & 0x7fffff80));
    }' unless defined(&GET_HASH_VALUE);
    eval 'sub GET_GENERATION_NUMBER {
        local($offset) = @_;
	    eval q((($offset) & 0x7f));
    }' unless defined(&GET_GENERATION_NUMBER);
    eval 'sub MAX_GENERATION_NUMBER () {127;}' unless defined(&MAX_GENERATION_NUMBER);
    eval 'sub SET_GENERATION_NUMBER {
        local($offset,$gen_number) = @_;
	    eval q(( &GET_HASH_VALUE($offset)|($gen_number)));
    }' unless defined(&SET_GENERATION_NUMBER);
    eval 'sub DC_SIZE () {($sizeof{\'struct disk_child\'});}' unless defined(&DC_SIZE);
    eval 'sub dc_block_number {
        local($dc_p) = @_;
	    eval q(( &le32_to_cpu(($dc_p)-> &dc_block_number)));
    }' unless defined(&dc_block_number);
    eval 'sub dc_size {
        local($dc_p) = @_;
	    eval q(( &le16_to_cpu(($dc_p)-> &dc_size)));
    }' unless defined(&dc_size);
    eval 'sub put_dc_block_number {
        local($dc_p, $val) = @_;
	    eval q( &do { ($dc_p)-> &dc_block_number =  &cpu_to_le32($val); }  &while(0));
    }' unless defined(&put_dc_block_number);
    eval 'sub put_dc_size {
        local($dc_p, $val) = @_;
	    eval q( &do { ($dc_p)-> &dc_size =  &cpu_to_le16($val); }  &while(0));
    }' unless defined(&put_dc_size);
    eval 'sub B_N_CHILD {
        local($p_s_bh,$n_pos) = @_;
	    eval q(((($p_s_bh)-> &b_data+ &BLKH_SIZE+ &B_NR_ITEMS($p_s_bh)* &KEY_SIZE+ &DC_SIZE*($n_pos))));
    }' unless defined(&B_N_CHILD);
    eval 'sub B_N_CHILD_NUM {
        local($p_s_bh,$n_pos) = @_;
	    eval q(( &dc_block_number( &B_N_CHILD($p_s_bh,$n_pos))));
    }' unless defined(&B_N_CHILD_NUM);
    eval 'sub PUT_B_N_CHILD_NUM {
        local($p_s_bh,$n_pos, $val) = @_;
	    eval q(( &put_dc_block_number( &B_N_CHILD($p_s_bh,$n_pos), $val )));
    }' unless defined(&PUT_B_N_CHILD_NUM);
    eval 'sub MAX_CHILD_SIZE {
        local($bh) = @_;
	    eval q((( ($bh)-> &b_size -  &BLKH_SIZE )));
    }' unless defined(&MAX_CHILD_SIZE);
    eval 'sub B_CHILD_SIZE {
        local($cur) = @_;
	    eval q(( &MAX_CHILD_SIZE($cur)-( &B_FREE_SPACE($cur))));
    }' unless defined(&B_CHILD_SIZE);
    eval 'sub MAX_NR_KEY {
        local($bh) = @_;
	    eval q(( ( &MAX_CHILD_SIZE($bh)- &DC_SIZE)/( &KEY_SIZE+ &DC_SIZE) ));
    }' unless defined(&MAX_NR_KEY);
    eval 'sub MIN_NR_KEY {
        local($bh) = @_;
	    eval q(( &MAX_NR_KEY($bh)/2));
    }' unless defined(&MIN_NR_KEY);
    eval 'sub MAX_HEIGHT () {5;}' unless defined(&MAX_HEIGHT);
    eval 'sub EXTENDED_MAX_HEIGHT () {7;}' unless defined(&EXTENDED_MAX_HEIGHT);
    eval 'sub FIRST_PATH_ELEMENT_OFFSET () {2;}' unless defined(&FIRST_PATH_ELEMENT_OFFSET);
    eval 'sub ILLEGAL_PATH_ELEMENT_OFFSET () {1;}' unless defined(&ILLEGAL_PATH_ELEMENT_OFFSET);
    eval 'sub MAX_FEB_SIZE () {6;}' unless defined(&MAX_FEB_SIZE);
    eval 'sub pos_in_item {
        local($path) = @_;
	    eval q((($path)-> &pos_in_item));
    }' unless defined(&pos_in_item);
    eval 'sub INITIALIZE_PATH {
        local($var) = @_;
	    eval q(\'struct path\' $var = { &ILLEGAL_PATH_ELEMENT_OFFSET, });
    }' unless defined(&INITIALIZE_PATH);
    eval 'sub PATH_OFFSET_PELEMENT {
        local($p_s_path,$n_offset) = @_;
	    eval q((($p_s_path)-> &path_elements +($n_offset)));
    }' unless defined(&PATH_OFFSET_PELEMENT);
    eval 'sub PATH_OFFSET_PBUFFER {
        local($p_s_path,$n_offset) = @_;
	    eval q(( &PATH_OFFSET_PELEMENT($p_s_path,$n_offset)-> &pe_buffer));
    }' unless defined(&PATH_OFFSET_PBUFFER);
    eval 'sub PATH_OFFSET_POSITION {
        local($p_s_path,$n_offset) = @_;
	    eval q(( &PATH_OFFSET_PELEMENT($p_s_path,$n_offset)-> &pe_position));
    }' unless defined(&PATH_OFFSET_POSITION);
    eval 'sub PATH_PLAST_BUFFER {
        local($p_s_path) = @_;
	    eval q(( &PATH_OFFSET_PBUFFER(($p_s_path), ($p_s_path)-> &path_length)));
    }' unless defined(&PATH_PLAST_BUFFER);
    eval 'sub PATH_LAST_POSITION {
        local($p_s_path) = @_;
	    eval q(( &PATH_OFFSET_POSITION(($p_s_path), ($p_s_path)-> &path_length)));
    }' unless defined(&PATH_LAST_POSITION);
    eval 'sub PATH_PITEM_HEAD {
        local($p_s_path) = @_;
	    eval q( &B_N_PITEM_HEAD( &PATH_PLAST_BUFFER($p_s_path), &PATH_LAST_POSITION($p_s_path)));
    }' unless defined(&PATH_PITEM_HEAD);
    eval 'sub PATH_H_PBUFFER {
        local($p_s_path, $h) = @_;
	    eval q( &PATH_OFFSET_PBUFFER ($p_s_path,  ($p_s_path->{path_length}) - ($h)));
    }' unless defined(&PATH_H_PBUFFER);
    eval 'sub PATH_H_PPARENT {
        local($path, $h) = @_;
	    eval q( &PATH_H_PBUFFER ($path, ($h) + 1));
    }' unless defined(&PATH_H_PPARENT);
    eval 'sub PATH_H_POSITION {
        local($path, $h) = @_;
	    eval q( &PATH_OFFSET_POSITION ($path,  ($path->{path_length}) - ($h)));
    }' unless defined(&PATH_H_POSITION);
    eval 'sub PATH_H_B_ITEM_ORDER {
        local($path, $h) = @_;
	    eval q( &PATH_H_POSITION($path, $h + 1));
    }' unless defined(&PATH_H_B_ITEM_ORDER);
    eval 'sub PATH_H_PATH_OFFSET {
        local($p_s_path, $n_h) = @_;
	    eval q((($p_s_path)-> &path_length - ($n_h)));
    }' unless defined(&PATH_H_PATH_OFFSET);
    eval 'sub get_last_bh {
        local($path) = @_;
	    eval q( &PATH_PLAST_BUFFER($path));
    }' unless defined(&get_last_bh);
    eval 'sub get_ih {
        local($path) = @_;
	    eval q( &PATH_PITEM_HEAD($path));
    }' unless defined(&get_ih);
    eval 'sub get_item_pos {
        local($path) = @_;
	    eval q( &PATH_LAST_POSITION($path));
    }' unless defined(&get_item_pos);
    eval 'sub get_item {
        local($path) = @_;
	    eval q((( &void *) &B_N_PITEM( &PATH_PLAST_BUFFER($path),  &PATH_LAST_POSITION ($path))));
    }' unless defined(&get_item);
    eval 'sub item_moved {
        local($ih,$path) = @_;
	    eval q( &comp_items($ih, $path));
    }' unless defined(&item_moved);
    eval 'sub path_changed {
        local($ih,$path) = @_;
	    eval q( &comp_items ($ih, $path));
    }' unless defined(&path_changed);
    eval 'sub UNFM_P_SIZE () {($sizeof{ &unp_t});}' unless defined(&UNFM_P_SIZE);
    eval 'sub UNFM_P_SHIFT () {2;}' unless defined(&UNFM_P_SHIFT);
    eval 'sub INODE_PKEY {
        local($inode) = @_;
	    eval q(((($inode)-> ($u->{reiserfs_i}->{i_key}))));
    }' unless defined(&INODE_PKEY);
    eval 'sub MAX_UL_INT () {0xffffffff;}' unless defined(&MAX_UL_INT);
    eval 'sub MAX_INT () {0x7ffffff;}' unless defined(&MAX_INT);
    eval 'sub MAX_US_INT () {0xffff;}' unless defined(&MAX_US_INT);
    eval 'sub U32_MAX () {(~( &__u32)0);}' unless defined(&U32_MAX);
    eval 'sub max_reiserfs_offset {
        local($inode) = @_;
	    eval q({  &if ( &get_inode_item_key_version($inode) ==  &KEY_FORMAT_3_5) ( &loff_t) &U32_MAX; ( &loff_t)((~( &__u64)0) >> 4); });
    }' unless defined(&max_reiserfs_offset);
    eval 'sub MAX_KEY_OBJECTID () { &MAX_UL_INT;}' unless defined(&MAX_KEY_OBJECTID);
    eval 'sub MAX_B_NUM () { &MAX_UL_INT;}' unless defined(&MAX_B_NUM);
    eval 'sub MAX_FC_NUM () { &MAX_US_INT;}' unless defined(&MAX_FC_NUM);
    eval 'sub REISERFS_LINK_MAX () {( &MAX_US_INT - 1000);}' unless defined(&REISERFS_LINK_MAX);
    eval 'sub REISERFS_KERNEL_MEM () {0;}' unless defined(&REISERFS_KERNEL_MEM);
    eval 'sub REISERFS_USER_MEM () {1;}' unless defined(&REISERFS_USER_MEM);
    eval 'sub fs_generation {
        local($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_generation_counter})));
    }' unless defined(&fs_generation);
    eval 'sub get_generation {
        local($s) = @_;
	    eval q( &atomic_read ( &fs_generation($s)));
    }' unless defined(&get_generation);
    eval 'sub FILESYSTEM_CHANGED_TB {
        local($tb) = @_;
	    eval q(( &get_generation(($tb)-> &tb_sb) != ($tb)-> &fs_gen));
    }' unless defined(&FILESYSTEM_CHANGED_TB);
    eval 'sub fs_changed {
        local($gen,$s) = @_;
	    eval q(($gen !=  &get_generation ($s)));
    }' unless defined(&fs_changed);
    eval 'sub VI_TYPE_LEFT_MERGEABLE () {1;}' unless defined(&VI_TYPE_LEFT_MERGEABLE);
    eval 'sub VI_TYPE_RIGHT_MERGEABLE () {2;}' unless defined(&VI_TYPE_RIGHT_MERGEABLE);
    eval 'sub MAX_FREE_BLOCK () {7;}' unless defined(&MAX_FREE_BLOCK);
    eval 'sub MAX_AMOUNT_NEEDED () {2;}' unless defined(&MAX_AMOUNT_NEEDED);
    if(defined(&DISPLACE_NEW_PACKING_LOCALITIES)) {
    }
    eval 'sub M_INSERT () {ord(\'i\');}' unless defined(&M_INSERT);
    eval 'sub M_PASTE () {ord(\'p\');}' unless defined(&M_PASTE);
    eval 'sub M_DELETE () {ord(\'d\');}' unless defined(&M_DELETE);
    eval 'sub M_CUT () {ord(\'c\');}' unless defined(&M_CUT);
    eval 'sub M_INTERNAL () {ord(\'n\');}' unless defined(&M_INTERNAL);
    eval 'sub M_SKIP_BALANCING () {ord(\'s\');}' unless defined(&M_SKIP_BALANCING);
    eval 'sub M_CONVERT () {ord(\'v\');}' unless defined(&M_CONVERT);
    eval 'sub LEAF_FROM_S_TO_L () {0;}' unless defined(&LEAF_FROM_S_TO_L);
    eval 'sub LEAF_FROM_S_TO_R () {1;}' unless defined(&LEAF_FROM_S_TO_R);
    eval 'sub LEAF_FROM_R_TO_L () {2;}' unless defined(&LEAF_FROM_R_TO_L);
    eval 'sub LEAF_FROM_L_TO_R () {3;}' unless defined(&LEAF_FROM_L_TO_R);
    eval 'sub LEAF_FROM_S_TO_SNEW () {4;}' unless defined(&LEAF_FROM_S_TO_SNEW);
    eval 'sub FIRST_TO_LAST () {0;}' unless defined(&FIRST_TO_LAST);
    eval 'sub LAST_TO_FIRST () {1;}' unless defined(&LAST_TO_FIRST);
    eval 'sub op_bytes_number {
        local($ih,$bsize) = @_;
	    eval q( ($item_ops[&le_ih_k_type(ih)]->{bytes_number}) ($ih, $bsize));
    }' unless defined(&op_bytes_number);
    eval 'sub op_is_left_mergeable {
        local($key,$bsize) = @_;
	    eval q( ($item_ops[&le_key_k_type(le_key_version(key),key)]->{is_left_mergeable}) ($key, $bsize));
    }' unless defined(&op_is_left_mergeable);
    eval 'sub op_print_item {
        local($ih,$item) = @_;
	    eval q( ($item_ops[&le_ih_k_type(ih)]->{print_item}) ($ih, $item));
    }' unless defined(&op_print_item);
    eval 'sub op_check_item {
        local($ih,$item) = @_;
	    eval q( ($item_ops[&le_ih_k_type(ih)]->{check_item}) ($ih, $item));
    }' unless defined(&op_check_item);
    eval 'sub op_create_vi {
        local($vn,$vi,$is_affected,$insert_size) = @_;
	    eval q( ($item_ops[&le_ih_k_type((vi)->{vi_ih)]}->{create_vi}) ($vn,$vi,$is_affected,$insert_size));
    }' unless defined(&op_create_vi);
    eval 'sub op_check_left {
        local($vi,$free,$start_skip,$end_skip) = @_;
	    eval q( ($item_ops[&(vi)->{vi_index]}->{check_left}) ($vi, $free, $start_skip, $end_skip));
    }' unless defined(&op_check_left);
    eval 'sub op_check_right {
        local($vi,$free) = @_;
	    eval q( ($item_ops[&(vi)->{vi_index]}->{check_right}) ($vi, $free));
    }' unless defined(&op_check_right);
    eval 'sub op_part_size {
        local($vi,$from,$to) = @_;
	    eval q( ($item_ops[&(vi)->{vi_index]}->{part_size}) ($vi, $from, $to));
    }' unless defined(&op_part_size);
    eval 'sub op_unit_num {
        local($vi) = @_;
	    eval q( ($item_ops[&(vi)->{vi_index]}->{unit_num}) ($vi));
    }' unless defined(&op_unit_num);
    eval 'sub op_print_vi {
        local($vi) = @_;
	    eval q( ($item_ops[&(vi)->{vi_index]}->{print_vi}) ($vi));
    }' unless defined(&op_print_vi);
    eval 'sub COMP_KEYS () { &comp_keys;}' unless defined(&COMP_KEYS);
    eval 'sub COMP_SHORT_KEYS () { &comp_short_keys;}' unless defined(&COMP_SHORT_KEYS);
    eval 'sub I_UNFM_NUM {
        local($p_s_ih) = @_;
	    eval q((  &ih_item_len($p_s_ih) /  &UNFM_P_SIZE ));
    }' unless defined(&I_UNFM_NUM);
    eval 'sub I_POS_UNFM_SIZE {
        local($ih,$pos,$size) = @_;
	    eval q(((($pos) ==  &I_UNFM_NUM($ih) - 1) ? ($size) -  &ih_free_space($ih) : ($size)));
    }' unless defined(&I_POS_UNFM_SIZE);
    eval 'sub B_N_PITEM_HEAD {
        local($bh,$item_num) = @_;
	    eval q(( (($bh)-> &b_data +  &BLKH_SIZE) + ($item_num) ));
    }' unless defined(&B_N_PITEM_HEAD);
    eval 'sub B_N_PDELIM_KEY {
        local($bh,$item_num) = @_;
	    eval q(( (($bh)-> &b_data +  &BLKH_SIZE) + ($item_num) ));
    }' unless defined(&B_N_PDELIM_KEY);
    eval 'sub B_N_PKEY {
        local($bh,$item_num) = @_;
	    eval q(( ( &B_N_PITEM_HEAD($bh,$item_num)-> &ih_key) ));
    }' unless defined(&B_N_PKEY);
    eval 'sub B_N_PITEM {
        local($bh,$item_num) = @_;
	    eval q(( ($bh)-> &b_data +  &ih_location( &B_N_PITEM_HEAD(($bh),($item_num)))));
    }' unless defined(&B_N_PITEM);
    eval 'sub B_N_STAT_DATA {
        local($bh,$nr) = @_;
	    eval q(( (($bh)-> &b_data +  &ih_location( &B_N_PITEM_HEAD(($bh),($nr))) ) ));
    }' unless defined(&B_N_STAT_DATA);
    eval 'sub B_I_STAT_DATA {
        local($bh, $ih) = @_;
	    eval q(( (($bh)-> &b_data +  &ih_location($ih)) ));
    }' unless defined(&B_I_STAT_DATA);
    eval 'sub MAX_DIRECT_ITEM_LEN {
        local($size) = @_;
	    eval q((($size) -  &BLKH_SIZE - 2* &IH_SIZE -  &SD_SIZE -  &UNFM_P_SIZE));
    }' unless defined(&MAX_DIRECT_ITEM_LEN);
    eval 'sub B_I_POS_UNFM_POINTER {
        local($bh,$ih,$pos) = @_;
	    eval q( &le32_to_cpu(*((( &unp_t *) &B_I_PITEM($bh,$ih)) + ($pos))));
    }' unless defined(&B_I_POS_UNFM_POINTER);
    eval 'sub PUT_B_I_POS_UNFM_POINTER {
        local($bh,$ih,$pos, $val) = @_;
	    eval q( &do {*((( &unp_t *) &B_I_PITEM($bh,$ih)) + ($pos)) =  &cpu_to_le32($val); }  &while (0));
    }' unless defined(&PUT_B_I_POS_UNFM_POINTER);
    eval 'sub JOURNAL_TRANS_HALF () {1018;}' unless defined(&JOURNAL_TRANS_HALF);
    eval 'sub JOURNAL_BLOCK_COUNT () {8192;}' unless defined(&JOURNAL_BLOCK_COUNT);
    eval 'sub JOURNAL_TRANS_MAX_DEFAULT () {1024;}' unless defined(&JOURNAL_TRANS_MAX_DEFAULT);
    eval 'sub JOURNAL_TRANS_MIN_DEFAULT () {256;}' unless defined(&JOURNAL_TRANS_MIN_DEFAULT);
    eval 'sub JOURNAL_MAX_BATCH_DEFAULT () {900;}' unless defined(&JOURNAL_MAX_BATCH_DEFAULT);
    eval 'sub JOURNAL_MIN_RATIO () {2;}' unless defined(&JOURNAL_MIN_RATIO);
    eval 'sub JOURNAL_MAX_COMMIT_AGE () {30;}' unless defined(&JOURNAL_MAX_COMMIT_AGE);
    eval 'sub JOURNAL_MAX_TRANS_AGE () {30;}' unless defined(&JOURNAL_MAX_TRANS_AGE);
    eval 'sub JOURNAL_PER_BALANCE_CNT () {(3* ( &MAX_HEIGHT-2) + 9);}' unless defined(&JOURNAL_PER_BALANCE_CNT);
    eval 'sub REISERFS_MIN_BITMAP_NODES () {10;}' unless defined(&REISERFS_MIN_BITMAP_NODES);
    eval 'sub REISERFS_MAX_BITMAP_NODES () {100;}' unless defined(&REISERFS_MAX_BITMAP_NODES);
    eval 'sub JBH_HASH_SHIFT () {13;}' unless defined(&JBH_HASH_SHIFT);
    eval 'sub JBH_HASH_MASK () {8191;}' unless defined(&JBH_HASH_MASK);
    eval 'sub _jhashfn {
        local($dev,$block) = @_;
	    eval q((((($dev)<<( &JBH_HASH_SHIFT - 6)) ^ (($dev)<<( &JBH_HASH_SHIFT - 9))) ^ ((($block)<<( &JBH_HASH_SHIFT - 6)) ^ (($block) >> 13) ^ (($block) << ( &JBH_HASH_SHIFT - 12)))));
    }' unless defined(&_jhashfn);
    eval 'sub journal_hash {
        local($t,$dev,$block) = @_;
	    eval q((($t)[ &_jhashfn(($dev),($block)) &  &JBH_HASH_MASK]));
    }' unless defined(&journal_hash);
    eval 'sub JOURNAL_BUFFER {
        local($j,$n) = @_;
	    eval q((($j)-> $j_ap_blocks[(($j)-> &j_start + ($n)) %  &JOURNAL_BLOCK_COUNT]));
    }' unless defined(&JOURNAL_BUFFER);
    eval 'sub mark_buffer_notjournal_dirty {
        local($bh) = @_;
	    eval q({  &if ($bh)  &clear_bit( &BH_JDirty_wait,  ($bh->{b_state})) ; 0; });
    }' unless defined(&mark_buffer_notjournal_dirty);
    eval 'sub mark_buffer_notjournal_new {
        local($bh) = @_;
	    eval q({  &if ($bh) {  &clear_bit( &BH_JNew,  ($bh->{b_state})) ; } 0; });
    }' unless defined(&mark_buffer_notjournal_new);
    eval 'sub search_item {
        local($s,$key,$path) = @_;
	    eval q( &search_by_key ($s, $key, $path,  &DISK_LEAF_NODE_LEVEL));
    }' unless defined(&search_item);
    eval 'sub block_size {
        local($inode) = @_;
	    eval q((($inode)-> ($i_sb->{s_blocksize})));
    }' unless defined(&block_size);
    eval 'sub file_size {
        local($inode) = @_;
	    eval q((($inode)-> &i_size));
    }' unless defined(&file_size);
    eval 'sub tail_size {
        local($inode) = @_;
	    eval q(( &file_size ($inode) & ( &block_size ($inode) - 1)));
    }' unless defined(&tail_size);
    eval 'sub tail_has_to_be_packed {
        local($inode) = @_;
	    eval q(( &have_large_tails (($inode)-> &i_sb)?! &STORE_TAIL_IN_UNFM_S1( &file_size ($inode),  &tail_size($inode),  &block_size ($inode)): &have_small_tails (($inode)-> &i_sb)?! &STORE_TAIL_IN_UNFM_S2( &file_size ($inode),  &tail_size($inode),  &block_size ($inode)):0));
    }' unless defined(&tail_has_to_be_packed);
    if(defined( (defined(&CONFIG_PROC_FS) ? &CONFIG_PROC_FS : 0) )  && defined( (defined(&CONFIG_REISERFS_PROC_INFO) ? &CONFIG_REISERFS_PROC_INFO : 0) )) {
	eval 'sub REISERFS_PROC_INFO () {1;}' unless defined(&REISERFS_PROC_INFO);
    } else {
	undef(&REISERFS_PROC_INFO) if defined(&REISERFS_PROC_INFO);
    }
    if(defined( (defined(&REISERFS_PROC_INFO) ? &REISERFS_PROC_INFO : 0) )) {
	eval 'sub PROC_EXP {
	    local( $e ) = @_;
    	    eval q( &e);
	}' unless defined(&PROC_EXP);
	eval 'sub MAX {
	    local( $a, $b ) = @_;
    	    eval q(( ( (  &a ) > (  &b ) ) ? (  &a ) : (  &b ) ));
	}' unless defined(&MAX);
	eval 'sub __PINFO {
	    local( $sb ) = @_;
    	    eval q(( $sb ) ->  ($u->{reiserfs_sb}->{s_proc_info_data}));
	}' unless defined(&__PINFO);
	eval 'sub PROC_INFO_MAX {
	    local( $sb, $field, $value ) = @_;
    	    eval q( &__PINFO( $sb ).$field =  &MAX( ( $sb ) ->  ($u->{reiserfs_sb}->{s_proc_info_data}->{field}), $value ));
	}' unless defined(&PROC_INFO_MAX);
	eval 'sub PROC_INFO_INC {
	    local( $sb, $field ) = @_;
    	    eval q(( ++ (  &__PINFO( $sb ).$field ) ));
	}' unless defined(&PROC_INFO_INC);
	eval 'sub PROC_INFO_ADD {
	    local( $sb, $field, $val ) = @_;
    	    eval q((  &__PINFO( $sb ).$field += ( $val ) ));
	}' unless defined(&PROC_INFO_ADD);
	eval 'sub PROC_INFO_BH_STAT {
	    local( $sb, $bh, $level ) = @_;
    	    eval q( &PROC_INFO_INC( $sb,  $sbk_read_at[ ( $level ) ] );  &PROC_INFO_ADD( $sb,  $free_at[ ( $level ) ],  &B_FREE_SPACE( $bh ) );  &PROC_INFO_ADD( $sb,  $items_at[ ( $level ) ],  &B_NR_ITEMS( $bh ) ));
	}' unless defined(&PROC_INFO_BH_STAT);
    } else {
	eval 'sub PROC_EXP {
	    local( $e ) = @_;
    	    eval q();
	}' unless defined(&PROC_EXP);
	eval 'sub VOID_V () {( (  &void ) 0);}' unless defined(&VOID_V);
	eval 'sub PROC_INFO_MAX {
	    local( $sb, $field, $value ) = @_;
    	    eval q( &VOID_V);
	}' unless defined(&PROC_INFO_MAX);
	eval 'sub PROC_INFO_INC {
	    local( $sb, $field ) = @_;
    	    eval q( &VOID_V);
	}' unless defined(&PROC_INFO_INC);
	eval 'sub PROC_INFO_ADD {
	    local( $sb, $field, $val ) = @_;
    	    eval q( &VOID_V);
	}' unless defined(&PROC_INFO_ADD);
	eval 'sub PROC_INFO_BH_STAT {
	    local( $p_s_sb, $p_s_bh, $n_node_level ) = @_;
    	    eval q( &VOID_V);
	}' unless defined(&PROC_INFO_BH_STAT);
    }
    if(defined(&CONFIG_REISERFS_CHECK)) {
    } else {
	eval 'sub reiserfs_kmalloc {
	    local($x, $y, $z) = @_;
    	    eval q( &kmalloc($x, $y));
	}' unless defined(&reiserfs_kmalloc);
	eval 'sub reiserfs_kfree {
	    local($x, $y, $z) = @_;
    	    eval q( &kfree($x));
	}' unless defined(&reiserfs_kfree);
    }
    eval 'sub PRINT_LEAF_ITEMS () {1;}' unless defined(&PRINT_LEAF_ITEMS);
    eval 'sub PRINT_DIRECTORY_ITEMS () {2;}' unless defined(&PRINT_DIRECTORY_ITEMS);
    eval 'sub PRINT_DIRECT_ITEMS () {4;}' unless defined(&PRINT_DIRECT_ITEMS);
    eval 'sub do_balance_mark_internal_dirty () { &do_balance_mark_leaf_dirty;}' unless defined(&do_balance_mark_internal_dirty);
    eval 'sub do_balance_mark_sb_dirty () { &do_balance_mark_leaf_dirty;}' unless defined(&do_balance_mark_sb_dirty);
    eval 'sub reiserfs_new_form_blocknrs {
        local($tb,$new_blocknrs,$amount_needed) = @_;
	    eval q({  &reiserfs_blocknr_hint_t  &hint = {  &th: ($tb->{transaction_handle}),  &path:  ($tb->{tb_path}),  &inode:  &NULL,  &key:  ($tb->{key}),  &block: 0,  &formatted_node:1};  &reiserfs_allocate_blocknrs( &hint, $new_blocknrs, $amount_needed, 0); });
    }' unless defined(&reiserfs_new_form_blocknrs);
    eval 'sub reiserfs_new_unf_blocknrs {
        local($th,$inode,$new_blocknrs,$path,$block) = @_;
	    eval q({  &reiserfs_blocknr_hint_t  &hint = { $th: $th, $path: $path, $inode: $inode, $block: $block,  &formatted_node: 0,  &preallocate: 0};  &reiserfs_allocate_blocknrs( &hint, $new_blocknrs, 1, 0); });
    }' unless defined(&reiserfs_new_unf_blocknrs);
    if(defined(&REISERFS_PREALLOCATE)) {
	eval 'sub reiserfs_new_unf_blocknrs2 {
	    local($th,$inode,$new_blocknrs,$path,$block) = @_;
    	    eval q({  &reiserfs_blocknr_hint_t  &hint = { $th: $th, $path: $path, $inode: $inode, $block: $block,  &formatted_node: 0,  &preallocate: 1};  &reiserfs_allocate_blocknrs( &hint, $new_blocknrs, 1, 0); });
	}' unless defined(&reiserfs_new_unf_blocknrs2);
    }
    eval 'sub reiserfs_test_and_set_le_bit () { &ext2_set_bit;}' unless defined(&reiserfs_test_and_set_le_bit);
    eval 'sub reiserfs_test_and_clear_le_bit () { &ext2_clear_bit;}' unless defined(&reiserfs_test_and_clear_le_bit);
    eval 'sub reiserfs_test_le_bit () { &ext2_test_bit;}' unless defined(&reiserfs_test_le_bit);
    eval 'sub reiserfs_find_next_zero_le_bit () { &ext2_find_next_zero_bit;}' unless defined(&reiserfs_find_next_zero_le_bit);
    eval 'sub SPARE_SPACE () {500;}' unless defined(&SPARE_SPACE);
    eval 'sub REISERFS_IOC_UNPACK () { &_IOW(0xcd,1,\'long\');}' unless defined(&REISERFS_IOC_UNPACK);
    eval 'sub REISERFS_IOC_GETFLAGS () { &EXT2_IOC_GETFLAGS;}' unless defined(&REISERFS_IOC_GETFLAGS);
    eval 'sub REISERFS_IOC_SETFLAGS () { &EXT2_IOC_SETFLAGS;}' unless defined(&REISERFS_IOC_SETFLAGS);
    eval 'sub REISERFS_IOC_GETVERSION () { &EXT2_IOC_GETVERSION;}' unless defined(&REISERFS_IOC_GETVERSION);
    eval 'sub REISERFS_IOC_SETVERSION () { &EXT2_IOC_SETVERSION;}' unless defined(&REISERFS_IOC_SETVERSION);
}
1;
