require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_QUOTA_)) {
    eval 'sub _LINUX_QUOTA_ () {1;}' unless defined(&_LINUX_QUOTA_);
    require 'linux/errno.ph';
    require 'linux/types.ph';
    eval 'sub __DQUOT_VERSION__ () {"dquot_6.5.1";}' unless defined(&__DQUOT_VERSION__);
    eval 'sub __DQUOT_NUM_VERSION__ () {6*10000+5*100+1;}' unless defined(&__DQUOT_NUM_VERSION__);
    eval 'sub QUOTABLOCK_BITS () {10;}' unless defined(&QUOTABLOCK_BITS);
    eval 'sub QUOTABLOCK_SIZE () {(1<<  &QUOTABLOCK_BITS);}' unless defined(&QUOTABLOCK_SIZE);
    eval 'sub qb2kb {
        local($x) = @_;
	    eval q((($x) << ( &QUOTABLOCK_BITS-10)));
    }' unless defined(&qb2kb);
    eval 'sub kb2qb {
        local($x) = @_;
	    eval q((($x) >> ( &QUOTABLOCK_BITS-10)));
    }' unless defined(&kb2qb);
    eval 'sub toqb {
        local($x) = @_;
	    eval q(((($x) +  &QUOTABLOCK_SIZE - 1) >>  &QUOTABLOCK_BITS));
    }' unless defined(&toqb);
    eval 'sub MAXQUOTAS () {2;}' unless defined(&MAXQUOTAS);
    eval 'sub USRQUOTA () {0;}' unless defined(&USRQUOTA);
    eval 'sub GRPQUOTA () {1;}' unless defined(&GRPQUOTA);
    eval 'sub INITQFNAMES () {{ "user", "group", "undefined", };;}' unless defined(&INITQFNAMES);
    eval 'sub SUBCMDMASK () {0xff;}' unless defined(&SUBCMDMASK);
    eval 'sub SUBCMDSHIFT () {8;}' unless defined(&SUBCMDSHIFT);
    eval 'sub QCMD {
        local($cmd, $type) = @_;
	    eval q(((($cmd) <<  &SUBCMDSHIFT) | (($type) &  &SUBCMDMASK)));
    }' unless defined(&QCMD);
    eval 'sub Q_SYNC () {0x800001;}' unless defined(&Q_SYNC);
    eval 'sub Q_QUOTAON () {0x800002;}' unless defined(&Q_QUOTAON);
    eval 'sub Q_QUOTAOFF () {0x800003;}' unless defined(&Q_QUOTAOFF);
    eval 'sub Q_GETFMT () {0x800004;}' unless defined(&Q_GETFMT);
    eval 'sub Q_GETINFO () {0x800005;}' unless defined(&Q_GETINFO);
    eval 'sub Q_SETINFO () {0x800006;}' unless defined(&Q_SETINFO);
    eval 'sub Q_GETQUOTA () {0x800007;}' unless defined(&Q_GETQUOTA);
    eval 'sub Q_SETQUOTA () {0x800008;}' unless defined(&Q_SETQUOTA);
    eval 'sub QIF_BLIMITS () {1;}' unless defined(&QIF_BLIMITS);
    eval 'sub QIF_SPACE () {2;}' unless defined(&QIF_SPACE);
    eval 'sub QIF_ILIMITS () {4;}' unless defined(&QIF_ILIMITS);
    eval 'sub QIF_INODES () {8;}' unless defined(&QIF_INODES);
    eval 'sub QIF_BTIME () {16;}' unless defined(&QIF_BTIME);
    eval 'sub QIF_ITIME () {32;}' unless defined(&QIF_ITIME);
    eval 'sub QIF_LIMITS () {( &QIF_BLIMITS |  &QIF_ILIMITS);}' unless defined(&QIF_LIMITS);
    eval 'sub QIF_USAGE () {( &QIF_SPACE |  &QIF_INODES);}' unless defined(&QIF_USAGE);
    eval 'sub QIF_TIMES () {( &QIF_BTIME |  &QIF_ITIME);}' unless defined(&QIF_TIMES);
    eval 'sub QIF_ALL () {( &QIF_LIMITS |  &QIF_USAGE |  &QIF_TIMES);}' unless defined(&QIF_ALL);
    eval 'sub IIF_BGRACE () {1;}' unless defined(&IIF_BGRACE);
    eval 'sub IIF_IGRACE () {2;}' unless defined(&IIF_IGRACE);
    eval 'sub IIF_FLAGS () {4;}' unless defined(&IIF_FLAGS);
    eval 'sub IIF_ALL () {( &IIF_BGRACE |  &IIF_IGRACE |  &IIF_FLAGS);}' unless defined(&IIF_ALL);
    if(defined(&__KERNEL__)) {
	require 'linux/dqblk_xfs.ph';
	require 'linux/dqblk_v1.ph';
	require 'linux/dqblk_v2.ph';
	eval 'sub DQF_MASK () {0xffff;}' unless defined(&DQF_MASK);
	eval 'sub DQF_INFO_DIRTY () {0x10000;}' unless defined(&DQF_INFO_DIRTY);
	eval 'sub DQF_ANY_DQUOT_DIRTY () {0x20000;}' unless defined(&DQF_ANY_DQUOT_DIRTY);
	eval 'sub mark_info_dirty {
	    local($info) = @_;
    	    eval q({  ($info->{dqi_flags}) |=  &DQF_INFO_DIRTY; });
	}' unless defined(&mark_info_dirty);
	eval 'sub info_dirty {
	    local($info) = @_;
    	    eval q((($info)-> &dqi_flags &  &DQF_INFO_DIRTY));
	}' unless defined(&info_dirty);
	eval 'sub info_any_dirty {
	    local($info) = @_;
    	    eval q((($info)-> &dqi_flags &  &DQF_INFO_DIRTY || ($info)-> &dqi_flags &  &DQF_ANY_DQUOT_DIRTY));
	}' unless defined(&info_any_dirty);
	eval 'sub sb_dqopt {
	    local($sb) = @_;
    	    eval q((($sb)-> &s_dquot));
	}' unless defined(&sb_dqopt);
	eval 'sub NR_DQHASH () {43;}' unless defined(&NR_DQHASH);
	eval 'sub DQ_LOCKED () {0x1;}' unless defined(&DQ_LOCKED);
	eval 'sub DQ_MOD () {0x2;}' unless defined(&DQ_MOD);
	eval 'sub DQ_BLKS () {0x10;}' unless defined(&DQ_BLKS);
	eval 'sub DQ_INODES () {0x20;}' unless defined(&DQ_INODES);
	eval 'sub DQ_FAKE () {0x40;}' unless defined(&DQ_FAKE);
	eval 'sub DQ_INVAL () {0x80;}' unless defined(&DQ_INVAL);
	eval 'sub NODQUOT () { &NULL;}' unless defined(&NODQUOT);
	eval 'sub QUOTA_OK () {0;}' unless defined(&QUOTA_OK);
	eval 'sub NO_QUOTA () {1;}' unless defined(&NO_QUOTA);
	eval 'sub DQUOT_USR_ENABLED () {0x1;}' unless defined(&DQUOT_USR_ENABLED);
	eval 'sub DQUOT_GRP_ENABLED () {0x2;}' unless defined(&DQUOT_GRP_ENABLED);
	eval 'sub mark_dquot_dirty {
	    local($dquot) = @_;
    	    eval q( &do {  ($dquot->{dq_flags}) |=  &DQ_MOD;  &sb_dqopt( ($dquot->{dq_sb}))-> ($info[$dquot->{dq_type]}->{dqi_flags}) |=  &DQF_ANY_DQUOT_DIRTY;}  &while (0));
	}' unless defined(&mark_dquot_dirty);
	eval 'sub dquot_dirty {
	    local($dquot) = @_;
    	    eval q((($dquot)-> &dq_flags &  &DQ_MOD));
	}' unless defined(&dquot_dirty);
	eval 'sub is_enabled {
	    local($dqopt,$type) = @_;
    	    eval q({  &switch ($type) {  &case  &USRQUOTA:  ($dqopt->{flags}) &  &DQUOT_USR_ENABLED;  &case  &GRPQUOTA:  ($dqopt->{flags}) &  &DQUOT_GRP_ENABLED; } 0; });
	}' unless defined(&is_enabled);
	eval 'sub sb_any_quota_enabled {
	    local($sb) = @_;
    	    eval q(( &is_enabled( &sb_dqopt($sb),  &USRQUOTA) |  &is_enabled( &sb_dqopt($sb),  &GRPQUOTA)));
	}' unless defined(&sb_any_quota_enabled);
	eval 'sub sb_has_quota_enabled {
	    local($sb, $type) = @_;
    	    eval q(( &is_enabled( &sb_dqopt($sb), $type)));
	}' unless defined(&sb_has_quota_enabled);
    } else {
	require 'sys/cdefs.ph';
    }
}
1;
