require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&LINUX_PCI_H)) {
    eval 'sub LINUX_PCI_H () {1;}' unless defined(&LINUX_PCI_H);
    eval 'sub PCI_VENDOR_ID () {0x;}' unless defined(&PCI_VENDOR_ID);
    eval 'sub PCI_DEVICE_ID () {0x2;}' unless defined(&PCI_DEVICE_ID);
    eval 'sub PCI_COMMAND () {0x4;}' unless defined(&PCI_COMMAND);
    eval 'sub PCI_COMMAND_IO () {0x1;}' unless defined(&PCI_COMMAND_IO);
    eval 'sub PCI_COMMAND_MEMORY () {0x2;}' unless defined(&PCI_COMMAND_MEMORY);
    eval 'sub PCI_COMMAND_MASTER () {0x4;}' unless defined(&PCI_COMMAND_MASTER);
    eval 'sub PCI_COMMAND_SPECIAL () {0x8;}' unless defined(&PCI_COMMAND_SPECIAL);
    eval 'sub PCI_COMMAND_INVALIDATE () {0x10;}' unless defined(&PCI_COMMAND_INVALIDATE);
    eval 'sub PCI_COMMAND_VGA_PALETTE () {0x20;}' unless defined(&PCI_COMMAND_VGA_PALETTE);
    eval 'sub PCI_COMMAND_PARITY () {0x40;}' unless defined(&PCI_COMMAND_PARITY);
    eval 'sub PCI_COMMAND_WAIT () {0x80;}' unless defined(&PCI_COMMAND_WAIT);
    eval 'sub PCI_COMMAND_SERR () {0x100;}' unless defined(&PCI_COMMAND_SERR);
    eval 'sub PCI_COMMAND_FAST_BACK () {0x200;}' unless defined(&PCI_COMMAND_FAST_BACK);
    eval 'sub PCI_COMMAND_INTX_DISABLE () {0x400;}' unless defined(&PCI_COMMAND_INTX_DISABLE);
    eval 'sub PCI_STATUS () {0x6;}' unless defined(&PCI_STATUS);
    eval 'sub PCI_STATUS_CAP_LIST () {0x10;}' unless defined(&PCI_STATUS_CAP_LIST);
    eval 'sub PCI_STATUS_66MHZ () {0x20;}' unless defined(&PCI_STATUS_66MHZ);
    eval 'sub PCI_STATUS_UDF () {0x40;}' unless defined(&PCI_STATUS_UDF);
    eval 'sub PCI_STATUS_FAST_BACK () {0x80;}' unless defined(&PCI_STATUS_FAST_BACK);
    eval 'sub PCI_STATUS_PARITY () {0x100;}' unless defined(&PCI_STATUS_PARITY);
    eval 'sub PCI_STATUS_DEVSEL_MASK () {0x600;}' unless defined(&PCI_STATUS_DEVSEL_MASK);
    eval 'sub PCI_STATUS_DEVSEL_FAST () {0x;}' unless defined(&PCI_STATUS_DEVSEL_FAST);
    eval 'sub PCI_STATUS_DEVSEL_MEDIUM () {0x200;}' unless defined(&PCI_STATUS_DEVSEL_MEDIUM);
    eval 'sub PCI_STATUS_DEVSEL_SLOW () {0x400;}' unless defined(&PCI_STATUS_DEVSEL_SLOW);
    eval 'sub PCI_STATUS_SIG_TARGET_ABORT () {0x800;}' unless defined(&PCI_STATUS_SIG_TARGET_ABORT);
    eval 'sub PCI_STATUS_REC_TARGET_ABORT () {0x1000;}' unless defined(&PCI_STATUS_REC_TARGET_ABORT);
    eval 'sub PCI_STATUS_REC_MASTER_ABORT () {0x2000;}' unless defined(&PCI_STATUS_REC_MASTER_ABORT);
    eval 'sub PCI_STATUS_SIG_SYSTEM_ERROR () {0x4000;}' unless defined(&PCI_STATUS_SIG_SYSTEM_ERROR);
    eval 'sub PCI_STATUS_DETECTED_PARITY () {0x8000;}' unless defined(&PCI_STATUS_DETECTED_PARITY);
    eval 'sub PCI_CLASS_REVISION () {0x8;}' unless defined(&PCI_CLASS_REVISION);
    eval 'sub PCI_REVISION_ID () {0x8;}' unless defined(&PCI_REVISION_ID);
    eval 'sub PCI_CLASS_PROG () {0x9;}' unless defined(&PCI_CLASS_PROG);
    eval 'sub PCI_CLASS_DEVICE () {0xa;}' unless defined(&PCI_CLASS_DEVICE);
    eval 'sub PCI_CACHE_LINE_SIZE () {0xc;}' unless defined(&PCI_CACHE_LINE_SIZE);
    eval 'sub PCI_LATENCY_TIMER () {0xd;}' unless defined(&PCI_LATENCY_TIMER);
    eval 'sub PCI_HEADER_TYPE () {0xe;}' unless defined(&PCI_HEADER_TYPE);
    eval 'sub PCI_HEADER_TYPE_NORMAL () {0;}' unless defined(&PCI_HEADER_TYPE_NORMAL);
    eval 'sub PCI_HEADER_TYPE_BRIDGE () {1;}' unless defined(&PCI_HEADER_TYPE_BRIDGE);
    eval 'sub PCI_HEADER_TYPE_CARDBUS () {2;}' unless defined(&PCI_HEADER_TYPE_CARDBUS);
    eval 'sub PCI_BIST () {0xf;}' unless defined(&PCI_BIST);
    eval 'sub PCI_BIST_CODE_MASK () {0xf;}' unless defined(&PCI_BIST_CODE_MASK);
    eval 'sub PCI_BIST_START () {0x40;}' unless defined(&PCI_BIST_START);
    eval 'sub PCI_BIST_CAPABLE () {0x80;}' unless defined(&PCI_BIST_CAPABLE);
    eval 'sub PCI_BASE_ADDRESS_0 () {0x10;}' unless defined(&PCI_BASE_ADDRESS_0);
    eval 'sub PCI_BASE_ADDRESS_1 () {0x14;}' unless defined(&PCI_BASE_ADDRESS_1);
    eval 'sub PCI_BASE_ADDRESS_2 () {0x18;}' unless defined(&PCI_BASE_ADDRESS_2);
    eval 'sub PCI_BASE_ADDRESS_3 () {0x1c;}' unless defined(&PCI_BASE_ADDRESS_3);
    eval 'sub PCI_BASE_ADDRESS_4 () {0x20;}' unless defined(&PCI_BASE_ADDRESS_4);
    eval 'sub PCI_BASE_ADDRESS_5 () {0x24;}' unless defined(&PCI_BASE_ADDRESS_5);
    eval 'sub PCI_BASE_ADDRESS_SPACE () {0x1;}' unless defined(&PCI_BASE_ADDRESS_SPACE);
    eval 'sub PCI_BASE_ADDRESS_SPACE_IO () {0x1;}' unless defined(&PCI_BASE_ADDRESS_SPACE_IO);
    eval 'sub PCI_BASE_ADDRESS_SPACE_MEMORY () {0x;}' unless defined(&PCI_BASE_ADDRESS_SPACE_MEMORY);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_MASK () {0x6;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_MASK);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_32 () {0x;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_32);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_1M () {0x2;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_1M);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_64 () {0x4;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_64);
    eval 'sub PCI_BASE_ADDRESS_MEM_PREFETCH () {0x8;}' unless defined(&PCI_BASE_ADDRESS_MEM_PREFETCH);
    eval 'sub PCI_BASE_ADDRESS_MEM_MASK () {(~0xf);}' unless defined(&PCI_BASE_ADDRESS_MEM_MASK);
    eval 'sub PCI_BASE_ADDRESS_IO_MASK () {(~0x3);}' unless defined(&PCI_BASE_ADDRESS_IO_MASK);
    eval 'sub PCI_CARDBUS_CIS () {0x28;}' unless defined(&PCI_CARDBUS_CIS);
    eval 'sub PCI_SUBSYSTEM_VENDOR_ID () {0x2c;}' unless defined(&PCI_SUBSYSTEM_VENDOR_ID);
    eval 'sub PCI_SUBSYSTEM_ID () {0x2e;}' unless defined(&PCI_SUBSYSTEM_ID);
    eval 'sub PCI_ROM_ADDRESS () {0x30;}' unless defined(&PCI_ROM_ADDRESS);
    eval 'sub PCI_ROM_ADDRESS_ENABLE () {0x1;}' unless defined(&PCI_ROM_ADDRESS_ENABLE);
    eval 'sub PCI_ROM_ADDRESS_MASK () {(~0x7ff);}' unless defined(&PCI_ROM_ADDRESS_MASK);
    eval 'sub PCI_CAPABILITY_LIST () {0x34;}' unless defined(&PCI_CAPABILITY_LIST);
    eval 'sub PCI_INTERRUPT_LINE () {0x3c;}' unless defined(&PCI_INTERRUPT_LINE);
    eval 'sub PCI_INTERRUPT_PIN () {0x3d;}' unless defined(&PCI_INTERRUPT_PIN);
    eval 'sub PCI_MIN_GNT () {0x3e;}' unless defined(&PCI_MIN_GNT);
    eval 'sub PCI_MAX_LAT () {0x3f;}' unless defined(&PCI_MAX_LAT);
    eval 'sub PCI_PRIMARY_BUS () {0x18;}' unless defined(&PCI_PRIMARY_BUS);
    eval 'sub PCI_SECONDARY_BUS () {0x19;}' unless defined(&PCI_SECONDARY_BUS);
    eval 'sub PCI_SUBORDINATE_BUS () {0x1a;}' unless defined(&PCI_SUBORDINATE_BUS);
    eval 'sub PCI_SEC_LATENCY_TIMER () {0x1b;}' unless defined(&PCI_SEC_LATENCY_TIMER);
    eval 'sub PCI_IO_BASE () {0x1c;}' unless defined(&PCI_IO_BASE);
    eval 'sub PCI_IO_LIMIT () {0x1d;}' unless defined(&PCI_IO_LIMIT);
    eval 'sub PCI_IO_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_IO_RANGE_TYPE_MASK);
    eval 'sub PCI_IO_RANGE_TYPE_16 () {0x;}' unless defined(&PCI_IO_RANGE_TYPE_16);
    eval 'sub PCI_IO_RANGE_TYPE_32 () {0x1;}' unless defined(&PCI_IO_RANGE_TYPE_32);
    eval 'sub PCI_IO_RANGE_MASK () {(~0xf);}' unless defined(&PCI_IO_RANGE_MASK);
    eval 'sub PCI_SEC_STATUS () {0x1e;}' unless defined(&PCI_SEC_STATUS);
    eval 'sub PCI_MEMORY_BASE () {0x20;}' unless defined(&PCI_MEMORY_BASE);
    eval 'sub PCI_MEMORY_LIMIT () {0x22;}' unless defined(&PCI_MEMORY_LIMIT);
    eval 'sub PCI_MEMORY_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_MEMORY_RANGE_TYPE_MASK);
    eval 'sub PCI_MEMORY_RANGE_MASK () {(~0xf);}' unless defined(&PCI_MEMORY_RANGE_MASK);
    eval 'sub PCI_PREF_MEMORY_BASE () {0x24;}' unless defined(&PCI_PREF_MEMORY_BASE);
    eval 'sub PCI_PREF_MEMORY_LIMIT () {0x26;}' unless defined(&PCI_PREF_MEMORY_LIMIT);
    eval 'sub PCI_PREF_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_PREF_RANGE_TYPE_MASK);
    eval 'sub PCI_PREF_RANGE_TYPE_32 () {0x;}' unless defined(&PCI_PREF_RANGE_TYPE_32);
    eval 'sub PCI_PREF_RANGE_TYPE_64 () {0x1;}' unless defined(&PCI_PREF_RANGE_TYPE_64);
    eval 'sub PCI_PREF_RANGE_MASK () {(~0xf);}' unless defined(&PCI_PREF_RANGE_MASK);
    eval 'sub PCI_PREF_BASE_UPPER32 () {0x28;}' unless defined(&PCI_PREF_BASE_UPPER32);
    eval 'sub PCI_PREF_LIMIT_UPPER32 () {0x2c;}' unless defined(&PCI_PREF_LIMIT_UPPER32);
    eval 'sub PCI_IO_BASE_UPPER16 () {0x30;}' unless defined(&PCI_IO_BASE_UPPER16);
    eval 'sub PCI_IO_LIMIT_UPPER16 () {0x32;}' unless defined(&PCI_IO_LIMIT_UPPER16);
    eval 'sub PCI_ROM_ADDRESS1 () {0x38;}' unless defined(&PCI_ROM_ADDRESS1);
    eval 'sub PCI_BRIDGE_CONTROL () {0x3e;}' unless defined(&PCI_BRIDGE_CONTROL);
    eval 'sub PCI_BRIDGE_CTL_PARITY () {0x1;}' unless defined(&PCI_BRIDGE_CTL_PARITY);
    eval 'sub PCI_BRIDGE_CTL_SERR () {0x2;}' unless defined(&PCI_BRIDGE_CTL_SERR);
    eval 'sub PCI_BRIDGE_CTL_NO_ISA () {0x4;}' unless defined(&PCI_BRIDGE_CTL_NO_ISA);
    eval 'sub PCI_BRIDGE_CTL_VGA () {0x8;}' unless defined(&PCI_BRIDGE_CTL_VGA);
    eval 'sub PCI_BRIDGE_CTL_MASTER_ABORT () {0x20;}' unless defined(&PCI_BRIDGE_CTL_MASTER_ABORT);
    eval 'sub PCI_BRIDGE_CTL_BUS_RESET () {0x40;}' unless defined(&PCI_BRIDGE_CTL_BUS_RESET);
    eval 'sub PCI_BRIDGE_CTL_FAST_BACK () {0x80;}' unless defined(&PCI_BRIDGE_CTL_FAST_BACK);
    eval 'sub PCI_CB_CAPABILITY_LIST () {0x14;}' unless defined(&PCI_CB_CAPABILITY_LIST);
    eval 'sub PCI_CB_SEC_STATUS () {0x16;}' unless defined(&PCI_CB_SEC_STATUS);
    eval 'sub PCI_CB_PRIMARY_BUS () {0x18;}' unless defined(&PCI_CB_PRIMARY_BUS);
    eval 'sub PCI_CB_CARD_BUS () {0x19;}' unless defined(&PCI_CB_CARD_BUS);
    eval 'sub PCI_CB_SUBORDINATE_BUS () {0x1a;}' unless defined(&PCI_CB_SUBORDINATE_BUS);
    eval 'sub PCI_CB_LATENCY_TIMER () {0x1b;}' unless defined(&PCI_CB_LATENCY_TIMER);
    eval 'sub PCI_CB_MEMORY_BASE_0 () {0x1c;}' unless defined(&PCI_CB_MEMORY_BASE_0);
    eval 'sub PCI_CB_MEMORY_LIMIT_0 () {0x20;}' unless defined(&PCI_CB_MEMORY_LIMIT_0);
    eval 'sub PCI_CB_MEMORY_BASE_1 () {0x24;}' unless defined(&PCI_CB_MEMORY_BASE_1);
    eval 'sub PCI_CB_MEMORY_LIMIT_1 () {0x28;}' unless defined(&PCI_CB_MEMORY_LIMIT_1);
    eval 'sub PCI_CB_IO_BASE_0 () {0x2c;}' unless defined(&PCI_CB_IO_BASE_0);
    eval 'sub PCI_CB_IO_BASE_0_HI () {0x2e;}' unless defined(&PCI_CB_IO_BASE_0_HI);
    eval 'sub PCI_CB_IO_LIMIT_0 () {0x30;}' unless defined(&PCI_CB_IO_LIMIT_0);
    eval 'sub PCI_CB_IO_LIMIT_0_HI () {0x32;}' unless defined(&PCI_CB_IO_LIMIT_0_HI);
    eval 'sub PCI_CB_IO_BASE_1 () {0x34;}' unless defined(&PCI_CB_IO_BASE_1);
    eval 'sub PCI_CB_IO_BASE_1_HI () {0x36;}' unless defined(&PCI_CB_IO_BASE_1_HI);
    eval 'sub PCI_CB_IO_LIMIT_1 () {0x38;}' unless defined(&PCI_CB_IO_LIMIT_1);
    eval 'sub PCI_CB_IO_LIMIT_1_HI () {0x3a;}' unless defined(&PCI_CB_IO_LIMIT_1_HI);
    eval 'sub PCI_CB_IO_RANGE_MASK () {(~0x3);}' unless defined(&PCI_CB_IO_RANGE_MASK);
    eval 'sub PCI_CB_BRIDGE_CONTROL () {0x3e;}' unless defined(&PCI_CB_BRIDGE_CONTROL);
    eval 'sub PCI_CB_BRIDGE_CTL_PARITY () {0x1;}' unless defined(&PCI_CB_BRIDGE_CTL_PARITY);
    eval 'sub PCI_CB_BRIDGE_CTL_SERR () {0x2;}' unless defined(&PCI_CB_BRIDGE_CTL_SERR);
    eval 'sub PCI_CB_BRIDGE_CTL_ISA () {0x4;}' unless defined(&PCI_CB_BRIDGE_CTL_ISA);
    eval 'sub PCI_CB_BRIDGE_CTL_VGA () {0x8;}' unless defined(&PCI_CB_BRIDGE_CTL_VGA);
    eval 'sub PCI_CB_BRIDGE_CTL_MASTER_ABORT () {0x20;}' unless defined(&PCI_CB_BRIDGE_CTL_MASTER_ABORT);
    eval 'sub PCI_CB_BRIDGE_CTL_CB_RESET () {0x40;}' unless defined(&PCI_CB_BRIDGE_CTL_CB_RESET);
    eval 'sub PCI_CB_BRIDGE_CTL_16BIT_INT () {0x80;}' unless defined(&PCI_CB_BRIDGE_CTL_16BIT_INT);
    eval 'sub PCI_CB_BRIDGE_CTL_PREFETCH_MEM0 () {0x100;}' unless defined(&PCI_CB_BRIDGE_CTL_PREFETCH_MEM0);
    eval 'sub PCI_CB_BRIDGE_CTL_PREFETCH_MEM1 () {0x200;}' unless defined(&PCI_CB_BRIDGE_CTL_PREFETCH_MEM1);
    eval 'sub PCI_CB_BRIDGE_CTL_POST_WRITES () {0x400;}' unless defined(&PCI_CB_BRIDGE_CTL_POST_WRITES);
    eval 'sub PCI_CB_SUBSYSTEM_VENDOR_ID () {0x40;}' unless defined(&PCI_CB_SUBSYSTEM_VENDOR_ID);
    eval 'sub PCI_CB_SUBSYSTEM_ID () {0x42;}' unless defined(&PCI_CB_SUBSYSTEM_ID);
    eval 'sub PCI_CB_LEGACY_MODE_BASE () {0x44;}' unless defined(&PCI_CB_LEGACY_MODE_BASE);
    eval 'sub PCI_CAP_LIST_ID () {0;}' unless defined(&PCI_CAP_LIST_ID);
    eval 'sub PCI_CAP_ID_PM () {0x1;}' unless defined(&PCI_CAP_ID_PM);
    eval 'sub PCI_CAP_ID_AGP () {0x2;}' unless defined(&PCI_CAP_ID_AGP);
    eval 'sub PCI_CAP_ID_VPD () {0x3;}' unless defined(&PCI_CAP_ID_VPD);
    eval 'sub PCI_CAP_ID_SLOTID () {0x4;}' unless defined(&PCI_CAP_ID_SLOTID);
    eval 'sub PCI_CAP_ID_MSI () {0x5;}' unless defined(&PCI_CAP_ID_MSI);
    eval 'sub PCI_CAP_ID_CHSWP () {0x6;}' unless defined(&PCI_CAP_ID_CHSWP);
    eval 'sub PCI_CAP_ID_PCIX () {0x7;}' unless defined(&PCI_CAP_ID_PCIX);
    eval 'sub PCI_CAP_LIST_NEXT () {1;}' unless defined(&PCI_CAP_LIST_NEXT);
    eval 'sub PCI_CAP_FLAGS () {2;}' unless defined(&PCI_CAP_FLAGS);
    eval 'sub PCI_CAP_SIZEOF () {4;}' unless defined(&PCI_CAP_SIZEOF);
    eval 'sub PCI_PM_PMC () {2;}' unless defined(&PCI_PM_PMC);
    eval 'sub PCI_PM_CAP_VER_MASK () {0x7;}' unless defined(&PCI_PM_CAP_VER_MASK);
    eval 'sub PCI_PM_CAP_PME_CLOCK () {0x8;}' unless defined(&PCI_PM_CAP_PME_CLOCK);
    eval 'sub PCI_PM_CAP_RESERVED () {0x10;}' unless defined(&PCI_PM_CAP_RESERVED);
    eval 'sub PCI_PM_CAP_DSI () {0x20;}' unless defined(&PCI_PM_CAP_DSI);
    eval 'sub PCI_PM_CAP_AUX_POWER () {0x1c0;}' unless defined(&PCI_PM_CAP_AUX_POWER);
    eval 'sub PCI_PM_CAP_D1 () {0x200;}' unless defined(&PCI_PM_CAP_D1);
    eval 'sub PCI_PM_CAP_D2 () {0x400;}' unless defined(&PCI_PM_CAP_D2);
    eval 'sub PCI_PM_CAP_PME () {0x800;}' unless defined(&PCI_PM_CAP_PME);
    eval 'sub PCI_PM_CAP_PME_MASK () {0xf800;}' unless defined(&PCI_PM_CAP_PME_MASK);
    eval 'sub PCI_PM_CAP_PME_D0 () {0x800;}' unless defined(&PCI_PM_CAP_PME_D0);
    eval 'sub PCI_PM_CAP_PME_D1 () {0x1000;}' unless defined(&PCI_PM_CAP_PME_D1);
    eval 'sub PCI_PM_CAP_PME_D2 () {0x2000;}' unless defined(&PCI_PM_CAP_PME_D2);
    eval 'sub PCI_PM_CAP_PME_D3 () {0x4000;}' unless defined(&PCI_PM_CAP_PME_D3);
    eval 'sub PCI_PM_CAP_PME_D3cold () {0x8000;}' unless defined(&PCI_PM_CAP_PME_D3cold);
    eval 'sub PCI_PM_CTRL () {4;}' unless defined(&PCI_PM_CTRL);
    eval 'sub PCI_PM_CTRL_STATE_MASK () {0x3;}' unless defined(&PCI_PM_CTRL_STATE_MASK);
    eval 'sub PCI_PM_CTRL_PME_ENABLE () {0x100;}' unless defined(&PCI_PM_CTRL_PME_ENABLE);
    eval 'sub PCI_PM_CTRL_DATA_SEL_MASK () {0x1e00;}' unless defined(&PCI_PM_CTRL_DATA_SEL_MASK);
    eval 'sub PCI_PM_CTRL_DATA_SCALE_MASK () {0x6000;}' unless defined(&PCI_PM_CTRL_DATA_SCALE_MASK);
    eval 'sub PCI_PM_CTRL_PME_STATUS () {0x8000;}' unless defined(&PCI_PM_CTRL_PME_STATUS);
    eval 'sub PCI_PM_PPB_EXTENSIONS () {6;}' unless defined(&PCI_PM_PPB_EXTENSIONS);
    eval 'sub PCI_PM_PPB_B2_B3 () {0x40;}' unless defined(&PCI_PM_PPB_B2_B3);
    eval 'sub PCI_PM_BPCC_ENABLE () {0x80;}' unless defined(&PCI_PM_BPCC_ENABLE);
    eval 'sub PCI_PM_DATA_REGISTER () {7;}' unless defined(&PCI_PM_DATA_REGISTER);
    eval 'sub PCI_PM_SIZEOF () {8;}' unless defined(&PCI_PM_SIZEOF);
    eval 'sub PCI_AGP_VERSION () {2;}' unless defined(&PCI_AGP_VERSION);
    eval 'sub PCI_AGP_RFU () {3;}' unless defined(&PCI_AGP_RFU);
    eval 'sub PCI_AGP_STATUS () {4;}' unless defined(&PCI_AGP_STATUS);
    eval 'sub PCI_AGP_STATUS_RQ_MASK () {0xff000000;}' unless defined(&PCI_AGP_STATUS_RQ_MASK);
    eval 'sub PCI_AGP_STATUS_SBA () {0x200;}' unless defined(&PCI_AGP_STATUS_SBA);
    eval 'sub PCI_AGP_STATUS_64BIT () {0x20;}' unless defined(&PCI_AGP_STATUS_64BIT);
    eval 'sub PCI_AGP_STATUS_FW () {0x10;}' unless defined(&PCI_AGP_STATUS_FW);
    eval 'sub PCI_AGP_STATUS_RATE4 () {0x4;}' unless defined(&PCI_AGP_STATUS_RATE4);
    eval 'sub PCI_AGP_STATUS_RATE2 () {0x2;}' unless defined(&PCI_AGP_STATUS_RATE2);
    eval 'sub PCI_AGP_STATUS_RATE1 () {0x1;}' unless defined(&PCI_AGP_STATUS_RATE1);
    eval 'sub PCI_AGP_COMMAND () {8;}' unless defined(&PCI_AGP_COMMAND);
    eval 'sub PCI_AGP_COMMAND_RQ_MASK () {0xff000000;}' unless defined(&PCI_AGP_COMMAND_RQ_MASK);
    eval 'sub PCI_AGP_COMMAND_SBA () {0x200;}' unless defined(&PCI_AGP_COMMAND_SBA);
    eval 'sub PCI_AGP_COMMAND_AGP () {0x100;}' unless defined(&PCI_AGP_COMMAND_AGP);
    eval 'sub PCI_AGP_COMMAND_64BIT () {0x20;}' unless defined(&PCI_AGP_COMMAND_64BIT);
    eval 'sub PCI_AGP_COMMAND_FW () {0x10;}' unless defined(&PCI_AGP_COMMAND_FW);
    eval 'sub PCI_AGP_COMMAND_RATE4 () {0x4;}' unless defined(&PCI_AGP_COMMAND_RATE4);
    eval 'sub PCI_AGP_COMMAND_RATE2 () {0x2;}' unless defined(&PCI_AGP_COMMAND_RATE2);
    eval 'sub PCI_AGP_COMMAND_RATE1 () {0x1;}' unless defined(&PCI_AGP_COMMAND_RATE1);
    eval 'sub PCI_AGP_SIZEOF () {12;}' unless defined(&PCI_AGP_SIZEOF);
    eval 'sub PCI_SID_ESR () {2;}' unless defined(&PCI_SID_ESR);
    eval 'sub PCI_SID_ESR_NSLOTS () {0x1f;}' unless defined(&PCI_SID_ESR_NSLOTS);
    eval 'sub PCI_SID_ESR_FIC () {0x20;}' unless defined(&PCI_SID_ESR_FIC);
    eval 'sub PCI_SID_CHASSIS_NR () {3;}' unless defined(&PCI_SID_CHASSIS_NR);
    eval 'sub PCI_MSI_FLAGS () {2;}' unless defined(&PCI_MSI_FLAGS);
    eval 'sub PCI_MSI_FLAGS_64BIT () {0x80;}' unless defined(&PCI_MSI_FLAGS_64BIT);
    eval 'sub PCI_MSI_FLAGS_QSIZE () {0x70;}' unless defined(&PCI_MSI_FLAGS_QSIZE);
    eval 'sub PCI_MSI_FLAGS_QMASK () {0xe;}' unless defined(&PCI_MSI_FLAGS_QMASK);
    eval 'sub PCI_MSI_FLAGS_ENABLE () {0x1;}' unless defined(&PCI_MSI_FLAGS_ENABLE);
    eval 'sub PCI_MSI_RFU () {3;}' unless defined(&PCI_MSI_RFU);
    eval 'sub PCI_MSI_ADDRESS_LO () {4;}' unless defined(&PCI_MSI_ADDRESS_LO);
    eval 'sub PCI_MSI_ADDRESS_HI () {8;}' unless defined(&PCI_MSI_ADDRESS_HI);
    eval 'sub PCI_MSI_DATA_32 () {8;}' unless defined(&PCI_MSI_DATA_32);
    eval 'sub PCI_MSI_DATA_64 () {12;}' unless defined(&PCI_MSI_DATA_64);
    eval 'sub PCI_CHSWP_CSR () {2;}' unless defined(&PCI_CHSWP_CSR);
    eval 'sub PCI_CHSWP_DHA () {0x1;}' unless defined(&PCI_CHSWP_DHA);
    eval 'sub PCI_CHSWP_EIM () {0x2;}' unless defined(&PCI_CHSWP_EIM);
    eval 'sub PCI_CHSWP_PIE () {0x4;}' unless defined(&PCI_CHSWP_PIE);
    eval 'sub PCI_CHSWP_LOO () {0x8;}' unless defined(&PCI_CHSWP_LOO);
    eval 'sub PCI_CHSWP_PI () {0x30;}' unless defined(&PCI_CHSWP_PI);
    eval 'sub PCI_CHSWP_EXT () {0x40;}' unless defined(&PCI_CHSWP_EXT);
    eval 'sub PCI_CHSWP_INS () {0x80;}' unless defined(&PCI_CHSWP_INS);
    eval 'sub PCI_X_CMD () {2;}' unless defined(&PCI_X_CMD);
    eval 'sub PCI_X_CMD_DPERR_E () {0x1;}' unless defined(&PCI_X_CMD_DPERR_E);
    eval 'sub PCI_X_CMD_ERO () {0x2;}' unless defined(&PCI_X_CMD_ERO);
    eval 'sub PCI_X_CMD_MAX_READ () {0xc;}' unless defined(&PCI_X_CMD_MAX_READ);
    eval 'sub PCI_X_CMD_MAX_SPLIT () {0x70;}' unless defined(&PCI_X_CMD_MAX_SPLIT);
    eval 'sub PCI_X_DEVFN () {4;}' unless defined(&PCI_X_DEVFN);
    eval 'sub PCI_X_BUSNR () {5;}' unless defined(&PCI_X_BUSNR);
    eval 'sub PCI_X_STATUS () {6;}' unless defined(&PCI_X_STATUS);
    eval 'sub PCI_X_STATUS_64BIT () {0x1;}' unless defined(&PCI_X_STATUS_64BIT);
    eval 'sub PCI_X_STATUS_133MHZ () {0x2;}' unless defined(&PCI_X_STATUS_133MHZ);
    eval 'sub PCI_X_STATUS_SPL_DISC () {0x4;}' unless defined(&PCI_X_STATUS_SPL_DISC);
    eval 'sub PCI_X_STATUS_UNX_SPL () {0x8;}' unless defined(&PCI_X_STATUS_UNX_SPL);
    eval 'sub PCI_X_STATUS_COMPLEX () {0x10;}' unless defined(&PCI_X_STATUS_COMPLEX);
    eval 'sub PCI_X_STATUS_MAX_READ () {0x60;}' unless defined(&PCI_X_STATUS_MAX_READ);
    eval 'sub PCI_X_STATUS_MAX_SPLIT () {0x380;}' unless defined(&PCI_X_STATUS_MAX_SPLIT);
    eval 'sub PCI_X_STATUS_MAX_CUM () {0x1c00;}' unless defined(&PCI_X_STATUS_MAX_CUM);
    eval 'sub PCI_X_STATUS_SPL_ERR () {0x2000;}' unless defined(&PCI_X_STATUS_SPL_ERR);
    require 'linux/pci_ids.ph';
    eval 'sub PCI_DEVFN {
        local($slot,$func) = @_;
	    eval q((((($slot) & 0x1f) << 3) | (($func) & 0x7)));
    }' unless defined(&PCI_DEVFN);
    eval 'sub PCI_SLOT {
        local($devfn) = @_;
	    eval q(((($devfn) >> 3) & 0x1f));
    }' unless defined(&PCI_SLOT);
    eval 'sub PCI_FUNC {
        local($devfn) = @_;
	    eval q((($devfn) & 0x7));
    }' unless defined(&PCI_FUNC);
    eval 'sub PCIIOC_BASE () {(ord(\'P\' << 24 | \'C\' << 16 | \'I\') << 8);}' unless defined(&PCIIOC_BASE);
    eval 'sub PCIIOC_CONTROLLER () {( &PCIIOC_BASE | 0x);}' unless defined(&PCIIOC_CONTROLLER);
    eval 'sub PCIIOC_MMAP_IS_IO () {( &PCIIOC_BASE | 0x1);}' unless defined(&PCIIOC_MMAP_IS_IO);
    eval 'sub PCIIOC_MMAP_IS_MEM () {( &PCIIOC_BASE | 0x2);}' unless defined(&PCIIOC_MMAP_IS_MEM);
    eval 'sub PCIIOC_WRITE_COMBINE () {( &PCIIOC_BASE | 0x3);}' unless defined(&PCIIOC_WRITE_COMBINE);
    if(defined(&__KERNEL__)) {
	require 'linux/types.ph';
	require 'linux/config.ph';
	require 'linux/ioport.ph';
	require 'linux/list.ph';
	require 'linux/errno.ph';
	eval("sub pci_mmap_io () { 0; }") unless defined(&pci_mmap_io);
	eval("sub pci_mmap_mem () { 1; }") unless defined(&pci_mmap_mem);
	eval 'sub PCI_DMA_BIDIRECTIONAL () {0;}' unless defined(&PCI_DMA_BIDIRECTIONAL);
	eval 'sub PCI_DMA_TODEVICE () {1;}' unless defined(&PCI_DMA_TODEVICE);
	eval 'sub PCI_DMA_FROMDEVICE () {2;}' unless defined(&PCI_DMA_FROMDEVICE);
	eval 'sub PCI_DMA_NONE () {3;}' unless defined(&PCI_DMA_NONE);
	eval 'sub DEVICE_COUNT_COMPATIBLE () {4;}' unless defined(&DEVICE_COUNT_COMPATIBLE);
	eval 'sub DEVICE_COUNT_IRQ () {2;}' unless defined(&DEVICE_COUNT_IRQ);
	eval 'sub DEVICE_COUNT_DMA () {2;}' unless defined(&DEVICE_COUNT_DMA);
	eval 'sub DEVICE_COUNT_RESOURCE () {12;}' unless defined(&DEVICE_COUNT_RESOURCE);
	eval 'sub PCI_ANY_ID () {(~0);}' unless defined(&PCI_ANY_ID);
	eval 'sub pci_present () { &pcibios_present;}' unless defined(&pci_present);
	eval 'sub pci_for_each_dev_reverse {
	    local($dev) = @_;
    	    eval q( &for($dev =  &pci_dev_g( ($pci_devices->{prev})); $dev !=  &pci_dev_g( &pci_devices); $dev =  &pci_dev_g( ($dev->{global_list}->{prev}))));
	}' unless defined(&pci_for_each_dev_reverse);
	eval 'sub pci_for_each_bus {
	    local($bus) = @_;
    	    eval q( &for($bus =  &pci_bus_b( ($pci_root_buses->{next})); $bus !=  &pci_bus_b( &pci_root_buses); $bus =  &pci_bus_b( ($bus->{node}->{next}))));
	}' unless defined(&pci_for_each_bus);
	eval 'sub pci_dev_g {
	    local($n) = @_;
    	    eval q( &list_entry($n, \'struct pci_dev\',  &global_list));
	}' unless defined(&pci_dev_g);
	eval 'sub pci_dev_b {
	    local($n) = @_;
    	    eval q( &list_entry($n, \'struct pci_dev\',  &bus_list));
	}' unless defined(&pci_dev_b);
	eval 'sub PCI_ROM_RESOURCE () {6;}' unless defined(&PCI_ROM_RESOURCE);
	eval 'sub PCI_BRIDGE_RESOURCES () {7;}' unless defined(&PCI_BRIDGE_RESOURCES);
	eval 'sub PCI_NUM_RESOURCES () {11;}' unless defined(&PCI_NUM_RESOURCES);
	eval 'sub PCI_REGION_FLAG_MASK () {0xf;}' unless defined(&PCI_REGION_FLAG_MASK);
	eval 'sub pci_bus_b {
	    local($n) = @_;
    	    eval q( &list_entry($n, \'struct pci_bus\',  &node));
	}' unless defined(&pci_bus_b);
	eval 'sub PCIBIOS_SUCCESSFUL () {0x;}' unless defined(&PCIBIOS_SUCCESSFUL);
	eval 'sub PCIBIOS_FUNC_NOT_SUPPORTED () {0x81;}' unless defined(&PCIBIOS_FUNC_NOT_SUPPORTED);
	eval 'sub PCIBIOS_BAD_VENDOR_ID () {0x83;}' unless defined(&PCIBIOS_BAD_VENDOR_ID);
	eval 'sub PCIBIOS_DEVICE_NOT_FOUND () {0x86;}' unless defined(&PCIBIOS_DEVICE_NOT_FOUND);
	eval 'sub PCIBIOS_BAD_REGISTER_NUMBER () {0x87;}' unless defined(&PCIBIOS_BAD_REGISTER_NUMBER);
	eval 'sub PCIBIOS_SET_FAILED () {0x88;}' unless defined(&PCIBIOS_SET_FAILED);
	eval 'sub PCIBIOS_BUFFER_TOO_SMALL () {0x89;}' unless defined(&PCIBIOS_BUFFER_TOO_SMALL);
	eval 'sub PCI_DEVICE {
	    local($vend,$dev) = @_;
    	    eval q(. &vendor = ($vend), . &device = ($dev), . &subvendor =  &PCI_ANY_ID, . &subdevice =  &PCI_ANY_ID);
	}' unless defined(&PCI_DEVICE);
	eval 'sub PCI_DEVICE_CLASS {
	    local($dev_class,$dev_class_mask) = @_;
    	    eval q(. &class = ($dev_class), . &class_mask = ($dev_class_mask), . &vendor =  &PCI_ANY_ID, . &device =  &PCI_ANY_ID, . &subvendor =  &PCI_ANY_ID, . &subdevice =  &PCI_ANY_ID);
	}' unless defined(&PCI_DEVICE_CLASS);
	if(defined(&CONFIG_PCI)) {
	    eval 'sub pci_for_each_dev {
	        local($dev) = @_;
    		eval q( &for($dev =  &pci_dev_g( ($pci_devices->{next})); $dev !=  &pci_dev_g( &pci_devices); $dev =  &pci_dev_g( ($dev->{global_list}->{next}))));
	    }' unless defined(&pci_for_each_dev);
	    eval 'sub HAVE_PCI_SET_MWI () {1;}' unless defined(&HAVE_PCI_SET_MWI);
	    eval 'sub HAVE_PCI_REQ_REGIONS () {2;}' unless defined(&HAVE_PCI_REQ_REGIONS);
	}
	require 'asm/pci.ph';
	unless(defined(&CONFIG_PCI)) {
	    eval 'sub _PCI_NOP {
	        local($o,$s,$t) = @_;
    		eval q( &static  &inline \'int\'  &pcibios_$o &_config_$s ( &u8  &bus,  &u8  &dfn,  &u8  &where, $t  &val) {  &return  &PCIBIOS_FUNC_NOT_SUPPORTED; }  &static  &inline \'int\'  &pci_$o &_config_$s (\'struct pci_dev\' * &dev, \'int\'  &where, $t  &val) {  &return  &PCIBIOS_FUNC_NOT_SUPPORTED; });
	    }' unless defined(&_PCI_NOP);
	    eval 'sub _PCI_NOP_ALL {
	        local($o,$x) = @_;
    		eval q( &_PCI_NOP($o, &byte, &u8 $x)  &_PCI_NOP($o, &word, &u16 $x)  &_PCI_NOP($o, &dword, &u32 $x));
	    }' unless defined(&_PCI_NOP_ALL);
	    eval 'sub pci_dev {
	        eval q(* &pci_find_device(my $vendor, my $device,  &const \'struct pci_dev\' * &from) {  &NULL; });
	    }' unless defined(&pci_dev);
	    eval 'sub pci_dev {
	        eval q(* &pci_find_class(my $class,  &const \'struct pci_dev\' * &from) {  &NULL; });
	    }' unless defined(&pci_dev);
	    eval 'sub pci_dev {
	        eval q(* &pci_find_slot(my $bus, my $devfn) {  &NULL; });
	    }' unless defined(&pci_dev);
	    eval 'sub pci_dev {
	        eval q(* &pci_find_subsys(my $vendor, my $device, my $ss_vendor, my $ss_device,  &const \'struct pci_dev\' * &from) {  &NULL; });
	    }' unless defined(&pci_dev);
	    eval 'sub pci_for_each_dev {
	        local($dev) = @_;
    		eval q( &for($dev =  &NULL; 0; ));
	    }' unless defined(&pci_for_each_dev);
	} else {
	    if(defined( &CONFIG_HOTPLUG)  && !defined( &MODULE)) {
	    } else {
	    }
	}
	eval 'sub pci_resource_start {
	    local($dev,$bar) = @_;
    	    eval q((($dev)-> ($resource[&(bar)]->{start})));
	}' unless defined(&pci_resource_start);
	eval 'sub pci_resource_end {
	    local($dev,$bar) = @_;
    	    eval q((($dev)-> ($resource[&(bar)]->{end})));
	}' unless defined(&pci_resource_end);
	eval 'sub pci_resource_flags {
	    local($dev,$bar) = @_;
    	    eval q((($dev)-> ($resource[&(bar)]->{flags})));
	}' unless defined(&pci_resource_flags);
	eval 'sub pci_resource_len {
	    local($dev,$bar) = @_;
    	    eval q((( &pci_resource_start(($dev),($bar)) == 0 &&  &pci_resource_end(($dev),($bar)) ==  &pci_resource_start(($dev),($bar))) ? 0: ( &pci_resource_end(($dev),($bar)) -  &pci_resource_start(($dev),($bar)) + 1)));
	}' unless defined(&pci_resource_len);
	eval 'sub pci_set_drvdata {
	    local($pdev,$data) = @_;
    	    eval q({  ($pdev->{driver_data}) = $data; });
	}' unless defined(&pci_set_drvdata);
	eval 'sub char {
	    eval q(* &pci_name(\'struct pci_dev\' * &pdev) {  ($pdev->{slot_name}); });
	}' unless defined(&char);
	eval 'sub PCI_FIXUP_HEADER () {1;}' unless defined(&PCI_FIXUP_HEADER);
	eval 'sub PCI_FIXUP_FINAL () {2;}' unless defined(&PCI_FIXUP_FINAL);
	eval 'sub PCIPCI_FAIL () {1;}' unless defined(&PCIPCI_FAIL);
	eval 'sub PCIPCI_TRITON () {2;}' unless defined(&PCIPCI_TRITON);
	eval 'sub PCIPCI_NATOMA () {4;}' unless defined(&PCIPCI_NATOMA);
	eval 'sub PCIPCI_VIAETBF () {8;}' unless defined(&PCIPCI_VIAETBF);
	eval 'sub PCIPCI_VSFX () {16;}' unless defined(&PCIPCI_VSFX);
	eval 'sub PCIPCI_ALIMAGIK () {32;}' unless defined(&PCIPCI_ALIMAGIK);
    }
}
1;
