require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_MMZONE_H)) {
    eval 'sub _LINUX_MMZONE_H () {1;}' unless defined(&_LINUX_MMZONE_H);
    if(defined(&__KERNEL__)) {
	unless(defined(&__ASSEMBLY__)) {
	    require 'linux/config.ph';
	    require 'linux/spinlock.ph';
	    require 'linux/list.ph';
	    require 'linux/wait.ph';
	    unless(defined(&CONFIG_FORCE_MAX_ZONEORDER)) {
		eval 'sub MAX_ORDER () {10;}' unless defined(&MAX_ORDER);
	    } else {
		eval 'sub MAX_ORDER () { &CONFIG_FORCE_MAX_ZONEORDER;}' unless defined(&MAX_ORDER);
	    }
	    eval 'sub ZONE_DMA () {0;}' unless defined(&ZONE_DMA);
	    eval 'sub ZONE_NORMAL () {1;}' unless defined(&ZONE_NORMAL);
	    eval 'sub ZONE_HIGHMEM () {2;}' unless defined(&ZONE_HIGHMEM);
	    eval 'sub MAX_NR_ZONES () {3;}' unless defined(&MAX_NR_ZONES);
	    eval 'sub GFP_ZONEMASK () {0xf;}' unless defined(&GFP_ZONEMASK);
	    eval 'sub zone_idx {
	        local($zone) = @_;
    		eval q((($zone) - ($zone)-> ($zone_pgdat->{node_zones})));
	    }' unless defined(&zone_idx);
	    eval 'sub memclass {
	        local($pgzone, $classzone) = @_;
    		eval q(( &zone_idx($pgzone) <=  &zone_idx($classzone)));
	    }' unless defined(&memclass);
	    eval 'sub for_each_pgdat {
	        local($pgdat) = @_;
    		eval q( &for ($pgdat =  &pgdat_list; $pgdat; $pgdat =  ($pgdat->{node_next})));
	    }' unless defined(&for_each_pgdat);
	    eval 'sub for_each_zone {
	        local($zone) = @_;
    		eval q( &for($zone =  ($pgdat_list->{node_zones}); $zone; $zone =  &next_zone($zone)));
	    }' unless defined(&for_each_zone);
	    unless(defined(&CONFIG_DISCONTIGMEM)) {
		eval 'sub NODE_DATA {
		    local($nid) = @_;
    		    eval q(( &contig_page_data));
		}' unless defined(&NODE_DATA);
		eval 'sub NODE_MEM_MAP {
		    local($nid) = @_;
    		    eval q( &mem_map);
		}' unless defined(&NODE_MEM_MAP);
		eval 'sub MAX_NR_NODES () {1;}' unless defined(&MAX_NR_NODES);
	    } else {
		require 'asm/mmzone.ph';
		unless(defined(&MAX_NR_NODES)) {
		    eval 'sub MAX_NR_NODES () {(255/  &MAX_NR_ZONES);}' unless defined(&MAX_NR_NODES);
		}
	    }
	    eval 'sub MAP_ALIGN {
	        local($x) = @_;
    		eval q((((($x) % $sizeof{ &mem_map_t}) == 0) ? ($x) : (($x) + $sizeof{ &mem_map_t} - (($x) % $sizeof{ &mem_map_t}))));
	    }' unless defined(&MAP_ALIGN);
	}
    }
}
1;
