require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_MM_H)) {
    eval 'sub _LINUX_MM_H () {1;}' unless defined(&_LINUX_MM_H);
    require 'linux/sched.ph';
    require 'linux/errno.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/string.ph';
	require 'linux/list.ph';
	require 'linux/mmzone.ph';
	require 'linux/swap.ph';
	require 'linux/rbtree.ph';
	require 'asm/page.ph';
	require 'asm/pgtable.ph';
	require 'asm/atomic.ph';
	eval 'sub VM_READ () {0x1;}' unless defined(&VM_READ);
	eval 'sub VM_WRITE () {0x2;}' unless defined(&VM_WRITE);
	eval 'sub VM_EXEC () {0x4;}' unless defined(&VM_EXEC);
	eval 'sub VM_SHARED () {0x8;}' unless defined(&VM_SHARED);
	eval 'sub VM_MAYREAD () {0x10;}' unless defined(&VM_MAYREAD);
	eval 'sub VM_MAYWRITE () {0x20;}' unless defined(&VM_MAYWRITE);
	eval 'sub VM_MAYEXEC () {0x40;}' unless defined(&VM_MAYEXEC);
	eval 'sub VM_MAYSHARE () {0x80;}' unless defined(&VM_MAYSHARE);
	eval 'sub VM_GROWSDOWN () {0x100;}' unless defined(&VM_GROWSDOWN);
	eval 'sub VM_GROWSUP () {0x200;}' unless defined(&VM_GROWSUP);
	eval 'sub VM_SHM () {0x400;}' unless defined(&VM_SHM);
	eval 'sub VM_DENYWRITE () {0x800;}' unless defined(&VM_DENYWRITE);
	eval 'sub VM_EXECUTABLE () {0x1000;}' unless defined(&VM_EXECUTABLE);
	eval 'sub VM_LOCKED () {0x2000;}' unless defined(&VM_LOCKED);
	eval 'sub VM_IO () {0x4000;}' unless defined(&VM_IO);
	eval 'sub VM_SEQ_READ () {0x8000;}' unless defined(&VM_SEQ_READ);
	eval 'sub VM_RAND_READ () {0x10000;}' unless defined(&VM_RAND_READ);
	eval 'sub VM_DONTCOPY () {0x20000;}' unless defined(&VM_DONTCOPY);
	eval 'sub VM_DONTEXPAND () {0x40000;}' unless defined(&VM_DONTEXPAND);
	eval 'sub VM_RESERVED () {0x80000;}' unless defined(&VM_RESERVED);
	unless(defined(&VM_STACK_FLAGS)) {
	    eval 'sub VM_STACK_FLAGS () {0x177;}' unless defined(&VM_STACK_FLAGS);
	}
	eval 'sub VM_READHINTMASK () {( &VM_SEQ_READ |  &VM_RAND_READ);}' unless defined(&VM_READHINTMASK);
	eval 'sub VM_ClearReadHint {
	    local($v) = @_;
    	    eval q(($v)-> &vm_flags &= ~ &VM_READHINTMASK);
	}' unless defined(&VM_ClearReadHint);
	eval 'sub VM_NormalReadHint {
	    local($v) = @_;
    	    eval q((!(($v)-> &vm_flags &  &VM_READHINTMASK)));
	}' unless defined(&VM_NormalReadHint);
	eval 'sub VM_SequentialReadHint {
	    local($v) = @_;
    	    eval q((($v)-> &vm_flags &  &VM_SEQ_READ));
	}' unless defined(&VM_SequentialReadHint);
	eval 'sub VM_RandomReadHint {
	    local($v) = @_;
    	    eval q((($v)-> &vm_flags &  &VM_RAND_READ));
	}' unless defined(&VM_RandomReadHint);
	if(defined( &CONFIG_HIGHMEM) || defined( &WANT_PAGE_VIRTUAL)) {
	}
	eval 'sub get_page {
	    local($p) = @_;
    	    eval q( &atomic_inc(($p)-> &count));
	}' unless defined(&get_page);
	eval 'sub put_page {
	    local($p) = @_;
    	    eval q( &__free_page($p));
	}' unless defined(&put_page);
	eval 'sub put_page_testzero {
	    local($p) = @_;
    	    eval q( &atomic_dec_and_test(($p)-> &count));
	}' unless defined(&put_page_testzero);
	eval 'sub page_count {
	    local($p) = @_;
    	    eval q( &atomic_read(($p)-> &count));
	}' unless defined(&page_count);
	eval 'sub set_page_count {
	    local($p,$v) = @_;
    	    eval q( &atomic_set(($p)-> &count, $v));
	}' unless defined(&set_page_count);
	eval 'sub PG_locked () {0;}' unless defined(&PG_locked);
	eval 'sub PG_error () {1;}' unless defined(&PG_error);
	eval 'sub PG_referenced () {2;}' unless defined(&PG_referenced);
	eval 'sub PG_uptodate () {3;}' unless defined(&PG_uptodate);
	eval 'sub PG_dirty () {4;}' unless defined(&PG_dirty);
	eval 'sub PG_unused () {5;}' unless defined(&PG_unused);
	eval 'sub PG_lru () {6;}' unless defined(&PG_lru);
	eval 'sub PG_active () {7;}' unless defined(&PG_active);
	eval 'sub PG_slab () {8;}' unless defined(&PG_slab);
	eval 'sub PG_skip () {10;}' unless defined(&PG_skip);
	eval 'sub PG_highmem () {11;}' unless defined(&PG_highmem);
	eval 'sub PG_checked () {12;}' unless defined(&PG_checked);
	eval 'sub PG_arch_1 () {13;}' unless defined(&PG_arch_1);
	eval 'sub PG_reserved () {14;}' unless defined(&PG_reserved);
	eval 'sub PG_launder () {15;}' unless defined(&PG_launder);
	eval 'sub PG_fs_1 () {16;}' unless defined(&PG_fs_1);
	unless(defined(&arch_set_page_uptodate)) {
	    eval 'sub arch_set_page_uptodate {
	        local($page) = @_;
    		eval q();
	    }' unless defined(&arch_set_page_uptodate);
	}
	eval 'sub UnlockPage {
	    local($page) = @_;
    	    eval q( &unlock_page($page));
	}' unless defined(&UnlockPage);
	eval 'sub Page_Uptodate {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_uptodate, ($page)-> &flags));
	}' unless defined(&Page_Uptodate);
	eval 'sub SetPageUptodate {
	    local($page) = @_;
    	    eval q( &do {  &arch_set_page_uptodate($page);  &set_bit( &PG_uptodate, ($page)-> &flags); }  &while (0));
	}' unless defined(&SetPageUptodate);
	eval 'sub ClearPageUptodate {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_uptodate, ($page)-> &flags));
	}' unless defined(&ClearPageUptodate);
	eval 'sub PageDirty {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_dirty, ($page)-> &flags));
	}' unless defined(&PageDirty);
	eval 'sub SetPageDirty {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_dirty, ($page)-> &flags));
	}' unless defined(&SetPageDirty);
	eval 'sub ClearPageDirty {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_dirty, ($page)-> &flags));
	}' unless defined(&ClearPageDirty);
	eval 'sub PageLocked {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_locked, ($page)-> &flags));
	}' unless defined(&PageLocked);
	eval 'sub LockPage {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_locked, ($page)-> &flags));
	}' unless defined(&LockPage);
	eval 'sub TryLockPage {
	    local($page) = @_;
    	    eval q( &test_and_set_bit( &PG_locked, ($page)-> &flags));
	}' unless defined(&TryLockPage);
	eval 'sub PageChecked {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_checked, ($page)-> &flags));
	}' unless defined(&PageChecked);
	eval 'sub SetPageChecked {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_checked, ($page)-> &flags));
	}' unless defined(&SetPageChecked);
	eval 'sub ClearPageChecked {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_checked, ($page)-> &flags));
	}' unless defined(&ClearPageChecked);
	eval 'sub PageLaunder {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_launder, ($page)-> &flags));
	}' unless defined(&PageLaunder);
	eval 'sub SetPageLaunder {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_launder, ($page)-> &flags));
	}' unless defined(&SetPageLaunder);
	eval 'sub ClearPageLaunder {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_launder, ($page)-> &flags));
	}' unless defined(&ClearPageLaunder);
	eval 'sub ClearPageArch1 {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_arch_1, ($page)-> &flags));
	}' unless defined(&ClearPageArch1);
	eval 'sub NODE_SHIFT () {4;}' unless defined(&NODE_SHIFT);
	eval 'sub ZONE_SHIFT () {( &BITS_PER_LONG - 8);}' unless defined(&ZONE_SHIFT);
	eval 'sub zone_t {
	    eval q(* &page_zone(\'struct page\' * &page) {  $zone_table[ ($page->{flags}) >>  &ZONE_SHIFT]; });
	}' unless defined(&zone_t);
	eval 'sub set_page_zone {
	    local($page,$zone_num) = @_;
    	    eval q({  ($page->{flags}) &= ~(~0 <<  &ZONE_SHIFT);  ($page->{flags}) |= $zone_num <<  &ZONE_SHIFT; });
	}' unless defined(&set_page_zone);
	if(defined( &CONFIG_HIGHMEM) || defined( &WANT_PAGE_VIRTUAL)) {
	    eval 'sub set_page_address {
	        local($page, $address) = @_;
    		eval q( &do { ($page)-> &virtual = ($address); }  &while(0));
	    }' unless defined(&set_page_address);
	} else {
	    eval 'sub set_page_address {
	        local($page, $address) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&set_page_address);
	}
	if(defined( &CONFIG_HIGHMEM) || defined( &WANT_PAGE_VIRTUAL)) {
	    eval 'sub page_address {
	        local($page) = @_;
    		eval q((($page)-> &virtual));
	    }' unless defined(&page_address);
	} else {
	    eval 'sub page_address {
	        local($page) = @_;
    		eval q( &__va( ((($page) -  &page_zone($page)-> &zone_mem_map) <<  &PAGE_SHIFT) +  &page_zone($page)-> &zone_start_paddr));
	    }' unless defined(&page_address);
	}
	eval 'sub PageError {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_error, ($page)-> &flags));
	}' unless defined(&PageError);
	eval 'sub SetPageError {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_error, ($page)-> &flags));
	}' unless defined(&SetPageError);
	eval 'sub ClearPageError {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_error, ($page)-> &flags));
	}' unless defined(&ClearPageError);
	eval 'sub PageReferenced {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_referenced, ($page)-> &flags));
	}' unless defined(&PageReferenced);
	eval 'sub SetPageReferenced {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_referenced, ($page)-> &flags));
	}' unless defined(&SetPageReferenced);
	eval 'sub ClearPageReferenced {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_referenced, ($page)-> &flags));
	}' unless defined(&ClearPageReferenced);
	eval 'sub PageTestandClearReferenced {
	    local($page) = @_;
    	    eval q( &test_and_clear_bit( &PG_referenced, ($page)-> &flags));
	}' unless defined(&PageTestandClearReferenced);
	eval 'sub PageSlab {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_slab, ($page)-> &flags));
	}' unless defined(&PageSlab);
	eval 'sub PageSetSlab {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_slab, ($page)-> &flags));
	}' unless defined(&PageSetSlab);
	eval 'sub PageClearSlab {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_slab, ($page)-> &flags));
	}' unless defined(&PageClearSlab);
	eval 'sub PageReserved {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_reserved, ($page)-> &flags));
	}' unless defined(&PageReserved);
	eval 'sub PageActive {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_active, ($page)-> &flags));
	}' unless defined(&PageActive);
	eval 'sub SetPageActive {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_active, ($page)-> &flags));
	}' unless defined(&SetPageActive);
	eval 'sub ClearPageActive {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_active, ($page)-> &flags));
	}' unless defined(&ClearPageActive);
	eval 'sub PageLRU {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_lru, ($page)-> &flags));
	}' unless defined(&PageLRU);
	eval 'sub TestSetPageLRU {
	    local($page) = @_;
    	    eval q( &test_and_set_bit( &PG_lru, ($page)-> &flags));
	}' unless defined(&TestSetPageLRU);
	eval 'sub TestClearPageLRU {
	    local($page) = @_;
    	    eval q( &test_and_clear_bit( &PG_lru, ($page)-> &flags));
	}' unless defined(&TestClearPageLRU);
	if(defined(&CONFIG_HIGHMEM)) {
	    eval 'sub PageHighMem {
	        local($page) = @_;
    		eval q( &test_bit( &PG_highmem, ($page)-> &flags));
	    }' unless defined(&PageHighMem);
	} else {
	    eval 'sub PageHighMem {
	        local($page) = @_;
    		eval q(0);
	    }' unless defined(&PageHighMem);
	}
	eval 'sub SetPageReserved {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_reserved, ($page)-> &flags));
	}' unless defined(&SetPageReserved);
	eval 'sub ClearPageReserved {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_reserved, ($page)-> &flags));
	}' unless defined(&ClearPageReserved);
	eval 'sub NOPAGE_SIGBUS () {( &NULL);}' unless defined(&NOPAGE_SIGBUS);
	eval 'sub NOPAGE_OOM () {( (-1));}' unless defined(&NOPAGE_OOM);
	eval 'sub alloc_pages {
	    local($gfp_mask,$order) = @_;
    	    eval q({  &if ($order >=  &MAX_ORDER)  &NULL;  &_alloc_pages($gfp_mask, $order); });
	}' unless defined(&alloc_pages);
	eval 'sub alloc_page {
	    local($gfp_mask) = @_;
    	    eval q( &alloc_pages($gfp_mask, 0));
	}' unless defined(&alloc_page);
	eval 'sub __get_free_page {
	    local($gfp_mask) = @_;
    	    eval q( &__get_free_pages(($gfp_mask),0));
	}' unless defined(&__get_free_page);
	eval 'sub __get_dma_pages {
	    local($gfp_mask, $order) = @_;
    	    eval q( &__get_free_pages(($gfp_mask) |  &GFP_DMA,($order)));
	}' unless defined(&__get_dma_pages);
	eval 'sub get_free_page () { &get_zeroed_page;}' unless defined(&get_free_page);
	eval 'sub __free_page {
	    local($page) = @_;
    	    eval q( &__free_pages(($page), 0));
	}' unless defined(&__free_page);
	eval 'sub free_page {
	    local($addr) = @_;
    	    eval q( &free_pages(($addr),0));
	}' unless defined(&free_page);
	eval 'sub PageSwapCache {
	    local($page) = @_;
    	    eval q((($page)-> &mapping ==  &swapper_space));
	}' unless defined(&PageSwapCache);
	eval 'sub is_page_cache_freeable {
	    local($page) = @_;
    	    eval q({  &page_count($page) - !! ($page->{buffers}) == 1; });
	}' unless defined(&is_page_cache_freeable);
	eval 'sub do_mmap {
	    local($file,$addr,$len,$prot,$flag,$offset) = @_;
    	    eval q({ my $ret = - &EINVAL;  &if (($offset +  &PAGE_ALIGN($len)) < $offset)  &goto  &out;  &if (!($offset & ~ &PAGE_MASK))  $ret =  &do_mmap_pgoff($file, $addr, $len, $prot, $flag, $offset >>  &PAGE_SHIFT);  &out:  $ret; });
	}' unless defined(&do_mmap);
	eval 'sub __vma_unlink {
	    local($mm,$vma,$prev) = @_;
    	    eval q({  ($prev->{vm_next}) =  ($vma->{vm_next});  &rb_erase( ($vma->{vm_rb}),  ($mm->{mm_rb}));  &if ( ($mm->{mmap_cache}) == $vma)  ($mm->{mmap_cache}) = $prev; });
	}' unless defined(&__vma_unlink);
	eval 'sub can_vma_merge {
	    local($vma,$vm_flags) = @_;
    	    eval q({  &if (! ($vma->{vm_file})  &&  ($vma->{vm_flags}) == $vm_flags) 1;  &else 0; });
	}' unless defined(&can_vma_merge);
	eval 'sub __GFP_DMA () {0x1;}' unless defined(&__GFP_DMA);
	eval 'sub __GFP_HIGHMEM () {0x2;}' unless defined(&__GFP_HIGHMEM);
	eval 'sub __GFP_WAIT () {0x10;}' unless defined(&__GFP_WAIT);
	eval 'sub __GFP_HIGH () {0x20;}' unless defined(&__GFP_HIGH);
	eval 'sub __GFP_IO () {0x40;}' unless defined(&__GFP_IO);
	eval 'sub __GFP_HIGHIO () {0x80;}' unless defined(&__GFP_HIGHIO);
	eval 'sub __GFP_FS () {0x100;}' unless defined(&__GFP_FS);
	eval 'sub GFP_NOHIGHIO () {( &__GFP_HIGH |  &__GFP_WAIT |  &__GFP_IO);}' unless defined(&GFP_NOHIGHIO);
	eval 'sub GFP_NOIO () {( &__GFP_HIGH |  &__GFP_WAIT);}' unless defined(&GFP_NOIO);
	eval 'sub GFP_NOFS () {( &__GFP_HIGH |  &__GFP_WAIT |  &__GFP_IO |  &__GFP_HIGHIO);}' unless defined(&GFP_NOFS);
	eval 'sub GFP_ATOMIC () {( &__GFP_HIGH);}' unless defined(&GFP_ATOMIC);
	eval 'sub GFP_USER () {(  &__GFP_WAIT |  &__GFP_IO |  &__GFP_HIGHIO |  &__GFP_FS);}' unless defined(&GFP_USER);
	eval 'sub GFP_HIGHUSER () {(  &__GFP_WAIT |  &__GFP_IO |  &__GFP_HIGHIO |  &__GFP_FS |  &__GFP_HIGHMEM);}' unless defined(&GFP_HIGHUSER);
	eval 'sub GFP_KERNEL () {( &__GFP_HIGH |  &__GFP_WAIT |  &__GFP_IO |  &__GFP_HIGHIO |  &__GFP_FS);}' unless defined(&GFP_KERNEL);
	eval 'sub GFP_NFS () {( &__GFP_HIGH |  &__GFP_WAIT |  &__GFP_IO |  &__GFP_HIGHIO |  &__GFP_FS);}' unless defined(&GFP_NFS);
	eval 'sub GFP_KSWAPD () {(  &__GFP_WAIT |  &__GFP_IO |  &__GFP_HIGHIO |  &__GFP_FS);}' unless defined(&GFP_KSWAPD);
	eval 'sub GFP_DMA () { &__GFP_DMA;}' unless defined(&GFP_DMA);
	eval 'sub pf_gfp_mask {
	    local($gfp_mask) = @_;
    	    eval q({  &if ( ($current->{flags}) &  &PF_NOIO) $gfp_mask &= ~( &__GFP_IO |  &__GFP_HIGHIO |  &__GFP_FS); $gfp_mask; });
	}' unless defined(&pf_gfp_mask);
    }
}
1;
