require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_KERNEL_H)) {
    eval 'sub _LINUX_KERNEL_H () {1;}' unless defined(&_LINUX_KERNEL_H);
    if(defined(&__KERNEL__)) {
	require 'stdarg.ph';
	require 'linux/linkage.ph';
	require 'linux/stddef.ph';
	require 'linux/types.ph';
	require 'linux/compiler.ph';
	require 'asm/byteorder.ph';
	eval 'sub barrier () {
	    eval q( &__asm__  &__volatile__(\\"\\": : :\\"memory\\"));
	}' unless defined(&barrier);
	eval 'sub INT_MAX () {((~0>>1));}' unless defined(&INT_MAX);
	eval 'sub INT_MIN () {(- &INT_MAX - 1);}' unless defined(&INT_MIN);
	eval 'sub UINT_MAX () {(~0);}' unless defined(&UINT_MAX);
	eval 'sub LONG_MAX () {((~0>>1));}' unless defined(&LONG_MAX);
	eval 'sub LONG_MIN () {(- &LONG_MAX - 1);}' unless defined(&LONG_MIN);
	eval 'sub ULONG_MAX () {(~0);}' unless defined(&ULONG_MAX);
	eval 'sub STACK_MAGIC () {0xdeadbeef;}' unless defined(&STACK_MAGIC);
	eval 'sub ARRAY_SIZE {
	    local($x) = @_;
    	    eval q(($sizeof{$x} / $sizeof{($x)[0]}));
	}' unless defined(&ARRAY_SIZE);
	eval 'sub KERN_EMERG () {"<0>";}' unless defined(&KERN_EMERG);
	eval 'sub KERN_ALERT () {"<1>";}' unless defined(&KERN_ALERT);
	eval 'sub KERN_CRIT () {"<2>";}' unless defined(&KERN_CRIT);
	eval 'sub KERN_ERR () {"<3>";}' unless defined(&KERN_ERR);
	eval 'sub KERN_WARNING () {"<4>";}' unless defined(&KERN_WARNING);
	eval 'sub KERN_NOTICE () {"<5>";}' unless defined(&KERN_NOTICE);
	eval 'sub KERN_INFO () {"<6>";}' unless defined(&KERN_INFO);
	eval 'sub KERN_DEBUG () {"<7>";}' unless defined(&KERN_DEBUG);
	eval 'sub console_loglevel () {( $console_printk[0]);}' unless defined(&console_loglevel);
	eval 'sub default_message_loglevel () {( $console_printk[1]);}' unless defined(&default_message_loglevel);
	eval 'sub minimum_console_loglevel () {( $console_printk[2]);}' unless defined(&minimum_console_loglevel);
	eval 'sub default_console_loglevel () {( $console_printk[3]);}' unless defined(&default_console_loglevel);
	eval 'sub NORET_TYPE () {1;}' unless defined(&NORET_TYPE);
	eval 'sub ATTRIB_NORET () { &__attribute__(( &noreturn));}' unless defined(&ATTRIB_NORET);
	eval 'sub NORET_AND () { &noreturn,;}' unless defined(&NORET_AND);
	if(defined(&__i386__)) {
	    eval 'sub FASTCALL {
	        local($x) = @_;
    		eval q($x  &__attribute__(( &regparm(3))));
	    }' unless defined(&FASTCALL);
	} else {
	    eval 'sub FASTCALL {
	        local($x) = @_;
    		eval q($x);
	    }' unless defined(&FASTCALL);
	}
	eval 'sub console_silent {
	    local($void) = @_;
    	    eval q({  &console_loglevel = 0; });
	}' unless defined(&console_silent);
	eval 'sub console_verbose {
	    local($void) = @_;
    	    eval q({  &if ( &console_loglevel)  &console_loglevel = 15; });
	}' unless defined(&console_verbose);
	if((defined(&DEBUG) ? &DEBUG : 0)) {
	    eval 'sub pr_debug () {( &fmt, &arg...)  &printk( &KERN_DEBUG  &fmt, &arg);}' unless defined(&pr_debug);
	} else {
	    eval 'sub pr_debug () {( &fmt, &arg...)  &do { }  &while (0);}' unless defined(&pr_debug);
	}
	eval 'sub pr_info () {( &fmt, &arg...)  &printk( &KERN_INFO  &fmt, &arg);}' unless defined(&pr_info);
	eval 'sub NIPQUAD {
	    local($addr) = @_;
    	    eval q(($addr)[0], ($addr)[1], ($addr)[2], ($addr)[3]);
	}' unless defined(&NIPQUAD);
	if(defined( &__LITTLE_ENDIAN)) {
	    eval 'sub HIPQUAD {
	        local($addr) = @_;
    		eval q(($addr)[3], ($addr)[2], ($addr)[1], ($addr)[0]);
	    }' unless defined(&HIPQUAD);
	}
 elsif(defined( &__BIG_ENDIAN)) {
	    eval 'sub HIPQUAD () { &NIPQUAD;}' unless defined(&HIPQUAD);
	} else {
	    die("Please fix asm/byteorder.h");
	}
	eval 'sub min {
	    local($x,$y) = @_;
    	    eval q(({  &const  &typeof($x)  &_x = ($x);  &const  &typeof($y)  &_y = ($y); ( &void) (& &_x == & &_y);  &_x <  &_y ?  &_x :  &_y; }));
	}' unless defined(&min);
	eval 'sub max {
	    local($x,$y) = @_;
    	    eval q(({  &const  &typeof($x)  &_x = ($x);  &const  &typeof($y)  &_y = ($y); ( &void) (& &_x == & &_y);  &_x >  &_y ?  &_x :  &_y; }));
	}' unless defined(&max);
	eval 'sub min_t {
	    local($type,$x,$y) = @_;
    	    eval q(({ $type  &__x = ($x); $type  &__y = ($y);  &__x <  &__y ?  &__x:  &__y; }));
	}' unless defined(&min_t);
	eval 'sub max_t {
	    local($type,$x,$y) = @_;
    	    eval q(({ $type  &__x = ($x); $type  &__y = ($y);  &__x >  &__y ?  &__x:  &__y; }));
	}' unless defined(&max_t);
	eval 'sub out_of_line_bug () {
	    eval q( &__out_of_line_bug( &__LINE__));
	}' unless defined(&out_of_line_bug);
    }
    eval 'sub SI_LOAD_SHIFT () {16;}' unless defined(&SI_LOAD_SHIFT);
    eval 'sub BUG_ON {
        local($condition) = @_;
	    eval q( &do {  &if ( &unlikely(($condition)!=0))  &BUG(); }  &while(0));
    }' unless defined(&BUG_ON);
}
1;
