require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ISOFS_FS_H)) {
    eval 'sub _ISOFS_FS_H () {1;}' unless defined(&_ISOFS_FS_H);
    require 'linux/types.ph';
    eval 'sub ISODCL {
        local($from, $to) = @_;
	    eval q(($to - $from + 1));
    }' unless defined(&ISODCL);
    eval 'sub ISO_VD_PRIMARY () {1;}' unless defined(&ISO_VD_PRIMARY);
    eval 'sub ISO_VD_SUPPLEMENTARY () {2;}' unless defined(&ISO_VD_SUPPLEMENTARY);
    eval 'sub ISO_VD_END () {255;}' unless defined(&ISO_VD_END);
    eval 'sub ISO_STANDARD_ID () {"CD001";}' unless defined(&ISO_STANDARD_ID);
    eval 'sub HS_STANDARD_ID () {"CDROM";}' unless defined(&HS_STANDARD_ID);
    eval 'sub ISOFS_BLOCK_BITS () {11;}' unless defined(&ISOFS_BLOCK_BITS);
    eval 'sub ISOFS_BLOCK_SIZE () {2048;}' unless defined(&ISOFS_BLOCK_SIZE);
    eval 'sub ISOFS_BUFFER_SIZE {
        local($INODE) = @_;
	    eval q((($INODE)-> ($i_sb->{s_blocksize})));
    }' unless defined(&ISOFS_BUFFER_SIZE);
    eval 'sub ISOFS_BUFFER_BITS {
        local($INODE) = @_;
	    eval q((($INODE)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&ISOFS_BUFFER_BITS);
    eval 'sub ISOFS_ZONE_BITS {
        local($INODE) = @_;
	    eval q((($INODE)-> ($i_sb->{u}->{isofs_sb}->{s_log_zone_size})));
    }' unless defined(&ISOFS_ZONE_BITS);
    eval 'sub ISOFS_SUPER_MAGIC () {0x9660;}' unless defined(&ISOFS_SUPER_MAGIC);
    if(defined(&__KERNEL__)) {
	require 'asm/byteorder.ph';
	require 'asm/unaligned.ph';
	eval 'sub isonum_711 {
	    local($p) = @_;
    	    eval q({ *( &u8 *)$p; });
	}' unless defined(&isonum_711);
	eval 'sub isonum_712 {
	    local($p) = @_;
    	    eval q({ *( &s8 *)$p; });
	}' unless defined(&isonum_712);
	eval 'sub isonum_721 {
	    local($p) = @_;
    	    eval q({  &le16_to_cpu( &get_unaligned(( &u16 *)$p)); });
	}' unless defined(&isonum_721);
	eval 'sub isonum_722 {
	    local($p) = @_;
    	    eval q({  &be16_to_cpu( &get_unaligned(( &u16 *)$p)); });
	}' unless defined(&isonum_722);
	eval 'sub isonum_723 {
	    local($p) = @_;
    	    eval q({  &le16_to_cpu( &get_unaligned(( &u16 *)$p)); });
	}' unless defined(&isonum_723);
	eval 'sub isonum_731 {
	    local($p) = @_;
    	    eval q({  &le32_to_cpu( &get_unaligned(( &u32 *)$p)); });
	}' unless defined(&isonum_731);
	eval 'sub isonum_732 {
	    local($p) = @_;
    	    eval q({  &be32_to_cpu( &get_unaligned(( &u32 *)$p)); });
	}' unless defined(&isonum_732);
	eval 'sub isonum_733 {
	    local($p) = @_;
    	    eval q({  &le32_to_cpu( &get_unaligned(( &u32 *)$p)); });
	}' unless defined(&isonum_733);
	if(defined(&LEAK_CHECK)) {
	    eval 'sub free_s () { &leak_check_free_s;}' unless defined(&free_s);
	    eval 'sub malloc () { &leak_check_malloc;}' unless defined(&malloc);
	    eval 'sub sb_bread () { &leak_check_bread;}' unless defined(&sb_bread);
	    eval 'sub brelse () { &leak_check_brelse;}' unless defined(&brelse);
	}
    }
}
1;
