require '_h2ph_pre.ph';

no warnings 'redefine';

require 'asm/types.ph';
unless(defined(&HIL_CLOCK)) {
    sub HIL_CLOCK () {	8 &MHZ;}
}
unless(defined(&HIL_EK1_CLOCK)) {
    sub HIL_EK1_CLOCK () {	30 &HZ;}
}
unless(defined(&HIL_EK2_CLOCK)) {
    sub HIL_EK2_CLOCK () {	60 &HZ;}
}
unless(defined(&HIL_TIMEOUT_DEV)) {
    sub HIL_TIMEOUT_DEV () {	5;}
}
unless(defined(&HIL_TIMEOUT_DEVS)) {
    sub HIL_TIMEOUT_DEVS () {	10;}
}
unless(defined(&HIL_TIMEOUT_NORESP)) {
    sub HIL_TIMEOUT_NORESP () {	10;}
}
unless(defined(&HIL_TIMEOUT_DEVS_DATA)) {
    sub HIL_TIMEOUT_DEVS_DATA () {	16;}
}
unless(defined(&HIL_TIMEOUT_SELFTEST)) {
    sub HIL_TIMEOUT_SELFTEST () {	200;}
}
unless(defined(&HIL_WIRE_PACKET_LEN)) {
    sub HIL_WIRE_PACKET_LEN () {	15;}
}
eval("sub HIL_WIRE_START () { 0; }") unless defined(&HIL_WIRE_START);
eval("sub HIL_WIRE_ADDR2 () { 1; }") unless defined(&HIL_WIRE_ADDR2);
eval("sub HIL_WIRE_ADDR1 () { 2; }") unless defined(&HIL_WIRE_ADDR1);
eval("sub HIL_WIRE_ADDR0 () { 3; }") unless defined(&HIL_WIRE_ADDR0);
eval("sub HIL_WIRE_COMMAND () { 4; }") unless defined(&HIL_WIRE_COMMAND);
eval("sub HIL_WIRE_DATA7 () { 5; }") unless defined(&HIL_WIRE_DATA7);
eval("sub HIL_WIRE_DATA6 () { 6; }") unless defined(&HIL_WIRE_DATA6);
eval("sub HIL_WIRE_DATA5 () { 7; }") unless defined(&HIL_WIRE_DATA5);
eval("sub HIL_WIRE_DATA4 () { 8; }") unless defined(&HIL_WIRE_DATA4);
eval("sub HIL_WIRE_DATA3 () { 9; }") unless defined(&HIL_WIRE_DATA3);
eval("sub HIL_WIRE_DATA2 () { 10; }") unless defined(&HIL_WIRE_DATA2);
eval("sub HIL_WIRE_DATA1 () { 11; }") unless defined(&HIL_WIRE_DATA1);
eval("sub HIL_WIRE_DATA0 () { 12; }") unless defined(&HIL_WIRE_DATA0);
eval("sub HIL_WIRE_PARITY () { 13; }") unless defined(&HIL_WIRE_PARITY);
eval("sub HIL_WIRE_STOP () { 14; }") unless defined(&HIL_WIRE_STOP);
eval("sub HIL_PKT_CMD () { 0x00000800; }") unless defined(&HIL_PKT_CMD);
eval("sub HIL_PKT_ADDR2 () { 0x00000400; }") unless defined(&HIL_PKT_ADDR2);
eval("sub HIL_PKT_ADDR1 () { 0x00000200; }") unless defined(&HIL_PKT_ADDR1);
eval("sub HIL_PKT_ADDR0 () { 0x00000100; }") unless defined(&HIL_PKT_ADDR0);
eval("sub HIL_PKT_ADDR_MASK () { 0x00000700; }") unless defined(&HIL_PKT_ADDR_MASK);
eval("sub HIL_PKT_ADDR_SHIFT () { 8; }") unless defined(&HIL_PKT_ADDR_SHIFT);
eval("sub HIL_PKT_DATA7 () { 0x00000080; }") unless defined(&HIL_PKT_DATA7);
eval("sub HIL_PKT_DATA6 () { 0x00000040; }") unless defined(&HIL_PKT_DATA6);
eval("sub HIL_PKT_DATA5 () { 0x00000020; }") unless defined(&HIL_PKT_DATA5);
eval("sub HIL_PKT_DATA4 () { 0x00000010; }") unless defined(&HIL_PKT_DATA4);
eval("sub HIL_PKT_DATA3 () { 0x00000008; }") unless defined(&HIL_PKT_DATA3);
eval("sub HIL_PKT_DATA2 () { 0x00000004; }") unless defined(&HIL_PKT_DATA2);
eval("sub HIL_PKT_DATA1 () { 0x00000002; }") unless defined(&HIL_PKT_DATA1);
eval("sub HIL_PKT_DATA0 () { 0x00000001; }") unless defined(&HIL_PKT_DATA0);
eval("sub HIL_PKT_DATA_MASK () { 0x000000FF; }") unless defined(&HIL_PKT_DATA_MASK);
eval("sub HIL_PKT_DATA_SHIFT () { 0; }") unless defined(&HIL_PKT_DATA_SHIFT);
eval("sub HIL_ERR_OB () { 0x00000800; }") unless defined(&HIL_ERR_OB);
eval("sub HIL_ERR_INT () { 0x00010000; }") unless defined(&HIL_ERR_INT);
eval("sub HIL_ERR_NMI () { 0x00020000; }") unless defined(&HIL_ERR_NMI);
eval("sub HIL_ERR_LERR () { 0x00040000; }") unless defined(&HIL_ERR_LERR);
eval("sub HIL_ERR_PERR () { 0x01000000; }") unless defined(&HIL_ERR_PERR);
eval("sub HIL_ERR_FERR () { 0x02000000; }") unless defined(&HIL_ERR_FERR);
eval("sub HIL_ERR_FOF () { 0x04000000; }") unless defined(&HIL_ERR_FOF);
eval("sub HIL_CTRL_TEST () { 0x00010000; }") unless defined(&HIL_CTRL_TEST);
eval("sub HIL_CTRL_IPF () { 0x00040000; }") unless defined(&HIL_CTRL_IPF);
eval("sub HIL_CTRL_APE () { 0x02000000; }") unless defined(&HIL_CTRL_APE);
unless(defined(&HIL_DO_ALTER_CTRL)) {
    sub HIL_DO_ALTER_CTRL () {	0x40000000;}
}
unless(defined(&HIL_CTRL_ONLY)) {
    sub HIL_CTRL_ONLY () {	0xc0000000;}
}
eval("sub HIL_CMD_IFC () { 0x00; }") unless defined(&HIL_CMD_IFC);
eval("sub HIL_CMD_EPT () { 0x01; }") unless defined(&HIL_CMD_EPT);
eval("sub HIL_CMD_ELB () { 0x02; }") unless defined(&HIL_CMD_ELB);
eval("sub HIL_CMD_IDD () { 0x03; }") unless defined(&HIL_CMD_IDD);
eval("sub HIL_CMD_DSR () { 0x04; }") unless defined(&HIL_CMD_DSR);
eval("sub HIL_CMD_PST () { 0x05; }") unless defined(&HIL_CMD_PST);
eval("sub HIL_CMD_RRG () { 0x06; }") unless defined(&HIL_CMD_RRG);
eval("sub HIL_CMD_WRG () { 0x07; }") unless defined(&HIL_CMD_WRG);
eval("sub HIL_CMD_ACF () { 0x08; }") unless defined(&HIL_CMD_ACF);
eval("sub HIL_CMDID_ACF () { 0x07; }") unless defined(&HIL_CMDID_ACF);
eval("sub HIL_CMD_POL () { 0x10; }") unless defined(&HIL_CMD_POL);
eval("sub HIL_CMDCT_POL () { 0x0f; }") unless defined(&HIL_CMDCT_POL);
eval("sub HIL_CMD_RPL () { 0x20; }") unless defined(&HIL_CMD_RPL);
eval("sub HIL_CMDCT_RPL () { 0x0f; }") unless defined(&HIL_CMDCT_RPL);
eval("sub HIL_CMD_RNM () { 0x30; }") unless defined(&HIL_CMD_RNM);
eval("sub HIL_CMD_RST () { 0x31; }") unless defined(&HIL_CMD_RST);
eval("sub HIL_CMD_EXD () { 0x32; }") unless defined(&HIL_CMD_EXD);
eval("sub HIL_CMD_RSC () { 0x33; }") unless defined(&HIL_CMD_RSC);
eval("sub HIL_CMD_DKA () { 0x3d; }") unless defined(&HIL_CMD_DKA);
eval("sub HIL_CMD_EK1 () { 0x3e; }") unless defined(&HIL_CMD_EK1);
eval("sub HIL_CMD_EK2 () { 0x3f; }") unless defined(&HIL_CMD_EK2);
eval("sub HIL_CMD_PR1 () { 0x40; }") unless defined(&HIL_CMD_PR1);
eval("sub HIL_CMD_PR2 () { 0x41; }") unless defined(&HIL_CMD_PR2);
eval("sub HIL_CMD_PR3 () { 0x42; }") unless defined(&HIL_CMD_PR3);
eval("sub HIL_CMD_PR4 () { 0x43; }") unless defined(&HIL_CMD_PR4);
eval("sub HIL_CMD_PR5 () { 0x44; }") unless defined(&HIL_CMD_PR5);
eval("sub HIL_CMD_PR6 () { 0x45; }") unless defined(&HIL_CMD_PR6);
eval("sub HIL_CMD_PR7 () { 0x46; }") unless defined(&HIL_CMD_PR7);
eval("sub HIL_CMD_PRM () { 0x47; }") unless defined(&HIL_CMD_PRM);
eval("sub HIL_CMD_AK1 () { 0x48; }") unless defined(&HIL_CMD_AK1);
eval("sub HIL_CMD_AK2 () { 0x49; }") unless defined(&HIL_CMD_AK2);
eval("sub HIL_CMD_AK3 () { 0x4a; }") unless defined(&HIL_CMD_AK3);
eval("sub HIL_CMD_AK4 () { 0x4b; }") unless defined(&HIL_CMD_AK4);
eval("sub HIL_CMD_AK5 () { 0x4c; }") unless defined(&HIL_CMD_AK5);
eval("sub HIL_CMD_AK6 () { 0x4d; }") unless defined(&HIL_CMD_AK6);
eval("sub HIL_CMD_AK7 () { 0x4e; }") unless defined(&HIL_CMD_AK7);
eval("sub HIL_CMD_ACK () { 0x4f; }") unless defined(&HIL_CMD_ACK);
eval("sub HIL_CMD_RIO () { 0xfa; }") unless defined(&HIL_CMD_RIO);
eval("sub HIL_CMD_SHR () { 0xfb; }") unless defined(&HIL_CMD_SHR);
eval("sub HIL_CMD_TER () { 0xfc; }") unless defined(&HIL_CMD_TER);
eval("sub HIL_CMD_CAE () { 0xfd; }") unless defined(&HIL_CMD_CAE);
eval("sub HIL_CMD_DHR () { 0xfe; }") unless defined(&HIL_CMD_DHR);
unless(defined(&HIL_IDD_DID_TYPE_MASK)) {
    sub HIL_IDD_DID_TYPE_MASK () {	0xe0;}
}
unless(defined(&HIL_IDD_DID_TYPE_KB_INTEGRAL)) {
    sub HIL_IDD_DID_TYPE_KB_INTEGRAL () {	0xa0;}
}
unless(defined(&HIL_IDD_DID_TYPE_KB_ITF)) {
    sub HIL_IDD_DID_TYPE_KB_ITF () {	0xc0;}
}
unless(defined(&HIL_IDD_DID_TYPE_KB_RSVD)) {
    sub HIL_IDD_DID_TYPE_KB_RSVD () {	0xe0;}
}
unless(defined(&HIL_IDD_DID_TYPE_KB_LANG_MASK)) {
    sub HIL_IDD_DID_TYPE_KB_LANG_MASK () {	0x1f;}
}
unless(defined(&HIL_IDD_DID_KBLANG_USE_ESD)) {
    sub HIL_IDD_DID_KBLANG_USE_ESD () {	0x;}
}
unless(defined(&HIL_IDD_DID_TYPE_ABS)) {
    sub HIL_IDD_DID_TYPE_ABS () {	0x80;}
}
unless(defined(&HIL_IDD_DID_ABS_RSVD1_MASK)) {
    sub HIL_IDD_DID_ABS_RSVD1_MASK () {	0xf8;}
}
unless(defined(&HIL_IDD_DID_ABS_RSVD1)) {
    sub HIL_IDD_DID_ABS_RSVD1 () {	0x98;}
}
unless(defined(&HIL_IDD_DID_ABS_TABLET_MASK)) {
    sub HIL_IDD_DID_ABS_TABLET_MASK () {	0xf8;}
}
unless(defined(&HIL_IDD_DID_ABS_TABLET)) {
    sub HIL_IDD_DID_ABS_TABLET () {	0x90;}
}
unless(defined(&HIL_IDD_DID_ABS_TSCREEN_MASK)) {
    sub HIL_IDD_DID_ABS_TSCREEN_MASK () {	0xfc;}
}
unless(defined(&HIL_IDD_DID_ABS_TSCREEN)) {
    sub HIL_IDD_DID_ABS_TSCREEN () {	0x8c;}
}
unless(defined(&HIL_IDD_DID_ABS_RSVD2_MASK)) {
    sub HIL_IDD_DID_ABS_RSVD2_MASK () {	0xfc;}
}
unless(defined(&HIL_IDD_DID_ABS_RSVD2)) {
    sub HIL_IDD_DID_ABS_RSVD2 () {	0x88;}
}
unless(defined(&HIL_IDD_DID_ABS_RSVD3_MASK)) {
    sub HIL_IDD_DID_ABS_RSVD3_MASK () {	0xfc;}
}
unless(defined(&HIL_IDD_DID_ABS_RSVD3)) {
    sub HIL_IDD_DID_ABS_RSVD3 () {	0x80;}
}
unless(defined(&HIL_IDD_DID_TYPE_REL)) {
    sub HIL_IDD_DID_TYPE_REL () {	0x60;}
}
unless(defined(&HIL_IDD_DID_REL_RSVD1_MASK)) {
    sub HIL_IDD_DID_REL_RSVD1_MASK () {	0xf0;}
}
unless(defined(&HIL_IDD_DID_REL_RSVD1)) {
    sub HIL_IDD_DID_REL_RSVD1 () {	0x70;}
}
unless(defined(&HIL_IDD_DID_REL_RSVD2_MASK)) {
    sub HIL_IDD_DID_REL_RSVD2_MASK () {	0xfc;}
}
unless(defined(&HIL_IDD_DID_REL_RSVD2)) {
    sub HIL_IDD_DID_REL_RSVD2 () {	0x6c;}
}
unless(defined(&HIL_IDD_DID_REL_MOUSE_MASK)) {
    sub HIL_IDD_DID_REL_MOUSE_MASK () {	0xfc;}
}
unless(defined(&HIL_IDD_DID_REL_MOUSE)) {
    sub HIL_IDD_DID_REL_MOUSE () {	0x68;}
}
unless(defined(&HIL_IDD_DID_REL_QUAD_MASK)) {
    sub HIL_IDD_DID_REL_QUAD_MASK () {	0xf8;}
}
unless(defined(&HIL_IDD_DID_REL_QUAD)) {
    sub HIL_IDD_DID_REL_QUAD () {	0x60;}
}
unless(defined(&HIL_IDD_DID_TYPE_CHAR)) {
    sub HIL_IDD_DID_TYPE_CHAR () {	0x40;}
}
unless(defined(&HIL_IDD_DID_CHAR_BARCODE_MASK)) {
    sub HIL_IDD_DID_CHAR_BARCODE_MASK () {	0xfc;}
}
unless(defined(&HIL_IDD_DID_CHAR_BARCODE)) {
    sub HIL_IDD_DID_CHAR_BARCODE () {	0x5c;}
}
unless(defined(&HIL_IDD_DID_CHAR_RSVD1_MASK)) {
    sub HIL_IDD_DID_CHAR_RSVD1_MASK () {	0xfc;}
}
unless(defined(&HIL_IDD_DID_CHAR_RSVD1)) {
    sub HIL_IDD_DID_CHAR_RSVD1 () {	0x58;}
}
unless(defined(&HIL_IDD_DID_CHAR_RSVD2_MASK)) {
    sub HIL_IDD_DID_CHAR_RSVD2_MASK () {	0xf8;}
}
unless(defined(&HIL_IDD_DID_CHAR_RSVD2)) {
    sub HIL_IDD_DID_CHAR_RSVD2 () {	0x50;}
}
unless(defined(&HIL_IDD_DID_CHAR_RSVD3_MASK)) {
    sub HIL_IDD_DID_CHAR_RSVD3_MASK () {	0xf0;}
}
unless(defined(&HIL_IDD_DID_CHAR_RSVD3)) {
    sub HIL_IDD_DID_CHAR_RSVD3 () {	0x40;}
}
unless(defined(&HIL_IDD_DID_TYPE_OTHER)) {
    sub HIL_IDD_DID_TYPE_OTHER () {	0x20;}
}
unless(defined(&HIL_IDD_DID_OTHER_RSVD1_MASK)) {
    sub HIL_IDD_DID_OTHER_RSVD1_MASK () {	0xf0;}
}
unless(defined(&HIL_IDD_DID_OTHER_RSVD1)) {
    sub HIL_IDD_DID_OTHER_RSVD1 () {	0x30;}
}
unless(defined(&HIL_IDD_DID_OTHER_BARCODE_MASK)) {
    sub HIL_IDD_DID_OTHER_BARCODE_MASK () {	0xfc;}
}
unless(defined(&HIL_IDD_DID_OTHER_BARCODE)) {
    sub HIL_IDD_DID_OTHER_BARCODE () {	0x2c;}
}
unless(defined(&HIL_IDD_DID_OTHER_RSVD2_MASK)) {
    sub HIL_IDD_DID_OTHER_RSVD2_MASK () {	0xfc;}
}
unless(defined(&HIL_IDD_DID_OTHER_RSVD2)) {
    sub HIL_IDD_DID_OTHER_RSVD2 () {	0x28;}
}
unless(defined(&HIL_IDD_DID_OTHER_RSVD3_MASK)) {
    sub HIL_IDD_DID_OTHER_RSVD3_MASK () {	0xf8;}
}
unless(defined(&HIL_IDD_DID_OTHER_RSVD3)) {
    sub HIL_IDD_DID_OTHER_RSVD3 () {	0x20;}
}
unless(defined(&HIL_IDD_DID_TYPE_KEYPAD)) {
    sub HIL_IDD_DID_TYPE_KEYPAD () {	0x;}
}
unless(defined(&HIL_IDD_HEADER_AXSET_MASK)) {
    sub HIL_IDD_HEADER_AXSET_MASK () {	0x3;}
}
unless(defined(&HIL_IDD_HEADER_RSC)) {
    sub HIL_IDD_HEADER_RSC () {	0x4;}
}
unless(defined(&HIL_IDD_HEADER_EXD)) {
    sub HIL_IDD_HEADER_EXD () {	0x8;}
}
unless(defined(&HIL_IDD_HEADER_IOD)) {
    sub HIL_IDD_HEADER_IOD () {	0x10;}
}
unless(defined(&HIL_IDD_HEADER_16BIT)) {
    sub HIL_IDD_HEADER_16BIT () {	0x20;}
}
unless(defined(&HIL_IDD_HEADER_ABS)) {
    sub HIL_IDD_HEADER_ABS () {	0x40;}
}
unless(defined(&HIL_IDD_HEADER_2X_AXIS)) {
    sub HIL_IDD_HEADER_2X_AXIS () {	0x80;}
}
unless(defined(&HIL_IDD_IOD_NBUTTON_MASK)) {
    sub HIL_IDD_IOD_NBUTTON_MASK () {	0x7;}
}
unless(defined(&HIL_IDD_IOD_PROXIMITY)) {
    sub HIL_IDD_IOD_PROXIMITY () {	0x8;}
}
unless(defined(&HIL_IDD_IOD_PROMPT_MASK)) {
    sub HIL_IDD_IOD_PROMPT_MASK () {	0x70;}
}
unless(defined(&HIL_IDD_IOD_PROMPT_SHIFT)) {
    sub HIL_IDD_IOD_PROMPT_SHIFT () {	4;}
}
unless(defined(&HIL_IDD_IOD_PROMPT)) {
    sub HIL_IDD_IOD_PROMPT () {	0x80;}
}
unless(defined(&HIL_IDD_NUM_AXES_PER_SET)) {
    sub HIL_IDD_NUM_AXES_PER_SET {
	local($header_packet) = @_;
	eval q((($header_packet) &  &HIL_IDD_HEADER_AXSET_MASK));
    }
}
unless(defined(&HIL_IDD_NUM_AXSETS)) {
    sub HIL_IDD_NUM_AXSETS {
	local($header_packet) = @_;
	eval q((2- !(($header_packet) &  &HIL_IDD_HEADER_2X_AXIS)));
    }
}
unless(defined(&HIL_IDD_LEN)) {
    sub HIL_IDD_LEN {
	local($header_packet) = @_;
	eval q(((4- !($header_packet &  &HIL_IDD_HEADER_IOD) - 2* !( &HIL_IDD_NUM_AXES_PER_SET($header_packet))) + 2*  &HIL_IDD_NUM_AXES_PER_SET($header_packet) * !!(($header_packet) &  &HIL_IDD_HEADER_ABS)));
    }
}
unless(defined(&HIL_IDD_AXIS_COUNTS_PER_M)) {
    sub HIL_IDD_AXIS_COUNTS_PER_M {
	local($header_ptr) = @_;
	eval q((!( &HIL_IDD_NUM_AXSETS(*($header_ptr))) ? -1: (((*($header_ptr + 1) &  &HIL_PKT_DATA_MASK) + ((*($header_ptr + 2) &  &HIL_PKT_DATA_MASK)) << 8) * ((*($header_ptr) &  &HIL_IDD_HEADER_16BIT) ? 100: 1))));
    }
}
unless(defined(&HIL_IDD_AXIS_MAX)) {
    sub HIL_IDD_AXIS_MAX {
	local($header_ptr, $__axnum) = @_;
	eval q(((!(*($header_ptr) &  &HIL_IDD_HEADER_ABS) || ( &HIL_IDD_NUM_AXES_PER_SET(*($header_ptr)) <= $__axnum)) ? 0: (( &HIL_PKT_DATA_MASK & *(($header_ptr) + 3+ 2* $__axnum)) + (( &HIL_PKT_DATA_MASK & *(($header_ptr) + 4+ 2* $__axnum)) << 8))));
    }
}
unless(defined(&HIL_IDD_IOD)) {
    sub HIL_IDD_IOD {
	local($header_ptr) = @_;
	eval q((*($header_ptr +  &HIL_IDD_LEN((*$header_ptr)) - 1)));
    }
}
unless(defined(&HIL_IDD_HAS_GEN_PROMPT)) {
    sub HIL_IDD_HAS_GEN_PROMPT {
	local($header_ptr) = @_;
	eval q(((*$header_ptr &  &HIL_IDD_HEADER_IOD)  && ( &HIL_IDD_IOD($header_ptr) &  &HIL_IDD_IOD_PROMPT)));
    }
}
unless(defined(&HIL_IDD_HAS_GEN_PROXIMITY)) {
    sub HIL_IDD_HAS_GEN_PROXIMITY {
	local($header_ptr) = @_;
	eval q(((*$header_ptr &  &HIL_IDD_HEADER_IOD)  && ( &HIL_IDD_IOD($header_ptr) &  &HIL_IDD_IOD_PROXIMITY)));
    }
}
unless(defined(&HIL_IDD_NUM_BUTTONS)) {
    sub HIL_IDD_NUM_BUTTONS {
	local($header_ptr) = @_;
	eval q(((*$header_ptr &  &HIL_IDD_HEADER_IOD) ? ( &HIL_IDD_IOD($header_ptr) &  &HIL_IDD_IOD_NBUTTON_MASK) : 0));
    }
}
unless(defined(&HIL_IDD_NUM_PROMPTS)) {
    sub HIL_IDD_NUM_PROMPTS {
	local($header_ptr) = @_;
	eval q(((*$header_ptr &  &HIL_IDD_HEADER_IOD) ? (( &HIL_IDD_IOD($header_ptr) &  &HIL_IDD_IOD_NPROMPT_MASK) >>  &HIL_IDD_IOD_PROMPT_SHIFT) : 0));
    }
}
unless(defined(&HIL_EXD_HEADER_WRG)) {
    sub HIL_EXD_HEADER_WRG () {	0x3;}
}
unless(defined(&HIL_EXD_HEADER_WRG_TYPE1)) {
    sub HIL_EXD_HEADER_WRG_TYPE1 () {	0x1;}
}
unless(defined(&HIL_EXD_HEADER_WRG_TYPE2)) {
    sub HIL_EXD_HEADER_WRG_TYPE2 () {	0x2;}
}
unless(defined(&HIL_EXD_HEADER_RRG)) {
    sub HIL_EXD_HEADER_RRG () {	0x4;}
}
unless(defined(&HIL_EXD_HEADER_RNM)) {
    sub HIL_EXD_HEADER_RNM () {	0x10;}
}
unless(defined(&HIL_EXD_HEADER_RST)) {
    sub HIL_EXD_HEADER_RST () {	0x20;}
}
unless(defined(&HIL_EXD_HEADER_LOCALE)) {
    sub HIL_EXD_HEADER_LOCALE () {	0x40;}
}
unless(defined(&HIL_EXD_NUM_RRG)) {
    sub HIL_EXD_NUM_RRG {
	local($header_ptr) = @_;
	eval q(((*$header_ptr &  &HIL_EXD_HEADER_RRG) ? (*($header_ptr + 1) &  &HIL_PKT_DATA_MASK) : 0));
    }
}
unless(defined(&HIL_EXD_NUM_WWG)) {
    sub HIL_EXD_NUM_WWG {
	local($header_ptr) = @_;
	eval q(((*$header_ptr &  &HIL_EXD_HEADER_WRG) ? (*($header_ptr + 2- !(*$header_ptr &  &HIL_EXD_HEADER_RRG)) &  &HIL_PKT_DATA_MASK) : 0));
    }
}
unless(defined(&HIL_EXD_LEN)) {
    sub HIL_EXD_LEN {
	local($header_ptr) = @_;
	eval q((!!(*$header_ptr &  &HIL_EXD_HEADER_RRG) + !!(*$header_ptr &  &HIL_EXD_HEADER_WRG) + !!(*$header_ptr &  &HIL_EXD_HEADER_LOCALE) + 2* !!(*$header_ptr &  &HIL_EXD_HEADER_WRG_TYPE2) + 1));
    }
}
unless(defined(&HIL_EXD_LOCALE)) {
    sub HIL_EXD_LOCALE {
	local($header_ptr) = @_;
	eval q((!(*$header_ptr &  &HIL_EXD_HEADER_LOCALE) ? -1: (*($header_ptr +  &HIL_EXD_LEN($header_ptr) - 1) &  &HIL_PKT_DATA_MASK)));
    }
}
unless(defined(&HIL_EXD_WRG_TYPE2_LEN)) {
    sub HIL_EXD_WRG_TYPE2_LEN {
	local($header_ptr) = @_;
	eval q((!(*$header_ptr &  &HIL_EXD_HEADER_WRG_TYPE2) ? -1: (*($header_ptr +  &HIL_EXD_LEN($header_ptr) - 2- !!(*$header_ptr &  &HIL_EXD_HEADER_LOCALE)) &  &HIL_PKT_DATA_MASK) + ((*($header_ptr +  &HIL_EXD_LEN($header_ptr) - 1- !!(*$header_ptr &  &HIL_EXD_HEADER_LOCALE)) &  &HIL_PKT_DATA_MASK) << 8)));
    }
}
unless(defined(&HIL_LOCALE_MAX)) {
    sub HIL_LOCALE_MAX () {	0x1f;}
}
unless(defined(&HIL_LOCALE_MAP)) {
    sub HIL_LOCALE_MAP () {	"", "", "", "swiss.french", "portuguese", "arabic", "hebrew", "english.canadian", "turkish", "greek", "thai", "italian", "korean", "dutch", "swedish", "german", "chinese", "chinese", "swiss.french", "spanish", "swiss.german", "flemish", "finnish", "english.uk", "french.canadian", "swiss.german", "norwegian", "french", "danish", "japanese", "spanish", "english.us";}
}
unless(defined(&HIL_POL_NUM_AXES_MASK)) {
    sub HIL_POL_NUM_AXES_MASK () {	0x3;}
}
unless(defined(&HIL_POL_CTS)) {
    sub HIL_POL_CTS () {	0x4;}
}
unless(defined(&HIL_POL_STATUS_PENDING)) {
    sub HIL_POL_STATUS_PENDING () {	0x8;}
}
unless(defined(&HIL_POL_CHARTYPE_MASK)) {
    sub HIL_POL_CHARTYPE_MASK () {	0x70;}
}
unless(defined(&HIL_POL_CHARTYPE_NONE)) {
    sub HIL_POL_CHARTYPE_NONE () {	0x;}
}
unless(defined(&HIL_POL_CHARTYPE_RSVD1)) {
    sub HIL_POL_CHARTYPE_RSVD1 () {	0x10;}
}
unless(defined(&HIL_POL_CHARTYPE_ASCII)) {
    sub HIL_POL_CHARTYPE_ASCII () {	0x20;}
}
unless(defined(&HIL_POL_CHARTYPE_BINARY)) {
    sub HIL_POL_CHARTYPE_BINARY () {	0x30;}
}
unless(defined(&HIL_POL_CHARTYPE_SET1)) {
    sub HIL_POL_CHARTYPE_SET1 () {	0x40;}
}
unless(defined(&HIL_POL_CHARTYPE_RSVD2)) {
    sub HIL_POL_CHARTYPE_RSVD2 () {	0x50;}
}
unless(defined(&HIL_POL_CHARTYPE_SET2)) {
    sub HIL_POL_CHARTYPE_SET2 () {	0x60;}
}
unless(defined(&HIL_POL_CHARTYPE_SET3)) {
    sub HIL_POL_CHARTYPE_SET3 () {	0x70;}
}
unless(defined(&HIL_POL_AXIS_ALT)) {
    sub HIL_POL_AXIS_ALT () {	0x80;}
}
1;
