require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__HDLC_H)) {
    eval 'sub __HDLC_H () {1;}' unless defined(&__HDLC_H);
    eval 'sub GENERIC_HDLC_VERSION () {4;}' unless defined(&GENERIC_HDLC_VERSION);
    eval 'sub CLOCK_DEFAULT () {0;}' unless defined(&CLOCK_DEFAULT);
    eval 'sub CLOCK_EXT () {1;}' unless defined(&CLOCK_EXT);
    eval 'sub CLOCK_INT () {2;}' unless defined(&CLOCK_INT);
    eval 'sub CLOCK_TXINT () {3;}' unless defined(&CLOCK_TXINT);
    eval 'sub CLOCK_TXFROMRX () {4;}' unless defined(&CLOCK_TXFROMRX);
    eval 'sub ENCODING_DEFAULT () {0;}' unless defined(&ENCODING_DEFAULT);
    eval 'sub ENCODING_NRZ () {1;}' unless defined(&ENCODING_NRZ);
    eval 'sub ENCODING_NRZI () {2;}' unless defined(&ENCODING_NRZI);
    eval 'sub ENCODING_FM_MARK () {3;}' unless defined(&ENCODING_FM_MARK);
    eval 'sub ENCODING_FM_SPACE () {4;}' unless defined(&ENCODING_FM_SPACE);
    eval 'sub ENCODING_MANCHESTER () {5;}' unless defined(&ENCODING_MANCHESTER);
    eval 'sub PARITY_DEFAULT () {0;}' unless defined(&PARITY_DEFAULT);
    eval 'sub PARITY_NONE () {1;}' unless defined(&PARITY_NONE);
    eval 'sub PARITY_CRC16_PR0 () {2;}' unless defined(&PARITY_CRC16_PR0);
    eval 'sub PARITY_CRC16_PR1 () {3;}' unless defined(&PARITY_CRC16_PR1);
    eval 'sub PARITY_CRC16_PR0_CCITT () {4;}' unless defined(&PARITY_CRC16_PR0_CCITT);
    eval 'sub PARITY_CRC16_PR1_CCITT () {5;}' unless defined(&PARITY_CRC16_PR1_CCITT);
    eval 'sub PARITY_CRC32_PR0_CCITT () {6;}' unless defined(&PARITY_CRC32_PR0_CCITT);
    eval 'sub PARITY_CRC32_PR1_CCITT () {7;}' unless defined(&PARITY_CRC32_PR1_CCITT);
    eval 'sub LMI_DEFAULT () {0;}' unless defined(&LMI_DEFAULT);
    eval 'sub LMI_NONE () {1;}' unless defined(&LMI_NONE);
    eval 'sub LMI_ANSI () {2;}' unless defined(&LMI_ANSI);
    eval 'sub LMI_CCITT () {3;}' unless defined(&LMI_CCITT);
    eval 'sub HDLC_MAX_MTU () {1500;}' unless defined(&HDLC_MAX_MTU);
    eval 'sub HDLC_MAX_MRU () {( &HDLC_MAX_MTU + 10+ 14+ 4);}' unless defined(&HDLC_MAX_MRU);
    if(defined(&__KERNEL__)) {
	require 'linux/skbuff.ph';
	require 'linux/netdevice.ph';
	require 'net/syncppp.ph';
	require 'linux/hdlc/ioctl.ph';
	eval 'sub CISCO_PACKET_LEN () {18;}' unless defined(&CISCO_PACKET_LEN);
	eval 'sub CISCO_BIG_PACKET_LEN () {20;}' unless defined(&CISCO_BIG_PACKET_LEN);
	eval 'sub hdlc_to_dev {
	    local($hdlc) = @_;
    	    eval q({  ($hdlc->{netdev}); });
	}' unless defined(&hdlc_to_dev);
	eval 'sub dev_to_hdlc {
	    local($dev) = @_;
    	    eval q({ ( &hdlc_device*)$dev; });
	}' unless defined(&dev_to_hdlc);
	eval 'sub dev_to_pvc {
	    local($dev) = @_;
    	    eval q({ ( &pvc_device*) ($dev->{priv}); });
	}' unless defined(&dev_to_pvc);
	eval 'sub char {
	    eval q(* &hdlc_to_name( &hdlc_device * &hdlc) {  &hdlc_to_dev( &hdlc)-> &name; });
	}' unless defined(&char);
	eval 'sub debug_frame {
	    local($skb) = @_;
    	    eval q({ \'int\'  &i;  &for ( &i=0;  &i <  ($skb->{len});  &i++) {  &if ( &i == 100) {  &printk(\\"...\\\\n\\"); ; }  &printk(\\" %02X\\",  ($skb->{data[&i]})); }  &printk(\\"\\\\n\\"); });
	}' unless defined(&debug_frame);
	eval 'sub hdlc_type_trans {
	    local($skb,$dev) = @_;
    	    eval q({  &hdlc_device * &hdlc =  &dev_to_hdlc( ($skb->{dev}));  &if ( ($hdlc->{type_trans}))  ($hdlc->{type_trans})($skb, $dev);  &else  &__constant_htons( &ETH_P_HDLC); });
	}' unless defined(&hdlc_type_trans);
    }
}
1;
