require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_JBD_H)) {
    eval 'sub _LINUX_JBD_H () {1;}' unless defined(&_LINUX_JBD_H);
    if(defined( &CONFIG_JBD) || defined( &CONFIG_JBD_MODULE) || !defined( &__KERNEL__)) {
	unless(defined(&__KERNEL__)) {
	    require 'jfs_compat.ph';
	    eval 'sub JFS_DEBUG () {1;}' unless defined(&JFS_DEBUG);
	    eval 'sub jfs_debug () { &jbd_debug;}' unless defined(&jfs_debug);
	} else {
	    require 'linux/journal-head.ph';
	    require 'linux/stddef.ph';
	    require 'asm/semaphore.ph';
	}
	eval 'sub journal_oom_retry () {1;}' unless defined(&journal_oom_retry);
	undef(&JBD_PARANOID_WRITES) if defined(&JBD_PARANOID_WRITES);
	undef(&JBD_PARANOID_IOFAIL) if defined(&JBD_PARANOID_IOFAIL);
	if(defined(&CONFIG_JBD_DEBUG)) {
	    eval 'sub JBD_EXPENSIVE_CHECKING () {1;}' unless defined(&JBD_EXPENSIVE_CHECKING);
	    eval 'sub jbd_debug () {( &n,  &f,  &a...)  &do {  &if (( &n) <=  &journal_enable_debug) {  &printk ( &KERN_DEBUG "(%s, %d): %s: ",  &__FILE__,  &__LINE__,  &__FUNCTION__);  &printk ( &f,   &a); } }  &while (0);}' unless defined(&jbd_debug);
	} else {
	    eval 'sub jbd_debug () {( &f,  &a...);}' unless defined(&jbd_debug);
	}
	eval 'sub jbd_kmalloc {
	    local($size, $flags) = @_;
    	    eval q( &__jbd_kmalloc( &__FUNCTION__, ($size), ($flags),  &journal_oom_retry));
	}' unless defined(&jbd_kmalloc);
	eval 'sub jbd_rep_kmalloc {
	    local($size, $flags) = @_;
    	    eval q( &__jbd_kmalloc( &__FUNCTION__, ($size), ($flags), 1));
	}' unless defined(&jbd_rep_kmalloc);
	eval 'sub JFS_MIN_JOURNAL_BLOCKS () {1024;}' unless defined(&JFS_MIN_JOURNAL_BLOCKS);
	if(defined(&__KERNEL__)) {
	}
	eval 'sub JFS_MAGIC_NUMBER () {0xc03b3998;}' unless defined(&JFS_MAGIC_NUMBER);
	eval 'sub JFS_DESCRIPTOR_BLOCK () {1;}' unless defined(&JFS_DESCRIPTOR_BLOCK);
	eval 'sub JFS_COMMIT_BLOCK () {2;}' unless defined(&JFS_COMMIT_BLOCK);
	eval 'sub JFS_SUPERBLOCK_V1 () {3;}' unless defined(&JFS_SUPERBLOCK_V1);
	eval 'sub JFS_SUPERBLOCK_V2 () {4;}' unless defined(&JFS_SUPERBLOCK_V2);
	eval 'sub JFS_REVOKE_BLOCK () {5;}' unless defined(&JFS_REVOKE_BLOCK);
	eval 'sub JFS_FLAG_ESCAPE () {1;}' unless defined(&JFS_FLAG_ESCAPE);
	eval 'sub JFS_FLAG_SAME_UUID () {2;}' unless defined(&JFS_FLAG_SAME_UUID);
	eval 'sub JFS_FLAG_DELETED () {4;}' unless defined(&JFS_FLAG_DELETED);
	eval 'sub JFS_FLAG_LAST_TAG () {8;}' unless defined(&JFS_FLAG_LAST_TAG);
	eval 'sub JFS_HAS_COMPAT_FEATURE {
	    local($j,$mask) = @_;
    	    eval q((($j)-> &j_format_version >= 2 && (($j)-> ($j_superblock->{s_feature_compat}) &  &cpu_to_be32(($mask)))));
	}' unless defined(&JFS_HAS_COMPAT_FEATURE);
	eval 'sub JFS_HAS_RO_COMPAT_FEATURE {
	    local($j,$mask) = @_;
    	    eval q((($j)-> &j_format_version >= 2 && (($j)-> ($j_superblock->{s_feature_ro_compat}) &  &cpu_to_be32(($mask)))));
	}' unless defined(&JFS_HAS_RO_COMPAT_FEATURE);
	eval 'sub JFS_HAS_INCOMPAT_FEATURE {
	    local($j,$mask) = @_;
    	    eval q((($j)-> &j_format_version >= 2 && (($j)-> ($j_superblock->{s_feature_incompat}) &  &cpu_to_be32(($mask)))));
	}' unless defined(&JFS_HAS_INCOMPAT_FEATURE);
	eval 'sub JFS_FEATURE_INCOMPAT_REVOKE () {0x1;}' unless defined(&JFS_FEATURE_INCOMPAT_REVOKE);
	eval 'sub JFS_KNOWN_COMPAT_FEATURES () {0;}' unless defined(&JFS_KNOWN_COMPAT_FEATURES);
	eval 'sub JFS_KNOWN_ROCOMPAT_FEATURES () {0;}' unless defined(&JFS_KNOWN_ROCOMPAT_FEATURES);
	eval 'sub JFS_KNOWN_INCOMPAT_FEATURES () { &JFS_FEATURE_INCOMPAT_REVOKE;}' unless defined(&JFS_KNOWN_INCOMPAT_FEATURES);
	if(defined(&__KERNEL__)) {
	    require 'linux/fs.ph';
	    require 'linux/sched.ph';
	    eval 'sub JBD_ASSERTIONS () {1;}' unless defined(&JBD_ASSERTIONS);
	    if(defined(&JBD_ASSERTIONS)) {
		eval 'sub J_ASSERT {
		    local($assert) = @_;
    		    eval q( &do {  &if (!($assert)) {  &printk ( &KERN_EMERG \\"Assertion failure in %s() at %s:%d: \\\\\\"%s\\\\\\"\\\\n\\",  &__FUNCTION__,  &__FILE__,  &__LINE__,  $assert);  &BUG(); } }  &while (0));
		}' unless defined(&J_ASSERT);
		if(defined( &CONFIG_BUFFER_DEBUG)) {
		    eval 'sub J_ASSERT_BH {
		        local($bh, $expr) = @_;
    			eval q( &do {  &if (!($expr))  &buffer_assertion_failure($bh);  &J_ASSERT($expr); }  &while (0));
		    }' unless defined(&J_ASSERT_BH);
		    eval 'sub J_ASSERT_JH {
		        local($jh, $expr) = @_;
    			eval q( &J_ASSERT_BH( &jh2bh($jh), $expr));
		    }' unless defined(&J_ASSERT_JH);
		} else {
		    eval 'sub J_ASSERT_BH {
		        local($bh, $expr) = @_;
    			eval q( &J_ASSERT($expr));
		    }' unless defined(&J_ASSERT_BH);
		    eval 'sub J_ASSERT_JH {
		        local($jh, $expr) = @_;
    			eval q( &J_ASSERT($expr));
		    }' unless defined(&J_ASSERT_JH);
		}
	    } else {
		eval 'sub J_ASSERT {
		    local($assert) = @_;
    		    eval q( &do { }  &while (0));
		}' unless defined(&J_ASSERT);
	    }
	    if(defined( &JBD_PARANOID_IOFAIL)) {
		eval 'sub J_EXPECT () {( &expr,  &why...)  &J_ASSERT( &expr);}' unless defined(&J_EXPECT);
		eval 'sub J_EXPECT_BH () {( &bh,  &expr,  &why...)  &J_ASSERT_BH( &bh,  &expr);}' unless defined(&J_EXPECT_BH);
		eval 'sub J_EXPECT_JH () {( &jh,  &expr,  &why...)  &J_ASSERT_JH( &jh,  &expr);}' unless defined(&J_EXPECT_JH);
	    } else {
		eval 'sub __journal_expect () {( &expr,  &why...)  &do {  &if (!( &expr)) {  &printk( &KERN_ERR "EXT3-fs unexpected failure: %s;\\n",   &expr);  &printk( &KERN_ERR  &why); } }  &while (0);}' unless defined(&__journal_expect);
		eval 'sub J_EXPECT () {( &expr,  &why...)  &__journal_expect( &expr,   &why);}' unless defined(&J_EXPECT);
		eval 'sub J_EXPECT_BH () {( &bh,  &expr,  &why...)  &__journal_expect( &expr,   &why);}' unless defined(&J_EXPECT_BH);
		eval 'sub J_EXPECT_JH () {( &jh,  &expr,  &why...)  &__journal_expect( &expr,   &why);}' unless defined(&J_EXPECT_JH);
	    }
	    eval("sub BH_JWrite () { BH_PrivateStart; }") unless defined(&BH_JWrite);
	    eval("sub BH_Freed () { 1; }") unless defined(&BH_Freed);
	    eval("sub BH_Revoked () { 2; }") unless defined(&BH_Revoked);
	    eval("sub BH_RevokeValid () { 3; }") unless defined(&BH_RevokeValid);
	    eval("sub BH_JBDDirty () { 4; }") unless defined(&BH_JBDDirty);
	    eval 'sub buffer_head {
	        eval q(* &jh2bh(\'struct journal_head\' * &jh) {  ($jh->{b_bh}); });
	    }' unless defined(&buffer_head);
	    eval 'sub journal_head {
	        eval q(* &bh2jh(\'struct buffer_head\' * &bh) {  ($bh->{b_private}); });
	    }' unless defined(&journal_head);
	    eval 'sub HAVE_JOURNAL_CALLBACK_STATUS () {1;}' unless defined(&HAVE_JOURNAL_CALLBACK_STATUS);
	    eval("sub T_RUNNING () { 0; }") unless defined(&T_RUNNING);
	    eval("sub T_LOCKED () { 1; }") unless defined(&T_LOCKED);
	    eval("sub T_RUNDOWN () { 2; }") unless defined(&T_RUNDOWN);
	    eval("sub T_FLUSH () { 3; }") unless defined(&T_FLUSH);
	    eval("sub T_COMMIT () { 4; }") unless defined(&T_COMMIT);
	    eval("sub T_FINISHED () { 5; }") unless defined(&T_FINISHED);
	    eval 'sub JFS_UNMOUNT () {0x1;}' unless defined(&JFS_UNMOUNT);
	    eval 'sub JFS_ABORT () {0x2;}' unless defined(&JFS_ABORT);
	    eval 'sub JFS_ACK_ERR () {0x4;}' unless defined(&JFS_ACK_ERR);
	    eval 'sub JFS_FLUSHED () {0x8;}' unless defined(&JFS_FLUSHED);
	    eval 'sub JFS_LOADED () {0x10;}' unless defined(&JFS_LOADED);
	    eval 'sub unlock_journal {
	        local($journal) = @_;
    		eval q({  &up( ($journal->{j_sem})); });
	    }' unless defined(&unlock_journal);
	    eval 'sub handle_t {
	        eval q(* &journal_current_handle( &void) {  ($current->{journal_info}); });
	    }' unless defined(&handle_t);
	    eval 'sub JOURNAL_REVOKE_DEFAULT_HASH () {256;}' unless defined(&JOURNAL_REVOKE_DEFAULT_HASH);
	    eval 'sub jbd_ENOSYS () {
	        eval q( &do {  &printk ( &KERN_ERR \\"JBD unimplemented function \\"  &__FUNCTION__);  ($current->{state}) =  &TASK_UNINTERRUPTIBLE;  &schedule(); }  &while (1));
	    }' unless defined(&jbd_ENOSYS);
	    eval 'sub jbd_unexpected_dirty_buffer {
	        local($jh) = @_;
    		eval q( &__jbd_unexpected_dirty_buffer( &__FUNCTION__,  &__LINE__, ($jh)));
	    }' unless defined(&jbd_unexpected_dirty_buffer);
	    eval 'sub is_handle_aborted {
	        local($handle) = @_;
    		eval q({  &if ( ($handle->{h_aborted})) 1;  &is_journal_aborted( ($handle->{h_transaction}->{t_journal})); });
	    }' unless defined(&is_handle_aborted);
	    eval 'sub journal_abort_handle {
	        local($handle) = @_;
    		eval q({  ($handle->{h_aborted}) = 1; });
	    }' unless defined(&journal_abort_handle);
	    unless(defined(&BUG)) {
		eval 'sub BUG () {
		    eval q( &do {  &printk(\\"kernel BUG at %s:%d!\\\\n\\",  &__FILE__,  &__LINE__); * ( 0) = 0; }  &while (0));
		}' unless defined(&BUG);
	    }
	}
	eval 'sub tid_geq {
	    local($x,$y) = @_;
    	    eval q({ \'int\'  &difference = ($x - $y); ( &difference >= 0); });
	}' unless defined(&tid_geq);
	eval 'sub BJ_None () {0;}' unless defined(&BJ_None);
	eval 'sub BJ_SyncData () {1;}' unless defined(&BJ_SyncData);
	eval 'sub BJ_AsyncData () {2;}' unless defined(&BJ_AsyncData);
	eval 'sub BJ_Metadata () {3;}' unless defined(&BJ_Metadata);
	eval 'sub BJ_Forget () {4;}' unless defined(&BJ_Forget);
	eval 'sub BJ_IO () {5;}' unless defined(&BJ_IO);
	eval 'sub BJ_Shadow () {6;}' unless defined(&BJ_Shadow);
	eval 'sub BJ_LogCtl () {7;}' unless defined(&BJ_LogCtl);
	eval 'sub BJ_Reserved () {8;}' unless defined(&BJ_Reserved);
	eval 'sub BJ_Types () {9;}' unless defined(&BJ_Types);
	if(defined(&__KERNEL__)) {
	    eval 'sub SPLICE_LOCK {
	        local($expr1, $expr2) = @_;
    		eval q(({ \'int\'  &ret = ($expr1);  &if ( &ret) {  &spin_lock( &jh_splice_lock);  &ret = ($expr1)  && ($expr2);  &spin_unlock( &jh_splice_lock); }  &ret; }));
	    }' unless defined(&SPLICE_LOCK);
	    if(defined(&CONFIG_SMP)) {
		eval 'sub assert_spin_locked {
		    local($lock) = @_;
    		    eval q( &J_ASSERT( &spin_is_locked($lock)));
		}' unless defined(&assert_spin_locked);
	    } else {
		eval 'sub assert_spin_locked {
		    local($lock) = @_;
    		    eval q( &do {}  &while(0));
		}' unless defined(&assert_spin_locked);
	    }
	    eval 'sub buffer_trace_init {
	        local($bh) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&buffer_trace_init);
	    eval 'sub print_buffer_fields {
	        local($bh) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&print_buffer_fields);
	    eval 'sub print_buffer_trace {
	        local($bh) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&print_buffer_trace);
	    eval 'sub BUFFER_TRACE {
	        local($bh, $info) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&BUFFER_TRACE);
	    eval 'sub BUFFER_TRACE2 {
	        local($bh, $bh2, $info) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&BUFFER_TRACE2);
	    eval 'sub JBUFFER_TRACE {
	        local($jh, $info) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&JBUFFER_TRACE);
	}
    }
    if(defined( &__KERNEL__)  && !(defined( &CONFIG_JBD) || defined( &CONFIG_JBD_MODULE))) {
	eval 'sub J_ASSERT {
	    local($expr) = @_;
    	    eval q( &do {}  &while (0));
	}' unless defined(&J_ASSERT);
	eval 'sub J_ASSERT_BH {
	    local($bh, $expr) = @_;
    	    eval q( &do {}  &while (0));
	}' unless defined(&J_ASSERT_BH);
	eval 'sub buffer_jbd {
	    local($bh) = @_;
    	    eval q(0);
	}' unless defined(&buffer_jbd);
	eval 'sub buffer_jlist_eq {
	    local($bh, $val) = @_;
    	    eval q(0);
	}' unless defined(&buffer_jlist_eq);
	eval 'sub journal_buffer_journal_lru {
	    local($bh) = @_;
    	    eval q(0);
	}' unless defined(&journal_buffer_journal_lru);
    }
}
1;
