require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_INETDEVICE_H)) {
    eval 'sub _LINUX_INETDEVICE_H () {1;}' unless defined(&_LINUX_INETDEVICE_H);
    if(defined(&__KERNEL__)) {
	eval 'sub IN_DEV_FORWARD {
	    local($in_dev) = @_;
    	    eval q((($in_dev)-> ($cnf->{forwarding})));
	}' unless defined(&IN_DEV_FORWARD);
	eval 'sub IN_DEV_MFORWARD {
	    local($in_dev) = @_;
    	    eval q(( ($ipv4_devconf->{mc_forwarding})  && ($in_dev)-> ($cnf->{mc_forwarding})));
	}' unless defined(&IN_DEV_MFORWARD);
	eval 'sub IN_DEV_RPFILTER {
	    local($in_dev) = @_;
    	    eval q(( ($ipv4_devconf->{rp_filter})  && ($in_dev)-> ($cnf->{rp_filter})));
	}' unless defined(&IN_DEV_RPFILTER);
	eval 'sub IN_DEV_SOURCE_ROUTE {
	    local($in_dev) = @_;
    	    eval q(( ($ipv4_devconf->{accept_source_route})  && ($in_dev)-> ($cnf->{accept_source_route})));
	}' unless defined(&IN_DEV_SOURCE_ROUTE);
	eval 'sub IN_DEV_BOOTP_RELAY {
	    local($in_dev) = @_;
    	    eval q(( ($ipv4_devconf->{bootp_relay})  && ($in_dev)-> ($cnf->{bootp_relay})));
	}' unless defined(&IN_DEV_BOOTP_RELAY);
	eval 'sub IN_DEV_LOG_MARTIANS {
	    local($in_dev) = @_;
    	    eval q(( ($ipv4_devconf->{log_martians}) || ($in_dev)-> ($cnf->{log_martians})));
	}' unless defined(&IN_DEV_LOG_MARTIANS);
	eval 'sub IN_DEV_PROXY_ARP {
	    local($in_dev) = @_;
    	    eval q(( ($ipv4_devconf->{proxy_arp}) || ($in_dev)-> ($cnf->{proxy_arp})));
	}' unless defined(&IN_DEV_PROXY_ARP);
	eval 'sub IN_DEV_SHARED_MEDIA {
	    local($in_dev) = @_;
    	    eval q(( ($ipv4_devconf->{shared_media}) || ($in_dev)-> ($cnf->{shared_media})));
	}' unless defined(&IN_DEV_SHARED_MEDIA);
	eval 'sub IN_DEV_TX_REDIRECTS {
	    local($in_dev) = @_;
    	    eval q(( ($ipv4_devconf->{send_redirects}) || ($in_dev)-> ($cnf->{send_redirects})));
	}' unless defined(&IN_DEV_TX_REDIRECTS);
	eval 'sub IN_DEV_SEC_REDIRECTS {
	    local($in_dev) = @_;
    	    eval q(( ($ipv4_devconf->{secure_redirects}) || ($in_dev)-> ($cnf->{secure_redirects})));
	}' unless defined(&IN_DEV_SEC_REDIRECTS);
	eval 'sub IN_DEV_IDTAG {
	    local($in_dev) = @_;
    	    eval q((($in_dev)-> ($cnf->{tag})));
	}' unless defined(&IN_DEV_IDTAG);
	eval 'sub IN_DEV_MEDIUM_ID {
	    local($in_dev) = @_;
    	    eval q((($in_dev)-> ($cnf->{medium_id})));
	}' unless defined(&IN_DEV_MEDIUM_ID);
	eval 'sub IN_DEV_RX_REDIRECTS {
	    local($in_dev) = @_;
    	    eval q((( &IN_DEV_FORWARD($in_dev)  && ( ($ipv4_devconf->{accept_redirects})  && ($in_dev)-> ($cnf->{accept_redirects}))) || (! &IN_DEV_FORWARD($in_dev)  && ( ($ipv4_devconf->{accept_redirects}) || ($in_dev)-> ($cnf->{accept_redirects})))));
	}' unless defined(&IN_DEV_RX_REDIRECTS);
	eval 'sub IN_DEV_ARPFILTER {
	    local($in_dev) = @_;
    	    eval q(( ($ipv4_devconf->{arp_filter}) || ($in_dev)-> ($cnf->{arp_filter})));
	}' unless defined(&IN_DEV_ARPFILTER);
	eval 'sub IN_DEV_ARP_ANNOUNCE {
	    local($in_dev) = @_;
    	    eval q(( &max( ($ipv4_devconf->{arp_announce}), ($in_dev)-> ($cnf->{arp_announce}))));
	}' unless defined(&IN_DEV_ARP_ANNOUNCE);
	eval 'sub IN_DEV_ARP_IGNORE {
	    local($in_dev) = @_;
    	    eval q(( &max( ($ipv4_devconf->{arp_ignore}), ($in_dev)-> ($cnf->{arp_ignore}))));
	}' unless defined(&IN_DEV_ARP_IGNORE);
	eval 'sub inet_ifa_match {
	    local($addr,$ifa) = @_;
    	    eval q({ !(($addr^ ($ifa->{ifa_address})) ($ifa->{ifa_mask})); });
	}' unless defined(&inet_ifa_match);
	eval 'sub for_primary_ifa {
	    local($in_dev) = @_;
    	    eval q({ \'struct in_ifaddr\' * &ifa;  &for ( &ifa = ($in_dev)-> &ifa_list;  &ifa  && !( ($ifa->{ifa_flags})& &IFA_F_SECONDARY);  &ifa =  ($ifa->{ifa_next})));
	}' unless defined(&for_primary_ifa);
	eval 'sub for_ifa {
	    local($in_dev) = @_;
    	    eval q({ \'struct in_ifaddr\' * &ifa;  &for ( &ifa = ($in_dev)-> &ifa_list;  &ifa;  &ifa =  ($ifa->{ifa_next})));
	}' unless defined(&for_ifa);
	eval 'sub endfor_ifa {
	    local($in_dev) = @_;
    	    eval q(});
	}' unless defined(&endfor_ifa);
	eval 'sub in_dev_get {
	    local($dev) = @_;
    	    eval q({ \'struct in_device\' * &in_dev;  &read_lock( &inetdev_lock);  &in_dev =  ($dev->{ip_ptr});  &if ( &in_dev)  &atomic_inc( ($in_dev->{refcnt}));  &read_unlock( &inetdev_lock);  &in_dev; });
	}' unless defined(&in_dev_get);
	eval 'sub __in_dev_get {
	    local($dev) = @_;
    	    eval q({  ($dev->{ip_ptr}); });
	}' unless defined(&__in_dev_get);
	eval 'sub in_dev_put {
	    local($idev) = @_;
    	    eval q({  &if ( &atomic_dec_and_test( ($idev->{refcnt})))  &in_dev_finish_destroy($idev); });
	}' unless defined(&in_dev_put);
	eval 'sub __in_dev_put {
	    local($idev) = @_;
    	    eval q( &atomic_dec(($idev)-> &refcnt));
	}' unless defined(&__in_dev_put);
	eval 'sub in_dev_hold {
	    local($idev) = @_;
    	    eval q( &atomic_inc(($idev)-> &refcnt));
	}' unless defined(&in_dev_hold);
    }
    eval 'sub inet_make_mask {
        local($logmask) = @_;
	    eval q({  &if ($logmask)  &htonl(~((1<<(32-$logmask))-1)); 0; });
    }' unless defined(&inet_make_mask);
    eval 'sub inet_mask_len {
        local($mask) = @_;
	    eval q({  &if (!($mask =  &ntohl($mask))) 0; 32-  &ffz(~$mask); });
    }' unless defined(&inet_mask_len);
}
1;
