require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&I2C_DEV_H)) {
    eval 'sub I2C_DEV_H () {1;}' unless defined(&I2C_DEV_H);
    require 'linux/types.ph';
    require 'linux/i2c.ph';
    unless(defined(&__KERNEL__)) {
	require 'sys/ioctl.ph';
	eval 'sub i2c_smbus_access {
	    local($file,$read_write,$command,$size,$data) = @_;
    	    eval q({ \'struct i2c_smbus_ioctl_data\'  &args;  ($args->{read_write}) = $read_write;  ($args->{command}) = $command;  ($args->{size}) = $size;  ($args->{data}) = $data;  &ioctl($file, &I2C_SMBUS, &args); });
	}' unless defined(&i2c_smbus_access);
	eval 'sub i2c_smbus_write_quick {
	    local($file,$value) = @_;
    	    eval q({  &i2c_smbus_access($file,$value,0, &I2C_SMBUS_QUICK, &NULL); });
	}' unless defined(&i2c_smbus_write_quick);
	eval 'sub i2c_smbus_write_byte {
	    local($file,$value) = @_;
    	    eval q({  &i2c_smbus_access($file, &I2C_SMBUS_WRITE,$value,  &I2C_SMBUS_BYTE, &NULL); });
	}' unless defined(&i2c_smbus_write_byte);
	eval 'sub i2c_smbus_read_byte_data {
	    local($file,$command) = @_;
    	    eval q({ \'union i2c_smbus_data\'  &data;  &if ( &i2c_smbus_access($file, &I2C_SMBUS_READ,$command,  &I2C_SMBUS_BYTE_DATA, &data)) -1;  &else 0xff &  ($data->{byte}); });
	}' unless defined(&i2c_smbus_read_byte_data);
	eval 'sub i2c_smbus_write_byte_data {
	    local($file,$command,$value) = @_;
    	    eval q({ \'union i2c_smbus_data\'  &data;  ($data->{byte}) = $value;  &i2c_smbus_access($file, &I2C_SMBUS_WRITE,$command,  &I2C_SMBUS_BYTE_DATA,  &data); });
	}' unless defined(&i2c_smbus_write_byte_data);
	eval 'sub i2c_smbus_read_word_data {
	    local($file,$command) = @_;
    	    eval q({ \'union i2c_smbus_data\'  &data;  &if ( &i2c_smbus_access($file, &I2C_SMBUS_READ,$command,  &I2C_SMBUS_WORD_DATA, &data)) -1;  &else 0xffff &  ($data->{word}); });
	}' unless defined(&i2c_smbus_read_word_data);
	eval 'sub i2c_smbus_write_word_data {
	    local($file,$command,$value) = @_;
    	    eval q({ \'union i2c_smbus_data\'  &data;  ($data->{word}) = $value;  &i2c_smbus_access($file, &I2C_SMBUS_WRITE,$command,  &I2C_SMBUS_WORD_DATA,  &data); });
	}' unless defined(&i2c_smbus_write_word_data);
	eval 'sub i2c_smbus_process_call {
	    local($file,$command,$value) = @_;
    	    eval q({ \'union i2c_smbus_data\'  &data;  ($data->{word}) = $value;  &if ( &i2c_smbus_access($file, &I2C_SMBUS_WRITE,$command,  &I2C_SMBUS_PROC_CALL, &data)) -1;  &else 0xffff &  ($data->{word}); });
	}' unless defined(&i2c_smbus_process_call);
	eval 'sub i2c_smbus_write_block_data {
	    local($file,$command,$length,$values) = @_;
    	    eval q({ \'union i2c_smbus_data\'  &data; \'int\'  &i;  &if ($length > 32) $length = 32;  &for ( &i = 1;  &i <= $length;  &i++)  ($data->{block[&i]}) = $values->[ &i-1];  ($data->{block[0]}) = $length;  &i2c_smbus_access($file, &I2C_SMBUS_WRITE,$command,  &I2C_SMBUS_BLOCK_DATA,  &data); });
	}' unless defined(&i2c_smbus_write_block_data);
	eval 'sub i2c_smbus_write_i2c_block_data {
	    local($file,$command,$length,$values) = @_;
    	    eval q({ \'union i2c_smbus_data\'  &data; \'int\'  &i;  &if ($length > 32) $length = 32;  &for ( &i = 1;  &i <= $length;  &i++)  ($data->{block[&i]}) = $values->[ &i-1];  ($data->{block[0]}) = $length;  &i2c_smbus_access($file, &I2C_SMBUS_WRITE,$command,  &I2C_SMBUS_I2C_BLOCK_DATA,  &data); });
	}' unless defined(&i2c_smbus_write_i2c_block_data);
    }
}
1;
