require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_HFS_SYSDEP_H)) {
    eval 'sub _HFS_SYSDEP_H () {1;}' unless defined(&_HFS_SYSDEP_H);
    require 'linux/slab.ph';
    require 'linux/types.ph';
    require 'linux/locks.ph';
    require 'linux/fs.ph';
    require 'asm/byteorder.ph';
    require 'asm/unaligned.ph';
    undef(&offsetof) if defined(&offsetof);
    eval 'sub offsetof {
        local($TYPE, $MEMB) = @_;
	    eval q(( (($TYPE *)0)->$MEMB));
    }' unless defined(&offsetof);
    eval 'sub hfs_warn () {( &format,  &args...)  &printk( &KERN_WARNING  &format ,   &args);}' unless defined(&hfs_warn);
    eval 'sub hfs_error () {( &format,  &args...)  &printk( &KERN_ERR  &format ,   &args);}' unless defined(&hfs_error);
    if(defined( &DEBUG_ALL) || defined( &DEBUG_MEM)) {
    }
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub void {
        eval q(* &hfs_malloc {  &kmalloc( &size,  &GFP_KERNEL); });
    }' unless defined(&void);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub hfs_free {
        local($ptr,$size) = @_;
	    eval q({  &kfree($ptr); });
    }' unless defined(&hfs_free);
    eval 'sub hfs_to_utc {
        local($time) = @_;
	    eval q({ $time +  ($sys_tz->{tz_minuteswest})*60; });
    }' unless defined(&hfs_to_utc);
    eval 'sub hfs_time {
        local($void) = @_;
	    eval q({  &htonl( &hfs_from_utc( &CURRENT_TIME)+2082844800); });
    }' unless defined(&hfs_time);
    eval 'sub hfs_init_waitqueue {
        local($queue) = @_;
	    eval q({  &init_waitqueue_head($queue); });
    }' unless defined(&hfs_init_waitqueue);
    eval 'sub hfs_sleep_on {
        local($queue) = @_;
	    eval q({  &sleep_on($queue); });
    }' unless defined(&hfs_sleep_on);
    eval 'sub hfs_wake_up {
        local($queue) = @_;
	    eval q({  &wake_up($queue); });
    }' unless defined(&hfs_wake_up);
    eval 'sub hfs_relinquish {
        local($void) = @_;
	    eval q({  &schedule(); });
    }' unless defined(&hfs_relinquish);
    eval 'sub hfs_mdb_dirty {
        local($sys_mdb) = @_;
	    eval q({  ($sys_mdb->{s_dirt}) = 1; });
    }' unless defined(&hfs_mdb_dirty);
    eval 'sub char {
        eval q(* &hfs_mdb_name( &hfs_sysmdb  &sys_mdb) {  &kdevname( ($sys_mdb->{s_dev})); });
    }' unless defined(&char);
    eval 'sub HFS_BAD_BUFFER () { &NULL;}' unless defined(&HFS_BAD_BUFFER);
    eval 'sub hfs_buffer_ok {
        local($buffer) = @_;
	    eval q({ ($buffer !=  &NULL); });
    }' unless defined(&hfs_buffer_ok);
    eval 'sub hfs_buffer_put {
        local($buffer) = @_;
	    eval q({  &brelse($buffer); });
    }' unless defined(&hfs_buffer_put);
    eval 'sub hfs_buffer_dirty {
        local($buffer) = @_;
	    eval q({  &mark_buffer_dirty($buffer); });
    }' unless defined(&hfs_buffer_dirty);
    eval 'sub hfs_buffer_sync {
        local($buffer) = @_;
	    eval q({  &while ( &buffer_locked($buffer)) {  &wait_on_buffer($buffer); }  &if ( &buffer_dirty($buffer)) {  &ll_rw_block( &WRITE, 1, $buffer);  &wait_on_buffer($buffer); } });
    }' unless defined(&hfs_buffer_sync);
    eval 'sub void {
        eval q(* &hfs_buffer_data( &const  &hfs_buffer  &buffer) {  ($buffer->{b_data}); });
    }' unless defined(&void);
    undef(&BITNR) if defined(&BITNR);
    if(defined( &__BIG_ENDIAN)) {
	eval 'sub BITNR {
	    local($X) = @_;
    	    eval q((($X)^31));
	}' unless defined(&BITNR);
	if(!defined( &__constant_htonl)) {
	    eval 'sub __constant_htonl {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&__constant_htonl);
	}
	if(!defined( &__constant_htons)) {
	    eval 'sub __constant_htons {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&__constant_htons);
	}
    }
 elsif(defined( &__LITTLE_ENDIAN)) {
	eval 'sub BITNR {
	    local($X) = @_;
    	    eval q((($X)^7));
	}' unless defined(&BITNR);
	if(!defined( &__constant_htonl)) {
	    eval 'sub __constant_htonl {
	        local($x) = @_;
    		eval q((((( & 0xff) << 24) | (( & 0xff00) << 8) | (( & 0xff0000) >> 8) | ((($x) & 0xff000000) >> 24))));
	    }' unless defined(&__constant_htonl);
	}
	if(!defined( &__constant_htons)) {
	    eval 'sub __constant_htons {
	        local($x) = @_;
    		eval q((((( & 0xff) << 8) | ((($x) & 0xff00) >> 8))));
	    }' unless defined(&__constant_htons);
	}
    } else {
	die("Don't know if bytes are big- or little-endian!");
    }
    eval 'sub hfs_clear_bit {
        local($bitnr,$lword) = @_;
	    eval q({  &test_and_clear_bit( &BITNR($bitnr), $lword); });
    }' unless defined(&hfs_clear_bit);
    eval 'sub hfs_set_bit {
        local($bitnr,$lword) = @_;
	    eval q({  &test_and_set_bit( &BITNR($bitnr), $lword); });
    }' unless defined(&hfs_set_bit);
    eval 'sub hfs_test_bit {
        local($bitnr,$lword) = @_;
	    eval q({  &test_bit( &BITNR($bitnr), ( &void *)$lword); });
    }' unless defined(&hfs_test_bit);
    undef(&BITNR) if defined(&BITNR);
    eval 'sub hfs_get_hs {
        local($addr) = @_;
	    eval q( &ntohs(*(( &hfs_u16 *)($addr))));
    }' unless defined(&hfs_get_hs);
    eval 'sub hfs_get_ns {
        local($addr) = @_;
	    eval q((*(( &hfs_u16 *)($addr))));
    }' unless defined(&hfs_get_ns);
    eval 'sub hfs_get_hl {
        local($addr) = @_;
	    eval q( &ntohl( &get_unaligned(( &hfs_u32 *)($addr))));
    }' unless defined(&hfs_get_hl);
    eval 'sub hfs_get_nl {
        local($addr) = @_;
	    eval q( &get_unaligned(( &hfs_u32 *)($addr)));
    }' unless defined(&hfs_get_nl);
    eval 'sub hfs_get_ahl {
        local($addr) = @_;
	    eval q( &ntohl(*(( &hfs_u32 *)($addr))));
    }' unless defined(&hfs_get_ahl);
    eval 'sub hfs_get_anl {
        local($addr) = @_;
	    eval q((*(( &hfs_u32 *)($addr))));
    }' unless defined(&hfs_get_anl);
    eval 'sub hfs_put_hs {
        local($val, $addr) = @_;
	    eval q((( &void)(*(( &hfs_u16 *)($addr)) =  &ntohs($val))));
    }' unless defined(&hfs_put_hs);
    eval 'sub hfs_put_ns {
        local($val, $addr) = @_;
	    eval q((( &void)(*(( &hfs_u16 *)($addr)) = ($val))));
    }' unless defined(&hfs_put_ns);
    eval 'sub hfs_put_hl {
        local($val, $addr) = @_;
	    eval q( &put_unaligned( &htonl($val), ( &hfs_u32 *)($addr)));
    }' unless defined(&hfs_put_hl);
    eval 'sub hfs_put_nl {
        local($val, $addr) = @_;
	    eval q( &put_unaligned(($val), ( &hfs_u32 *)($addr)));
    }' unless defined(&hfs_put_nl);
    eval 'sub hfs_put_ahl {
        local($val, $addr) = @_;
	    eval q((( &void)(*(( &hfs_u32 *)($addr)) =  &ntohl($val))));
    }' unless defined(&hfs_put_ahl);
    eval 'sub hfs_put_anl {
        local($val, $addr) = @_;
	    eval q((( &void)(*(( &hfs_u32 *)($addr)) = ($val))));
    }' unless defined(&hfs_put_anl);
}
1;
