require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_EXT3_JBD_H)) {
    eval 'sub _LINUX_EXT3_JBD_H () {1;}' unless defined(&_LINUX_EXT3_JBD_H);
    require 'linux/fs.ph';
    require 'linux/jbd.ph';
    require 'linux/ext3_fs.ph';
    eval 'sub EXT3_JOURNAL {
        local($inode) = @_;
	    eval q(( &EXT3_SB(($inode)-> &i_sb)-> &s_journal));
    }' unless defined(&EXT3_JOURNAL);
    eval 'sub EXT3_SINGLEDATA_TRANS_BLOCKS () {8;}' unless defined(&EXT3_SINGLEDATA_TRANS_BLOCKS);
    eval 'sub EXT3_DATA_TRANS_BLOCKS () {(3*  &EXT3_SINGLEDATA_TRANS_BLOCKS - 2);}' unless defined(&EXT3_DATA_TRANS_BLOCKS);
    eval 'sub EXT3_DELETE_TRANS_BLOCKS () {(2*  &EXT3_DATA_TRANS_BLOCKS + 64);}' unless defined(&EXT3_DELETE_TRANS_BLOCKS);
    eval 'sub EXT3_MAX_TRANS_DATA () {64;}' unless defined(&EXT3_MAX_TRANS_DATA);
    eval 'sub EXT3_RESERVE_TRANS_BLOCKS () {12;}' unless defined(&EXT3_RESERVE_TRANS_BLOCKS);
    eval 'sub __ext3_journal_get_undo_access {
        local($where,$handle,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_get_undo_access($handle, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_get_undo_access);
    eval 'sub __ext3_journal_get_write_access {
        local($where,$handle,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_get_write_access($handle, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_get_write_access);
    eval 'sub __ext3_journal_dirty_data {
        local($where,$handle,$bh,$async) = @_;
	    eval q({ \'int\'  &err =  &journal_dirty_data($handle, $bh, $async);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_dirty_data);
    eval 'sub ext3_journal_forget {
        local($handle,$bh) = @_;
	    eval q({  &journal_forget($handle, $bh); });
    }' unless defined(&ext3_journal_forget);
    eval 'sub __ext3_journal_revoke {
        local($where,$handle,$blocknr,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_revoke($handle, $blocknr, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_revoke);
    eval 'sub __ext3_journal_get_create_access {
        local($where,$handle,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_get_create_access($handle, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_get_create_access);
    eval 'sub __ext3_journal_dirty_metadata {
        local($where,$handle,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_dirty_metadata($handle, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_dirty_metadata);
    eval 'sub ext3_journal_get_undo_access {
        local($handle, $bh) = @_;
	    eval q( &__ext3_journal_get_undo_access( &__FUNCTION__, ($handle), ($bh)));
    }' unless defined(&ext3_journal_get_undo_access);
    eval 'sub ext3_journal_get_write_access {
        local($handle, $bh) = @_;
	    eval q( &__ext3_journal_get_write_access( &__FUNCTION__, ($handle), ($bh)));
    }' unless defined(&ext3_journal_get_write_access);
    eval 'sub ext3_journal_dirty_data {
        local($handle, $bh, $async) = @_;
	    eval q( &__ext3_journal_dirty_data( &__FUNCTION__, ($handle), ($bh), ($async)));
    }' unless defined(&ext3_journal_dirty_data);
    eval 'sub ext3_journal_revoke {
        local($handle, $blocknr, $bh) = @_;
	    eval q( &__ext3_journal_revoke( &__FUNCTION__, ($handle), ($blocknr), ($bh)));
    }' unless defined(&ext3_journal_revoke);
    eval 'sub ext3_journal_get_create_access {
        local($handle, $bh) = @_;
	    eval q( &__ext3_journal_get_create_access( &__FUNCTION__, ($handle), ($bh)));
    }' unless defined(&ext3_journal_get_create_access);
    eval 'sub ext3_journal_dirty_metadata {
        local($handle, $bh) = @_;
	    eval q( &__ext3_journal_dirty_metadata( &__FUNCTION__, ($handle), ($bh)));
    }' unless defined(&ext3_journal_dirty_metadata);
    eval 'sub ext3_journal_try_start {
        local($inode,$nblocks) = @_;
	    eval q({  &if ( ($inode->{i_sb}->{s_flags}) &  &MS_RDONLY)  &ERR_PTR(- &EROFS);  &journal_try_start( &EXT3_JOURNAL($inode), $nblocks); });
    }' unless defined(&ext3_journal_try_start);
    eval 'sub ext3_journal_stop {
        local($handle, $inode) = @_;
	    eval q( &__ext3_journal_stop( &__FUNCTION__, ($handle), ($inode)));
    }' unless defined(&ext3_journal_stop);
    eval 'sub handle_t {
        eval q(* &ext3_journal_current_handle( &void) {  &journal_current_handle(); });
    }' unless defined(&handle_t);
    eval 'sub ext3_log_start_commit {
        local($journal,$transaction) = @_;
	    eval q({  &log_start_commit($journal, $transaction); });
    }' unless defined(&ext3_log_start_commit);
    eval 'sub ext3_log_wait_commit {
        local($journal,$tid) = @_;
	    eval q({  &log_wait_commit($journal, $tid); });
    }' unless defined(&ext3_log_wait_commit);
    eval 'sub ext3_journal_extend {
        local($handle,$nblocks) = @_;
	    eval q({  &journal_extend($handle, $nblocks); });
    }' unless defined(&ext3_journal_extend);
    eval 'sub ext3_journal_restart {
        local($handle,$nblocks) = @_;
	    eval q({  &journal_restart($handle, $nblocks); });
    }' unless defined(&ext3_journal_restart);
    eval 'sub ext3_journal_blocks_per_page {
        local($inode) = @_;
	    eval q({  &journal_blocks_per_page($inode); });
    }' unless defined(&ext3_journal_blocks_per_page);
    eval 'sub ext3_journal_force_commit {
        local($journal) = @_;
	    eval q({  &journal_force_commit($journal); });
    }' unless defined(&ext3_journal_force_commit);
    eval 'sub ext3_should_journal_data {
        local($inode) = @_;
	    eval q({  &if (! &S_ISREG( ($inode->{i_mode}))) 1;  &if ( &test_opt( ($inode->{i_sb}),  &DATA_FLAGS) ==  &EXT3_MOUNT_JOURNAL_DATA) 1;  &if ( ($inode->{u}->{ext3_i}->{i_flags}) &  &EXT3_JOURNAL_DATA_FL) 1; 0; });
    }' unless defined(&ext3_should_journal_data);
    eval 'sub ext3_should_order_data {
        local($inode) = @_;
	    eval q({ ( &test_opt( ($inode->{i_sb}),  &DATA_FLAGS) ==  &EXT3_MOUNT_ORDERED_DATA); });
    }' unless defined(&ext3_should_order_data);
}
1;
