require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_EXT2_FS_H)) {
    eval 'sub _LINUX_EXT2_FS_H () {1;}' unless defined(&_LINUX_EXT2_FS_H);
    require 'linux/types.ph';
    undef(&EXT2FS_DEBUG) if defined(&EXT2FS_DEBUG);
    eval 'sub EXT2_PREALLOCATE () {1;}' unless defined(&EXT2_PREALLOCATE);
    eval 'sub EXT2_DEFAULT_PREALLOC_BLOCKS () {8;}' unless defined(&EXT2_DEFAULT_PREALLOC_BLOCKS);
    eval 'sub EXT2FS_DATE () {"95/08/09";}' unless defined(&EXT2FS_DATE);
    eval 'sub EXT2FS_VERSION () {"0.5b";}' unless defined(&EXT2FS_VERSION);
    if(defined(&EXT2FS_DEBUG)) {
	eval 'sub ext2_debug () {( &f,  &a...) {  &printk ("EXT2-fs DEBUG (%s, %d): %s:",  &__FILE__,  &__LINE__,  &__FUNCTION__);  &printk ( &f,   &a); };}' unless defined(&ext2_debug);
    } else {
	eval 'sub ext2_debug () {( &f,  &a...);}' unless defined(&ext2_debug);
    }
    eval 'sub EXT2_BAD_INO () {1;}' unless defined(&EXT2_BAD_INO);
    eval 'sub EXT2_ROOT_INO () {2;}' unless defined(&EXT2_ROOT_INO);
    eval 'sub EXT2_ACL_IDX_INO () {3;}' unless defined(&EXT2_ACL_IDX_INO);
    eval 'sub EXT2_ACL_DATA_INO () {4;}' unless defined(&EXT2_ACL_DATA_INO);
    eval 'sub EXT2_BOOT_LOADER_INO () {5;}' unless defined(&EXT2_BOOT_LOADER_INO);
    eval 'sub EXT2_UNDEL_DIR_INO () {6;}' unless defined(&EXT2_UNDEL_DIR_INO);
    eval 'sub EXT2_GOOD_OLD_FIRST_INO () {11;}' unless defined(&EXT2_GOOD_OLD_FIRST_INO);
    eval 'sub EXT2_SUPER_MAGIC () {0xef53;}' unless defined(&EXT2_SUPER_MAGIC);
    eval 'sub EXT2_LINK_MAX () {32000;}' unless defined(&EXT2_LINK_MAX);
    eval 'sub EXT2_MIN_BLOCK_SIZE () {1024;}' unless defined(&EXT2_MIN_BLOCK_SIZE);
    eval 'sub EXT2_MAX_BLOCK_SIZE () {4096;}' unless defined(&EXT2_MAX_BLOCK_SIZE);
    eval 'sub EXT2_MIN_BLOCK_LOG_SIZE () {10;}' unless defined(&EXT2_MIN_BLOCK_LOG_SIZE);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT2_BLOCK_SIZE {
	    local($s) = @_;
    	    eval q((($s)-> &s_blocksize));
	}' unless defined(&EXT2_BLOCK_SIZE);
    } else {
	eval 'sub EXT2_BLOCK_SIZE {
	    local($s) = @_;
    	    eval q(( &EXT2_MIN_BLOCK_SIZE << ($s)-> &s_log_block_size));
	}' unless defined(&EXT2_BLOCK_SIZE);
    }
    eval 'sub EXT2_ACLE_PER_BLOCK {
        local($s) = @_;
	    eval q(( &EXT2_BLOCK_SIZE($s) / $sizeof{\'struct ext2_acl_entry\'}));
    }' unless defined(&EXT2_ACLE_PER_BLOCK);
    eval 'sub EXT2_ADDR_PER_BLOCK {
        local($s) = @_;
	    eval q(( &EXT2_BLOCK_SIZE($s) / $sizeof{ &__u32}));
    }' unless defined(&EXT2_ADDR_PER_BLOCK);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT2_BLOCK_SIZE_BITS {
	    local($s) = @_;
    	    eval q((($s)-> &s_blocksize_bits));
	}' unless defined(&EXT2_BLOCK_SIZE_BITS);
    } else {
	eval 'sub EXT2_BLOCK_SIZE_BITS {
	    local($s) = @_;
    	    eval q((($s)-> &s_log_block_size + 10));
	}' unless defined(&EXT2_BLOCK_SIZE_BITS);
    }
    if(defined(&__KERNEL__)) {
	eval 'sub EXT2_ADDR_PER_BLOCK_BITS {
	    local($s) = @_;
    	    eval q((($s)-> ($u->{ext2_sb}->{s_addr_per_block_bits})));
	}' unless defined(&EXT2_ADDR_PER_BLOCK_BITS);
	eval 'sub EXT2_INODE_SIZE {
	    local($s) = @_;
    	    eval q((($s)-> ($u->{ext2_sb}->{s_inode_size})));
	}' unless defined(&EXT2_INODE_SIZE);
	eval 'sub EXT2_FIRST_INO {
	    local($s) = @_;
    	    eval q((($s)-> ($u->{ext2_sb}->{s_first_ino})));
	}' unless defined(&EXT2_FIRST_INO);
    } else {
	eval 'sub EXT2_INODE_SIZE {
	    local($s) = @_;
    	    eval q(((($s)-> &s_rev_level ==  &EXT2_GOOD_OLD_REV) ?  &EXT2_GOOD_OLD_INODE_SIZE : ($s)-> &s_inode_size));
	}' unless defined(&EXT2_INODE_SIZE);
	eval 'sub EXT2_FIRST_INO {
	    local($s) = @_;
    	    eval q(((($s)-> &s_rev_level ==  &EXT2_GOOD_OLD_REV) ?  &EXT2_GOOD_OLD_FIRST_INO : ($s)-> &s_first_ino));
	}' unless defined(&EXT2_FIRST_INO);
    }
    eval 'sub EXT2_MIN_FRAG_SIZE () {1024;}' unless defined(&EXT2_MIN_FRAG_SIZE);
    eval 'sub EXT2_MAX_FRAG_SIZE () {4096;}' unless defined(&EXT2_MAX_FRAG_SIZE);
    eval 'sub EXT2_MIN_FRAG_LOG_SIZE () {10;}' unless defined(&EXT2_MIN_FRAG_LOG_SIZE);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT2_FRAG_SIZE {
	    local($s) = @_;
    	    eval q((($s)-> ($u->{ext2_sb}->{s_frag_size})));
	}' unless defined(&EXT2_FRAG_SIZE);
	eval 'sub EXT2_FRAGS_PER_BLOCK {
	    local($s) = @_;
    	    eval q((($s)-> ($u->{ext2_sb}->{s_frags_per_block})));
	}' unless defined(&EXT2_FRAGS_PER_BLOCK);
    } else {
	eval 'sub EXT2_FRAG_SIZE {
	    local($s) = @_;
    	    eval q(( &EXT2_MIN_FRAG_SIZE << ($s)-> &s_log_frag_size));
	}' unless defined(&EXT2_FRAG_SIZE);
	eval 'sub EXT2_FRAGS_PER_BLOCK {
	    local($s) = @_;
    	    eval q(( &EXT2_BLOCK_SIZE($s) /  &EXT2_FRAG_SIZE($s)));
	}' unless defined(&EXT2_FRAGS_PER_BLOCK);
    }
    if(defined(&__KERNEL__)) {
	eval 'sub EXT2_BLOCKS_PER_GROUP {
	    local($s) = @_;
    	    eval q((($s)-> ($u->{ext2_sb}->{s_blocks_per_group})));
	}' unless defined(&EXT2_BLOCKS_PER_GROUP);
	eval 'sub EXT2_DESC_PER_BLOCK {
	    local($s) = @_;
    	    eval q((($s)-> ($u->{ext2_sb}->{s_desc_per_block})));
	}' unless defined(&EXT2_DESC_PER_BLOCK);
	eval 'sub EXT2_INODES_PER_GROUP {
	    local($s) = @_;
    	    eval q((($s)-> ($u->{ext2_sb}->{s_inodes_per_group})));
	}' unless defined(&EXT2_INODES_PER_GROUP);
	eval 'sub EXT2_DESC_PER_BLOCK_BITS {
	    local($s) = @_;
    	    eval q((($s)-> ($u->{ext2_sb}->{s_desc_per_block_bits})));
	}' unless defined(&EXT2_DESC_PER_BLOCK_BITS);
    } else {
	eval 'sub EXT2_BLOCKS_PER_GROUP {
	    local($s) = @_;
    	    eval q((($s)-> &s_blocks_per_group));
	}' unless defined(&EXT2_BLOCKS_PER_GROUP);
	eval 'sub EXT2_DESC_PER_BLOCK {
	    local($s) = @_;
    	    eval q(( &EXT2_BLOCK_SIZE($s) / $sizeof{\'struct ext2_group_desc\'}));
	}' unless defined(&EXT2_DESC_PER_BLOCK);
	eval 'sub EXT2_INODES_PER_GROUP {
	    local($s) = @_;
    	    eval q((($s)-> &s_inodes_per_group));
	}' unless defined(&EXT2_INODES_PER_GROUP);
    }
    eval 'sub EXT2_NDIR_BLOCKS () {12;}' unless defined(&EXT2_NDIR_BLOCKS);
    eval 'sub EXT2_IND_BLOCK () { &EXT2_NDIR_BLOCKS;}' unless defined(&EXT2_IND_BLOCK);
    eval 'sub EXT2_DIND_BLOCK () {( &EXT2_IND_BLOCK + 1);}' unless defined(&EXT2_DIND_BLOCK);
    eval 'sub EXT2_TIND_BLOCK () {( &EXT2_DIND_BLOCK + 1);}' unless defined(&EXT2_TIND_BLOCK);
    eval 'sub EXT2_N_BLOCKS () {( &EXT2_TIND_BLOCK + 1);}' unless defined(&EXT2_N_BLOCKS);
    eval 'sub EXT2_SECRM_FL () {0x1;}' unless defined(&EXT2_SECRM_FL);
    eval 'sub EXT2_UNRM_FL () {0x2;}' unless defined(&EXT2_UNRM_FL);
    eval 'sub EXT2_COMPR_FL () {0x4;}' unless defined(&EXT2_COMPR_FL);
    eval 'sub EXT2_SYNC_FL () {0x8;}' unless defined(&EXT2_SYNC_FL);
    eval 'sub EXT2_IMMUTABLE_FL () {0x10;}' unless defined(&EXT2_IMMUTABLE_FL);
    eval 'sub EXT2_APPEND_FL () {0x20;}' unless defined(&EXT2_APPEND_FL);
    eval 'sub EXT2_NODUMP_FL () {0x40;}' unless defined(&EXT2_NODUMP_FL);
    eval 'sub EXT2_NOATIME_FL () {0x80;}' unless defined(&EXT2_NOATIME_FL);
    eval 'sub EXT2_DIRTY_FL () {0x100;}' unless defined(&EXT2_DIRTY_FL);
    eval 'sub EXT2_COMPRBLK_FL () {0x200;}' unless defined(&EXT2_COMPRBLK_FL);
    eval 'sub EXT2_NOCOMP_FL () {0x400;}' unless defined(&EXT2_NOCOMP_FL);
    eval 'sub EXT2_ECOMPR_FL () {0x800;}' unless defined(&EXT2_ECOMPR_FL);
    eval 'sub EXT2_BTREE_FL () {0x1000;}' unless defined(&EXT2_BTREE_FL);
    eval 'sub EXT2_RESERVED_FL () {0x80000000;}' unless defined(&EXT2_RESERVED_FL);
    eval 'sub EXT2_FL_USER_VISIBLE () {0x1fff;}' unless defined(&EXT2_FL_USER_VISIBLE);
    eval 'sub EXT2_FL_USER_MODIFIABLE () {0xff;}' unless defined(&EXT2_FL_USER_MODIFIABLE);
    eval 'sub EXT2_IOC_GETFLAGS () { &_IOR(ord(\'f\'), 1, \'long\');}' unless defined(&EXT2_IOC_GETFLAGS);
    eval 'sub EXT2_IOC_SETFLAGS () { &_IOW(ord(\'f\'), 2, \'long\');}' unless defined(&EXT2_IOC_SETFLAGS);
    eval 'sub EXT2_IOC_GETVERSION () { &_IOR(ord(\'v\'), 1, \'long\');}' unless defined(&EXT2_IOC_GETVERSION);
    eval 'sub EXT2_IOC_SETVERSION () { &_IOW(ord(\'v\'), 2, \'long\');}' unless defined(&EXT2_IOC_SETVERSION);
    eval 'sub i_size_high () { &i_dir_acl;}' unless defined(&i_size_high);
    if(defined( &__KERNEL__) || defined( &__linux__)) {
	eval 'sub i_reserved1 () { ($osd1->{linux1}->{l_i_reserved1});}' unless defined(&i_reserved1);
	eval 'sub i_frag () { ($osd2->{linux2}->{l_i_frag});}' unless defined(&i_frag);
	eval 'sub i_fsize () { ($osd2->{linux2}->{l_i_fsize});}' unless defined(&i_fsize);
	eval 'sub i_uid_low () { &i_uid;}' unless defined(&i_uid_low);
	eval 'sub i_gid_low () { &i_gid;}' unless defined(&i_gid_low);
	eval 'sub i_uid_high () { ($osd2->{linux2}->{l_i_uid_high});}' unless defined(&i_uid_high);
	eval 'sub i_gid_high () { ($osd2->{linux2}->{l_i_gid_high});}' unless defined(&i_gid_high);
	eval 'sub i_reserved2 () { ($osd2->{linux2}->{l_i_reserved2});}' unless defined(&i_reserved2);
    }
    if(defined(&__hurd__)) {
	eval 'sub i_translator () { ($osd1->{hurd1}->{h_i_translator});}' unless defined(&i_translator);
	eval 'sub i_frag () { ($osd2->{hurd2}->{h_i_frag});;}' unless defined(&i_frag);
	eval 'sub i_fsize () { ($osd2->{hurd2}->{h_i_fsize});;}' unless defined(&i_fsize);
	eval 'sub i_uid_high () { ($osd2->{hurd2}->{h_i_uid_high});}' unless defined(&i_uid_high);
	eval 'sub i_gid_high () { ($osd2->{hurd2}->{h_i_gid_high});}' unless defined(&i_gid_high);
	eval 'sub i_author () { ($osd2->{hurd2}->{h_i_author});}' unless defined(&i_author);
    }
    if(defined(&__masix__)) {
	eval 'sub i_reserved1 () { ($osd1->{masix1}->{m_i_reserved1});}' unless defined(&i_reserved1);
	eval 'sub i_frag () { ($osd2->{masix2}->{m_i_frag});}' unless defined(&i_frag);
	eval 'sub i_fsize () { ($osd2->{masix2}->{m_i_fsize});}' unless defined(&i_fsize);
	eval 'sub i_reserved2 () { ($osd2->{masix2}->{m_i_reserved2});}' unless defined(&i_reserved2);
    }
    eval 'sub EXT2_VALID_FS () {0x1;}' unless defined(&EXT2_VALID_FS);
    eval 'sub EXT2_ERROR_FS () {0x2;}' unless defined(&EXT2_ERROR_FS);
    eval 'sub EXT2_MOUNT_CHECK () {0x1;}' unless defined(&EXT2_MOUNT_CHECK);
    eval 'sub EXT2_MOUNT_GRPID () {0x4;}' unless defined(&EXT2_MOUNT_GRPID);
    eval 'sub EXT2_MOUNT_DEBUG () {0x8;}' unless defined(&EXT2_MOUNT_DEBUG);
    eval 'sub EXT2_MOUNT_ERRORS_CONT () {0x10;}' unless defined(&EXT2_MOUNT_ERRORS_CONT);
    eval 'sub EXT2_MOUNT_ERRORS_RO () {0x20;}' unless defined(&EXT2_MOUNT_ERRORS_RO);
    eval 'sub EXT2_MOUNT_ERRORS_PANIC () {0x40;}' unless defined(&EXT2_MOUNT_ERRORS_PANIC);
    eval 'sub EXT2_MOUNT_MINIX_DF () {0x80;}' unless defined(&EXT2_MOUNT_MINIX_DF);
    eval 'sub EXT2_MOUNT_NO_UID32 () {0x200;}' unless defined(&EXT2_MOUNT_NO_UID32);
    eval 'sub clear_opt {
        local($o, $opt) = @_;
	    eval q($o &= ~ &EXT2_MOUNT_$opt);
    }' unless defined(&clear_opt);
    eval 'sub set_opt {
        local($o, $opt) = @_;
	    eval q($o |=  &EXT2_MOUNT_$opt);
    }' unless defined(&set_opt);
    eval 'sub test_opt {
        local($sb, $opt) = @_;
	    eval q((($sb)-> ($u->{ext2_sb}->{s_mount_opt}) &  &EXT2_MOUNT_$opt));
    }' unless defined(&test_opt);
    eval 'sub EXT2_DFL_MAX_MNT_COUNT () {20;}' unless defined(&EXT2_DFL_MAX_MNT_COUNT);
    eval 'sub EXT2_DFL_CHECKINTERVAL () {0;}' unless defined(&EXT2_DFL_CHECKINTERVAL);
    eval 'sub EXT2_ERRORS_CONTINUE () {1;}' unless defined(&EXT2_ERRORS_CONTINUE);
    eval 'sub EXT2_ERRORS_RO () {2;}' unless defined(&EXT2_ERRORS_RO);
    eval 'sub EXT2_ERRORS_PANIC () {3;}' unless defined(&EXT2_ERRORS_PANIC);
    eval 'sub EXT2_ERRORS_DEFAULT () { &EXT2_ERRORS_CONTINUE;}' unless defined(&EXT2_ERRORS_DEFAULT);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT2_SB {
	    local($sb) = @_;
    	    eval q(((($sb)-> ($u->{ext2_sb}))));
	}' unless defined(&EXT2_SB);
    } else {
	eval 'sub EXT2_SB {
	    local($sb) = @_;
    	    eval q(($sb));
	}' unless defined(&EXT2_SB);
    }
    eval 'sub EXT2_OS_LINUX () {0;}' unless defined(&EXT2_OS_LINUX);
    eval 'sub EXT2_OS_HURD () {1;}' unless defined(&EXT2_OS_HURD);
    eval 'sub EXT2_OS_MASIX () {2;}' unless defined(&EXT2_OS_MASIX);
    eval 'sub EXT2_OS_FREEBSD () {3;}' unless defined(&EXT2_OS_FREEBSD);
    eval 'sub EXT2_OS_LITES () {4;}' unless defined(&EXT2_OS_LITES);
    eval 'sub EXT2_GOOD_OLD_REV () {0;}' unless defined(&EXT2_GOOD_OLD_REV);
    eval 'sub EXT2_DYNAMIC_REV () {1;}' unless defined(&EXT2_DYNAMIC_REV);
    eval 'sub EXT2_CURRENT_REV () { &EXT2_GOOD_OLD_REV;}' unless defined(&EXT2_CURRENT_REV);
    eval 'sub EXT2_MAX_SUPP_REV () { &EXT2_DYNAMIC_REV;}' unless defined(&EXT2_MAX_SUPP_REV);
    eval 'sub EXT2_GOOD_OLD_INODE_SIZE () {128;}' unless defined(&EXT2_GOOD_OLD_INODE_SIZE);
    eval 'sub EXT2_HAS_COMPAT_FEATURE {
        local($sb,$mask) = @_;
	    eval q((  &EXT2_SB($sb)-> ($s_es->{s_feature_compat}) &  &cpu_to_le32($mask) ));
    }' unless defined(&EXT2_HAS_COMPAT_FEATURE);
    eval 'sub EXT2_HAS_RO_COMPAT_FEATURE {
        local($sb,$mask) = @_;
	    eval q((  &EXT2_SB($sb)-> ($s_es->{s_feature_ro_compat}) &  &cpu_to_le32($mask) ));
    }' unless defined(&EXT2_HAS_RO_COMPAT_FEATURE);
    eval 'sub EXT2_HAS_INCOMPAT_FEATURE {
        local($sb,$mask) = @_;
	    eval q((  &EXT2_SB($sb)-> ($s_es->{s_feature_incompat}) &  &cpu_to_le32($mask) ));
    }' unless defined(&EXT2_HAS_INCOMPAT_FEATURE);
    eval 'sub EXT2_SET_COMPAT_FEATURE {
        local($sb,$mask) = @_;
	    eval q( &EXT2_SB($sb)-> ($s_es->{s_feature_compat}) |=  &cpu_to_le32($mask));
    }' unless defined(&EXT2_SET_COMPAT_FEATURE);
    eval 'sub EXT2_SET_RO_COMPAT_FEATURE {
        local($sb,$mask) = @_;
	    eval q( &EXT2_SB($sb)-> ($s_es->{s_feature_ro_compat}) |=  &cpu_to_le32($mask));
    }' unless defined(&EXT2_SET_RO_COMPAT_FEATURE);
    eval 'sub EXT2_SET_INCOMPAT_FEATURE {
        local($sb,$mask) = @_;
	    eval q( &EXT2_SB($sb)-> ($s_es->{s_feature_incompat}) |=  &cpu_to_le32($mask));
    }' unless defined(&EXT2_SET_INCOMPAT_FEATURE);
    eval 'sub EXT2_CLEAR_COMPAT_FEATURE {
        local($sb,$mask) = @_;
	    eval q( &EXT2_SB($sb)-> ($s_es->{s_feature_compat}) &= ~ &cpu_to_le32($mask));
    }' unless defined(&EXT2_CLEAR_COMPAT_FEATURE);
    eval 'sub EXT2_CLEAR_RO_COMPAT_FEATURE {
        local($sb,$mask) = @_;
	    eval q( &EXT2_SB($sb)-> ($s_es->{s_feature_ro_compat}) &= ~ &cpu_to_le32($mask));
    }' unless defined(&EXT2_CLEAR_RO_COMPAT_FEATURE);
    eval 'sub EXT2_CLEAR_INCOMPAT_FEATURE {
        local($sb,$mask) = @_;
	    eval q( &EXT2_SB($sb)-> ($s_es->{s_feature_incompat}) &= ~ &cpu_to_le32($mask));
    }' unless defined(&EXT2_CLEAR_INCOMPAT_FEATURE);
    eval 'sub EXT2_FEATURE_COMPAT_DIR_PREALLOC () {0x1;}' unless defined(&EXT2_FEATURE_COMPAT_DIR_PREALLOC);
    eval 'sub EXT2_FEATURE_COMPAT_IMAGIC_INODES () {0x2;}' unless defined(&EXT2_FEATURE_COMPAT_IMAGIC_INODES);
    eval 'sub EXT3_FEATURE_COMPAT_HAS_JOURNAL () {0x4;}' unless defined(&EXT3_FEATURE_COMPAT_HAS_JOURNAL);
    eval 'sub EXT2_FEATURE_COMPAT_EXT_ATTR () {0x8;}' unless defined(&EXT2_FEATURE_COMPAT_EXT_ATTR);
    eval 'sub EXT2_FEATURE_COMPAT_RESIZE_INO () {0x10;}' unless defined(&EXT2_FEATURE_COMPAT_RESIZE_INO);
    eval 'sub EXT2_FEATURE_COMPAT_DIR_INDEX () {0x20;}' unless defined(&EXT2_FEATURE_COMPAT_DIR_INDEX);
    eval 'sub EXT2_FEATURE_COMPAT_ANY () {0xffffffff;}' unless defined(&EXT2_FEATURE_COMPAT_ANY);
    eval 'sub EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER () {0x1;}' unless defined(&EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER);
    eval 'sub EXT2_FEATURE_RO_COMPAT_LARGE_FILE () {0x2;}' unless defined(&EXT2_FEATURE_RO_COMPAT_LARGE_FILE);
    eval 'sub EXT2_FEATURE_RO_COMPAT_BTREE_DIR () {0x4;}' unless defined(&EXT2_FEATURE_RO_COMPAT_BTREE_DIR);
    eval 'sub EXT2_FEATURE_RO_COMPAT_ANY () {0xffffffff;}' unless defined(&EXT2_FEATURE_RO_COMPAT_ANY);
    eval 'sub EXT2_FEATURE_INCOMPAT_COMPRESSION () {0x1;}' unless defined(&EXT2_FEATURE_INCOMPAT_COMPRESSION);
    eval 'sub EXT2_FEATURE_INCOMPAT_FILETYPE () {0x2;}' unless defined(&EXT2_FEATURE_INCOMPAT_FILETYPE);
    eval 'sub EXT3_FEATURE_INCOMPAT_RECOVER () {0x4;}' unless defined(&EXT3_FEATURE_INCOMPAT_RECOVER);
    eval 'sub EXT3_FEATURE_INCOMPAT_JOURNAL_DEV () {0x8;}' unless defined(&EXT3_FEATURE_INCOMPAT_JOURNAL_DEV);
    eval 'sub EXT2_FEATURE_INCOMPAT_META_BG () {0x10;}' unless defined(&EXT2_FEATURE_INCOMPAT_META_BG);
    eval 'sub EXT2_FEATURE_INCOMPAT_ANY () {0xffffffff;}' unless defined(&EXT2_FEATURE_INCOMPAT_ANY);
    eval 'sub EXT2_FEATURE_COMPAT_SUPP () {0;}' unless defined(&EXT2_FEATURE_COMPAT_SUPP);
    eval 'sub EXT2_FEATURE_INCOMPAT_SUPP () {( &EXT2_FEATURE_INCOMPAT_FILETYPE|  &EXT2_FEATURE_INCOMPAT_META_BG);}' unless defined(&EXT2_FEATURE_INCOMPAT_SUPP);
    eval 'sub EXT2_FEATURE_RO_COMPAT_SUPP () {( &EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER|  &EXT2_FEATURE_RO_COMPAT_LARGE_FILE|  &EXT2_FEATURE_RO_COMPAT_BTREE_DIR);}' unless defined(&EXT2_FEATURE_RO_COMPAT_SUPP);
    eval 'sub EXT2_FEATURE_RO_COMPAT_UNSUPPORTED () {~ &EXT2_FEATURE_RO_COMPAT_SUPP;}' unless defined(&EXT2_FEATURE_RO_COMPAT_UNSUPPORTED);
    eval 'sub EXT2_FEATURE_INCOMPAT_UNSUPPORTED () {~ &EXT2_FEATURE_INCOMPAT_SUPP;}' unless defined(&EXT2_FEATURE_INCOMPAT_UNSUPPORTED);
    eval 'sub EXT2_DEFM_DEBUG () {0x1;}' unless defined(&EXT2_DEFM_DEBUG);
    eval 'sub EXT2_DEFM_BSDGROUPS () {0x2;}' unless defined(&EXT2_DEFM_BSDGROUPS);
    eval 'sub EXT2_DEFM_XATTR_USER () {0x4;}' unless defined(&EXT2_DEFM_XATTR_USER);
    eval 'sub EXT2_DEFM_ACL () {0x8;}' unless defined(&EXT2_DEFM_ACL);
    eval 'sub EXT2_DEFM_UID16 () {0x10;}' unless defined(&EXT2_DEFM_UID16);
    eval 'sub EXT3_DEFM_JMODE () {0x60;}' unless defined(&EXT3_DEFM_JMODE);
    eval 'sub EXT3_DEFM_JMODE_DATA () {0x20;}' unless defined(&EXT3_DEFM_JMODE_DATA);
    eval 'sub EXT3_DEFM_JMODE_ORDERED () {0x40;}' unless defined(&EXT3_DEFM_JMODE_ORDERED);
    eval 'sub EXT3_DEFM_JMODE_WBACK () {0x60;}' unless defined(&EXT3_DEFM_JMODE_WBACK);
    eval 'sub EXT2_DEF_RESUID () {0;}' unless defined(&EXT2_DEF_RESUID);
    eval 'sub EXT2_DEF_RESGID () {0;}' unless defined(&EXT2_DEF_RESGID);
    eval 'sub EXT2_NAME_LEN () {255;}' unless defined(&EXT2_NAME_LEN);
    eval("sub EXT2_FT_UNKNOWN () { 0; }") unless defined(&EXT2_FT_UNKNOWN);
    eval("sub EXT2_FT_REG_FILE () { 1; }") unless defined(&EXT2_FT_REG_FILE);
    eval("sub EXT2_FT_DIR () { 2; }") unless defined(&EXT2_FT_DIR);
    eval("sub EXT2_FT_CHRDEV () { 3; }") unless defined(&EXT2_FT_CHRDEV);
    eval("sub EXT2_FT_BLKDEV () { 4; }") unless defined(&EXT2_FT_BLKDEV);
    eval("sub EXT2_FT_FIFO () { 5; }") unless defined(&EXT2_FT_FIFO);
    eval("sub EXT2_FT_SOCK () { 6; }") unless defined(&EXT2_FT_SOCK);
    eval("sub EXT2_FT_SYMLINK () { 7; }") unless defined(&EXT2_FT_SYMLINK);
    eval("sub EXT2_FT_MAX () { 8; }") unless defined(&EXT2_FT_MAX);
    eval 'sub EXT2_DIR_PAD () {4;}' unless defined(&EXT2_DIR_PAD);
    eval 'sub EXT2_DIR_ROUND () {( &EXT2_DIR_PAD - 1);}' unless defined(&EXT2_DIR_ROUND);
    eval 'sub EXT2_DIR_REC_LEN {
        local($name_len) = @_;
	    eval q(((($name_len) + 8+  &EXT2_DIR_ROUND) & ~ &EXT2_DIR_ROUND));
    }' unless defined(&EXT2_DIR_REC_LEN);
    if(defined(&__KERNEL__)) {
	eval 'sub NORET_TYPE () {1;}' unless defined(&NORET_TYPE);
	eval 'sub ATTRIB_NORET () { &__attribute__(( &noreturn));}' unless defined(&ATTRIB_NORET);
	eval 'sub NORET_AND () { &noreturn,;}' unless defined(&NORET_AND);
    }
}
1;
