require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&COMPATMAC_H)) {
    eval 'sub COMPATMAC_H () {1;}' unless defined(&COMPATMAC_H);
    require 'linux/version.ph';
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) < 0x20100 ) {
	eval 'sub TWO_ZERO () {1;}' unless defined(&TWO_ZERO);
    } else {
	if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) < 0x20200 ) {
	    warn("\"Please\ use\ a\ 2\.2\.x\ kernel\.\ \"");
	} else {
	    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) < 0x20300 ) {
		eval 'sub TWO_TWO () {1;}' unless defined(&TWO_TWO);
	    } else {
		eval 'sub TWO_THREE () {1;}' unless defined(&TWO_THREE);
	    }
	}
    }
    if(defined(&TWO_ZERO)) {
	eval 'sub MAX_SCHEDULE_TIMEOUT () {((~0>>1));}' unless defined(&MAX_SCHEDULE_TIMEOUT);
	require 'linux/bios32.ph';
	eval 'sub Get_user {
	    local($a,$b) = @_;
    	    eval q($a =  &get_user($b));
	}' unless defined(&Get_user);
	eval 'sub Put_user {
	    local($a,$b) = @_;
    	    eval q(0, &put_user($a,$b));
	}' unless defined(&Put_user);
	eval 'sub copy_to_user {
	    local($a,$b,$c) = @_;
    	    eval q( &memcpy_tofs($a,$b,$c));
	}' unless defined(&copy_to_user);
	eval 'sub copy_from_user {
	    local($to,$from,$c) = @_;
    	    eval q({  &memcpy_fromfs($to, $from, $c); 0; });
	}' unless defined(&copy_from_user);
	eval 'sub pci_present () { &pcibios_present;}' unless defined(&pci_present);
	eval 'sub pci_read_config_word () { &pcibios_read_config_word;}' unless defined(&pci_read_config_word);
	eval 'sub pci_read_config_dword () { &pcibios_read_config_dword;}' unless defined(&pci_read_config_dword);
	eval 'sub get_irq {
	    local($bus,$fn) = @_;
    	    eval q({ my $t;  &pcibios_read_config_byte ($bus, $fn,  &PCI_INTERRUPT_LINE,  $t);  $t; });
	}' unless defined(&get_irq);
	eval 'sub void {
	    eval q(* &ioremap(my $base, my $length) {  &if ( $base < 0x100000) ( &void *) $base;  &vremap ( $base,  $length); });
	}' unless defined(&void);
	eval 'sub my_iounmap {
	    local($x, $b) = @_;
    	    eval q((($x<0x100000)?0: &vfree (( &void*)$x)));
	}' unless defined(&my_iounmap);
	eval 'sub capable {
	    local($x) = @_;
    	    eval q( &suser());
	}' unless defined(&capable);
	eval 'sub tty_flip_buffer_push {
	    local($tty) = @_;
    	    eval q( &queue_task( ($tty->{flip}->{tqueue}),  &tq_timer));
	}' unless defined(&tty_flip_buffer_push);
	eval 'sub signal_pending {
	    local($current) = @_;
    	    eval q(( ($current->{signal}) & ~ ($current->{blocked})));
	}' unless defined(&signal_pending);
	eval 'sub schedule_timeout {
	    local($to) = @_;
    	    eval q( &do { ($current->{timeout}) =  &jiffies + ($to); &schedule ();}  &while (0));
	}' unless defined(&schedule_timeout);
	eval 'sub time_after {
	    local($t1,$t2) = @_;
    	    eval q((($t1-$t2) > 0));
	}' unless defined(&time_after);
	eval 'sub test_and_set_bit {
	    local($nr, $addr) = @_;
    	    eval q( &set_bit($nr, $addr));
	}' unless defined(&test_and_set_bit);
	eval 'sub test_and_clear_bit {
	    local($nr, $addr) = @_;
    	    eval q( &clear_bit($nr, $addr));
	}' unless defined(&test_and_clear_bit);
	eval 'sub ASYNC_SPD_SHI () {-1;}' unless defined(&ASYNC_SPD_SHI);
	eval 'sub ASYNC_SPD_WARP () {-1;}' unless defined(&ASYNC_SPD_WARP);
	eval 'sub driver_name () { &name;}' unless defined(&driver_name);
	eval 'sub TTY_HW_COOK_OUT () {14;}' unless defined(&TTY_HW_COOK_OUT);
	eval 'sub TTY_HW_COOK_IN () {15;}' unless defined(&TTY_HW_COOK_IN);
	eval 'sub INT () { &void;}' unless defined(&INT);
	eval 'sub NO_ERROR () {1;}' unless defined(&NO_ERROR);
    } else {
	require 'asm/uaccess.ph';
	eval 'sub Get_user {
	    local($a,$b) = @_;
    	    eval q( &get_user($a,$b));
	}' unless defined(&Get_user);
	eval 'sub Put_user {
	    local($a,$b) = @_;
    	    eval q( &put_user($a,$b));
	}' unless defined(&Put_user);
	eval 'sub get_irq {
	    local($pdev) = @_;
    	    eval q( ($pdev->{irq}));
	}' unless defined(&get_irq);
	eval 'sub INT () {\'int\';}' unless defined(&INT);
	eval 'sub NO_ERROR () {0;}' unless defined(&NO_ERROR);
	eval 'sub my_iounmap {
	    local($x,$b) = @_;
    	    eval q(( &iounmap(($b))));
	}' unless defined(&my_iounmap);
    }
    unless(defined(&TWO_THREE)) {
	eval 'sub wait_queue_head_t () {\'struct wait_queue\' *;}' unless defined(&wait_queue_head_t);
	eval 'sub DECLARE_MUTEX {
	    local($name) = @_;
    	    eval q(\'struct semaphore\' $name =  &MUTEX);
	}' unless defined(&DECLARE_MUTEX);
	eval 'sub DECLARE_WAITQUEUE {
	    local($wait, $current) = @_;
    	    eval q(\'struct wait_queue\' $wait = { $current,  &NULL });
	}' unless defined(&DECLARE_WAITQUEUE);
    }
}
1;
