require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_BLKDEV_H)) {
    eval 'sub _LINUX_BLKDEV_H () {1;}' unless defined(&_LINUX_BLKDEV_H);
    require 'linux/major.ph';
    require 'linux/sched.ph';
    require 'linux/genhd.ph';
    require 'linux/tqueue.ph';
    require 'linux/list.ph';
    require 'linux/mm.ph';
    require 'asm/io.ph';
    eval 'sub RQ_INACTIVE () {(-1);}' unless defined(&RQ_INACTIVE);
    eval 'sub RQ_ACTIVE () {1;}' unless defined(&RQ_ACTIVE);
    eval 'sub RQ_SCSI_BUSY () {0xffff;}' unless defined(&RQ_SCSI_BUSY);
    eval 'sub RQ_SCSI_DONE () {0xfffe;}' unless defined(&RQ_SCSI_DONE);
    eval 'sub RQ_SCSI_DISCONNECTING () {0xffe0;}' unless defined(&RQ_SCSI_DISCONNECTING);
    require 'linux/elevator.ph';
    eval 'sub blk_queue_plugged {
        local($q) = @_;
	    eval q(($q)-> &plugged);
    }' unless defined(&blk_queue_plugged);
    eval 'sub blk_fs_request {
        local($rq) = @_;
	    eval q((($rq)-> &cmd ==  &READ || ($rq)-> &cmd ==  &WRITE));
    }' unless defined(&blk_fs_request);
    eval 'sub blk_queue_empty {
        local($q) = @_;
	    eval q( &list_empty(($q)-> &queue_head));
    }' unless defined(&blk_queue_empty);
    eval 'sub rq_data_dir {
        local($rq) = @_;
	    eval q({  &if ( ($rq->{cmd}) ==  &READ)  &READ;  &else  &if ( ($rq->{cmd}) ==  &WRITE)  &WRITE;  &else {  &BUG(); -1; } });
    }' unless defined(&rq_data_dir);
    eval 'sub BLK_BOUNCE_HIGH () {(( &u64) &blk_max_low_pfn <<  &PAGE_SHIFT);}' unless defined(&BLK_BOUNCE_HIGH);
    eval 'sub BLK_BOUNCE_ANY () {(( &u64) &blk_max_pfn <<  &PAGE_SHIFT);}' unless defined(&BLK_BOUNCE_ANY);
    if(defined(&CONFIG_HIGHMEM)) {
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub buffer_head {
	    eval q(* &blk_queue_bounce( &request_queue_t * &q, \'int\'  &rw, \'struct buffer_head\' * &bh) { \'struct page\' * &page =  ($bh->{b_page});  &bh;  &create_bounce( &rw,  &bh); });
	}' unless defined(&buffer_head);
    } else {
	eval 'sub blk_queue_bounce {
	    local($q, $rw, $bh) = @_;
    	    eval q(($bh));
	}' unless defined(&blk_queue_bounce);
    }
    eval 'sub bh_phys {
        local($bh) = @_;
	    eval q(( &page_to_phys(($bh)-> &b_page) +  &bh_offset(($bh))));
    }' unless defined(&bh_phys);
    eval 'sub BH_CONTIG {
        local($b1, $b2) = @_;
	    eval q(( &bh_phys(($b1)) + ($b1)-> &b_size ==  &bh_phys(($b2))));
    }' unless defined(&BH_CONTIG);
    eval 'sub BH_PHYS_4G {
        local($b1, $b2) = @_;
	    eval q((( &bh_phys(($b1)) | 0xffffffff) == (( &bh_phys(($b2)) + ($b2)-> &b_size - 1) | 0xffffffff)));
    }' unless defined(&BH_PHYS_4G);
    eval 'sub BLK_DEFAULT_QUEUE {
        local($_MAJOR) = @_;
	    eval q( ($blk_dev[$_MAJOR]->{request_queue}));
    }' unless defined(&BLK_DEFAULT_QUEUE);
    eval 'sub MAX_SEGMENTS () {128;}' unless defined(&MAX_SEGMENTS);
    eval 'sub MAX_SECTORS () {255;}' unless defined(&MAX_SECTORS);
    eval 'sub MAX_QUEUE_SECTORS () {(4<< (20- 9));}' unless defined(&MAX_QUEUE_SECTORS);
    eval 'sub MAX_NR_REQUESTS () {1024;}' unless defined(&MAX_NR_REQUESTS);
    eval 'sub PageAlignSize {
        local($size) = @_;
	    eval q(((($size) +  &PAGE_SIZE -1) &  &PAGE_MASK));
    }' unless defined(&PageAlignSize);
    eval 'sub blkdev_entry_to_request {
        local($entry) = @_;
	    eval q( &list_entry(($entry), \'struct request\',  &queue));
    }' unless defined(&blkdev_entry_to_request);
    eval 'sub blkdev_entry_next_request {
        local($entry) = @_;
	    eval q( &blkdev_entry_to_request(($entry)-> &next));
    }' unless defined(&blkdev_entry_next_request);
    eval 'sub blkdev_entry_prev_request {
        local($entry) = @_;
	    eval q( &blkdev_entry_to_request(($entry)-> &prev));
    }' unless defined(&blkdev_entry_prev_request);
    eval 'sub blkdev_next_request {
        local($req) = @_;
	    eval q( &blkdev_entry_to_request(($req)-> ($queue->{next})));
    }' unless defined(&blkdev_next_request);
    eval 'sub blkdev_prev_request {
        local($req) = @_;
	    eval q( &blkdev_entry_to_request(($req)-> ($queue->{prev})));
    }' unless defined(&blkdev_prev_request);
    eval 'sub get_hardsect_size {
        local($dev) = @_;
	    eval q({ \'int\'  &retval = 512; \'int\'  &major =  &MAJOR($dev);  &if ( $hardsect_size[ &major]) { \'int\'  &minor =  &MINOR($dev);  &if ( $hardsect_size[ &major][ &minor])  &retval =  $hardsect_size[ &major][ &minor]; }  &retval; });
    }' unless defined(&get_hardsect_size);
    eval 'sub blk_oversized_queue {
        local($q) = @_;
	    eval q({  &if ( ($q->{can_throttle}))  &atomic_read( ($q->{nr_sectors})) >  ($q->{max_queue_sectors});  ($q->{r$q}->{count}) == 0; });
    }' unless defined(&blk_oversized_queue);
    eval 'sub blk_oversized_queue_reads {
        local($q) = @_;
	    eval q({  &if ( ($q->{can_throttle}))  &atomic_read( ($q->{nr_sectors})) >  ($q->{max_queue_sectors}) +  ($q->{batch_sectors});  ($q->{r$q}->{count}) == 0; });
    }' unless defined(&blk_oversized_queue_reads);
    eval 'sub blk_oversized_queue_batch {
        local($q) = @_;
	    eval q({  &atomic_read( ($q->{nr_sectors})) >  ($q->{max_queue_sectors}) -  ($q->{batch_sectors}); });
    }' unless defined(&blk_oversized_queue_batch);
    eval 'sub blk_finished_io {
        local($nsects) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&blk_finished_io);
    eval 'sub blk_started_io {
        local($nsects) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&blk_started_io);
    eval 'sub blk_started_sectors {
        local($rq,$count) = @_;
	    eval q({  &request_queue_t * &q =  ($rq->{q});  &if ( &q  &&  ($q->{can_throttle})) {  &atomic_add($count,  ($q->{nr_sectors}));  &if ( &atomic_read( ($q->{nr_sectors})) < 0) {  &printk(\\"nr_sectors is %d\\\\n\\",  &atomic_read( ($q->{nr_sectors})));  &BUG(); } } });
    }' unless defined(&blk_started_sectors);
    eval 'sub blk_finished_sectors {
        local($rq,$count) = @_;
	    eval q({  &request_queue_t * &q =  ($rq->{q});  &if ( &q  &&  ($q->{can_throttle})) {  &atomic_sub($count,  ($q->{nr_sectors}));  &smp_mb();  &if ( ($q->{rq}->{count}) >=  ($q->{batch_requests})  && ! &blk_oversized_queue_batch( &q)) {  &if ( &waitqueue_active( ($q->{wait_for_requests})))  &wake_up( ($q->{wait_for_requests})); }  &if ( &atomic_read( ($q->{nr_sectors})) < 0) {  &printk(\\"nr_sectors is %d\\\\n\\",  &atomic_read( ($q->{nr_sectors})));  &BUG(); } } });
    }' unless defined(&blk_finished_sectors);
    eval 'sub blksize_bits {
        local($size) = @_;
	    eval q({ my $bits = 8;  &do {  $bits++; $size >>= 1; }  &while ($size > 256);  $bits; });
    }' unless defined(&blksize_bits);
    eval 'sub block_size {
        local($dev) = @_;
	    eval q({ \'int\'  &retval =  &BLOCK_SIZE; \'int\'  &major =  &MAJOR($dev);  &if ( $blksize_size[ &major]) { \'int\'  &minor =  &MINOR($dev);  &if ( $blksize_size[ &major][ &minor])  &retval =  $blksize_size[ &major][ &minor]; }  &retval; });
    }' unless defined(&block_size);
}
1;
