require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_STDIO_H)) {
    die("Always\ include\ \<stdio\.h\>\ rather\ than\ \<bits\/uClibc_stdio\.h\>");
}
unless(defined(&__STDIO_BUFFERS)) {
    sub __STDIO_BUFFERS () {	1;}
}
if(defined( &__UCLIBC_HAS_STDIO_BUFSIZ_NONE__)) {
    eval 'sub __STDIO_BUFSIZ () {256;}' unless defined(&__STDIO_BUFSIZ);
    undef(&__STDIO_BUFFERS) if defined(&__STDIO_BUFFERS);
}
 elsif(defined( &__UCLIBC_HAS_STDIO_BUFSIZ_256__)) {
    eval 'sub __STDIO_BUFSIZ () {256;}' unless defined(&__STDIO_BUFSIZ);
}
 elsif(defined( &__UCLIBC_HAS_STDIO_BUFSIZ_512__)) {
    eval 'sub __STDIO_BUFSIZ () {512;}' unless defined(&__STDIO_BUFSIZ);
}
 elsif(defined( &__UCLIBC_HAS_STDIO_BUFSIZ_1024__)) {
    eval 'sub __STDIO_BUFSIZ () {1024;}' unless defined(&__STDIO_BUFSIZ);
}
 elsif(defined( &__UCLIBC_HAS_STDIO_BUFSIZ_2048__)) {
    eval 'sub __STDIO_BUFSIZ () {2048;}' unless defined(&__STDIO_BUFSIZ);
}
 elsif(defined( &__UCLIBC_HAS_STDIO_BUFSIZ_4096__)) {
    eval 'sub __STDIO_BUFSIZ () {4096;}' unless defined(&__STDIO_BUFSIZ);
}
 elsif(defined( &__UCLIBC_HAS_STDIO_BUFSIZ_8192__)) {
    eval 'sub __STDIO_BUFSIZ () {8192;}' unless defined(&__STDIO_BUFSIZ);
} else {
    die("config\ seems\ to\ be\ out\ of\ sync\ regarding\ bufsiz\ options");
}
if(defined(&__UCLIBC_HAS_STDIO_BUFSIZ_NONE__)) {
    eval 'sub __STDIO_BUILTIN_BUF_SIZE () {0;}' unless defined(&__STDIO_BUILTIN_BUF_SIZE);
} else {
    if(defined( &__UCLIBC_HAS_STDIO_BUILTIN_BUFFER_NONE__)) {
	eval 'sub __STDIO_BUILTIN_BUF_SIZE () {0;}' unless defined(&__STDIO_BUILTIN_BUF_SIZE);
    }
 elsif(defined( &__UCLIBC_HAS_STDIO_BUILTIN_BUFFER_4__)) {
	eval 'sub __STDIO_BUILTIN_BUF_SIZE () {4;}' unless defined(&__STDIO_BUILTIN_BUF_SIZE);
    }
 elsif(defined( &__UCLIBC_HAS_STDIO_BUILTIN_BUFFER_8__)) {
	eval 'sub __STDIO_BUILTIN_BUF_SIZE () {8;}' unless defined(&__STDIO_BUILTIN_BUF_SIZE);
    } else {
	die("config\ seems\ to\ be\ out\ of\ sync\ regarding\ builtin\ buffer\ size");
    }
}
if(defined( &__STDIO_BUFFERS) || defined( &__UCLIBC_HAS_GLIBC_CUSTOM_STREAMS__) || defined( &__UCLIBC_HAS_THREADS__)) {
    eval 'sub __STDIO_HAS_OPENLIST () {1;}' unless defined(&__STDIO_HAS_OPENLIST);
} else {
    undef(&__STDIO_HAS_OPENLIST) if defined(&__STDIO_HAS_OPENLIST);
}
if(defined(&_LIBC)) {
    if(defined(&__UCLIBC_HAS_LFS__)) {
	undef(&__USE_LARGEFILE) if defined(&__USE_LARGEFILE);
	undef(&__USE_LARGEFILE64) if defined(&__USE_LARGEFILE64);
	undef(&__USE_FILE_OFFSET64) if defined(&__USE_FILE_OFFSET64);
	eval 'sub __USE_LARGEFILE64 () {1;}' unless defined(&__USE_LARGEFILE64);
    }
} else {
    unless(defined(&__UCLIBC_HAS_LFS__)) {
	if(defined( &__LARGEFILE64_SOURCE) || defined( &__USE_LARGEFILE64) || defined( &__USE_FILE_OFFSET64)) {
	    die("Sorry\.\.\.\ uClibc\ was\ built\ without\ large\ file\ support\!");
	}
    }
}
if(defined(&__UCLIBC_HAS_WCHAR__)) {
    eval 'sub __need_wchar_t () {1;}' unless defined(&__need_wchar_t);
    require 'stddef.ph';
    eval 'sub __STDIO_MBSTATE () {1;}' unless defined(&__STDIO_MBSTATE);
    eval 'sub __need_mbstate_t () {1;}' unless defined(&__need_mbstate_t);
    require 'wchar.ph';
}
if(defined(&__UCLIBC_HAS_STDIO_GETC_MACRO__)) {
    eval 'sub __STDIO_GETC_MACRO () {1;}' unless defined(&__STDIO_GETC_MACRO);
}
if(defined(&__UCLIBC_HAS_STDIO_PUTC_MACRO__)) {
    eval 'sub __STDIO_PUTC_MACRO () {1;}' unless defined(&__STDIO_PUTC_MACRO);
}
unless(defined(&__STDIO_BUFFERS)) {
    undef(&__STDIO_GETC_MACRO) if defined(&__STDIO_GETC_MACRO);
    undef(&__STDIO_PUTC_MACRO) if defined(&__STDIO_PUTC_MACRO);
}
if(defined(&__BCC__)) {
    undef(&__UCLIBC_HAS_LFS__) if defined(&__UCLIBC_HAS_LFS__);
}
unless(defined(&__UCLIBC_HAS_LFS__)) {
    undef(&__UCLIBC_HAS_FOPEN_LARGEFILE_MODE__) if defined(&__UCLIBC_HAS_FOPEN_LARGEFILE_MODE__);
}
if(defined(&__UCLIBC_HAS_THREADS__)) {
    require 'bits/pthreadtypes.ph';
    eval 'sub __STDIO_AUTO_THREADLOCK_VAR () {\'int\'  &__infunc_user_locking;}' unless defined(&__STDIO_AUTO_THREADLOCK_VAR);
    eval 'sub __STDIO_AUTO_THREADLOCK {
        local($__stream) = @_;
	    eval q( &if (( &__infunc_user_locking = ($__stream)-> &__user_locking) == 0) {  &__pthread_mutex_lock(($__stream)-> &__lock); });
    }' unless defined(&__STDIO_AUTO_THREADLOCK);
    eval 'sub __STDIO_AUTO_THREADUNLOCK {
        local($__stream) = @_;
	    eval q( &if ( &__infunc_user_locking == 0) {  &__pthread_mutex_unlock(($__stream)-> &__lock); });
    }' unless defined(&__STDIO_AUTO_THREADUNLOCK);
    eval 'sub __STDIO_SET_USER_LOCKING {
        local($__stream) = @_;
	    eval q((($__stream)-> &__user_locking = 1));
    }' unless defined(&__STDIO_SET_USER_LOCKING);
    eval 'sub __STDIO_ALWAYS_THREADLOCK {
        local($__stream) = @_;
	    eval q( &__pthread_mutex_lock(($__stream)-> &__lock));
    }' unless defined(&__STDIO_ALWAYS_THREADLOCK);
    eval 'sub __STDIO_ALWAYS_THREADTRYLOCK {
        local($__stream) = @_;
	    eval q( &__pthread_mutex_trylock(($__stream)-> &__lock));
    }' unless defined(&__STDIO_ALWAYS_THREADTRYLOCK);
    eval 'sub __STDIO_ALWAYS_THREADUNLOCK {
        local($__stream) = @_;
	    eval q( &__pthread_mutex_unlock(($__stream)-> &__lock));
    }' unless defined(&__STDIO_ALWAYS_THREADUNLOCK);
} else {
    eval 'sub __STDIO_AUTO_THREADLOCK_VAR () {(( &void)0);}' unless defined(&__STDIO_AUTO_THREADLOCK_VAR);
    eval 'sub __STDIO_AUTO_THREADLOCK {
        local($__stream) = @_;
	    eval q((( &void)0));
    }' unless defined(&__STDIO_AUTO_THREADLOCK);
    eval 'sub __STDIO_AUTO_THREADUNLOCK {
        local($__stream) = @_;
	    eval q((( &void)0));
    }' unless defined(&__STDIO_AUTO_THREADUNLOCK);
    eval 'sub __STDIO_SET_USER_LOCKING {
        local($__stream) = @_;
	    eval q((( &void)0));
    }' unless defined(&__STDIO_SET_USER_LOCKING);
    eval 'sub __STDIO_ALWAYS_THREADLOCK {
        local($__stream) = @_;
	    eval q((( &void)0));
    }' unless defined(&__STDIO_ALWAYS_THREADLOCK);
    eval 'sub __STDIO_ALWAYS_THREADTRYLOCK {
        local($__stream) = @_;
	    eval q((0));
    }' unless defined(&__STDIO_ALWAYS_THREADTRYLOCK);
    eval 'sub __STDIO_ALWAYS_THREADUNLOCK {
        local($__stream) = @_;
	    eval q((( &void)0));
    }' unless defined(&__STDIO_ALWAYS_THREADUNLOCK);
}
unless(defined(&__STDIO_IOFBF)) {
    sub __STDIO_IOFBF () {	0;}
}
unless(defined(&__STDIO_IOLBF)) {
    sub __STDIO_IOLBF () {	1;}
}
unless(defined(&__STDIO_IONBF)) {
    sub __STDIO_IONBF () {	2;}
}
if(defined(&__STDIO_MBSTATE)) {
}
if(defined(&__UCLIBC_HAS_WCHAR__)) {
}
if(defined(&__UCLIBC_HAS_LFS__)) {
    if(defined(&__STDIO_MBSTATE)) {
    }
    if(defined(&__UCLIBC_HAS_WCHAR__)) {
    }
}
if(defined(&__UCLIBC_HAS_LFS__)) {
} else {
}
if(defined(&__UCLIBC_HAS_GLIBC_CUSTOM_STREAMS__)) {
    if(defined( &_LIBC) || defined( &_GNU_SOURCE)) {
    }
}
if(defined(&__UCLIBC_HAS_WCHAR__)) {
} else {
}
if(defined(&__STDIO_BUFFERS)) {
    if(defined(&__STDIO_GETC_MACRO)) {
    }
    if(defined(&__STDIO_PUTC_MACRO)) {
    }
}
if(defined(&__STDIO_HAS_OPENLIST)) {
}
if(defined(&__UCLIBC_HAS_GLIBC_CUSTOM_STREAMS__)) {
}
if(defined(&__UCLIBC_HAS_WCHAR__)) {
}
if(defined(&__STDIO_MBSTATE)) {
}
if(defined(&__UCLIBC_HAS_XLOCALE__)) {
}
if(defined(&__UCLIBC_HAS_THREADS__)) {
}
if((defined(&__STDIO_BUILTIN_BUF_SIZE) ? &__STDIO_BUILTIN_BUF_SIZE : 0) > 0) {
}
unless(defined(&__MASK_READING)) {
    sub __MASK_READING () {	0x3;}
}
unless(defined(&__FLAG_READING)) {
    sub __FLAG_READING () {	0x1;}
}
unless(defined(&__FLAG_UNGOT)) {
    sub __FLAG_UNGOT () {	0x2;}
}
unless(defined(&__FLAG_EOF)) {
    sub __FLAG_EOF () {	0x4;}
}
unless(defined(&__FLAG_ERROR)) {
    sub __FLAG_ERROR () {	0x8;}
}
unless(defined(&__FLAG_WRITEONLY)) {
    sub __FLAG_WRITEONLY () {	0x10;}
}
unless(defined(&__FLAG_READONLY)) {
    sub __FLAG_READONLY () {	0x20;}
}
unless(defined(&__FLAG_WRITING)) {
    sub __FLAG_WRITING () {	0x40;}
}
unless(defined(&__FLAG_NARROW)) {
    sub __FLAG_NARROW () {	0x80;}
}
unless(defined(&__FLAG_FBF)) {
    sub __FLAG_FBF () {	0x;}
}
unless(defined(&__FLAG_LBF)) {
    sub __FLAG_LBF () {	0x100;}
}
unless(defined(&__FLAG_NBF)) {
    sub __FLAG_NBF () {	0x200;}
}
unless(defined(&__MASK_BUFMODE)) {
    sub __MASK_BUFMODE () {	0x300;}
}
unless(defined(&__FLAG_APPEND)) {
    sub __FLAG_APPEND () {	0x400;}
}
unless(defined(&__FLAG_WIDE)) {
    sub __FLAG_WIDE () {	0x800;}
}
unless(defined(&__FLAG_FREEFILE)) {
    sub __FLAG_FREEFILE () {	0x2000;}
}
unless(defined(&__FLAG_FREEBUF)) {
    sub __FLAG_FREEBUF () {	0x4000;}
}
unless(defined(&__FLAG_LARGEFILE)) {
    sub __FLAG_LARGEFILE () {	0x8000;}
}
if(defined(&_LIBC)) {
    if(defined(&__STDIO_HAS_OPENLIST)) {
	if(defined(&__UCLIBC_HAS_THREADS__)) {
	}
    }
}
unless(defined(&__CLEARERR_UNLOCKED)) {
    sub __CLEARERR_UNLOCKED {
	local($__stream) = @_;
	eval q((( &void)(($__stream)-> &__modeflags &= ~( &__FLAG_EOF| &__FLAG_ERROR))));
    }
}
unless(defined(&__FEOF_UNLOCKED)) {
    sub __FEOF_UNLOCKED {
	local($__stream) = @_;
	eval q((($__stream)-> &__modeflags &  &__FLAG_EOF));
    }
}
unless(defined(&__FERROR_UNLOCKED)) {
    sub __FERROR_UNLOCKED {
	local($__stream) = @_;
	eval q((($__stream)-> &__modeflags &  &__FLAG_ERROR));
    }
}
if(defined(&__UCLIBC_HAS_THREADS__)) {
    eval 'sub __CLEARERR {
        local($__stream) = @_;
	    eval q(( &clearerr)($__stream));
    }' unless defined(&__CLEARERR);
    eval 'sub __FERROR {
        local($__stream) = @_;
	    eval q(( &ferror)($__stream));
    }' unless defined(&__FERROR);
    eval 'sub __FEOF {
        local($__stream) = @_;
	    eval q(( &feof)($__stream));
    }' unless defined(&__FEOF);
} else {
    eval 'sub __CLEARERR {
        local($__stream) = @_;
	    eval q( &__CLEARERR_UNLOCKED($__stream));
    }' unless defined(&__CLEARERR);
    eval 'sub __FERROR {
        local($__stream) = @_;
	    eval q( &__FERROR_UNLOCKED($__stream));
    }' unless defined(&__FERROR);
    eval 'sub __FEOF {
        local($__stream) = @_;
	    eval q( &__FEOF_UNLOCKED($__stream));
    }' unless defined(&__FEOF);
}
unless(defined(&__FGETC_UNLOCKED)) {
    sub __FGETC_UNLOCKED {
	local($__stream) = @_;
	eval q(( &__fgetc_unlocked)(($__stream)));
    }
}
unless(defined(&__FGETC)) {
    sub __FGETC {
	local($__stream) = @_;
	eval q(( &fgetc)(($__stream)));
    }
}
unless(defined(&__GETC_UNLOCKED_MACRO)) {
    sub __GETC_UNLOCKED_MACRO {
	local($__stream) = @_;
	eval q(( &__fgetc_unlocked)(($__stream)));
    }
}
unless(defined(&__GETC_UNLOCKED)) {
    sub __GETC_UNLOCKED {
	local($__stream) = @_;
	eval q(( &__fgetc_unlocked)(($__stream)));
    }
}
unless(defined(&__GETC)) {
    sub __GETC {
	local($__stream) = @_;
	eval q(( &fgetc)(($__stream)));
    }
}
unless(defined(&__FPUTC_UNLOCKED)) {
    sub __FPUTC_UNLOCKED {
	local($__c, $__stream) = @_;
	eval q(( &__fputc_unlocked)(($__c),($__stream)));
    }
}
unless(defined(&__FPUTC)) {
    sub __FPUTC {
	local($__c, $__stream) = @_;
	eval q(( &fputc)(($__c),($__stream)));
    }
}
unless(defined(&__PUTC_UNLOCKED_MACRO)) {
    sub __PUTC_UNLOCKED_MACRO {
	local($__c, $__stream) = @_;
	eval q(( &__fputc_unlocked)(($__c),($__stream)));
    }
}
unless(defined(&__PUTC_UNLOCKED)) {
    sub __PUTC_UNLOCKED {
	local($__c, $__stream) = @_;
	eval q(( &__fputc_unlocked)(($__c),($__stream)));
    }
}
unless(defined(&__PUTC)) {
    sub __PUTC {
	local($__c, $__stream) = @_;
	eval q(( &fputc)(($__c),($__stream)));
    }
}
if(defined(&__STDIO_GETC_MACRO)) {
    undef(&__GETC_UNLOCKED_MACRO) if defined(&__GETC_UNLOCKED_MACRO);
    eval 'sub __GETC_UNLOCKED_MACRO {
        local($__stream) = @_;
	    eval q(( (($__stream)-> &__bufpos < ($__stream)-> &__bufgetc_u) ? (*($__stream)-> &__bufpos++) :  &__fgetc_unlocked($__stream) ));
    }' unless defined(&__GETC_UNLOCKED_MACRO);
    if(0) {
	undef(&__GETC_UNLOCKED) if defined(&__GETC_UNLOCKED);
	eval 'sub __GETC_UNLOCKED {
	    local($__stream) = @_;
    	    eval q( &__GETC_UNLOCKED_MACRO(($__stream)));
	}' unless defined(&__GETC_UNLOCKED);
	unless(defined(&__UCLIBC_HAS_THREADS__)) {
	    undef(&__GETC) if defined(&__GETC);
	    eval 'sub __GETC {
	        local($__stream) = @_;
    		eval q( &__GETC_UNLOCKED_MACRO(($__stream)));
	    }' unless defined(&__GETC);
	}
    } else {
	undef(&__FGETC_UNLOCKED) if defined(&__FGETC_UNLOCKED);
	eval 'sub __FGETC_UNLOCKED {
	    local($__stream) = @_;
    	    eval q(( &__extension__ ({ \'FILE\' * &__S = ($__stream);  &__GETC_UNLOCKED_MACRO( &__S); }) ));
	}' unless defined(&__FGETC_UNLOCKED);
	undef(&__GETC_UNLOCKED) if defined(&__GETC_UNLOCKED);
	eval 'sub __GETC_UNLOCKED {
	    local($__stream) = @_;
    	    eval q( &__FGETC_UNLOCKED(($__stream)));
	}' unless defined(&__GETC_UNLOCKED);
	if(defined(&__UCLIBC_HAS_THREADS__)) {
	    undef(&__FGETC) if defined(&__FGETC);
	    eval 'sub __FGETC {
	        local($__stream) = @_;
    		eval q(( &__extension__ ({ \'FILE\' * &__S = ($__stream); (( ($__S->{__user_locking}) ) ?  &__GETC_UNLOCKED_MACRO( &__S) : ( &fgetc)( &__S)); }) ));
	    }' unless defined(&__FGETC);
	    undef(&__GETC) if defined(&__GETC);
	    eval 'sub __GETC {
	        local($__stream) = @_;
    		eval q( &__FGETC(($__stream)));
	    }' unless defined(&__GETC);
	} else {
	    undef(&__FGETC) if defined(&__FGETC);
	    eval 'sub __FGETC {
	        local($__stream) = @_;
    		eval q( &__FGETC_UNLOCKED(($__stream)));
	    }' unless defined(&__FGETC);
	    undef(&__GETC) if defined(&__GETC);
	    eval 'sub __GETC {
	        local($__stream) = @_;
    		eval q( &__FGETC_UNLOCKED(($__stream)));
	    }' unless defined(&__GETC);
	}
    }
} else {
}
if(defined(&__STDIO_PUTC_MACRO)) {
    undef(&__PUTC_UNLOCKED_MACRO) if defined(&__PUTC_UNLOCKED_MACRO);
    eval 'sub __PUTC_UNLOCKED_MACRO {
        local($__c, $__stream) = @_;
	    eval q(( (($__stream)-> &__bufpos < ($__stream)-> &__bufputc_u) ? (*($__stream)-> &__bufpos++) = ($__c) :  &__fputc_unlocked(($__c),($__stream)) ));
    }' unless defined(&__PUTC_UNLOCKED_MACRO);
    if(0) {
	undef(&__PUTC_UNLOCKED) if defined(&__PUTC_UNLOCKED);
	eval 'sub __PUTC_UNLOCKED {
	    local($__c, $__stream) = @_;
    	    eval q( &__PUTC_UNLOCKED_MACRO(($__c), ($__stream)));
	}' unless defined(&__PUTC_UNLOCKED);
	unless(defined(&__UCLIBC_HAS_THREADS__)) {
	    undef(&__PUTC) if defined(&__PUTC);
	    eval 'sub __PUTC {
	        local($__c, $__stream) = @_;
    		eval q( &__PUTC_UNLOCKED_MACRO(($__c), ($__stream)));
	    }' unless defined(&__PUTC);
	}
    } else {
	undef(&__FPUTC_UNLOCKED) if defined(&__FPUTC_UNLOCKED);
	eval 'sub __FPUTC_UNLOCKED {
	    local($__c, $__stream) = @_;
    	    eval q(( &__extension__ ({ \'FILE\' * &__S = ($__stream);  &__PUTC_UNLOCKED_MACRO(($__c), &__S); }) ));
	}' unless defined(&__FPUTC_UNLOCKED);
	undef(&__PUTC_UNLOCKED) if defined(&__PUTC_UNLOCKED);
	eval 'sub __PUTC_UNLOCKED {
	    local($__c, $__stream) = @_;
    	    eval q( &__FPUTC_UNLOCKED(($__c), ($__stream)));
	}' unless defined(&__PUTC_UNLOCKED);
	if(defined(&__UCLIBC_HAS_THREADS__)) {
	    undef(&__FPUTC) if defined(&__FPUTC);
	    eval 'sub __FPUTC {
	        local($__c, $__stream) = @_;
    		eval q(( &__extension__ ({ \'FILE\' * &__S = ($__stream); (( ($__S->{__user_locking})) ?  &__PUTC_UNLOCKED_MACRO(($__c), &__S) : ( &fputc)(($__c), &__S)); }) ));
	    }' unless defined(&__FPUTC);
	    undef(&__PUTC) if defined(&__PUTC);
	    eval 'sub __PUTC {
	        local($__c, $__stream) = @_;
    		eval q( &__FPUTC(($__c), ($__stream)));
	    }' unless defined(&__PUTC);
	} else {
	    undef(&__FPUTC) if defined(&__FPUTC);
	    eval 'sub __FPUTC {
	        local($__c, $__stream) = @_;
    		eval q( &__FPUTC_UNLOCKED(($__c),($__stream)));
	    }' unless defined(&__FPUTC);
	    undef(&__PUTC) if defined(&__PUTC);
	    eval 'sub __PUTC {
	        local($__c, $__stream) = @_;
    		eval q( &__FPUTC_UNLOCKED(($__c),($__stream)));
	    }' unless defined(&__PUTC);
	}
    }
}
1;
