require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_SYSTEM_H)) {
    eval 'sub __ASM_ARM_SYSTEM_H () {1;}' unless defined(&__ASM_ARM_SYSTEM_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/kernel.ph';
	if(defined(&CONFIG_PCI)) {
	} else {
	    eval 'sub have_isa_bridge () {(0);}' unless defined(&have_isa_bridge);
	}
	require 'asm/proc-fns.ph';
	eval 'sub xchg {
	    local($ptr,$x) = @_;
    	    eval q((( &__typeof__(*)) &__xchg(($x),($ptr),$sizeof{($ptr)})));
	}' unless defined(&xchg);
	eval 'sub tas {
	    local($ptr) = @_;
    	    eval q(( &xchg(($ptr),1)));
	}' unless defined(&tas);
	require 'asm/proc/system.ph';
	eval 'sub mb () {
	    eval q( &__asm__  &__volatile__ (\\"\\" : : : \\"memory\\"));
	}' unless defined(&mb);
	eval 'sub rmb () {
	    eval q( &mb());
	}' unless defined(&rmb);
	eval 'sub wmb () {
	    eval q( &mb());
	}' unless defined(&wmb);
	eval 'sub set_mb {
	    local($var, $value) = @_;
    	    eval q( &do { $var = $value;  &mb(); }  &while (0));
	}' unless defined(&set_mb);
	eval 'sub set_wmb {
	    local($var, $value) = @_;
    	    eval q( &do { $var = $value;  &wmb(); }  &while (0));
	}' unless defined(&set_wmb);
	eval 'sub nop () {
	    eval q( &__asm__  &__volatile__(\\"mov\\\\tr0,r0\\\\t@ nop\\\\n\\\\t\\"););
	}' unless defined(&nop);
	eval 'sub prepare_to_switch () {
	    eval q( &do { }  &while(0));
	}' unless defined(&prepare_to_switch);
	eval 'sub switch_to {
	    local($prev,$next,$last) = @_;
    	    eval q( &do { $last =  &__switch_to($prev,$next);  &mb(); }  &while (0));
	}' unless defined(&switch_to);
	eval 'sub __save_flags_cli {
	    local($x) = @_;
    	    eval q( &local_irq_save($x));
	}' unless defined(&__save_flags_cli);
	eval 'sub __save_flags {
	    local($x) = @_;
    	    eval q( &local_save_flags($x));
	}' unless defined(&__save_flags);
	eval 'sub __restore_flags {
	    local($x) = @_;
    	    eval q( &local_irq_restore($x));
	}' unless defined(&__restore_flags);
	eval 'sub __cli () {
	    eval q( &local_irq_disable());
	}' unless defined(&__cli);
	eval 'sub __sti () {
	    eval q( &local_irq_enable());
	}' unless defined(&__sti);
	if(defined(&CONFIG_SMP)) {
	    die("SMP\ not\ supported");
	    eval 'sub smp_mb () {
	        eval q( &mb());
	    }' unless defined(&smp_mb);
	    eval 'sub smp_rmb () {
	        eval q( &rmb());
	    }' unless defined(&smp_rmb);
	    eval 'sub smp_wmb () {
	        eval q( &wmb());
	    }' unless defined(&smp_wmb);
	} else {
	    eval 'sub smp_mb () {
	        eval q( &barrier());
	    }' unless defined(&smp_mb);
	    eval 'sub smp_rmb () {
	        eval q( &barrier());
	    }' unless defined(&smp_rmb);
	    eval 'sub smp_wmb () {
	        eval q( &barrier());
	    }' unless defined(&smp_wmb);
	    eval 'sub cli () {
	        eval q( &local_irq_disable());
	    }' unless defined(&cli);
	    eval 'sub sti () {
	        eval q( &local_irq_enable());
	    }' unless defined(&sti);
	    eval 'sub clf () {
	        eval q( &__clf());
	    }' unless defined(&clf);
	    eval 'sub stf () {
	        eval q( &__stf());
	    }' unless defined(&stf);
	    eval 'sub save_flags {
	        local($x) = @_;
    		eval q( &local_save_flags($x));
	    }' unless defined(&save_flags);
	    eval 'sub restore_flags {
	        local($x) = @_;
    		eval q( &local_irq_restore($x));
	    }' unless defined(&restore_flags);
	    eval 'sub save_flags_cli {
	        local($x) = @_;
    		eval q( &local_irq_save($x));
	    }' unless defined(&save_flags_cli);
	    eval 'sub save_and_cli {
	        local($x) = @_;
    		eval q( &local_irq_save($x));
	    }' unless defined(&save_and_cli);
	    eval 'sub save_and_sti {
	        local($x) = @_;
    		eval q( &local_irq_set($x));
	    }' unless defined(&save_and_sti);
	}
    }
}
1;
