require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_PROCESSOR_H)) {
    eval 'sub __ASM_ARM_PROCESSOR_H () {1;}' unless defined(&__ASM_ARM_PROCESSOR_H);
    eval 'sub current_text_addr () {
        eval q(({  &__label__  &_l;  &_l:  && &_l;}));
    }' unless defined(&current_text_addr);
    eval 'sub FP_SIZE () {35;}' unless defined(&FP_SIZE);
    if(defined(&__KERNEL__)) {
	eval 'sub EISA_bus () {0;}' unless defined(&EISA_bus);
	eval 'sub MCA_bus () {0;}' unless defined(&MCA_bus);
	eval 'sub MCA_bus__is_a_macro () {1;}' unless defined(&MCA_bus__is_a_macro);
	require 'asm/atomic.ph';
	require 'asm/ptrace.ph';
	require 'asm/arch/memory.ph';
	require 'asm/proc/processor.ph';
	require 'asm/types.ph';
	eval 'sub INIT_THREAD () {{  &refcount:  &ATOMIC_INIT(1),  &EXTRA_THREAD_STRUCT_INIT };}' unless defined(&INIT_THREAD);
	eval 'sub thread_saved_fp {
	    local($t) = @_;
    	    eval q({  ($t->{save}) ?  ($t->{save}->{fp}) : 0; });
	}' unless defined(&thread_saved_fp);
	eval 'sub copy_segments {
	    local($tsk, $mm) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&copy_segments);
	eval 'sub release_segments {
	    local($mm) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&release_segments);
	eval 'sub THREAD_SIZE () {(8192);}' unless defined(&THREAD_SIZE);
	eval 'sub get_task_struct {
	    local($p) = @_;
    	    eval q( &atomic_inc(($p)-> ($thread->{refcount})));
	}' unless defined(&get_task_struct);
	eval 'sub free_task_struct {
	    local($p) = @_;
    	    eval q( &do {  &if ( &atomic_dec_and_test(($p)-> ($thread->{refcount})))  &__free_task_struct(($p)); }  &while (0));
	}' unless defined(&free_task_struct);
	eval 'sub init_task () {( ($init_task_union->{task}));}' unless defined(&init_task);
	eval 'sub init_stack () {( ($init_task_union->{stack}));}' unless defined(&init_stack);
	eval 'sub cpu_relax () {
	    eval q( &barrier());
	}' unless defined(&cpu_relax);
    }
}
1;
